<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CategoriaHabitacionMast.xml */
/* Generado: 2021-06-25 23:59:49 */

/* Busqueda de registros de la tabla MST_CategoriaHabitacionMast. */
abstract class BaseMST_CategoriaHabitacionMastFN extends MST_CategoriaHabitacionMastBN
{
    /* Declaracion de constantes */
    const IdCategoria = "MST_CategoriaHabitacionMast.IdCategoria";
    const IdCompania = "MST_CategoriaHabitacionMast.IdCompania";
    const IdSucursal = "MST_CategoriaHabitacionMast.IdSucursal";
    const Descripcion = "MST_CategoriaHabitacionMast.Descripcion";
    const Estado = "MST_CategoriaHabitacionMast.Estado";
    const FechaCreacion = "MST_CategoriaHabitacionMast.FechaCreacion";
    const UsuarioCreacion = "MST_CategoriaHabitacionMast.UsuarioCreacion";
    const FechaModificacion = "MST_CategoriaHabitacionMast.FechaModificacion";
    const UsuarioModificacion = "MST_CategoriaHabitacionMast.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_CategoriaHabitacionMast.IdCategoria AS IdCategoria, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.Estado AS Estado, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_CategoriaHabitacionMast.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_CategoriaHabitacionMastBN */
    public function setByBN( MST_CategoriaHabitacionMastBN $o_MST_CategoriaHabitacionMastBN )
    {
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getIdCategoria() ) )
        {
            $this->setIdCategoria( $o_MST_CategoriaHabitacionMastBN->getIdCategoria() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_CategoriaHabitacionMastBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_CategoriaHabitacionMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_CategoriaHabitacionMastBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CategoriaHabitacionMastBN->getEstado() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CategoriaHabitacionMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CategoriaHabitacionMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CategoriaHabitacionMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_CategoriaHabitacionMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CategoriaHabitacionMastBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_CategoriaHabitacionMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCategoria )
    {
        if( is_null( $i_IdCategoria ) ){ $i_IdCategoria = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaHabitacionMast ";
        $s_SQLQuery .= "WHERE IdCategoria = ".$i_IdCategoria." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_MST_CategoriaHabitacionMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_CategoriaHabitacionMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_CategoriaHabitacionMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCategoria() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.IdCategoria = ".$this->getIdCategoria()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_CategoriaHabitacionMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_CategoriaHabitacionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_CategoriaHabitacionMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_CategoriaHabitacionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_MST_CategoriaHabitacionMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_CategoriaHabitacionMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_CategoriaHabitacionMastBN[] = $o_MST_CategoriaHabitacionMastBN;
            }
        }
        return $a_MST_CategoriaHabitacionMastBN;
    }

    /* Devuelve un objeto MST_CategoriaHabitacionMastBN desde un objeto propel */
    public function insertObjectBN( $a_MST_CategoriaHabitacionMast )
    {
        $o_MST_CategoriaHabitacionMastBN = new MST_CategoriaHabitacionMastBN();
        if ( !is_null( $a_MST_CategoriaHabitacionMast['IdCategoria'] ) ) $o_MST_CategoriaHabitacionMastBN->setIdCategoria( ( integer ) $a_MST_CategoriaHabitacionMast['IdCategoria'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['IdCompania'] ) ) $o_MST_CategoriaHabitacionMastBN->setIdCompania( ( integer ) $a_MST_CategoriaHabitacionMast['IdCompania'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['IdSucursal'] ) ) $o_MST_CategoriaHabitacionMastBN->setIdSucursal( ( integer ) $a_MST_CategoriaHabitacionMast['IdSucursal'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['Descripcion'] ) ) $o_MST_CategoriaHabitacionMastBN->setDescripcion( $a_MST_CategoriaHabitacionMast['Descripcion'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['Estado'] ) ) $o_MST_CategoriaHabitacionMastBN->setEstado( $a_MST_CategoriaHabitacionMast['Estado'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['FechaCreacion'] ) ) $o_MST_CategoriaHabitacionMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_CategoriaHabitacionMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['UsuarioCreacion'] ) ) $o_MST_CategoriaHabitacionMastBN->setUsuarioCreacion( $a_MST_CategoriaHabitacionMast['UsuarioCreacion'] );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['FechaModificacion'] ) ) $o_MST_CategoriaHabitacionMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_CategoriaHabitacionMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_CategoriaHabitacionMast['UsuarioModificacion'] ) ) $o_MST_CategoriaHabitacionMastBN->setUsuarioModificacion( $a_MST_CategoriaHabitacionMast['UsuarioModificacion'] );
        return $o_MST_CategoriaHabitacionMastBN;
    }
}
?>