<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_UsuarioSucuDocumento.xml */
/* Generado: 2021-06-25 23:59:48 */

/* Busqueda de registros de la tabla GSS_UsuarioSucuDocumento. */
abstract class BaseGSS_UsuarioSucuDocumentoFN extends GSS_UsuarioSucuDocumentoBN
{
    /* Declaracion de constantes */
    const IdSucuDoc = "GSS_UsuarioSucuDocumento.IdSucuDoc";
    const IdUsuario = "GSS_UsuarioSucuDocumento.IdUsuario";
    const IdCompania = "GSS_UsuarioSucuDocumento.IdCompania";
    const IdTipoDocumento = "GSS_UsuarioSucuDocumento.IdTipoDocumento";
    const IdSucursalDocumento = "GSS_UsuarioSucuDocumento.IdSucursalDocumento";
    const SerieDocumento = "GSS_UsuarioSucuDocumento.SerieDocumento";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_UsuarioSucuDocumento.IdSucuDoc AS IdSucuDoc, ";
        $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdSucursalDocumento AS IdSucursalDocumento, ";
        $s_SQLQuery .= "GSS_UsuarioSucuDocumento.SerieDocumento AS SerieDocumento ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_UsuarioSucuDocumentoBN */
    public function setByBN( GSS_UsuarioSucuDocumentoBN $o_GSS_UsuarioSucuDocumentoBN )
    {
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdSucuDoc() ) )
        {
            $this->setIdSucuDoc( $o_GSS_UsuarioSucuDocumentoBN->getIdSucuDoc() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_GSS_UsuarioSucuDocumentoBN->getIdUsuario() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_UsuarioSucuDocumentoBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() ) )
        {
            $this->setIdSucursalDocumento( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
        }
        if ( !is_null( $o_GSS_UsuarioSucuDocumentoBN->getSerieDocumento() ) )
        {
            $this->setSerieDocumento( $o_GSS_UsuarioSucuDocumentoBN->getSerieDocumento() );
        }
    }

    /**
    * @return GSS_UsuarioSucuDocumentoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdSucuDoc )
    {
        if( is_null( $i_IdSucuDoc ) ){ $i_IdSucuDoc = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_UsuarioSucuDocumento ";
        $s_SQLQuery .= "WHERE IdSucuDoc = ".$i_IdSucuDoc." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_UsuarioSucuDocumentoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_UsuarioSucuDocumentoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_UsuarioSucuDocumentoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSucuDoc() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdSucuDoc = ".$this->getIdSucuDoc()." AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdSucursalDocumento() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.IdSucursalDocumento = ".$this->getIdSucursalDocumento()." AND ";
        if ( !is_null( $this->getSerieDocumento() ) ) $s_SQLQuery .= "GSS_UsuarioSucuDocumento.SerieDocumento = '".$this->getSerieDocumento()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_UsuarioSucuDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_UsuarioSucuDocumentoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_UsuarioSucuDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_UsuarioSucuDocumentoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_UsuarioSucuDocumentoBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_UsuarioSucuDocumentoBN[] = $o_GSS_UsuarioSucuDocumentoBN;
            }
        }
        return $a_GSS_UsuarioSucuDocumentoBN;
    }

    /* Devuelve un objeto GSS_UsuarioSucuDocumentoBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_UsuarioSucuDocumento )
    {
        $o_GSS_UsuarioSucuDocumentoBN = new GSS_UsuarioSucuDocumentoBN();
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['IdSucuDoc'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setIdSucuDoc( ( integer ) $a_GSS_UsuarioSucuDocumento['IdSucuDoc'] );
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['IdUsuario'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setIdUsuario( $a_GSS_UsuarioSucuDocumento['IdUsuario'] );
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['IdCompania'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setIdCompania( ( integer ) $a_GSS_UsuarioSucuDocumento['IdCompania'] );
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['IdTipoDocumento'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setIdTipoDocumento( $a_GSS_UsuarioSucuDocumento['IdTipoDocumento'] );
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['IdSucursalDocumento'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setIdSucursalDocumento( ( integer ) $a_GSS_UsuarioSucuDocumento['IdSucursalDocumento'] );
        if ( !is_null( $a_GSS_UsuarioSucuDocumento['SerieDocumento'] ) ) $o_GSS_UsuarioSucuDocumentoBN->setSerieDocumento( $a_GSS_UsuarioSucuDocumento['SerieDocumento'] );
        return $o_GSS_UsuarioSucuDocumentoBN;
    }
}
?>