<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Ticketera.xml */
/* Generado: 2021-06-25 23:59:48 */

/* Busqueda de registros de la tabla GSS_Ticketera. */
abstract class BaseGSS_TicketeraFN extends GSS_TicketeraBN
{
    /* Declaracion de constantes */
    const IdTicketera = "GSS_Ticketera.IdTicketera";
    const IdSucursal = "GSS_Ticketera.IdSucursal";
    const AutorizacionSunat = "GSS_Ticketera.AutorizacionSunat";
    const SerieTicket = "GSS_Ticketera.SerieTicket";
    const Estado = "GSS_Ticketera.Estado";
    const FechaCreacion = "GSS_Ticketera.FechaCreacion";
    const UsuarioCreacion = "GSS_Ticketera.UsuarioCreacion";
    const FechaModificacion = "GSS_Ticketera.FechaModificacion";
    const UsuarioModificacion = "GSS_Ticketera.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Ticketera.IdTicketera AS IdTicketera, ";
        $s_SQLQuery .= "GSS_Ticketera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "GSS_Ticketera.AutorizacionSunat AS AutorizacionSunat, ";
        $s_SQLQuery .= "GSS_Ticketera.SerieTicket AS SerieTicket, ";
        $s_SQLQuery .= "GSS_Ticketera.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Ticketera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Ticketera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Ticketera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Ticketera.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_TicketeraBN */
    public function setByBN( GSS_TicketeraBN $o_GSS_TicketeraBN )
    {
        if ( !is_null( $o_GSS_TicketeraBN->getIdTicketera() ) )
        {
            $this->setIdTicketera( $o_GSS_TicketeraBN->getIdTicketera() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_TicketeraBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getAutorizacionSunat() ) )
        {
            $this->setAutorizacionSunat( $o_GSS_TicketeraBN->getAutorizacionSunat() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getSerieTicket() ) )
        {
            $this->setSerieTicket( $o_GSS_TicketeraBN->getSerieTicket() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_TicketeraBN->getEstado() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_TicketeraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_TicketeraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_TicketeraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_TicketeraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_TicketeraBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_TicketeraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTicketera )
    {
        if( is_null( $i_IdTicketera ) ){ $i_IdTicketera = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Ticketera ";
        $s_SQLQuery .= "WHERE IdTicketera = ".$i_IdTicketera." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_TicketeraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_TicketeraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_TicketeraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTicketera() ) ) $s_SQLQuery .= "GSS_Ticketera.IdTicketera = ".$this->getIdTicketera()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "GSS_Ticketera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getAutorizacionSunat() ) ) $s_SQLQuery .= "GSS_Ticketera.AutorizacionSunat = '".$this->getAutorizacionSunat()."' AND ";
        if ( !is_null( $this->getSerieTicket() ) ) $s_SQLQuery .= "GSS_Ticketera.SerieTicket = '".$this->getSerieTicket()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Ticketera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Ticketera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Ticketera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Ticketera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Ticketera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Ticketera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_TicketeraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Ticketera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_TicketeraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_TicketeraBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_TicketeraBN[] = $o_GSS_TicketeraBN;
            }
        }
        return $a_GSS_TicketeraBN;
    }

    /* Devuelve un objeto GSS_TicketeraBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Ticketera )
    {
        $o_GSS_TicketeraBN = new GSS_TicketeraBN();
        if ( !is_null( $a_GSS_Ticketera['IdTicketera'] ) ) $o_GSS_TicketeraBN->setIdTicketera( ( integer ) $a_GSS_Ticketera['IdTicketera'] );
        if ( !is_null( $a_GSS_Ticketera['IdSucursal'] ) ) $o_GSS_TicketeraBN->setIdSucursal( ( integer ) $a_GSS_Ticketera['IdSucursal'] );
        if ( !is_null( $a_GSS_Ticketera['AutorizacionSunat'] ) ) $o_GSS_TicketeraBN->setAutorizacionSunat( $a_GSS_Ticketera['AutorizacionSunat'] );
        if ( !is_null( $a_GSS_Ticketera['SerieTicket'] ) ) $o_GSS_TicketeraBN->setSerieTicket( $a_GSS_Ticketera['SerieTicket'] );
        if ( !is_null( $a_GSS_Ticketera['Estado'] ) ) $o_GSS_TicketeraBN->setEstado( $a_GSS_Ticketera['Estado'] );
        if ( !is_null( $a_GSS_Ticketera['FechaCreacion'] ) ) $o_GSS_TicketeraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Ticketera['FechaCreacion'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_Ticketera['UsuarioCreacion'] ) ) $o_GSS_TicketeraBN->setUsuarioCreacion( $a_GSS_Ticketera['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Ticketera['FechaModificacion'] ) ) $o_GSS_TicketeraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Ticketera['FechaModificacion'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_Ticketera['UsuarioModificacion'] ) ) $o_GSS_TicketeraBN->setUsuarioModificacion( $a_GSS_Ticketera['UsuarioModificacion'] );
        return $o_GSS_TicketeraBN;
    }
}
?>