<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Sucursal.xml */
/* Generado: 2022-01-18 15:31:54 */

/* Busqueda de registros de la tabla GSS_Sucursal. */
abstract class BaseGSS_SucursalFN extends GSS_SucursalBN
{
    /* Declaracion de constantes */
    const IdSucursal = "GSS_Sucursal.IdSucursal";
    const IdCompania = "GSS_Sucursal.IdCompania";
    const IdUnidadProduccion = "GSS_Sucursal.IdUnidadProduccion";
    const IdAlmacen = "GSS_Sucursal.IdAlmacen";
    const CodigoSunat = "GSS_Sucursal.CodigoSunat";
    const Descripcion = "GSS_Sucursal.Descripcion";
    const Departamento = "GSS_Sucursal.Departamento";
    const Provincia = "GSS_Sucursal.Provincia";
    const Distrito = "GSS_Sucursal.Distrito";
    const Direccion = "GSS_Sucursal.Direccion";
    const Telefono = "GSS_Sucursal.Telefono";
    const Longitud = "GSS_Sucursal.Longitud";
    const Latitud = "GSS_Sucursal.Latitud";
    const Ubigeo = "GSS_Sucursal.Ubigeo";
    const Ip = "GSS_Sucursal.Ip";
    const CuentaContableDefecto = "GSS_Sucursal.CuentaContableDefecto";
    const EstaExoneradoIGV = "GSS_Sucursal.EstaExoneradoIGV";
    const RutaProveedorExt = "GSS_Sucursal.RutaProveedorExt";
    const TokenProveedorExt = "GSS_Sucursal.TokenProveedorExt";
    const Estado = "GSS_Sucursal.Estado";
    const FechaCreacion = "GSS_Sucursal.FechaCreacion";
    const UsuarioCreacion = "GSS_Sucursal.UsuarioCreacion";
    const FechaModificacion = "GSS_Sucursal.FechaModificacion";
    const UsuarioModificacion = "GSS_Sucursal.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Sucursal.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "GSS_Sucursal.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_Sucursal.IdUnidadProduccion AS IdUnidadProduccion, ";
        $s_SQLQuery .= "GSS_Sucursal.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "GSS_Sucursal.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "GSS_Sucursal.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_Sucursal.Departamento AS Departamento, ";
        $s_SQLQuery .= "GSS_Sucursal.Provincia AS Provincia, ";
        $s_SQLQuery .= "GSS_Sucursal.Distrito AS Distrito, ";
        $s_SQLQuery .= "GSS_Sucursal.Direccion AS Direccion, ";
        $s_SQLQuery .= "GSS_Sucursal.Telefono AS Telefono, ";
        $s_SQLQuery .= "GSS_Sucursal.Longitud AS Longitud, ";
        $s_SQLQuery .= "GSS_Sucursal.Latitud AS Latitud, ";
        $s_SQLQuery .= "GSS_Sucursal.Ubigeo AS Ubigeo, ";
        $s_SQLQuery .= "GSS_Sucursal.Ip AS Ip, ";
        $s_SQLQuery .= "GSS_Sucursal.CuentaContableDefecto AS CuentaContableDefecto, ";
        $s_SQLQuery .= "GSS_Sucursal.EstaExoneradoIGV AS EstaExoneradoIGV, ";
        $s_SQLQuery .= "GSS_Sucursal.RutaProveedorExt AS RutaProveedorExt, ";
        $s_SQLQuery .= "GSS_Sucursal.TokenProveedorExt AS TokenProveedorExt, ";
        $s_SQLQuery .= "GSS_Sucursal.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Sucursal.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Sucursal.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Sucursal.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Sucursal.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_SucursalBN */
    public function setByBN( GSS_SucursalBN $o_GSS_SucursalBN )
    {
        if ( !is_null( $o_GSS_SucursalBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_SucursalBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_SucursalBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdUnidadProduccion() ) )
        {
            $this->setIdUnidadProduccion( $o_GSS_SucursalBN->getIdUnidadProduccion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_GSS_SucursalBN->getIdAlmacen() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_SucursalBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_SucursalBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_GSS_SucursalBN->getDepartamento() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getProvincia() ) )
        {
            $this->setProvincia( $o_GSS_SucursalBN->getProvincia() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDistrito() ) )
        {
            $this->setDistrito( $o_GSS_SucursalBN->getDistrito() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDireccion() ) )
        {
            $this->setDireccion( $o_GSS_SucursalBN->getDireccion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getTelefono() ) )
        {
            $this->setTelefono( $o_GSS_SucursalBN->getTelefono() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getLongitud() ) )
        {
            $this->setLongitud( $o_GSS_SucursalBN->getLongitud() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getLatitud() ) )
        {
            $this->setLatitud( $o_GSS_SucursalBN->getLatitud() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUbigeo() ) )
        {
            $this->setUbigeo( $o_GSS_SucursalBN->getUbigeo() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIp() ) )
        {
            $this->setIp( $o_GSS_SucursalBN->getIp() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getCuentaContableDefecto() ) )
        {
            $this->setCuentaContableDefecto( $o_GSS_SucursalBN->getCuentaContableDefecto() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getEstaExoneradoIGV() ) )
        {
            $this->setEstaExoneradoIGV( $o_GSS_SucursalBN->getEstaExoneradoIGV() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getRutaProveedorExt() ) )
        {
            $this->setRutaProveedorExt( $o_GSS_SucursalBN->getRutaProveedorExt() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getTokenProveedorExt() ) )
        {
            $this->setTokenProveedorExt( $o_GSS_SucursalBN->getTokenProveedorExt() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_SucursalBN->getEstado() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_SucursalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_SucursalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_SucursalBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_SucursalBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_SucursalBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdSucursal )
    {
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Sucursal ";
        $s_SQLQuery .= "WHERE IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_SucursalBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_SucursalBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_SucursalBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "GSS_Sucursal.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_Sucursal.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdUnidadProduccion() ) ) $s_SQLQuery .= "GSS_Sucursal.IdUnidadProduccion = ".$this->getIdUnidadProduccion()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "GSS_Sucursal.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "GSS_Sucursal.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_Sucursal.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getDepartamento() ) ) $s_SQLQuery .= "GSS_Sucursal.Departamento = '".$this->getDepartamento()."' AND ";
        if ( !is_null( $this->getProvincia() ) ) $s_SQLQuery .= "GSS_Sucursal.Provincia = '".$this->getProvincia()."' AND ";
        if ( !is_null( $this->getDistrito() ) ) $s_SQLQuery .= "GSS_Sucursal.Distrito = '".$this->getDistrito()."' AND ";
        if ( !is_null( $this->getDireccion() ) ) $s_SQLQuery .= "GSS_Sucursal.Direccion = '".$this->getDireccion()."' AND ";
        if ( !is_null( $this->getTelefono() ) ) $s_SQLQuery .= "GSS_Sucursal.Telefono = '".$this->getTelefono()."' AND ";
        if ( !is_null( $this->getLongitud() ) ) $s_SQLQuery .= "GSS_Sucursal.Longitud = '".$this->getLongitud()."' AND ";
        if ( !is_null( $this->getLatitud() ) ) $s_SQLQuery .= "GSS_Sucursal.Latitud = '".$this->getLatitud()."' AND ";
        if ( !is_null( $this->getUbigeo() ) ) $s_SQLQuery .= "GSS_Sucursal.Ubigeo = '".$this->getUbigeo()."' AND ";
        if ( !is_null( $this->getIp() ) ) $s_SQLQuery .= "GSS_Sucursal.Ip = '".$this->getIp()."' AND ";
        if ( !is_null( $this->getCuentaContableDefecto() ) ) $s_SQLQuery .= "GSS_Sucursal.CuentaContableDefecto = '".$this->getCuentaContableDefecto()."' AND ";
        if ( !is_null( $this->getEstaExoneradoIGV() ) ) $s_SQLQuery .= "GSS_Sucursal.EstaExoneradoIGV = ".$this->getEstaExoneradoIGV()." AND ";
        if ( !is_null( $this->getRutaProveedorExt() ) ) $s_SQLQuery .= "GSS_Sucursal.RutaProveedorExt = '".$this->getRutaProveedorExt()."' AND ";
        if ( !is_null( $this->getTokenProveedorExt() ) ) $s_SQLQuery .= "GSS_Sucursal.TokenProveedorExt = '".$this->getTokenProveedorExt()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Sucursal.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Sucursal.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Sucursal.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Sucursal.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Sucursal.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Sucursal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_SucursalBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Sucursal WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_SucursalBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_SucursalBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_SucursalBN[] = $o_GSS_SucursalBN;
            }
        }
        return $a_GSS_SucursalBN;
    }

    /* Devuelve un objeto GSS_SucursalBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Sucursal )
    {
        $o_GSS_SucursalBN = new GSS_SucursalBN();
        if ( !is_null( $a_GSS_Sucursal['IdSucursal'] ) ) $o_GSS_SucursalBN->setIdSucursal( ( integer ) $a_GSS_Sucursal['IdSucursal'] );
        if ( !is_null( $a_GSS_Sucursal['IdCompania'] ) ) $o_GSS_SucursalBN->setIdCompania( ( integer ) $a_GSS_Sucursal['IdCompania'] );
        if ( !is_null( $a_GSS_Sucursal['IdUnidadProduccion'] ) ) $o_GSS_SucursalBN->setIdUnidadProduccion( ( integer ) $a_GSS_Sucursal['IdUnidadProduccion'] );
        if ( !is_null( $a_GSS_Sucursal['IdAlmacen'] ) ) $o_GSS_SucursalBN->setIdAlmacen( $a_GSS_Sucursal['IdAlmacen'] );
        if ( !is_null( $a_GSS_Sucursal['CodigoSunat'] ) ) $o_GSS_SucursalBN->setCodigoSunat( $a_GSS_Sucursal['CodigoSunat'] );
        if ( !is_null( $a_GSS_Sucursal['Descripcion'] ) ) $o_GSS_SucursalBN->setDescripcion( $a_GSS_Sucursal['Descripcion'] );
        if ( !is_null( $a_GSS_Sucursal['Departamento'] ) ) $o_GSS_SucursalBN->setDepartamento( $a_GSS_Sucursal['Departamento'] );
        if ( !is_null( $a_GSS_Sucursal['Provincia'] ) ) $o_GSS_SucursalBN->setProvincia( $a_GSS_Sucursal['Provincia'] );
        if ( !is_null( $a_GSS_Sucursal['Distrito'] ) ) $o_GSS_SucursalBN->setDistrito( $a_GSS_Sucursal['Distrito'] );
        if ( !is_null( $a_GSS_Sucursal['Direccion'] ) ) $o_GSS_SucursalBN->setDireccion( $a_GSS_Sucursal['Direccion'] );
        if ( !is_null( $a_GSS_Sucursal['Telefono'] ) ) $o_GSS_SucursalBN->setTelefono( $a_GSS_Sucursal['Telefono'] );
        if ( !is_null( $a_GSS_Sucursal['Longitud'] ) ) $o_GSS_SucursalBN->setLongitud( $a_GSS_Sucursal['Longitud'] );
        if ( !is_null( $a_GSS_Sucursal['Latitud'] ) ) $o_GSS_SucursalBN->setLatitud( $a_GSS_Sucursal['Latitud'] );
        if ( !is_null( $a_GSS_Sucursal['Ubigeo'] ) ) $o_GSS_SucursalBN->setUbigeo( $a_GSS_Sucursal['Ubigeo'] );
        if ( !is_null( $a_GSS_Sucursal['Ip'] ) ) $o_GSS_SucursalBN->setIp( $a_GSS_Sucursal['Ip'] );
        if ( !is_null( $a_GSS_Sucursal['CuentaContableDefecto'] ) ) $o_GSS_SucursalBN->setCuentaContableDefecto( $a_GSS_Sucursal['CuentaContableDefecto'] );
        if ( !is_null( $a_GSS_Sucursal['EstaExoneradoIGV'] ) ) $o_GSS_SucursalBN->setEstaExoneradoIGV( ( integer ) $a_GSS_Sucursal['EstaExoneradoIGV'] );
        if ( !is_null( $a_GSS_Sucursal['RutaProveedorExt'] ) ) $o_GSS_SucursalBN->setRutaProveedorExt( $a_GSS_Sucursal['RutaProveedorExt'] );
        if ( !is_null( $a_GSS_Sucursal['TokenProveedorExt'] ) ) $o_GSS_SucursalBN->setTokenProveedorExt( $a_GSS_Sucursal['TokenProveedorExt'] );
        if ( !is_null( $a_GSS_Sucursal['Estado'] ) ) $o_GSS_SucursalBN->setEstado( $a_GSS_Sucursal['Estado'] );
        if ( !is_null( $a_GSS_Sucursal['FechaCreacion'] ) ) $o_GSS_SucursalBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Sucursal['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Sucursal['UsuarioCreacion'] ) ) $o_GSS_SucursalBN->setUsuarioCreacion( $a_GSS_Sucursal['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Sucursal['FechaModificacion'] ) ) $o_GSS_SucursalBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Sucursal['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Sucursal['UsuarioModificacion'] ) ) $o_GSS_SucursalBN->setUsuarioModificacion( $a_GSS_Sucursal['UsuarioModificacion'] );
        return $o_GSS_SucursalBN;
    }
}
?>