<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_MonedaMast.xml */
/* Generado: 2021-06-25 23:59:47 */

/* Busqueda de registros de la tabla GSS_MonedaMast. */
abstract class BaseGSS_MonedaMastFN extends GSS_MonedaMastBN
{
    /* Declaracion de constantes */
    const IdMoneda = "GSS_MonedaMast.IdMoneda";
    const Descripcion = "GSS_MonedaMast.Descripcion";
    const Sigla = "GSS_MonedaMast.Sigla";
    const CodigoFiscal = "GSS_MonedaMast.CodigoFiscal";
    const Estado = "GSS_MonedaMast.Estado";
    const FechaCreacion = "GSS_MonedaMast.FechaCreacion";
    const UsuarioCreacion = "GSS_MonedaMast.UsuarioCreacion";
    const FechaModificacion = "GSS_MonedaMast.FechaModificacion";
    const UsuarioModificacion = "GSS_MonedaMast.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_MonedaMast.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "GSS_MonedaMast.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_MonedaMast.Sigla AS Sigla, ";
        $s_SQLQuery .= "GSS_MonedaMast.CodigoFiscal AS CodigoFiscal, ";
        $s_SQLQuery .= "GSS_MonedaMast.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_MonedaMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_MonedaMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_MonedaMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_MonedaMast.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_MonedaMastBN */
    public function setByBN( GSS_MonedaMastBN $o_GSS_MonedaMastBN )
    {
        if ( !is_null( $o_GSS_MonedaMastBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_GSS_MonedaMastBN->getIdMoneda() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_MonedaMastBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getSigla() ) )
        {
            $this->setSigla( $o_GSS_MonedaMastBN->getSigla() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_GSS_MonedaMastBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_MonedaMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_MonedaMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_MonedaMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_MonedaMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_MonedaMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_MonedaMastBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_MonedaMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdMoneda )
    {
        if( is_null( $s_IdMoneda ) ){ $s_IdMoneda = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_MonedaMast ";
        $s_SQLQuery .= "WHERE IdMoneda = '".$s_IdMoneda."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_MonedaMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_MonedaMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_MonedaMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "GSS_MonedaMast.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_MonedaMast.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getSigla() ) ) $s_SQLQuery .= "GSS_MonedaMast.Sigla = '".$this->getSigla()."' AND ";
        if ( !is_null( $this->getCodigoFiscal() ) ) $s_SQLQuery .= "GSS_MonedaMast.CodigoFiscal = '".$this->getCodigoFiscal()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_MonedaMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_MonedaMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_MonedaMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_MonedaMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_MonedaMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_MonedaMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_MonedaMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_MonedaMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_MonedaMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_MonedaMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_MonedaMastBN[] = $o_GSS_MonedaMastBN;
            }
        }
        return $a_GSS_MonedaMastBN;
    }

    /* Devuelve un objeto GSS_MonedaMastBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_MonedaMast )
    {
        $o_GSS_MonedaMastBN = new GSS_MonedaMastBN();
        if ( !is_null( $a_GSS_MonedaMast['IdMoneda'] ) ) $o_GSS_MonedaMastBN->setIdMoneda( $a_GSS_MonedaMast['IdMoneda'] );
        if ( !is_null( $a_GSS_MonedaMast['Descripcion'] ) ) $o_GSS_MonedaMastBN->setDescripcion( $a_GSS_MonedaMast['Descripcion'] );
        if ( !is_null( $a_GSS_MonedaMast['Sigla'] ) ) $o_GSS_MonedaMastBN->setSigla( $a_GSS_MonedaMast['Sigla'] );
        if ( !is_null( $a_GSS_MonedaMast['CodigoFiscal'] ) ) $o_GSS_MonedaMastBN->setCodigoFiscal( $a_GSS_MonedaMast['CodigoFiscal'] );
        if ( !is_null( $a_GSS_MonedaMast['Estado'] ) ) $o_GSS_MonedaMastBN->setEstado( $a_GSS_MonedaMast['Estado'] );
        if ( !is_null( $a_GSS_MonedaMast['FechaCreacion'] ) ) $o_GSS_MonedaMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_MonedaMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_MonedaMast['UsuarioCreacion'] ) ) $o_GSS_MonedaMastBN->setUsuarioCreacion( $a_GSS_MonedaMast['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_MonedaMast['FechaModificacion'] ) ) $o_GSS_MonedaMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_MonedaMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_MonedaMast['UsuarioModificacion'] ) ) $o_GSS_MonedaMastBN->setUsuarioModificacion( $a_GSS_MonedaMast['UsuarioModificacion'] );
        return $o_GSS_MonedaMastBN;
    }
}
?>