<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Impuesto.xml */
/* Generado: 2021-10-11 19:18:18 */

/* Busqueda de registros de la tabla GSS_Impuesto. */
abstract class BaseGSS_ImpuestoFN extends GSS_ImpuestoBN
{
    /* Declaracion de constantes */
    const IdImpuesto = "GSS_Impuesto.IdImpuesto";
    const Codigo = "GSS_Impuesto.Codigo";
    const Descripcion = "GSS_Impuesto.Descripcion";
    const Valor = "GSS_Impuesto.Valor";
    const CodigoSunat = "GSS_Impuesto.CodigoSunat";
    const CuentaContable = "GSS_Impuesto.CuentaContable";
    const TipoRegistro = "GSS_Impuesto.TipoRegistro";
    const FechaDesde = "GSS_Impuesto.FechaDesde";
    const FechaHasta = "GSS_Impuesto.FechaHasta";
    const Estado = "GSS_Impuesto.Estado";
    const FechaCreacion = "GSS_Impuesto.FechaCreacion";
    const UsuarioCreacion = "GSS_Impuesto.UsuarioCreacion";
    const FechaModificacion = "GSS_Impuesto.FechaModificacion";
    const UsuarioModificacion = "GSS_Impuesto.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Impuesto.IdImpuesto AS IdImpuesto, ";
        $s_SQLQuery .= "GSS_Impuesto.Codigo AS Codigo, ";
        $s_SQLQuery .= "GSS_Impuesto.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_Impuesto.Valor AS Valor, ";
        $s_SQLQuery .= "GSS_Impuesto.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "GSS_Impuesto.CuentaContable AS CuentaContable, ";
        $s_SQLQuery .= "GSS_Impuesto.TipoRegistro AS TipoRegistro, ";
        $s_SQLQuery .= "GSS_Impuesto.FechaDesde AS FechaDesde, ";
        $s_SQLQuery .= "GSS_Impuesto.FechaHasta AS FechaHasta, ";
        $s_SQLQuery .= "GSS_Impuesto.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Impuesto.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Impuesto.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Impuesto.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Impuesto.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_ImpuestoBN */
    public function setByBN( GSS_ImpuestoBN $o_GSS_ImpuestoBN )
    {
        if ( !is_null( $o_GSS_ImpuestoBN->getIdImpuesto() ) )
        {
            $this->setIdImpuesto( $o_GSS_ImpuestoBN->getIdImpuesto() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_ImpuestoBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_ImpuestoBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getValor() ) )
        {
            $this->setValor( $o_GSS_ImpuestoBN->getValor() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_ImpuestoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCuentaContable() ) )
        {
            $this->setCuentaContable( $o_GSS_ImpuestoBN->getCuentaContable() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getTipoRegistro() ) )
        {
            $this->setTipoRegistro( $o_GSS_ImpuestoBN->getTipoRegistro() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaDesde() ) )
        {
            $this->setFechaDesde( $o_GSS_ImpuestoBN->getFechaDesde() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaHasta() ) )
        {
            $this->setFechaHasta( $o_GSS_ImpuestoBN->getFechaHasta() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_ImpuestoBN->getEstado() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_ImpuestoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_ImpuestoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_ImpuestoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_ImpuestoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_ImpuestoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdImpuesto )
    {
        if( is_null( $i_IdImpuesto ) ){ $i_IdImpuesto = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Impuesto ";
        $s_SQLQuery .= "WHERE IdImpuesto = ".$i_IdImpuesto." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_ImpuestoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_ImpuestoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_ImpuestoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdImpuesto() ) ) $s_SQLQuery .= "GSS_Impuesto.IdImpuesto = ".$this->getIdImpuesto()." AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "GSS_Impuesto.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_Impuesto.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getValor() ) ) $s_SQLQuery .= "GSS_Impuesto.Valor = ".$this->getValor()." AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "GSS_Impuesto.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getCuentaContable() ) ) $s_SQLQuery .= "GSS_Impuesto.CuentaContable = '".$this->getCuentaContable()."' AND ";
        if ( !is_null( $this->getTipoRegistro() ) ) $s_SQLQuery .= "GSS_Impuesto.TipoRegistro = '".$this->getTipoRegistro()."' AND ";
        if ( !is_null( $this->getFechaDesde() ) ) $s_SQLQuery .= "GSS_Impuesto.FechaDesde = '".$this->getFechaDesde()."' AND ";
        if ( !is_null( $this->getFechaHasta() ) ) $s_SQLQuery .= "GSS_Impuesto.FechaHasta = '".$this->getFechaHasta()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Impuesto.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Impuesto.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Impuesto.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Impuesto.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Impuesto.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Impuesto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_ImpuestoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Impuesto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_ImpuestoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_ImpuestoBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_ImpuestoBN[] = $o_GSS_ImpuestoBN;
            }
        }
        return $a_GSS_ImpuestoBN;
    }

    /* Devuelve un objeto GSS_ImpuestoBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Impuesto )
    {
        $o_GSS_ImpuestoBN = new GSS_ImpuestoBN();
        if ( !is_null( $a_GSS_Impuesto['IdImpuesto'] ) ) $o_GSS_ImpuestoBN->setIdImpuesto( ( integer ) $a_GSS_Impuesto['IdImpuesto'] );
        if ( !is_null( $a_GSS_Impuesto['Codigo'] ) ) $o_GSS_ImpuestoBN->setCodigo( $a_GSS_Impuesto['Codigo'] );
        if ( !is_null( $a_GSS_Impuesto['Descripcion'] ) ) $o_GSS_ImpuestoBN->setDescripcion( $a_GSS_Impuesto['Descripcion'] );
        if ( !is_null( $a_GSS_Impuesto['Valor'] ) ) $o_GSS_ImpuestoBN->setValor( ( float ) $a_GSS_Impuesto['Valor'] );
        if ( !is_null( $a_GSS_Impuesto['CodigoSunat'] ) ) $o_GSS_ImpuestoBN->setCodigoSunat( $a_GSS_Impuesto['CodigoSunat'] );
        if ( !is_null( $a_GSS_Impuesto['CuentaContable'] ) ) $o_GSS_ImpuestoBN->setCuentaContable( $a_GSS_Impuesto['CuentaContable'] );
        if ( !is_null( $a_GSS_Impuesto['TipoRegistro'] ) ) $o_GSS_ImpuestoBN->setTipoRegistro( $a_GSS_Impuesto['TipoRegistro'] );
        if ( !is_null( $a_GSS_Impuesto['FechaDesde'] ) ) $o_GSS_ImpuestoBN->setFechaDesde( utilTimestamp::getTimestamp( $a_GSS_Impuesto['FechaDesde'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_Impuesto['FechaHasta'] ) ) $o_GSS_ImpuestoBN->setFechaHasta( utilTimestamp::getTimestamp( $a_GSS_Impuesto['FechaHasta'], "Y-m-d" ) );
        if ( !is_null( $a_GSS_Impuesto['Estado'] ) ) $o_GSS_ImpuestoBN->setEstado( $a_GSS_Impuesto['Estado'] );
        if ( !is_null( $a_GSS_Impuesto['FechaCreacion'] ) ) $o_GSS_ImpuestoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Impuesto['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Impuesto['UsuarioCreacion'] ) ) $o_GSS_ImpuestoBN->setUsuarioCreacion( $a_GSS_Impuesto['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Impuesto['FechaModificacion'] ) ) $o_GSS_ImpuestoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Impuesto['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Impuesto['UsuarioModificacion'] ) ) $o_GSS_ImpuestoBN->setUsuarioModificacion( $a_GSS_Impuesto['UsuarioModificacion'] );
        return $o_GSS_ImpuestoBN;
    }
}
?>