<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_FeriadosMast.xml */
/* Generado: 2021-06-25 23:59:47 */

/* Busqueda de registros de la tabla GSS_FeriadosMast. */
abstract class BaseGSS_FeriadosMastFN extends GSS_FeriadosMastBN
{
    /* Declaracion de constantes */
    const IdFeriado = "GSS_FeriadosMast.IdFeriado";
    const IdCompania = "GSS_FeriadosMast.IdCompania";
    const IdSucursal = "GSS_FeriadosMast.IdSucursal";
    const Anio = "GSS_FeriadosMast.Anio";
    const Mes = "GSS_FeriadosMast.Mes";
    const Dia = "GSS_FeriadosMast.Dia";
    const DiaNumero = "GSS_FeriadosMast.DiaNumero";
    const UsuarioCreacion = "GSS_FeriadosMast.UsuarioCreacion";
    const FechaCreacion = "GSS_FeriadosMast.FechaCreacion";
    const UsuarioModificacion = "GSS_FeriadosMast.UsuarioModificacion";
    const FechaModificacion = "GSS_FeriadosMast.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_FeriadosMast.IdFeriado AS IdFeriado, ";
        $s_SQLQuery .= "GSS_FeriadosMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_FeriadosMast.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "GSS_FeriadosMast.Anio AS Anio, ";
        $s_SQLQuery .= "GSS_FeriadosMast.Mes AS Mes, ";
        $s_SQLQuery .= "GSS_FeriadosMast.Dia AS Dia, ";
        $s_SQLQuery .= "GSS_FeriadosMast.DiaNumero AS DiaNumero, ";
        $s_SQLQuery .= "GSS_FeriadosMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_FeriadosMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_FeriadosMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "GSS_FeriadosMast.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_FeriadosMastBN */
    public function setByBN( GSS_FeriadosMastBN $o_GSS_FeriadosMastBN )
    {
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdFeriado() ) )
        {
            $this->setIdFeriado( $o_GSS_FeriadosMastBN->getIdFeriado() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_FeriadosMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_FeriadosMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getAnio() ) )
        {
            $this->setAnio( $o_GSS_FeriadosMastBN->getAnio() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getMes() ) )
        {
            $this->setMes( $o_GSS_FeriadosMastBN->getMes() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getDia() ) )
        {
            $this->setDia( $o_GSS_FeriadosMastBN->getDia() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getDiaNumero() ) )
        {
            $this->setDiaNumero( $o_GSS_FeriadosMastBN->getDiaNumero() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_FeriadosMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_FeriadosMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_FeriadosMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_FeriadosMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_FeriadosMastBN->getFechaModificacion() );
        }
    }

    /**
    * @return GSS_FeriadosMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdFeriado )
    {
        if( is_null( $i_IdFeriado ) ){ $i_IdFeriado = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_FeriadosMast ";
        $s_SQLQuery .= "WHERE IdFeriado = ".$i_IdFeriado." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_FeriadosMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_FeriadosMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_FeriadosMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdFeriado() ) ) $s_SQLQuery .= "GSS_FeriadosMast.IdFeriado = ".$this->getIdFeriado()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_FeriadosMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "GSS_FeriadosMast.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getAnio() ) ) $s_SQLQuery .= "GSS_FeriadosMast.Anio = '".$this->getAnio()."' AND ";
        if ( !is_null( $this->getMes() ) ) $s_SQLQuery .= "GSS_FeriadosMast.Mes = '".$this->getMes()."' AND ";
        if ( !is_null( $this->getDia() ) ) $s_SQLQuery .= "GSS_FeriadosMast.Dia = '".$this->getDia()."' AND ";
        if ( !is_null( $this->getDiaNumero() ) ) $s_SQLQuery .= "GSS_FeriadosMast.DiaNumero = ".$this->getDiaNumero()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_FeriadosMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_FeriadosMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_FeriadosMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_FeriadosMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_FeriadosMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_FeriadosMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_FeriadosMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_FeriadosMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_FeriadosMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_FeriadosMastBN[] = $o_GSS_FeriadosMastBN;
            }
        }
        return $a_GSS_FeriadosMastBN;
    }

    /* Devuelve un objeto GSS_FeriadosMastBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_FeriadosMast )
    {
        $o_GSS_FeriadosMastBN = new GSS_FeriadosMastBN();
        if ( !is_null( $a_GSS_FeriadosMast['IdFeriado'] ) ) $o_GSS_FeriadosMastBN->setIdFeriado( ( integer ) $a_GSS_FeriadosMast['IdFeriado'] );
        if ( !is_null( $a_GSS_FeriadosMast['IdCompania'] ) ) $o_GSS_FeriadosMastBN->setIdCompania( ( integer ) $a_GSS_FeriadosMast['IdCompania'] );
        if ( !is_null( $a_GSS_FeriadosMast['IdSucursal'] ) ) $o_GSS_FeriadosMastBN->setIdSucursal( ( integer ) $a_GSS_FeriadosMast['IdSucursal'] );
        if ( !is_null( $a_GSS_FeriadosMast['Anio'] ) ) $o_GSS_FeriadosMastBN->setAnio( $a_GSS_FeriadosMast['Anio'] );
        if ( !is_null( $a_GSS_FeriadosMast['Mes'] ) ) $o_GSS_FeriadosMastBN->setMes( $a_GSS_FeriadosMast['Mes'] );
        if ( !is_null( $a_GSS_FeriadosMast['Dia'] ) ) $o_GSS_FeriadosMastBN->setDia( $a_GSS_FeriadosMast['Dia'] );
        if ( !is_null( $a_GSS_FeriadosMast['DiaNumero'] ) ) $o_GSS_FeriadosMastBN->setDiaNumero( ( integer ) $a_GSS_FeriadosMast['DiaNumero'] );
        if ( !is_null( $a_GSS_FeriadosMast['UsuarioCreacion'] ) ) $o_GSS_FeriadosMastBN->setUsuarioCreacion( $a_GSS_FeriadosMast['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_FeriadosMast['FechaCreacion'] ) ) $o_GSS_FeriadosMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_FeriadosMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_FeriadosMast['UsuarioModificacion'] ) ) $o_GSS_FeriadosMastBN->setUsuarioModificacion( $a_GSS_FeriadosMast['UsuarioModificacion'] );
        if ( !is_null( $a_GSS_FeriadosMast['FechaModificacion'] ) ) $o_GSS_FeriadosMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_FeriadosMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_GSS_FeriadosMastBN;
    }
}
?>