<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_CorrelativoMast.xml */
/* Generado: 2021-06-25 23:59:47 */

/* Busqueda de registros de la tabla GSS_CorrelativoMast. */
abstract class BaseGSS_CorrelativoMastFN extends GSS_CorrelativoMastBN
{
    /* Declaracion de constantes */
    const IdCompania = "GSS_CorrelativoMast.IdCompania";
    const IdTipocomprobante = "GSS_CorrelativoMast.IdTipocomprobante";
    const IdSerie = "GSS_CorrelativoMast.IdSerie";
    const Descripcion = "GSS_CorrelativoMast.Descripcion";
    const CorrelativoNumero = "GSS_CorrelativoMast.CorrelativoNumero";
    const CorrelativoDesde = "GSS_CorrelativoMast.CorrelativoDesde";
    const CorrelativoHasta = "GSS_CorrelativoMast.CorrelativoHasta";
    const AlmacenCodigo = "GSS_CorrelativoMast.AlmacenCodigo";
    const Estado = "GSS_CorrelativoMast.Estado";
    const UsuarioModificacion = "GSS_CorrelativoMast.UsuarioModificacion";
    const FechaModificacion = "GSS_CorrelativoMast.FechaModificacion";
    const FechaCreacion = "GSS_CorrelativoMast.FechaCreacion";
    const UsuarioCreacion = "GSS_CorrelativoMast.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_CorrelativoMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.IdTipocomprobante AS IdTipocomprobante, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.IdSerie AS IdSerie, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoNumero AS CorrelativoNumero, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoDesde AS CorrelativoDesde, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoHasta AS CorrelativoHasta, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.AlmacenCodigo AS AlmacenCodigo, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_CorrelativoMast.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_CorrelativoMastBN */
    public function setByBN( GSS_CorrelativoMastBN $o_GSS_CorrelativoMastBN )
    {
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_CorrelativoMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdTipocomprobante() ) )
        {
            $this->setIdTipocomprobante( $o_GSS_CorrelativoMastBN->getIdTipocomprobante() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdSerie() ) )
        {
            $this->setIdSerie( $o_GSS_CorrelativoMastBN->getIdSerie() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_CorrelativoMastBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoNumero() ) )
        {
            $this->setCorrelativoNumero( $o_GSS_CorrelativoMastBN->getCorrelativoNumero() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoDesde() ) )
        {
            $this->setCorrelativoDesde( $o_GSS_CorrelativoMastBN->getCorrelativoDesde() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoHasta() ) )
        {
            $this->setCorrelativoHasta( $o_GSS_CorrelativoMastBN->getCorrelativoHasta() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getAlmacenCodigo() ) )
        {
            $this->setAlmacenCodigo( $o_GSS_CorrelativoMastBN->getAlmacenCodigo() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CorrelativoMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CorrelativoMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CorrelativoMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CorrelativoMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CorrelativoMastBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return GSS_CorrelativoMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdTipocomprobante, $s_IdSerie )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdTipocomprobante ) ){ $s_IdTipocomprobante = '-1'; } 
        if( is_null( $s_IdSerie ) ){ $s_IdSerie = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_CorrelativoMast ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdTipocomprobante = '".$s_IdTipocomprobante."' ";
        $s_SQLQuery .= "AND IdSerie = '".$s_IdSerie."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_CorrelativoMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_CorrelativoMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_CorrelativoMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdTipocomprobante() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.IdTipocomprobante = '".$this->getIdTipocomprobante()."' AND ";
        if ( !is_null( $this->getIdSerie() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.IdSerie = '".$this->getIdSerie()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCorrelativoNumero() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoNumero = ".$this->getCorrelativoNumero()." AND ";
        if ( !is_null( $this->getCorrelativoDesde() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoDesde = ".$this->getCorrelativoDesde()." AND ";
        if ( !is_null( $this->getCorrelativoHasta() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.CorrelativoHasta = ".$this->getCorrelativoHasta()." AND ";
        if ( !is_null( $this->getAlmacenCodigo() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.AlmacenCodigo = '".$this->getAlmacenCodigo()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_CorrelativoMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_CorrelativoMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_CorrelativoMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_CorrelativoMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_CorrelativoMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_CorrelativoMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_CorrelativoMastBN[] = $o_GSS_CorrelativoMastBN;
            }
        }
        return $a_GSS_CorrelativoMastBN;
    }

    /* Devuelve un objeto GSS_CorrelativoMastBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_CorrelativoMast )
    {
        $o_GSS_CorrelativoMastBN = new GSS_CorrelativoMastBN();
        if ( !is_null( $a_GSS_CorrelativoMast['IdCompania'] ) ) $o_GSS_CorrelativoMastBN->setIdCompania( ( integer ) $a_GSS_CorrelativoMast['IdCompania'] );
        if ( !is_null( $a_GSS_CorrelativoMast['IdTipocomprobante'] ) ) $o_GSS_CorrelativoMastBN->setIdTipocomprobante( $a_GSS_CorrelativoMast['IdTipocomprobante'] );
        if ( !is_null( $a_GSS_CorrelativoMast['IdSerie'] ) ) $o_GSS_CorrelativoMastBN->setIdSerie( $a_GSS_CorrelativoMast['IdSerie'] );
        if ( !is_null( $a_GSS_CorrelativoMast['Descripcion'] ) ) $o_GSS_CorrelativoMastBN->setDescripcion( $a_GSS_CorrelativoMast['Descripcion'] );
        if ( !is_null( $a_GSS_CorrelativoMast['CorrelativoNumero'] ) ) $o_GSS_CorrelativoMastBN->setCorrelativoNumero( ( integer ) $a_GSS_CorrelativoMast['CorrelativoNumero'] );
        if ( !is_null( $a_GSS_CorrelativoMast['CorrelativoDesde'] ) ) $o_GSS_CorrelativoMastBN->setCorrelativoDesde( ( integer ) $a_GSS_CorrelativoMast['CorrelativoDesde'] );
        if ( !is_null( $a_GSS_CorrelativoMast['CorrelativoHasta'] ) ) $o_GSS_CorrelativoMastBN->setCorrelativoHasta( ( integer ) $a_GSS_CorrelativoMast['CorrelativoHasta'] );
        if ( !is_null( $a_GSS_CorrelativoMast['AlmacenCodigo'] ) ) $o_GSS_CorrelativoMastBN->setAlmacenCodigo( $a_GSS_CorrelativoMast['AlmacenCodigo'] );
        if ( !is_null( $a_GSS_CorrelativoMast['Estado'] ) ) $o_GSS_CorrelativoMastBN->setEstado( $a_GSS_CorrelativoMast['Estado'] );
        if ( !is_null( $a_GSS_CorrelativoMast['UsuarioModificacion'] ) ) $o_GSS_CorrelativoMastBN->setUsuarioModificacion( $a_GSS_CorrelativoMast['UsuarioModificacion'] );
        if ( !is_null( $a_GSS_CorrelativoMast['FechaModificacion'] ) ) $o_GSS_CorrelativoMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_CorrelativoMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_CorrelativoMast['FechaCreacion'] ) ) $o_GSS_CorrelativoMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_CorrelativoMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_CorrelativoMast['UsuarioCreacion'] ) ) $o_GSS_CorrelativoMastBN->setUsuarioCreacion( $a_GSS_CorrelativoMast['UsuarioCreacion'] );
        return $o_GSS_CorrelativoMastBN;
    }
}
?>