<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Compania.xml */
/* Generado: 2022-02-16 18:36:47 */

/* Busqueda de registros de la tabla GSS_Compania. */
abstract class BaseGSS_CompaniaFN extends GSS_CompaniaBN
{
    /* Declaracion de constantes */
    const IdCompania = "GSS_Compania.IdCompania";
    const Codigo = "GSS_Compania.Codigo";
    const DescripcionCorta = "GSS_Compania.DescripcionCorta";
    const DescripcionLarga = "GSS_Compania.DescripcionLarga";
    const Departamento = "GSS_Compania.Departamento";
    const Provincia = "GSS_Compania.Provincia";
    const Distrito = "GSS_Compania.Distrito";
    const DireccionComun = "GSS_Compania.DireccionComun";
    const DireccionAdicional = "GSS_Compania.DireccionAdicional";
    const Telefono1 = "GSS_Compania.Telefono1";
    const Telefono2 = "GSS_Compania.Telefono2";
    const Ruc = "GSS_Compania.Ruc";
    const Estado = "GSS_Compania.Estado";
    const Telefono3 = "GSS_Compania.Telefono3";
    const Fax1 = "GSS_Compania.Fax1";
    const Fax2 = "GSS_Compania.Fax2";
    const AfectoIGVFlag = "GSS_Compania.AfectoIGVFlag";
    const LogoFileDir = "GSS_Compania.LogoFileDir";
    const LogoFile = "GSS_Compania.LogoFile";
    const LogoFileAncho = "GSS_Compania.LogoFileAncho";
    const LogoFileAlto = "GSS_Compania.LogoFileAlto";
    const LogoBackFileDir = "GSS_Compania.LogoBackFileDir";
    const LogoBackFileWeb = "GSS_Compania.LogoBackFileWeb";
    const LogoBackFileAncho = "GSS_Compania.LogoBackFileAncho";
    const LogoBackFileAlto = "GSS_Compania.LogoBackFileAlto";
    const RepresentanteLegal = "GSS_Compania.RepresentanteLegal";
    const PaginaWeb = "GSS_Compania.PaginaWeb";
    const FacturaNotasFormatoPDF = "GSS_Compania.FacturaNotasFormatoPDF";
    const BoletaNotasFormatoPDF = "GSS_Compania.BoletaNotasFormatoPDF";
    const EmailEmpresa = "GSS_Compania.EmailEmpresa";
    const DirParaBuscarComprobante = "GSS_Compania.DirParaBuscarComprobante";
    const PorTipoCambio = "GSS_Compania.PorTipoCambio";
    const EnviarProveedorAutoFlag = "GSS_Compania.EnviarProveedorAutoFlag";
    const AfectoRetencionIGVFlag = "GSS_Compania.AfectoRetencionIGVFlag";
    const AfectoPercepcionIGVFlag = "GSS_Compania.AfectoPercepcionIGVFlag";
    const MostrarMargenVenta = "GSS_Compania.MostrarMargenVenta";
    const CarteraClienteFlag = "GSS_Compania.CarteraClienteFlag";
    const AprobacionParaImpGuias = "GSS_Compania.AprobacionParaImpGuias";
    const MostrarNumeroLote = "GSS_Compania.MostrarNumeroLote";
    const TrabajarModoAlquiler = "GSS_Compania.TrabajarModoAlquiler";
    const OpeCierreCaja = "GSS_Compania.OpeCierreCaja";
    const IdClientePorDef = "GSS_Compania.IdClientePorDef";
    const IdUsuarioAdmin = "GSS_Compania.IdUsuarioAdmin";
    const OpeDsctoStockEnGuiaR = "GSS_Compania.OpeDsctoStockEnGuiaR";
    const LogoBackgroundColor = "GSS_Compania.LogoBackgroundColor";
    const NavbarBackgroundColor = "GSS_Compania.NavbarBackgroundColor";
    const SidebarBackgroundColor = "GSS_Compania.SidebarBackgroundColor";
    const UsuSecundarioPruebaUser = "GSS_Compania.UsuSecundarioPruebaUser";
    const UsuSecundarioPruebaPass = "GSS_Compania.UsuSecundarioPruebaPass";
    const UsuSecundarioProdUser = "GSS_Compania.UsuSecundarioProdUser";
    const UsuSecundarioProdPass = "GSS_Compania.UsuSecundarioProdPass";
    const ModoEntorno = "GSS_Compania.ModoEntorno";
    const Eliminado = "GSS_Compania.Eliminado";
    const FechaEliminado = "GSS_Compania.FechaEliminado";
    const UsuarioEliminado = "GSS_Compania.UsuarioEliminado";
    const FechaCreacion = "GSS_Compania.FechaCreacion";
    const UsuarioCreacion = "GSS_Compania.UsuarioCreacion";
    const FechaModificacion = "GSS_Compania.FechaModificacion";
    const UsuarioModificacion = "GSS_Compania.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Compania.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "GSS_Compania.Codigo AS Codigo, ";
        $s_SQLQuery .= "GSS_Compania.DescripcionCorta AS DescripcionCorta, ";
        $s_SQLQuery .= "GSS_Compania.DescripcionLarga AS DescripcionLarga, ";
        $s_SQLQuery .= "GSS_Compania.Departamento AS Departamento, ";
        $s_SQLQuery .= "GSS_Compania.Provincia AS Provincia, ";
        $s_SQLQuery .= "GSS_Compania.Distrito AS Distrito, ";
        $s_SQLQuery .= "GSS_Compania.DireccionComun AS DireccionComun, ";
        $s_SQLQuery .= "GSS_Compania.DireccionAdicional AS DireccionAdicional, ";
        $s_SQLQuery .= "GSS_Compania.Telefono1 AS Telefono1, ";
        $s_SQLQuery .= "GSS_Compania.Telefono2 AS Telefono2, ";
        $s_SQLQuery .= "GSS_Compania.Ruc AS Ruc, ";
        $s_SQLQuery .= "GSS_Compania.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Compania.Telefono3 AS Telefono3, ";
        $s_SQLQuery .= "GSS_Compania.Fax1 AS Fax1, ";
        $s_SQLQuery .= "GSS_Compania.Fax2 AS Fax2, ";
        $s_SQLQuery .= "GSS_Compania.AfectoIGVFlag AS AfectoIGVFlag, ";
        $s_SQLQuery .= "GSS_Compania.LogoFileDir AS LogoFileDir, ";
        $s_SQLQuery .= "GSS_Compania.LogoFile AS LogoFile, ";
        $s_SQLQuery .= "GSS_Compania.LogoFileAncho AS LogoFileAncho, ";
        $s_SQLQuery .= "GSS_Compania.LogoFileAlto AS LogoFileAlto, ";
        $s_SQLQuery .= "GSS_Compania.LogoBackFileDir AS LogoBackFileDir, ";
        $s_SQLQuery .= "GSS_Compania.LogoBackFileWeb AS LogoBackFileWeb, ";
        $s_SQLQuery .= "GSS_Compania.LogoBackFileAncho AS LogoBackFileAncho, ";
        $s_SQLQuery .= "GSS_Compania.LogoBackFileAlto AS LogoBackFileAlto, ";
        $s_SQLQuery .= "GSS_Compania.RepresentanteLegal AS RepresentanteLegal, ";
        $s_SQLQuery .= "GSS_Compania.PaginaWeb AS PaginaWeb, ";
        $s_SQLQuery .= "GSS_Compania.FacturaNotasFormatoPDF AS FacturaNotasFormatoPDF, ";
        $s_SQLQuery .= "GSS_Compania.BoletaNotasFormatoPDF AS BoletaNotasFormatoPDF, ";
        $s_SQLQuery .= "GSS_Compania.EmailEmpresa AS EmailEmpresa, ";
        $s_SQLQuery .= "GSS_Compania.DirParaBuscarComprobante AS DirParaBuscarComprobante, ";
        $s_SQLQuery .= "GSS_Compania.PorTipoCambio AS PorTipoCambio, ";
        $s_SQLQuery .= "GSS_Compania.EnviarProveedorAutoFlag AS EnviarProveedorAutoFlag, ";
        $s_SQLQuery .= "GSS_Compania.AfectoRetencionIGVFlag AS AfectoRetencionIGVFlag, ";
        $s_SQLQuery .= "GSS_Compania.AfectoPercepcionIGVFlag AS AfectoPercepcionIGVFlag, ";
        $s_SQLQuery .= "GSS_Compania.MostrarMargenVenta AS MostrarMargenVenta, ";
        $s_SQLQuery .= "GSS_Compania.CarteraClienteFlag AS CarteraClienteFlag, ";
        $s_SQLQuery .= "GSS_Compania.AprobacionParaImpGuias AS AprobacionParaImpGuias, ";
        $s_SQLQuery .= "GSS_Compania.MostrarNumeroLote AS MostrarNumeroLote, ";
        $s_SQLQuery .= "GSS_Compania.TrabajarModoAlquiler AS TrabajarModoAlquiler, ";
        $s_SQLQuery .= "GSS_Compania.OpeCierreCaja AS OpeCierreCaja, ";
        $s_SQLQuery .= "GSS_Compania.IdClientePorDef AS IdClientePorDef, ";
        $s_SQLQuery .= "GSS_Compania.IdUsuarioAdmin AS IdUsuarioAdmin, ";
        $s_SQLQuery .= "GSS_Compania.OpeDsctoStockEnGuiaR AS OpeDsctoStockEnGuiaR, ";
        $s_SQLQuery .= "GSS_Compania.LogoBackgroundColor AS LogoBackgroundColor, ";
        $s_SQLQuery .= "GSS_Compania.NavbarBackgroundColor AS NavbarBackgroundColor, ";
        $s_SQLQuery .= "GSS_Compania.SidebarBackgroundColor AS SidebarBackgroundColor, ";
        $s_SQLQuery .= "GSS_Compania.UsuSecundarioPruebaUser AS UsuSecundarioPruebaUser, ";
        $s_SQLQuery .= "GSS_Compania.UsuSecundarioPruebaPass AS UsuSecundarioPruebaPass, ";
        $s_SQLQuery .= "GSS_Compania.UsuSecundarioProdUser AS UsuSecundarioProdUser, ";
        $s_SQLQuery .= "GSS_Compania.UsuSecundarioProdPass AS UsuSecundarioProdPass, ";
        $s_SQLQuery .= "GSS_Compania.ModoEntorno AS ModoEntorno, ";
        $s_SQLQuery .= "GSS_Compania.Eliminado AS Eliminado, ";
        $s_SQLQuery .= "GSS_Compania.FechaEliminado AS FechaEliminado, ";
        $s_SQLQuery .= "GSS_Compania.UsuarioEliminado AS UsuarioEliminado, ";
        $s_SQLQuery .= "GSS_Compania.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Compania.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Compania.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Compania.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_CompaniaBN */
    public function setByBN( GSS_CompaniaBN $o_GSS_CompaniaBN )
    {
        if ( !is_null( $o_GSS_CompaniaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_CompaniaBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_CompaniaBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDescripcionCorta() ) )
        {
            $this->setDescripcionCorta( $o_GSS_CompaniaBN->getDescripcionCorta() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDescripcionLarga() ) )
        {
            $this->setDescripcionLarga( $o_GSS_CompaniaBN->getDescripcionLarga() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_GSS_CompaniaBN->getDepartamento() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getProvincia() ) )
        {
            $this->setProvincia( $o_GSS_CompaniaBN->getProvincia() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDistrito() ) )
        {
            $this->setDistrito( $o_GSS_CompaniaBN->getDistrito() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDireccionComun() ) )
        {
            $this->setDireccionComun( $o_GSS_CompaniaBN->getDireccionComun() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDireccionAdicional() ) )
        {
            $this->setDireccionAdicional( $o_GSS_CompaniaBN->getDireccionAdicional() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono1() ) )
        {
            $this->setTelefono1( $o_GSS_CompaniaBN->getTelefono1() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono2() ) )
        {
            $this->setTelefono2( $o_GSS_CompaniaBN->getTelefono2() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getRuc() ) )
        {
            $this->setRuc( $o_GSS_CompaniaBN->getRuc() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CompaniaBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono3() ) )
        {
            $this->setTelefono3( $o_GSS_CompaniaBN->getTelefono3() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFax1() ) )
        {
            $this->setFax1( $o_GSS_CompaniaBN->getFax1() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFax2() ) )
        {
            $this->setFax2( $o_GSS_CompaniaBN->getFax2() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoIGVFlag() ) )
        {
            $this->setAfectoIGVFlag( $o_GSS_CompaniaBN->getAfectoIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileDir() ) )
        {
            $this->setLogoFileDir( $o_GSS_CompaniaBN->getLogoFileDir() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFile() ) )
        {
            $this->setLogoFile( $o_GSS_CompaniaBN->getLogoFile() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileAncho() ) )
        {
            $this->setLogoFileAncho( $o_GSS_CompaniaBN->getLogoFileAncho() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileAlto() ) )
        {
            $this->setLogoFileAlto( $o_GSS_CompaniaBN->getLogoFileAlto() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileDir() ) )
        {
            $this->setLogoBackFileDir( $o_GSS_CompaniaBN->getLogoBackFileDir() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileWeb() ) )
        {
            $this->setLogoBackFileWeb( $o_GSS_CompaniaBN->getLogoBackFileWeb() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileAncho() ) )
        {
            $this->setLogoBackFileAncho( $o_GSS_CompaniaBN->getLogoBackFileAncho() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileAlto() ) )
        {
            $this->setLogoBackFileAlto( $o_GSS_CompaniaBN->getLogoBackFileAlto() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getRepresentanteLegal() ) )
        {
            $this->setRepresentanteLegal( $o_GSS_CompaniaBN->getRepresentanteLegal() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getPaginaWeb() ) )
        {
            $this->setPaginaWeb( $o_GSS_CompaniaBN->getPaginaWeb() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() ) )
        {
            $this->setFacturaNotasFormatoPDF( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() ) )
        {
            $this->setBoletaNotasFormatoPDF( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEmailEmpresa() ) )
        {
            $this->setEmailEmpresa( $o_GSS_CompaniaBN->getEmailEmpresa() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDirParaBuscarComprobante() ) )
        {
            $this->setDirParaBuscarComprobante( $o_GSS_CompaniaBN->getDirParaBuscarComprobante() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getPorTipoCambio() ) )
        {
            $this->setPorTipoCambio( $o_GSS_CompaniaBN->getPorTipoCambio() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEnviarProveedorAutoFlag() ) )
        {
            $this->setEnviarProveedorAutoFlag( $o_GSS_CompaniaBN->getEnviarProveedorAutoFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoRetencionIGVFlag() ) )
        {
            $this->setAfectoRetencionIGVFlag( $o_GSS_CompaniaBN->getAfectoRetencionIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoPercepcionIGVFlag() ) )
        {
            $this->setAfectoPercepcionIGVFlag( $o_GSS_CompaniaBN->getAfectoPercepcionIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getMostrarMargenVenta() ) )
        {
            $this->setMostrarMargenVenta( $o_GSS_CompaniaBN->getMostrarMargenVenta() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getCarteraClienteFlag() ) )
        {
            $this->setCarteraClienteFlag( $o_GSS_CompaniaBN->getCarteraClienteFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAprobacionParaImpGuias() ) )
        {
            $this->setAprobacionParaImpGuias( $o_GSS_CompaniaBN->getAprobacionParaImpGuias() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getMostrarNumeroLote() ) )
        {
            $this->setMostrarNumeroLote( $o_GSS_CompaniaBN->getMostrarNumeroLote() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTrabajarModoAlquiler() ) )
        {
            $this->setTrabajarModoAlquiler( $o_GSS_CompaniaBN->getTrabajarModoAlquiler() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getOpeCierreCaja() ) )
        {
            $this->setOpeCierreCaja( $o_GSS_CompaniaBN->getOpeCierreCaja() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getIdClientePorDef() ) )
        {
            $this->setIdClientePorDef( $o_GSS_CompaniaBN->getIdClientePorDef() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getIdUsuarioAdmin() ) )
        {
            $this->setIdUsuarioAdmin( $o_GSS_CompaniaBN->getIdUsuarioAdmin() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getOpeDsctoStockEnGuiaR() ) )
        {
            $this->setOpeDsctoStockEnGuiaR( $o_GSS_CompaniaBN->getOpeDsctoStockEnGuiaR() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackgroundColor() ) )
        {
            $this->setLogoBackgroundColor( $o_GSS_CompaniaBN->getLogoBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getNavbarBackgroundColor() ) )
        {
            $this->setNavbarBackgroundColor( $o_GSS_CompaniaBN->getNavbarBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getSidebarBackgroundColor() ) )
        {
            $this->setSidebarBackgroundColor( $o_GSS_CompaniaBN->getSidebarBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioPruebaUser() ) )
        {
            $this->setUsuSecundarioPruebaUser( $o_GSS_CompaniaBN->getUsuSecundarioPruebaUser() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioPruebaPass() ) )
        {
            $this->setUsuSecundarioPruebaPass( $o_GSS_CompaniaBN->getUsuSecundarioPruebaPass() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioProdUser() ) )
        {
            $this->setUsuSecundarioProdUser( $o_GSS_CompaniaBN->getUsuSecundarioProdUser() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioProdPass() ) )
        {
            $this->setUsuSecundarioProdPass( $o_GSS_CompaniaBN->getUsuSecundarioProdPass() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getModoEntorno() ) )
        {
            $this->setModoEntorno( $o_GSS_CompaniaBN->getModoEntorno() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEliminado() ) )
        {
            $this->setEliminado( $o_GSS_CompaniaBN->getEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_GSS_CompaniaBN->getFechaEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_GSS_CompaniaBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CompaniaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CompaniaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CompaniaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CompaniaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_CompaniaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Compania ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_CompaniaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_CompaniaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_CompaniaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "GSS_Compania.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "GSS_Compania.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getDescripcionCorta() ) ) $s_SQLQuery .= "GSS_Compania.DescripcionCorta = '".$this->getDescripcionCorta()."' AND ";
        if ( !is_null( $this->getDescripcionLarga() ) ) $s_SQLQuery .= "GSS_Compania.DescripcionLarga = '".$this->getDescripcionLarga()."' AND ";
        if ( !is_null( $this->getDepartamento() ) ) $s_SQLQuery .= "GSS_Compania.Departamento = '".$this->getDepartamento()."' AND ";
        if ( !is_null( $this->getProvincia() ) ) $s_SQLQuery .= "GSS_Compania.Provincia = '".$this->getProvincia()."' AND ";
        if ( !is_null( $this->getDistrito() ) ) $s_SQLQuery .= "GSS_Compania.Distrito = '".$this->getDistrito()."' AND ";
        if ( !is_null( $this->getDireccionComun() ) ) $s_SQLQuery .= "GSS_Compania.DireccionComun = '".$this->getDireccionComun()."' AND ";
        if ( !is_null( $this->getDireccionAdicional() ) ) $s_SQLQuery .= "GSS_Compania.DireccionAdicional = '".$this->getDireccionAdicional()."' AND ";
        if ( !is_null( $this->getTelefono1() ) ) $s_SQLQuery .= "GSS_Compania.Telefono1 = '".$this->getTelefono1()."' AND ";
        if ( !is_null( $this->getTelefono2() ) ) $s_SQLQuery .= "GSS_Compania.Telefono2 = '".$this->getTelefono2()."' AND ";
        if ( !is_null( $this->getRuc() ) ) $s_SQLQuery .= "GSS_Compania.Ruc = '".$this->getRuc()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Compania.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getTelefono3() ) ) $s_SQLQuery .= "GSS_Compania.Telefono3 = '".$this->getTelefono3()."' AND ";
        if ( !is_null( $this->getFax1() ) ) $s_SQLQuery .= "GSS_Compania.Fax1 = '".$this->getFax1()."' AND ";
        if ( !is_null( $this->getFax2() ) ) $s_SQLQuery .= "GSS_Compania.Fax2 = '".$this->getFax2()."' AND ";
        if ( !is_null( $this->getAfectoIGVFlag() ) ) $s_SQLQuery .= "GSS_Compania.AfectoIGVFlag = '".$this->getAfectoIGVFlag()."' AND ";
        if ( !is_null( $this->getLogoFileDir() ) ) $s_SQLQuery .= "GSS_Compania.LogoFileDir = '".$this->getLogoFileDir()."' AND ";
        if ( !is_null( $this->getLogoFile() ) ) $s_SQLQuery .= "GSS_Compania.LogoFile = '".$this->getLogoFile()."' AND ";
        if ( !is_null( $this->getLogoFileAncho() ) ) $s_SQLQuery .= "GSS_Compania.LogoFileAncho = '".$this->getLogoFileAncho()."' AND ";
        if ( !is_null( $this->getLogoFileAlto() ) ) $s_SQLQuery .= "GSS_Compania.LogoFileAlto = '".$this->getLogoFileAlto()."' AND ";
        if ( !is_null( $this->getLogoBackFileDir() ) ) $s_SQLQuery .= "GSS_Compania.LogoBackFileDir = '".$this->getLogoBackFileDir()."' AND ";
        if ( !is_null( $this->getLogoBackFileWeb() ) ) $s_SQLQuery .= "GSS_Compania.LogoBackFileWeb = '".$this->getLogoBackFileWeb()."' AND ";
        if ( !is_null( $this->getLogoBackFileAncho() ) ) $s_SQLQuery .= "GSS_Compania.LogoBackFileAncho = '".$this->getLogoBackFileAncho()."' AND ";
        if ( !is_null( $this->getLogoBackFileAlto() ) ) $s_SQLQuery .= "GSS_Compania.LogoBackFileAlto = '".$this->getLogoBackFileAlto()."' AND ";
        if ( !is_null( $this->getRepresentanteLegal() ) ) $s_SQLQuery .= "GSS_Compania.RepresentanteLegal = '".$this->getRepresentanteLegal()."' AND ";
        if ( !is_null( $this->getPaginaWeb() ) ) $s_SQLQuery .= "GSS_Compania.PaginaWeb = '".$this->getPaginaWeb()."' AND ";
        if ( !is_null( $this->getFacturaNotasFormatoPDF() ) ) $s_SQLQuery .= "GSS_Compania.FacturaNotasFormatoPDF = '".$this->getFacturaNotasFormatoPDF()."' AND ";
        if ( !is_null( $this->getBoletaNotasFormatoPDF() ) ) $s_SQLQuery .= "GSS_Compania.BoletaNotasFormatoPDF = '".$this->getBoletaNotasFormatoPDF()."' AND ";
        if ( !is_null( $this->getEmailEmpresa() ) ) $s_SQLQuery .= "GSS_Compania.EmailEmpresa = '".$this->getEmailEmpresa()."' AND ";
        if ( !is_null( $this->getDirParaBuscarComprobante() ) ) $s_SQLQuery .= "GSS_Compania.DirParaBuscarComprobante = '".$this->getDirParaBuscarComprobante()."' AND ";
        if ( !is_null( $this->getPorTipoCambio() ) ) $s_SQLQuery .= "GSS_Compania.PorTipoCambio = ".$this->getPorTipoCambio()." AND ";
        if ( !is_null( $this->getEnviarProveedorAutoFlag() ) ) $s_SQLQuery .= "GSS_Compania.EnviarProveedorAutoFlag = '".$this->getEnviarProveedorAutoFlag()."' AND ";
        if ( !is_null( $this->getAfectoRetencionIGVFlag() ) ) $s_SQLQuery .= "GSS_Compania.AfectoRetencionIGVFlag = '".$this->getAfectoRetencionIGVFlag()."' AND ";
        if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) ) $s_SQLQuery .= "GSS_Compania.AfectoPercepcionIGVFlag = '".$this->getAfectoPercepcionIGVFlag()."' AND ";
        if ( !is_null( $this->getMostrarMargenVenta() ) ) $s_SQLQuery .= "GSS_Compania.MostrarMargenVenta = ".$this->getMostrarMargenVenta()." AND ";
        if ( !is_null( $this->getCarteraClienteFlag() ) ) $s_SQLQuery .= "GSS_Compania.CarteraClienteFlag = ".$this->getCarteraClienteFlag()." AND ";
        if ( !is_null( $this->getAprobacionParaImpGuias() ) ) $s_SQLQuery .= "GSS_Compania.AprobacionParaImpGuias = ".$this->getAprobacionParaImpGuias()." AND ";
        if ( !is_null( $this->getMostrarNumeroLote() ) ) $s_SQLQuery .= "GSS_Compania.MostrarNumeroLote = ".$this->getMostrarNumeroLote()." AND ";
        if ( !is_null( $this->getTrabajarModoAlquiler() ) ) $s_SQLQuery .= "GSS_Compania.TrabajarModoAlquiler = ".$this->getTrabajarModoAlquiler()." AND ";
        if ( !is_null( $this->getOpeCierreCaja() ) ) $s_SQLQuery .= "GSS_Compania.OpeCierreCaja = ".$this->getOpeCierreCaja()." AND ";
        if ( !is_null( $this->getIdClientePorDef() ) ) $s_SQLQuery .= "GSS_Compania.IdClientePorDef = ".$this->getIdClientePorDef()." AND ";
        if ( !is_null( $this->getIdUsuarioAdmin() ) ) $s_SQLQuery .= "GSS_Compania.IdUsuarioAdmin = ".$this->getIdUsuarioAdmin()." AND ";
        if ( !is_null( $this->getOpeDsctoStockEnGuiaR() ) ) $s_SQLQuery .= "GSS_Compania.OpeDsctoStockEnGuiaR = ".$this->getOpeDsctoStockEnGuiaR()." AND ";
        if ( !is_null( $this->getLogoBackgroundColor() ) ) $s_SQLQuery .= "GSS_Compania.LogoBackgroundColor = '".$this->getLogoBackgroundColor()."' AND ";
        if ( !is_null( $this->getNavbarBackgroundColor() ) ) $s_SQLQuery .= "GSS_Compania.NavbarBackgroundColor = '".$this->getNavbarBackgroundColor()."' AND ";
        if ( !is_null( $this->getSidebarBackgroundColor() ) ) $s_SQLQuery .= "GSS_Compania.SidebarBackgroundColor = '".$this->getSidebarBackgroundColor()."' AND ";
        if ( !is_null( $this->getUsuSecundarioPruebaUser() ) ) $s_SQLQuery .= "GSS_Compania.UsuSecundarioPruebaUser = '".$this->getUsuSecundarioPruebaUser()."' AND ";
        if ( !is_null( $this->getUsuSecundarioPruebaPass() ) ) $s_SQLQuery .= "GSS_Compania.UsuSecundarioPruebaPass = '".$this->getUsuSecundarioPruebaPass()."' AND ";
        if ( !is_null( $this->getUsuSecundarioProdUser() ) ) $s_SQLQuery .= "GSS_Compania.UsuSecundarioProdUser = '".$this->getUsuSecundarioProdUser()."' AND ";
        if ( !is_null( $this->getUsuSecundarioProdPass() ) ) $s_SQLQuery .= "GSS_Compania.UsuSecundarioProdPass = '".$this->getUsuSecundarioProdPass()."' AND ";
        if ( !is_null( $this->getModoEntorno() ) ) $s_SQLQuery .= "GSS_Compania.ModoEntorno = ".$this->getModoEntorno()." AND ";
        if ( !is_null( $this->getEliminado() ) ) $s_SQLQuery .= "GSS_Compania.Eliminado = ".$this->getEliminado()." AND ";
        if ( !is_null( $this->getFechaEliminado() ) ) $s_SQLQuery .= "GSS_Compania.FechaEliminado = '".$this->getFechaEliminado()."' AND ";
        if ( !is_null( $this->getUsuarioEliminado() ) ) $s_SQLQuery .= "GSS_Compania.UsuarioEliminado = '".$this->getUsuarioEliminado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Compania.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Compania.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Compania.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Compania.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Compania WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_CompaniaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Compania WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_CompaniaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_CompaniaBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_CompaniaBN[] = $o_GSS_CompaniaBN;
            }
        }
        return $a_GSS_CompaniaBN;
    }

    /* Devuelve un objeto GSS_CompaniaBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Compania )
    {
        $o_GSS_CompaniaBN = new GSS_CompaniaBN();
        if ( !is_null( $a_GSS_Compania['IdCompania'] ) ) $o_GSS_CompaniaBN->setIdCompania( ( integer ) $a_GSS_Compania['IdCompania'] );
        if ( !is_null( $a_GSS_Compania['Codigo'] ) ) $o_GSS_CompaniaBN->setCodigo( $a_GSS_Compania['Codigo'] );
        if ( !is_null( $a_GSS_Compania['DescripcionCorta'] ) ) $o_GSS_CompaniaBN->setDescripcionCorta( $a_GSS_Compania['DescripcionCorta'] );
        if ( !is_null( $a_GSS_Compania['DescripcionLarga'] ) ) $o_GSS_CompaniaBN->setDescripcionLarga( $a_GSS_Compania['DescripcionLarga'] );
        if ( !is_null( $a_GSS_Compania['Departamento'] ) ) $o_GSS_CompaniaBN->setDepartamento( $a_GSS_Compania['Departamento'] );
        if ( !is_null( $a_GSS_Compania['Provincia'] ) ) $o_GSS_CompaniaBN->setProvincia( $a_GSS_Compania['Provincia'] );
        if ( !is_null( $a_GSS_Compania['Distrito'] ) ) $o_GSS_CompaniaBN->setDistrito( $a_GSS_Compania['Distrito'] );
        if ( !is_null( $a_GSS_Compania['DireccionComun'] ) ) $o_GSS_CompaniaBN->setDireccionComun( $a_GSS_Compania['DireccionComun'] );
        if ( !is_null( $a_GSS_Compania['DireccionAdicional'] ) ) $o_GSS_CompaniaBN->setDireccionAdicional( $a_GSS_Compania['DireccionAdicional'] );
        if ( !is_null( $a_GSS_Compania['Telefono1'] ) ) $o_GSS_CompaniaBN->setTelefono1( $a_GSS_Compania['Telefono1'] );
        if ( !is_null( $a_GSS_Compania['Telefono2'] ) ) $o_GSS_CompaniaBN->setTelefono2( $a_GSS_Compania['Telefono2'] );
        if ( !is_null( $a_GSS_Compania['Ruc'] ) ) $o_GSS_CompaniaBN->setRuc( $a_GSS_Compania['Ruc'] );
        if ( !is_null( $a_GSS_Compania['Estado'] ) ) $o_GSS_CompaniaBN->setEstado( $a_GSS_Compania['Estado'] );
        if ( !is_null( $a_GSS_Compania['Telefono3'] ) ) $o_GSS_CompaniaBN->setTelefono3( $a_GSS_Compania['Telefono3'] );
        if ( !is_null( $a_GSS_Compania['Fax1'] ) ) $o_GSS_CompaniaBN->setFax1( $a_GSS_Compania['Fax1'] );
        if ( !is_null( $a_GSS_Compania['Fax2'] ) ) $o_GSS_CompaniaBN->setFax2( $a_GSS_Compania['Fax2'] );
        if ( !is_null( $a_GSS_Compania['AfectoIGVFlag'] ) ) $o_GSS_CompaniaBN->setAfectoIGVFlag( $a_GSS_Compania['AfectoIGVFlag'] );
        if ( !is_null( $a_GSS_Compania['LogoFileDir'] ) ) $o_GSS_CompaniaBN->setLogoFileDir( $a_GSS_Compania['LogoFileDir'] );
        if ( !is_null( $a_GSS_Compania['LogoFile'] ) ) $o_GSS_CompaniaBN->setLogoFile( $a_GSS_Compania['LogoFile'] );
        if ( !is_null( $a_GSS_Compania['LogoFileAncho'] ) ) $o_GSS_CompaniaBN->setLogoFileAncho( $a_GSS_Compania['LogoFileAncho'] );
        if ( !is_null( $a_GSS_Compania['LogoFileAlto'] ) ) $o_GSS_CompaniaBN->setLogoFileAlto( $a_GSS_Compania['LogoFileAlto'] );
        if ( !is_null( $a_GSS_Compania['LogoBackFileDir'] ) ) $o_GSS_CompaniaBN->setLogoBackFileDir( $a_GSS_Compania['LogoBackFileDir'] );
        if ( !is_null( $a_GSS_Compania['LogoBackFileWeb'] ) ) $o_GSS_CompaniaBN->setLogoBackFileWeb( $a_GSS_Compania['LogoBackFileWeb'] );
        if ( !is_null( $a_GSS_Compania['LogoBackFileAncho'] ) ) $o_GSS_CompaniaBN->setLogoBackFileAncho( $a_GSS_Compania['LogoBackFileAncho'] );
        if ( !is_null( $a_GSS_Compania['LogoBackFileAlto'] ) ) $o_GSS_CompaniaBN->setLogoBackFileAlto( $a_GSS_Compania['LogoBackFileAlto'] );
        if ( !is_null( $a_GSS_Compania['RepresentanteLegal'] ) ) $o_GSS_CompaniaBN->setRepresentanteLegal( $a_GSS_Compania['RepresentanteLegal'] );
        if ( !is_null( $a_GSS_Compania['PaginaWeb'] ) ) $o_GSS_CompaniaBN->setPaginaWeb( $a_GSS_Compania['PaginaWeb'] );
        if ( !is_null( $a_GSS_Compania['FacturaNotasFormatoPDF'] ) ) $o_GSS_CompaniaBN->setFacturaNotasFormatoPDF( $a_GSS_Compania['FacturaNotasFormatoPDF'] );
        if ( !is_null( $a_GSS_Compania['BoletaNotasFormatoPDF'] ) ) $o_GSS_CompaniaBN->setBoletaNotasFormatoPDF( $a_GSS_Compania['BoletaNotasFormatoPDF'] );
        if ( !is_null( $a_GSS_Compania['EmailEmpresa'] ) ) $o_GSS_CompaniaBN->setEmailEmpresa( $a_GSS_Compania['EmailEmpresa'] );
        if ( !is_null( $a_GSS_Compania['DirParaBuscarComprobante'] ) ) $o_GSS_CompaniaBN->setDirParaBuscarComprobante( $a_GSS_Compania['DirParaBuscarComprobante'] );
        if ( !is_null( $a_GSS_Compania['PorTipoCambio'] ) ) $o_GSS_CompaniaBN->setPorTipoCambio( ( float ) $a_GSS_Compania['PorTipoCambio'] );
        if ( !is_null( $a_GSS_Compania['EnviarProveedorAutoFlag'] ) ) $o_GSS_CompaniaBN->setEnviarProveedorAutoFlag( $a_GSS_Compania['EnviarProveedorAutoFlag'] );
        if ( !is_null( $a_GSS_Compania['AfectoRetencionIGVFlag'] ) ) $o_GSS_CompaniaBN->setAfectoRetencionIGVFlag( $a_GSS_Compania['AfectoRetencionIGVFlag'] );
        if ( !is_null( $a_GSS_Compania['AfectoPercepcionIGVFlag'] ) ) $o_GSS_CompaniaBN->setAfectoPercepcionIGVFlag( $a_GSS_Compania['AfectoPercepcionIGVFlag'] );
        if ( !is_null( $a_GSS_Compania['MostrarMargenVenta'] ) ) $o_GSS_CompaniaBN->setMostrarMargenVenta( ( integer ) $a_GSS_Compania['MostrarMargenVenta'] );
        if ( !is_null( $a_GSS_Compania['CarteraClienteFlag'] ) ) $o_GSS_CompaniaBN->setCarteraClienteFlag( ( integer ) $a_GSS_Compania['CarteraClienteFlag'] );
        if ( !is_null( $a_GSS_Compania['AprobacionParaImpGuias'] ) ) $o_GSS_CompaniaBN->setAprobacionParaImpGuias( ( integer ) $a_GSS_Compania['AprobacionParaImpGuias'] );
        if ( !is_null( $a_GSS_Compania['MostrarNumeroLote'] ) ) $o_GSS_CompaniaBN->setMostrarNumeroLote( ( integer ) $a_GSS_Compania['MostrarNumeroLote'] );
        if ( !is_null( $a_GSS_Compania['TrabajarModoAlquiler'] ) ) $o_GSS_CompaniaBN->setTrabajarModoAlquiler( ( integer ) $a_GSS_Compania['TrabajarModoAlquiler'] );
        if ( !is_null( $a_GSS_Compania['OpeCierreCaja'] ) ) $o_GSS_CompaniaBN->setOpeCierreCaja( ( integer ) $a_GSS_Compania['OpeCierreCaja'] );
        if ( !is_null( $a_GSS_Compania['IdClientePorDef'] ) ) $o_GSS_CompaniaBN->setIdClientePorDef( ( integer ) $a_GSS_Compania['IdClientePorDef'] );
        if ( !is_null( $a_GSS_Compania['IdUsuarioAdmin'] ) ) $o_GSS_CompaniaBN->setIdUsuarioAdmin( ( integer ) $a_GSS_Compania['IdUsuarioAdmin'] );
        if ( !is_null( $a_GSS_Compania['OpeDsctoStockEnGuiaR'] ) ) $o_GSS_CompaniaBN->setOpeDsctoStockEnGuiaR( ( integer ) $a_GSS_Compania['OpeDsctoStockEnGuiaR'] );
        if ( !is_null( $a_GSS_Compania['LogoBackgroundColor'] ) ) $o_GSS_CompaniaBN->setLogoBackgroundColor( $a_GSS_Compania['LogoBackgroundColor'] );
        if ( !is_null( $a_GSS_Compania['NavbarBackgroundColor'] ) ) $o_GSS_CompaniaBN->setNavbarBackgroundColor( $a_GSS_Compania['NavbarBackgroundColor'] );
        if ( !is_null( $a_GSS_Compania['SidebarBackgroundColor'] ) ) $o_GSS_CompaniaBN->setSidebarBackgroundColor( $a_GSS_Compania['SidebarBackgroundColor'] );
        if ( !is_null( $a_GSS_Compania['UsuSecundarioPruebaUser'] ) ) $o_GSS_CompaniaBN->setUsuSecundarioPruebaUser( $a_GSS_Compania['UsuSecundarioPruebaUser'] );
        if ( !is_null( $a_GSS_Compania['UsuSecundarioPruebaPass'] ) ) $o_GSS_CompaniaBN->setUsuSecundarioPruebaPass( $a_GSS_Compania['UsuSecundarioPruebaPass'] );
        if ( !is_null( $a_GSS_Compania['UsuSecundarioProdUser'] ) ) $o_GSS_CompaniaBN->setUsuSecundarioProdUser( $a_GSS_Compania['UsuSecundarioProdUser'] );
        if ( !is_null( $a_GSS_Compania['UsuSecundarioProdPass'] ) ) $o_GSS_CompaniaBN->setUsuSecundarioProdPass( $a_GSS_Compania['UsuSecundarioProdPass'] );
        if ( !is_null( $a_GSS_Compania['ModoEntorno'] ) ) $o_GSS_CompaniaBN->setModoEntorno( ( integer ) $a_GSS_Compania['ModoEntorno'] );
        if ( !is_null( $a_GSS_Compania['Eliminado'] ) ) $o_GSS_CompaniaBN->setEliminado( ( integer ) $a_GSS_Compania['Eliminado'] );
        if ( !is_null( $a_GSS_Compania['FechaEliminado'] ) ) $o_GSS_CompaniaBN->setFechaEliminado( utilTimestamp::getTimestamp( $a_GSS_Compania['FechaEliminado'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Compania['UsuarioEliminado'] ) ) $o_GSS_CompaniaBN->setUsuarioEliminado( $a_GSS_Compania['UsuarioEliminado'] );
        if ( !is_null( $a_GSS_Compania['FechaCreacion'] ) ) $o_GSS_CompaniaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Compania['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Compania['UsuarioCreacion'] ) ) $o_GSS_CompaniaBN->setUsuarioCreacion( $a_GSS_Compania['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Compania['FechaModificacion'] ) ) $o_GSS_CompaniaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Compania['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Compania['UsuarioModificacion'] ) ) $o_GSS_CompaniaBN->setUsuarioModificacion( $a_GSS_Compania['UsuarioModificacion'] );
        return $o_GSS_CompaniaBN;
    }
}
?>