<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Banco.xml */
/* Generado: 2021-06-25 23:59:47 */

/* Busqueda de registros de la tabla GSS_Banco. */
abstract class BaseGSS_BancoFN extends GSS_BancoBN
{
    /* Declaracion de constantes */
    const IdBanco = "GSS_Banco.IdBanco";
    const DescripcionLocal = "GSS_Banco.DescripcionLocal";
    const Codigo = "GSS_Banco.Codigo";
    const CodigoSunat = "GSS_Banco.CodigoSunat";
    const Estado = "GSS_Banco.Estado";
    const FechaCreacion = "GSS_Banco.FechaCreacion";
    const UsuarioCreacion = "GSS_Banco.UsuarioCreacion";
    const FechaModificacion = "GSS_Banco.FechaModificacion";
    const UsuarioModificacion = "GSS_Banco.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "GSS_Banco.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "GSS_Banco.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "GSS_Banco.Codigo AS Codigo, ";
        $s_SQLQuery .= "GSS_Banco.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "GSS_Banco.Estado AS Estado, ";
        $s_SQLQuery .= "GSS_Banco.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "GSS_Banco.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "GSS_Banco.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "GSS_Banco.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto GSS_BancoBN */
    public function setByBN( GSS_BancoBN $o_GSS_BancoBN )
    {
        if ( !is_null( $o_GSS_BancoBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_GSS_BancoBN->getIdBanco() );
        }
        if ( !is_null( $o_GSS_BancoBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_GSS_BancoBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_GSS_BancoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_BancoBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_BancoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_BancoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_BancoBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_BancoBN->getEstado() );
        }
        if ( !is_null( $o_GSS_BancoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_BancoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_BancoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_BancoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_BancoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return GSS_BancoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdBanco )
    {
        if( is_null( $i_IdBanco ) ){ $i_IdBanco = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Banco ";
        $s_SQLQuery .= "WHERE IdBanco = ".$i_IdBanco." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_GSS_BancoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_GSS_BancoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_GSS_BancoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "GSS_Banco.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "GSS_Banco.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "GSS_Banco.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "GSS_Banco.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "GSS_Banco.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "GSS_Banco.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "GSS_Banco.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "GSS_Banco.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "GSS_Banco.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM GSS_Banco WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return GSS_BancoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM GSS_Banco WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_GSS_BancoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_GSS_BancoBN = $this->insertObjectBN( $a_SQLRow );
                $a_GSS_BancoBN[] = $o_GSS_BancoBN;
            }
        }
        return $a_GSS_BancoBN;
    }

    /* Devuelve un objeto GSS_BancoBN desde un objeto propel */
    public function insertObjectBN( $a_GSS_Banco )
    {
        $o_GSS_BancoBN = new GSS_BancoBN();
        if ( !is_null( $a_GSS_Banco['IdBanco'] ) ) $o_GSS_BancoBN->setIdBanco( ( integer ) $a_GSS_Banco['IdBanco'] );
        if ( !is_null( $a_GSS_Banco['DescripcionLocal'] ) ) $o_GSS_BancoBN->setDescripcionLocal( $a_GSS_Banco['DescripcionLocal'] );
        if ( !is_null( $a_GSS_Banco['Codigo'] ) ) $o_GSS_BancoBN->setCodigo( $a_GSS_Banco['Codigo'] );
        if ( !is_null( $a_GSS_Banco['CodigoSunat'] ) ) $o_GSS_BancoBN->setCodigoSunat( $a_GSS_Banco['CodigoSunat'] );
        if ( !is_null( $a_GSS_Banco['Estado'] ) ) $o_GSS_BancoBN->setEstado( $a_GSS_Banco['Estado'] );
        if ( !is_null( $a_GSS_Banco['FechaCreacion'] ) ) $o_GSS_BancoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_GSS_Banco['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Banco['UsuarioCreacion'] ) ) $o_GSS_BancoBN->setUsuarioCreacion( $a_GSS_Banco['UsuarioCreacion'] );
        if ( !is_null( $a_GSS_Banco['FechaModificacion'] ) ) $o_GSS_BancoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_GSS_Banco['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_GSS_Banco['UsuarioModificacion'] ) ) $o_GSS_BancoBN->setUsuarioModificacion( $a_GSS_Banco['UsuarioModificacion'] );
        return $o_GSS_BancoBN;
    }
}
?>