<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_TipoPago.xml */
/* Generado: 2021-06-25 23:59:46 */

/* Busqueda de registros de la tabla FCO_TipoPago. */
abstract class BaseFCO_TipoPagoFN extends FCO_TipoPagoBN
{
    /* Declaracion de constantes */
    const IdTipoPago = "FCO_TipoPago.IdTipoPago";
    const IdCompania = "FCO_TipoPago.IdCompania";
    const Codigo = "FCO_TipoPago.Codigo";
    const Nombre = "FCO_TipoPago.Nombre";
    const ClaseNombre = "FCO_TipoPago.ClaseNombre";
    const Mostrar = "FCO_TipoPago.Mostrar";
    const Estado = "FCO_TipoPago.Estado";
    const FechaCreacion = "FCO_TipoPago.FechaCreacion";
    const UsuarioCreacion = "FCO_TipoPago.UsuarioCreacion";
    const FechaModificacion = "FCO_TipoPago.FechaModificacion";
    const UsuarioModificacion = "FCO_TipoPago.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_TipoPago.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "FCO_TipoPago.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_TipoPago.Codigo AS Codigo, ";
        $s_SQLQuery .= "FCO_TipoPago.Nombre AS Nombre, ";
        $s_SQLQuery .= "FCO_TipoPago.ClaseNombre AS ClaseNombre, ";
        $s_SQLQuery .= "FCO_TipoPago.Mostrar AS Mostrar, ";
        $s_SQLQuery .= "FCO_TipoPago.Estado AS Estado, ";
        $s_SQLQuery .= "FCO_TipoPago.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_TipoPago.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_TipoPago.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_TipoPago.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_TipoPagoBN */
    public function setByBN( FCO_TipoPagoBN $o_FCO_TipoPagoBN )
    {
        if ( !is_null( $o_FCO_TipoPagoBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_FCO_TipoPagoBN->getIdTipoPago() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_TipoPagoBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_FCO_TipoPagoBN->getCodigo() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getNombre() ) )
        {
            $this->setNombre( $o_FCO_TipoPagoBN->getNombre() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getClaseNombre() ) )
        {
            $this->setClaseNombre( $o_FCO_TipoPagoBN->getClaseNombre() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getMostrar() ) )
        {
            $this->setMostrar( $o_FCO_TipoPagoBN->getMostrar() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_TipoPagoBN->getEstado() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_TipoPagoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_TipoPagoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_TipoPagoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_TipoPagoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_TipoPagoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_TipoPagoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTipoPago )
    {
        if( is_null( $i_IdTipoPago ) ){ $i_IdTipoPago = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_TipoPago ";
        $s_SQLQuery .= "WHERE IdTipoPago = ".$i_IdTipoPago." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_TipoPagoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_TipoPagoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_TipoPagoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "FCO_TipoPago.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_TipoPago.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "FCO_TipoPago.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "FCO_TipoPago.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getClaseNombre() ) ) $s_SQLQuery .= "FCO_TipoPago.ClaseNombre = '".$this->getClaseNombre()."' AND ";
        if ( !is_null( $this->getMostrar() ) ) $s_SQLQuery .= "FCO_TipoPago.Mostrar = '".$this->getMostrar()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "FCO_TipoPago.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_TipoPago.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_TipoPago.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_TipoPago.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_TipoPago.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_TipoPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_TipoPagoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_TipoPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_TipoPagoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_TipoPagoBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_TipoPagoBN[] = $o_FCO_TipoPagoBN;
            }
        }
        return $a_FCO_TipoPagoBN;
    }

    /* Devuelve un objeto FCO_TipoPagoBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_TipoPago )
    {
        $o_FCO_TipoPagoBN = new FCO_TipoPagoBN();
        if ( !is_null( $a_FCO_TipoPago['IdTipoPago'] ) ) $o_FCO_TipoPagoBN->setIdTipoPago( ( integer ) $a_FCO_TipoPago['IdTipoPago'] );
        if ( !is_null( $a_FCO_TipoPago['IdCompania'] ) ) $o_FCO_TipoPagoBN->setIdCompania( ( integer ) $a_FCO_TipoPago['IdCompania'] );
        if ( !is_null( $a_FCO_TipoPago['Codigo'] ) ) $o_FCO_TipoPagoBN->setCodigo( $a_FCO_TipoPago['Codigo'] );
        if ( !is_null( $a_FCO_TipoPago['Nombre'] ) ) $o_FCO_TipoPagoBN->setNombre( $a_FCO_TipoPago['Nombre'] );
        if ( !is_null( $a_FCO_TipoPago['ClaseNombre'] ) ) $o_FCO_TipoPagoBN->setClaseNombre( $a_FCO_TipoPago['ClaseNombre'] );
        if ( !is_null( $a_FCO_TipoPago['Mostrar'] ) ) $o_FCO_TipoPagoBN->setMostrar( $a_FCO_TipoPago['Mostrar'] );
        if ( !is_null( $a_FCO_TipoPago['Estado'] ) ) $o_FCO_TipoPagoBN->setEstado( $a_FCO_TipoPago['Estado'] );
        if ( !is_null( $a_FCO_TipoPago['FechaCreacion'] ) ) $o_FCO_TipoPagoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_TipoPago['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_TipoPago['UsuarioCreacion'] ) ) $o_FCO_TipoPagoBN->setUsuarioCreacion( $a_FCO_TipoPago['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_TipoPago['FechaModificacion'] ) ) $o_FCO_TipoPagoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_TipoPago['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_TipoPago['UsuarioModificacion'] ) ) $o_FCO_TipoPagoBN->setUsuarioModificacion( $a_FCO_TipoPago['UsuarioModificacion'] );
        return $o_FCO_TipoPagoBN;
    }
}
?>