<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_RecibosEstadoLog.xml */
/* Generado: 2021-06-25 23:59:46 */

/* Busqueda de registros de la tabla FCO_RecibosEstadoLog. */
abstract class BaseFCO_RecibosEstadoLogFN extends FCO_RecibosEstadoLogBN
{
    /* Declaracion de constantes */
    const IdEstadoLog = "FCO_RecibosEstadoLog.IdEstadoLog";
    const IdDocRecibo = "FCO_RecibosEstadoLog.IdDocRecibo";
    const FlujoEstado = "FCO_RecibosEstadoLog.FlujoEstado";
    const NombreEstado = "FCO_RecibosEstadoLog.NombreEstado";
    const Comentario = "FCO_RecibosEstadoLog.Comentario";
    const FechaCreacion = "FCO_RecibosEstadoLog.FechaCreacion";
    const UsuarioCreacion = "FCO_RecibosEstadoLog.UsuarioCreacion";
    const FechaModificacion = "FCO_RecibosEstadoLog.FechaModificacion";
    const UsuarioModificacion = "FCO_RecibosEstadoLog.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_RecibosEstadoLog.IdEstadoLog AS IdEstadoLog, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.FlujoEstado AS FlujoEstado, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.NombreEstado AS NombreEstado, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.Comentario AS Comentario, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_RecibosEstadoLog.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_RecibosEstadoLogBN */
    public function setByBN( FCO_RecibosEstadoLogBN $o_FCO_RecibosEstadoLogBN )
    {
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getIdEstadoLog() ) )
        {
            $this->setIdEstadoLog( $o_FCO_RecibosEstadoLogBN->getIdEstadoLog() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_RecibosEstadoLogBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFlujoEstado() ) )
        {
            $this->setFlujoEstado( $o_FCO_RecibosEstadoLogBN->getFlujoEstado() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getNombreEstado() ) )
        {
            $this->setNombreEstado( $o_FCO_RecibosEstadoLogBN->getNombreEstado() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getComentario() ) )
        {
            $this->setComentario( $o_FCO_RecibosEstadoLogBN->getComentario() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_RecibosEstadoLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_RecibosEstadoLogBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_RecibosEstadoLogBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_RecibosEstadoLogBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_RecibosEstadoLogBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdEstadoLog, $i_IdDocRecibo )
    {
        if( is_null( $i_IdEstadoLog ) ){ $i_IdEstadoLog = -1; } 
        if( is_null( $i_IdDocRecibo ) ){ $i_IdDocRecibo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_RecibosEstadoLog ";
        $s_SQLQuery .= "WHERE IdEstadoLog = ".$i_IdEstadoLog." ";
        $s_SQLQuery .= "AND IdDocRecibo = ".$i_IdDocRecibo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_RecibosEstadoLogBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_RecibosEstadoLogBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_RecibosEstadoLogBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdEstadoLog() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.IdEstadoLog = ".$this->getIdEstadoLog()." AND ";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getFlujoEstado() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.FlujoEstado = '".$this->getFlujoEstado()."' AND ";
        if ( !is_null( $this->getNombreEstado() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.NombreEstado = '".$this->getNombreEstado()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_RecibosEstadoLog.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_RecibosEstadoLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_RecibosEstadoLogBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_RecibosEstadoLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_RecibosEstadoLogBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_RecibosEstadoLogBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_RecibosEstadoLogBN[] = $o_FCO_RecibosEstadoLogBN;
            }
        }
        return $a_FCO_RecibosEstadoLogBN;
    }

    /* Devuelve un objeto FCO_RecibosEstadoLogBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_RecibosEstadoLog )
    {
        $o_FCO_RecibosEstadoLogBN = new FCO_RecibosEstadoLogBN();
        if ( !is_null( $a_FCO_RecibosEstadoLog['IdEstadoLog'] ) ) $o_FCO_RecibosEstadoLogBN->setIdEstadoLog( ( integer ) $a_FCO_RecibosEstadoLog['IdEstadoLog'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['IdDocRecibo'] ) ) $o_FCO_RecibosEstadoLogBN->setIdDocRecibo( ( integer ) $a_FCO_RecibosEstadoLog['IdDocRecibo'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['FlujoEstado'] ) ) $o_FCO_RecibosEstadoLogBN->setFlujoEstado( $a_FCO_RecibosEstadoLog['FlujoEstado'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['NombreEstado'] ) ) $o_FCO_RecibosEstadoLogBN->setNombreEstado( $a_FCO_RecibosEstadoLog['NombreEstado'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['Comentario'] ) ) $o_FCO_RecibosEstadoLogBN->setComentario( $a_FCO_RecibosEstadoLog['Comentario'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['FechaCreacion'] ) ) $o_FCO_RecibosEstadoLogBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_RecibosEstadoLog['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_RecibosEstadoLog['UsuarioCreacion'] ) ) $o_FCO_RecibosEstadoLogBN->setUsuarioCreacion( $a_FCO_RecibosEstadoLog['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_RecibosEstadoLog['FechaModificacion'] ) ) $o_FCO_RecibosEstadoLogBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_RecibosEstadoLog['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_RecibosEstadoLog['UsuarioModificacion'] ) ) $o_FCO_RecibosEstadoLogBN->setUsuarioModificacion( $a_FCO_RecibosEstadoLog['UsuarioModificacion'] );
        return $o_FCO_RecibosEstadoLogBN;
    }
}
?>