<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_OrdenRecibo.xml */
/* Generado: 2021-06-25 23:59:46 */

/* Busqueda de registros de la tabla FCO_OrdenRecibo. */
abstract class BaseFCO_OrdenReciboFN extends FCO_OrdenReciboBN
{
    /* Declaracion de constantes */
    const OrdenId = "FCO_OrdenRecibo.OrdenId";
    const IdDocRecibo = "FCO_OrdenRecibo.IdDocRecibo";
    const OrdenNum = "FCO_OrdenRecibo.OrdenNum";
    const IdMoneda = "FCO_OrdenRecibo.IdMoneda";
    const TipoCambio = "FCO_OrdenRecibo.TipoCambio";
    const MontoOrden = "FCO_OrdenRecibo.MontoOrden";
    const MontoOrdenMN = "FCO_OrdenRecibo.MontoOrdenMN";
    const MontoOrdenME = "FCO_OrdenRecibo.MontoOrdenME";
    const UsuarioCreacion = "FCO_OrdenRecibo.UsuarioCreacion";
    const FechaCreacion = "FCO_OrdenRecibo.FechaCreacion";
    const UsuarioModificacion = "FCO_OrdenRecibo.UsuarioModificacion";
    const FechaModificacion = "FCO_OrdenRecibo.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_OrdenRecibo.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.OrdenNum AS OrdenNum, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrden AS MontoOrden, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrdenMN AS MontoOrdenMN, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrdenME AS MontoOrdenME, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "FCO_OrdenRecibo.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_OrdenReciboBN */
    public function setByBN( FCO_OrdenReciboBN $o_FCO_OrdenReciboBN )
    {
        if ( !is_null( $o_FCO_OrdenReciboBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_FCO_OrdenReciboBN->getOrdenId() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_OrdenReciboBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getOrdenNum() ) )
        {
            $this->setOrdenNum( $o_FCO_OrdenReciboBN->getOrdenNum() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_OrdenReciboBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_FCO_OrdenReciboBN->getTipoCambio() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrden() ) )
        {
            $this->setMontoOrden( $o_FCO_OrdenReciboBN->getMontoOrden() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrdenMN() ) )
        {
            $this->setMontoOrdenMN( $o_FCO_OrdenReciboBN->getMontoOrdenMN() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrdenME() ) )
        {
            $this->setMontoOrdenME( $o_FCO_OrdenReciboBN->getMontoOrdenME() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_OrdenReciboBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_OrdenReciboBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_OrdenReciboBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_OrdenReciboBN->getFechaModificacion() );
        }
    }

    /**
    * @return FCO_OrdenReciboBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_OrdenId, $i_IdDocRecibo )
    {
        if( is_null( $i_OrdenId ) ){ $i_OrdenId = -1; } 
        if( is_null( $i_IdDocRecibo ) ){ $i_IdDocRecibo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_OrdenRecibo ";
        $s_SQLQuery .= "WHERE OrdenId = ".$i_OrdenId." ";
        $s_SQLQuery .= "AND IdDocRecibo = ".$i_IdDocRecibo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_OrdenReciboBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_OrdenReciboBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_OrdenReciboBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getOrdenNum() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.OrdenNum = '".$this->getOrdenNum()."' AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getMontoOrden() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrden = ".$this->getMontoOrden()." AND ";
        if ( !is_null( $this->getMontoOrdenMN() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrdenMN = ".$this->getMontoOrdenMN()." AND ";
        if ( !is_null( $this->getMontoOrdenME() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.MontoOrdenME = ".$this->getMontoOrdenME()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_OrdenRecibo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_OrdenRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_OrdenReciboBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_OrdenRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_OrdenReciboBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_OrdenReciboBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_OrdenReciboBN[] = $o_FCO_OrdenReciboBN;
            }
        }
        return $a_FCO_OrdenReciboBN;
    }

    /* Devuelve un objeto FCO_OrdenReciboBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_OrdenRecibo )
    {
        $o_FCO_OrdenReciboBN = new FCO_OrdenReciboBN();
        if ( !is_null( $a_FCO_OrdenRecibo['OrdenId'] ) ) $o_FCO_OrdenReciboBN->setOrdenId( ( integer ) $a_FCO_OrdenRecibo['OrdenId'] );
        if ( !is_null( $a_FCO_OrdenRecibo['IdDocRecibo'] ) ) $o_FCO_OrdenReciboBN->setIdDocRecibo( ( integer ) $a_FCO_OrdenRecibo['IdDocRecibo'] );
        if ( !is_null( $a_FCO_OrdenRecibo['OrdenNum'] ) ) $o_FCO_OrdenReciboBN->setOrdenNum( $a_FCO_OrdenRecibo['OrdenNum'] );
        if ( !is_null( $a_FCO_OrdenRecibo['IdMoneda'] ) ) $o_FCO_OrdenReciboBN->setIdMoneda( $a_FCO_OrdenRecibo['IdMoneda'] );
        if ( !is_null( $a_FCO_OrdenRecibo['TipoCambio'] ) ) $o_FCO_OrdenReciboBN->setTipoCambio( ( float ) $a_FCO_OrdenRecibo['TipoCambio'] );
        if ( !is_null( $a_FCO_OrdenRecibo['MontoOrden'] ) ) $o_FCO_OrdenReciboBN->setMontoOrden( ( float ) $a_FCO_OrdenRecibo['MontoOrden'] );
        if ( !is_null( $a_FCO_OrdenRecibo['MontoOrdenMN'] ) ) $o_FCO_OrdenReciboBN->setMontoOrdenMN( ( float ) $a_FCO_OrdenRecibo['MontoOrdenMN'] );
        if ( !is_null( $a_FCO_OrdenRecibo['MontoOrdenME'] ) ) $o_FCO_OrdenReciboBN->setMontoOrdenME( ( float ) $a_FCO_OrdenRecibo['MontoOrdenME'] );
        if ( !is_null( $a_FCO_OrdenRecibo['UsuarioCreacion'] ) ) $o_FCO_OrdenReciboBN->setUsuarioCreacion( $a_FCO_OrdenRecibo['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_OrdenRecibo['FechaCreacion'] ) ) $o_FCO_OrdenReciboBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_OrdenRecibo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_OrdenRecibo['UsuarioModificacion'] ) ) $o_FCO_OrdenReciboBN->setUsuarioModificacion( $a_FCO_OrdenRecibo['UsuarioModificacion'] );
        if ( !is_null( $a_FCO_OrdenRecibo['FechaModificacion'] ) ) $o_FCO_OrdenReciboBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_OrdenRecibo['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_FCO_OrdenReciboBN;
    }
}
?>