<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_DocRecibo.xml */
/* Generado: 2021-07-24 06:20:20 */

/* Busqueda de registros de la tabla FCO_DocRecibo. */
abstract class BaseFCO_DocReciboFN extends FCO_DocReciboBN
{
    /* Declaracion de constantes */
    const IdDocRecibo = "FCO_DocRecibo.IdDocRecibo";
    const IdCompania = "FCO_DocRecibo.IdCompania";
    const IdSucursal = "FCO_DocRecibo.IdSucursal";
    const IdTipoPago = "FCO_DocRecibo.IdTipoPago";
    const IdMoneda = "FCO_DocRecibo.IdMoneda";
    const MonedaDes = "FCO_DocRecibo.MonedaDes";
    const ReciboNumero = "FCO_DocRecibo.ReciboNumero";
    const ReciboFecha = "FCO_DocRecibo.ReciboFecha";
    const IdBanco = "FCO_DocRecibo.IdBanco";
    const IdCuenta = "FCO_DocRecibo.IdCuenta";
    const NumeroCuenta = "FCO_DocRecibo.NumeroCuenta";
    const TerminoPago = "FCO_DocRecibo.TerminoPago";
    const FechaVencimiento = "FCO_DocRecibo.FechaVencimiento";
    const IdNumeroDocumento = "FCO_DocRecibo.IdNumeroDocumento";
    const ClaseNombre = "FCO_DocRecibo.ClaseNombre";
    const TipoCambio = "FCO_DocRecibo.TipoCambio";
    const IdPersona = "FCO_DocRecibo.IdPersona";
    const TipoDocCliente = "FCO_DocRecibo.TipoDocCliente";
    const NumTipoDocCliente = "FCO_DocRecibo.NumTipoDocCliente";
    const NombreCliente = "FCO_DocRecibo.NombreCliente";
    const Descripcion = "FCO_DocRecibo.Descripcion";
    const Monto = "FCO_DocRecibo.Monto";
    const Saldo = "FCO_DocRecibo.Saldo";
    const MontoMN = "FCO_DocRecibo.MontoMN";
    const SaldoMN = "FCO_DocRecibo.SaldoMN";
    const MontoME = "FCO_DocRecibo.MontoME";
    const SaldoME = "FCO_DocRecibo.SaldoME";
    const FechaAprobacion = "FCO_DocRecibo.FechaAprobacion";
    const ApruebaUsuario = "FCO_DocRecibo.ApruebaUsuario";
    const FechaCobranza = "FCO_DocRecibo.FechaCobranza";
    const CobranzaEstado = "FCO_DocRecibo.CobranzaEstado";
    const FlujoEstado = "FCO_DocRecibo.FlujoEstado";
    const Estado = "FCO_DocRecibo.Estado";
    const FechaCreacion = "FCO_DocRecibo.FechaCreacion";
    const UsuarioCreacion = "FCO_DocRecibo.UsuarioCreacion";
    const FechaModificacion = "FCO_DocRecibo.FechaModificacion";
    const UsuarioModificacion = "FCO_DocRecibo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_DocRecibo.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "FCO_DocRecibo.MonedaDes AS MonedaDes, ";
        $s_SQLQuery .= "FCO_DocRecibo.ReciboNumero AS ReciboNumero, ";
        $s_SQLQuery .= "FCO_DocRecibo.ReciboFecha AS ReciboFecha, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdCuenta AS IdCuenta, ";
        $s_SQLQuery .= "FCO_DocRecibo.NumeroCuenta AS NumeroCuenta, ";
        $s_SQLQuery .= "FCO_DocRecibo.TerminoPago AS TerminoPago, ";
        $s_SQLQuery .= "FCO_DocRecibo.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "FCO_DocRecibo.ClaseNombre AS ClaseNombre, ";
        $s_SQLQuery .= "FCO_DocRecibo.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "FCO_DocRecibo.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "FCO_DocRecibo.TipoDocCliente AS TipoDocCliente, ";
        $s_SQLQuery .= "FCO_DocRecibo.NumTipoDocCliente AS NumTipoDocCliente, ";
        $s_SQLQuery .= "FCO_DocRecibo.NombreCliente AS NombreCliente, ";
        $s_SQLQuery .= "FCO_DocRecibo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "FCO_DocRecibo.Monto AS Monto, ";
        $s_SQLQuery .= "FCO_DocRecibo.Saldo AS Saldo, ";
        $s_SQLQuery .= "FCO_DocRecibo.MontoMN AS MontoMN, ";
        $s_SQLQuery .= "FCO_DocRecibo.SaldoMN AS SaldoMN, ";
        $s_SQLQuery .= "FCO_DocRecibo.MontoME AS MontoME, ";
        $s_SQLQuery .= "FCO_DocRecibo.SaldoME AS SaldoME, ";
        $s_SQLQuery .= "FCO_DocRecibo.FechaAprobacion AS FechaAprobacion, ";
        $s_SQLQuery .= "FCO_DocRecibo.ApruebaUsuario AS ApruebaUsuario, ";
        $s_SQLQuery .= "FCO_DocRecibo.FechaCobranza AS FechaCobranza, ";
        $s_SQLQuery .= "FCO_DocRecibo.CobranzaEstado AS CobranzaEstado, ";
        $s_SQLQuery .= "FCO_DocRecibo.FlujoEstado AS FlujoEstado, ";
        $s_SQLQuery .= "FCO_DocRecibo.Estado AS Estado, ";
        $s_SQLQuery .= "FCO_DocRecibo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_DocRecibo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_DocRecibo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_DocRecibo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_DocReciboBN */
    public function setByBN( FCO_DocReciboBN $o_FCO_DocReciboBN )
    {
        if ( !is_null( $o_FCO_DocReciboBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_DocReciboBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_DocReciboBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_DocReciboBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_FCO_DocReciboBN->getIdTipoPago() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_DocReciboBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_FCO_DocReciboBN->getMonedaDes() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getReciboNumero() ) )
        {
            $this->setReciboNumero( $o_FCO_DocReciboBN->getReciboNumero() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getReciboFecha() ) )
        {
            $this->setReciboFecha( $o_FCO_DocReciboBN->getReciboFecha() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_FCO_DocReciboBN->getIdBanco() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdCuenta() ) )
        {
            $this->setIdCuenta( $o_FCO_DocReciboBN->getIdCuenta() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getNumeroCuenta() ) )
        {
            $this->setNumeroCuenta( $o_FCO_DocReciboBN->getNumeroCuenta() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getTerminoPago() ) )
        {
            $this->setTerminoPago( $o_FCO_DocReciboBN->getTerminoPago() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_FCO_DocReciboBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_FCO_DocReciboBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getClaseNombre() ) )
        {
            $this->setClaseNombre( $o_FCO_DocReciboBN->getClaseNombre() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_FCO_DocReciboBN->getTipoCambio() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_FCO_DocReciboBN->getIdPersona() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getTipoDocCliente() ) )
        {
            $this->setTipoDocCliente( $o_FCO_DocReciboBN->getTipoDocCliente() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getNumTipoDocCliente() ) )
        {
            $this->setNumTipoDocCliente( $o_FCO_DocReciboBN->getNumTipoDocCliente() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getNombreCliente() ) )
        {
            $this->setNombreCliente( $o_FCO_DocReciboBN->getNombreCliente() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_FCO_DocReciboBN->getDescripcion() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getMonto() ) )
        {
            $this->setMonto( $o_FCO_DocReciboBN->getMonto() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getSaldo() ) )
        {
            $this->setSaldo( $o_FCO_DocReciboBN->getSaldo() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getMontoMN() ) )
        {
            $this->setMontoMN( $o_FCO_DocReciboBN->getMontoMN() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getSaldoMN() ) )
        {
            $this->setSaldoMN( $o_FCO_DocReciboBN->getSaldoMN() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getMontoME() ) )
        {
            $this->setMontoME( $o_FCO_DocReciboBN->getMontoME() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getSaldoME() ) )
        {
            $this->setSaldoME( $o_FCO_DocReciboBN->getSaldoME() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFechaAprobacion() ) )
        {
            $this->setFechaAprobacion( $o_FCO_DocReciboBN->getFechaAprobacion() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getApruebaUsuario() ) )
        {
            $this->setApruebaUsuario( $o_FCO_DocReciboBN->getApruebaUsuario() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFechaCobranza() ) )
        {
            $this->setFechaCobranza( $o_FCO_DocReciboBN->getFechaCobranza() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getCobranzaEstado() ) )
        {
            $this->setCobranzaEstado( $o_FCO_DocReciboBN->getCobranzaEstado() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFlujoEstado() ) )
        {
            $this->setFlujoEstado( $o_FCO_DocReciboBN->getFlujoEstado() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_DocReciboBN->getEstado() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_DocReciboBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_DocReciboBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_DocReciboBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_DocReciboBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_DocReciboBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_DocReciboBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDocRecibo )
    {
        if( is_null( $i_IdDocRecibo ) ){ $i_IdDocRecibo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_DocRecibo ";
        $s_SQLQuery .= "WHERE IdDocRecibo = ".$i_IdDocRecibo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_DocReciboBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_DocReciboBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_DocReciboBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getMonedaDes() ) ) $s_SQLQuery .= "FCO_DocRecibo.MonedaDes = '".$this->getMonedaDes()."' AND ";
        if ( !is_null( $this->getReciboNumero() ) ) $s_SQLQuery .= "FCO_DocRecibo.ReciboNumero = '".$this->getReciboNumero()."' AND ";
        if ( !is_null( $this->getReciboFecha() ) ) $s_SQLQuery .= "FCO_DocRecibo.ReciboFecha = '".$this->getReciboFecha()."' AND ";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getIdCuenta() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdCuenta = ".$this->getIdCuenta()." AND ";
        if ( !is_null( $this->getNumeroCuenta() ) ) $s_SQLQuery .= "FCO_DocRecibo.NumeroCuenta = '".$this->getNumeroCuenta()."' AND ";
        if ( !is_null( $this->getTerminoPago() ) ) $s_SQLQuery .= "FCO_DocRecibo.TerminoPago = ".$this->getTerminoPago()." AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "FCO_DocRecibo.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getClaseNombre() ) ) $s_SQLQuery .= "FCO_DocRecibo.ClaseNombre = '".$this->getClaseNombre()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "FCO_DocRecibo.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "FCO_DocRecibo.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getTipoDocCliente() ) ) $s_SQLQuery .= "FCO_DocRecibo.TipoDocCliente = '".$this->getTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNumTipoDocCliente() ) ) $s_SQLQuery .= "FCO_DocRecibo.NumTipoDocCliente = '".$this->getNumTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNombreCliente() ) ) $s_SQLQuery .= "FCO_DocRecibo.NombreCliente = '".$this->getNombreCliente()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "FCO_DocRecibo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getMonto() ) ) $s_SQLQuery .= "FCO_DocRecibo.Monto = ".$this->getMonto()." AND ";
        if ( !is_null( $this->getSaldo() ) ) $s_SQLQuery .= "FCO_DocRecibo.Saldo = ".$this->getSaldo()." AND ";
        if ( !is_null( $this->getMontoMN() ) ) $s_SQLQuery .= "FCO_DocRecibo.MontoMN = ".$this->getMontoMN()." AND ";
        if ( !is_null( $this->getSaldoMN() ) ) $s_SQLQuery .= "FCO_DocRecibo.SaldoMN = ".$this->getSaldoMN()." AND ";
        if ( !is_null( $this->getMontoME() ) ) $s_SQLQuery .= "FCO_DocRecibo.MontoME = ".$this->getMontoME()." AND ";
        if ( !is_null( $this->getSaldoME() ) ) $s_SQLQuery .= "FCO_DocRecibo.SaldoME = ".$this->getSaldoME()." AND ";
        if ( !is_null( $this->getFechaAprobacion() ) ) $s_SQLQuery .= "FCO_DocRecibo.FechaAprobacion = '".$this->getFechaAprobacion()."' AND ";
        if ( !is_null( $this->getApruebaUsuario() ) ) $s_SQLQuery .= "FCO_DocRecibo.ApruebaUsuario = '".$this->getApruebaUsuario()."' AND ";
        if ( !is_null( $this->getFechaCobranza() ) ) $s_SQLQuery .= "FCO_DocRecibo.FechaCobranza = '".$this->getFechaCobranza()."' AND ";
        if ( !is_null( $this->getCobranzaEstado() ) ) $s_SQLQuery .= "FCO_DocRecibo.CobranzaEstado = '".$this->getCobranzaEstado()."' AND ";
        if ( !is_null( $this->getFlujoEstado() ) ) $s_SQLQuery .= "FCO_DocRecibo.FlujoEstado = '".$this->getFlujoEstado()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "FCO_DocRecibo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_DocRecibo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_DocRecibo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_DocRecibo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_DocRecibo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_DocRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_DocReciboBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_DocRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_DocReciboBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_DocReciboBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_DocReciboBN[] = $o_FCO_DocReciboBN;
            }
        }
        return $a_FCO_DocReciboBN;
    }

    /* Devuelve un objeto FCO_DocReciboBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_DocRecibo )
    {
        $o_FCO_DocReciboBN = new FCO_DocReciboBN();
        if ( !is_null( $a_FCO_DocRecibo['IdDocRecibo'] ) ) $o_FCO_DocReciboBN->setIdDocRecibo( ( integer ) $a_FCO_DocRecibo['IdDocRecibo'] );
        if ( !is_null( $a_FCO_DocRecibo['IdCompania'] ) ) $o_FCO_DocReciboBN->setIdCompania( ( integer ) $a_FCO_DocRecibo['IdCompania'] );
        if ( !is_null( $a_FCO_DocRecibo['IdSucursal'] ) ) $o_FCO_DocReciboBN->setIdSucursal( ( integer ) $a_FCO_DocRecibo['IdSucursal'] );
        if ( !is_null( $a_FCO_DocRecibo['IdTipoPago'] ) ) $o_FCO_DocReciboBN->setIdTipoPago( ( integer ) $a_FCO_DocRecibo['IdTipoPago'] );
        if ( !is_null( $a_FCO_DocRecibo['IdMoneda'] ) ) $o_FCO_DocReciboBN->setIdMoneda( $a_FCO_DocRecibo['IdMoneda'] );
        if ( !is_null( $a_FCO_DocRecibo['MonedaDes'] ) ) $o_FCO_DocReciboBN->setMonedaDes( $a_FCO_DocRecibo['MonedaDes'] );
        if ( !is_null( $a_FCO_DocRecibo['ReciboNumero'] ) ) $o_FCO_DocReciboBN->setReciboNumero( $a_FCO_DocRecibo['ReciboNumero'] );
        if ( !is_null( $a_FCO_DocRecibo['ReciboFecha'] ) ) $o_FCO_DocReciboBN->setReciboFecha( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['ReciboFecha'], "Y-m-d" ) );
        if ( !is_null( $a_FCO_DocRecibo['IdBanco'] ) ) $o_FCO_DocReciboBN->setIdBanco( ( integer ) $a_FCO_DocRecibo['IdBanco'] );
        if ( !is_null( $a_FCO_DocRecibo['IdCuenta'] ) ) $o_FCO_DocReciboBN->setIdCuenta( ( integer ) $a_FCO_DocRecibo['IdCuenta'] );
        if ( !is_null( $a_FCO_DocRecibo['NumeroCuenta'] ) ) $o_FCO_DocReciboBN->setNumeroCuenta( $a_FCO_DocRecibo['NumeroCuenta'] );
        if ( !is_null( $a_FCO_DocRecibo['TerminoPago'] ) ) $o_FCO_DocReciboBN->setTerminoPago( ( integer ) $a_FCO_DocRecibo['TerminoPago'] );
        if ( !is_null( $a_FCO_DocRecibo['FechaVencimiento'] ) ) $o_FCO_DocReciboBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_FCO_DocRecibo['IdNumeroDocumento'] ) ) $o_FCO_DocReciboBN->setIdNumeroDocumento( $a_FCO_DocRecibo['IdNumeroDocumento'] );
        if ( !is_null( $a_FCO_DocRecibo['ClaseNombre'] ) ) $o_FCO_DocReciboBN->setClaseNombre( $a_FCO_DocRecibo['ClaseNombre'] );
        if ( !is_null( $a_FCO_DocRecibo['TipoCambio'] ) ) $o_FCO_DocReciboBN->setTipoCambio( ( float ) $a_FCO_DocRecibo['TipoCambio'] );
        if ( !is_null( $a_FCO_DocRecibo['IdPersona'] ) ) $o_FCO_DocReciboBN->setIdPersona( ( integer ) $a_FCO_DocRecibo['IdPersona'] );
        if ( !is_null( $a_FCO_DocRecibo['TipoDocCliente'] ) ) $o_FCO_DocReciboBN->setTipoDocCliente( $a_FCO_DocRecibo['TipoDocCliente'] );
        if ( !is_null( $a_FCO_DocRecibo['NumTipoDocCliente'] ) ) $o_FCO_DocReciboBN->setNumTipoDocCliente( $a_FCO_DocRecibo['NumTipoDocCliente'] );
        if ( !is_null( $a_FCO_DocRecibo['NombreCliente'] ) ) $o_FCO_DocReciboBN->setNombreCliente( $a_FCO_DocRecibo['NombreCliente'] );
        if ( !is_null( $a_FCO_DocRecibo['Descripcion'] ) ) $o_FCO_DocReciboBN->setDescripcion( $a_FCO_DocRecibo['Descripcion'] );
        if ( !is_null( $a_FCO_DocRecibo['Monto'] ) ) $o_FCO_DocReciboBN->setMonto( ( float ) $a_FCO_DocRecibo['Monto'] );
        if ( !is_null( $a_FCO_DocRecibo['Saldo'] ) ) $o_FCO_DocReciboBN->setSaldo( ( float ) $a_FCO_DocRecibo['Saldo'] );
        if ( !is_null( $a_FCO_DocRecibo['MontoMN'] ) ) $o_FCO_DocReciboBN->setMontoMN( ( float ) $a_FCO_DocRecibo['MontoMN'] );
        if ( !is_null( $a_FCO_DocRecibo['SaldoMN'] ) ) $o_FCO_DocReciboBN->setSaldoMN( ( float ) $a_FCO_DocRecibo['SaldoMN'] );
        if ( !is_null( $a_FCO_DocRecibo['MontoME'] ) ) $o_FCO_DocReciboBN->setMontoME( ( float ) $a_FCO_DocRecibo['MontoME'] );
        if ( !is_null( $a_FCO_DocRecibo['SaldoME'] ) ) $o_FCO_DocReciboBN->setSaldoME( ( float ) $a_FCO_DocRecibo['SaldoME'] );
        if ( !is_null( $a_FCO_DocRecibo['FechaAprobacion'] ) ) $o_FCO_DocReciboBN->setFechaAprobacion( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['FechaAprobacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_DocRecibo['ApruebaUsuario'] ) ) $o_FCO_DocReciboBN->setApruebaUsuario( $a_FCO_DocRecibo['ApruebaUsuario'] );
        if ( !is_null( $a_FCO_DocRecibo['FechaCobranza'] ) ) $o_FCO_DocReciboBN->setFechaCobranza( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['FechaCobranza'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_DocRecibo['CobranzaEstado'] ) ) $o_FCO_DocReciboBN->setCobranzaEstado( $a_FCO_DocRecibo['CobranzaEstado'] );
        if ( !is_null( $a_FCO_DocRecibo['FlujoEstado'] ) ) $o_FCO_DocReciboBN->setFlujoEstado( $a_FCO_DocRecibo['FlujoEstado'] );
        if ( !is_null( $a_FCO_DocRecibo['Estado'] ) ) $o_FCO_DocReciboBN->setEstado( $a_FCO_DocRecibo['Estado'] );
        if ( !is_null( $a_FCO_DocRecibo['FechaCreacion'] ) ) $o_FCO_DocReciboBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_DocRecibo['UsuarioCreacion'] ) ) $o_FCO_DocReciboBN->setUsuarioCreacion( $a_FCO_DocRecibo['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_DocRecibo['FechaModificacion'] ) ) $o_FCO_DocReciboBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_DocRecibo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_DocRecibo['UsuarioModificacion'] ) ) $o_FCO_DocReciboBN->setUsuarioModificacion( $a_FCO_DocRecibo['UsuarioModificacion'] );
        return $o_FCO_DocReciboBN;
    }
}
?>