<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_CierreAplicacionTipo.xml */
/* Generado: 2021-06-25 23:59:46 */

/* Busqueda de registros de la tabla FCO_CierreAplicacionTipo. */
abstract class BaseFCO_CierreAplicacionTipoFN extends FCO_CierreAplicacionTipoBN
{
    /* Declaracion de constantes */
    const IdCierre = "FCO_CierreAplicacionTipo.IdCierre";
    const IdTipoPago = "FCO_CierreAplicacionTipo.IdTipoPago";
    const IdMoneda = "FCO_CierreAplicacionTipo.IdMoneda";
    const MonedaDes = "FCO_CierreAplicacionTipo.MonedaDes";
    const CierreCantTrans = "FCO_CierreAplicacionTipo.CierreCantTrans";
    const CierreMontoTrans = "FCO_CierreAplicacionTipo.CierreMontoTrans";
    const FechaCreacion = "FCO_CierreAplicacionTipo.FechaCreacion";
    const UsuarioCreacion = "FCO_CierreAplicacionTipo.UsuarioCreacion";
    const FechaModificacion = "FCO_CierreAplicacionTipo.FechaModificacion";
    const UsuarioModificacion = "FCO_CierreAplicacionTipo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_CierreAplicacionTipo.IdCierre AS IdCierre, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.MonedaDes AS MonedaDes, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.CierreCantTrans AS CierreCantTrans, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.CierreMontoTrans AS CierreMontoTrans, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_CierreAplicacionTipo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_CierreAplicacionTipoBN */
    public function setByBN( FCO_CierreAplicacionTipoBN $o_FCO_CierreAplicacionTipoBN )
    {
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_FCO_CierreAplicacionTipoBN->getIdCierre() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_FCO_CierreAplicacionTipoBN->getIdTipoPago() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_CierreAplicacionTipoBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_FCO_CierreAplicacionTipoBN->getMonedaDes() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getCierreCantTrans() ) )
        {
            $this->setCierreCantTrans( $o_FCO_CierreAplicacionTipoBN->getCierreCantTrans() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getCierreMontoTrans() ) )
        {
            $this->setCierreMontoTrans( $o_FCO_CierreAplicacionTipoBN->getCierreMontoTrans() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CierreAplicacionTipoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CierreAplicacionTipoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CierreAplicacionTipoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CierreAplicacionTipoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_CierreAplicacionTipoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCierre, $i_IdTipoPago, $s_IdMoneda )
    {
        if( is_null( $i_IdCierre ) ){ $i_IdCierre = -1; } 
        if( is_null( $i_IdTipoPago ) ){ $i_IdTipoPago = -1; } 
        if( is_null( $s_IdMoneda ) ){ $s_IdMoneda = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_CierreAplicacionTipo ";
        $s_SQLQuery .= "WHERE IdCierre = ".$i_IdCierre." ";
        $s_SQLQuery .= "AND IdTipoPago = ".$i_IdTipoPago." ";
        $s_SQLQuery .= "AND IdMoneda = '".$s_IdMoneda."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_CierreAplicacionTipoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_CierreAplicacionTipoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_CierreAplicacionTipoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCierre() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.IdCierre = ".$this->getIdCierre()." AND ";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getMonedaDes() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.MonedaDes = '".$this->getMonedaDes()."' AND ";
        if ( !is_null( $this->getCierreCantTrans() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.CierreCantTrans = ".$this->getCierreCantTrans()." AND ";
        if ( !is_null( $this->getCierreMontoTrans() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.CierreMontoTrans = ".$this->getCierreMontoTrans()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_CierreAplicacionTipo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_CierreAplicacionTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_CierreAplicacionTipoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_CierreAplicacionTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_CierreAplicacionTipoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_CierreAplicacionTipoBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_CierreAplicacionTipoBN[] = $o_FCO_CierreAplicacionTipoBN;
            }
        }
        return $a_FCO_CierreAplicacionTipoBN;
    }

    /* Devuelve un objeto FCO_CierreAplicacionTipoBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_CierreAplicacionTipo )
    {
        $o_FCO_CierreAplicacionTipoBN = new FCO_CierreAplicacionTipoBN();
        if ( !is_null( $a_FCO_CierreAplicacionTipo['IdCierre'] ) ) $o_FCO_CierreAplicacionTipoBN->setIdCierre( ( integer ) $a_FCO_CierreAplicacionTipo['IdCierre'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['IdTipoPago'] ) ) $o_FCO_CierreAplicacionTipoBN->setIdTipoPago( ( integer ) $a_FCO_CierreAplicacionTipo['IdTipoPago'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['IdMoneda'] ) ) $o_FCO_CierreAplicacionTipoBN->setIdMoneda( $a_FCO_CierreAplicacionTipo['IdMoneda'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['MonedaDes'] ) ) $o_FCO_CierreAplicacionTipoBN->setMonedaDes( $a_FCO_CierreAplicacionTipo['MonedaDes'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['CierreCantTrans'] ) ) $o_FCO_CierreAplicacionTipoBN->setCierreCantTrans( ( integer ) $a_FCO_CierreAplicacionTipo['CierreCantTrans'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['CierreMontoTrans'] ) ) $o_FCO_CierreAplicacionTipoBN->setCierreMontoTrans( ( float ) $a_FCO_CierreAplicacionTipo['CierreMontoTrans'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['FechaCreacion'] ) ) $o_FCO_CierreAplicacionTipoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_CierreAplicacionTipo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['UsuarioCreacion'] ) ) $o_FCO_CierreAplicacionTipoBN->setUsuarioCreacion( $a_FCO_CierreAplicacionTipo['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['FechaModificacion'] ) ) $o_FCO_CierreAplicacionTipoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_CierreAplicacionTipo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_CierreAplicacionTipo['UsuarioModificacion'] ) ) $o_FCO_CierreAplicacionTipoBN->setUsuarioModificacion( $a_FCO_CierreAplicacionTipo['UsuarioModificacion'] );
        return $o_FCO_CierreAplicacionTipoBN;
    }
}
?>