<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_Aplicacion.xml */
/* Generado: 2021-08-31 20:59:23 */

/* Busqueda de registros de la tabla FCO_Aplicacion. */
abstract class BaseFCO_AplicacionFN extends FCO_AplicacionBN
{
    /* Declaracion de constantes */
    const IdAplicacion = "FCO_Aplicacion.IdAplicacion";
    const IdParent = "FCO_Aplicacion.IdParent";
    const IdCompania = "FCO_Aplicacion.IdCompania";
    const IdSucursal = "FCO_Aplicacion.IdSucursal";
    const IdTipoPago = "FCO_Aplicacion.IdTipoPago";
    const IdCaja = "FCO_Aplicacion.IdCaja";
    const IdTurno = "FCO_Aplicacion.IdTurno";
    const IdCierre = "FCO_Aplicacion.IdCierre";
    const IdBanco = "FCO_Aplicacion.IdBanco";
    const IdCuenta = "FCO_Aplicacion.IdCuenta";
    const IdMoneda = "FCO_Aplicacion.IdMoneda";
    const MonedaDes = "FCO_Aplicacion.MonedaDes";
    const TipoCambio = "FCO_Aplicacion.TipoCambio";
    const TipoPagoNombre = "FCO_Aplicacion.TipoPagoNombre";
    const IdPersona = "FCO_Aplicacion.IdPersona";
    const TipoDocCliente = "FCO_Aplicacion.TipoDocCliente";
    const NumTipoDocCliente = "FCO_Aplicacion.NumTipoDocCliente";
    const NombreCliente = "FCO_Aplicacion.NombreCliente";
    const NombreTipo = "FCO_Aplicacion.NombreTipo";
    const ClaseNombre = "FCO_Aplicacion.ClaseNombre";
    const Descripcion = "FCO_Aplicacion.Descripcion";
    const ReciboNumero = "FCO_Aplicacion.ReciboNumero";
    const IdDocRecibo = "FCO_Aplicacion.IdDocRecibo";
    const IdNumeroDocumento = "FCO_Aplicacion.IdNumeroDocumento";
    const IdDocNumRef = "FCO_Aplicacion.IdDocNumRef";
    const CodDocRef = "FCO_Aplicacion.CodDocRef";
    const SerieNumeroDocRef = "FCO_Aplicacion.SerieNumeroDocRef";
    const MontoTotalDocRef = "FCO_Aplicacion.MontoTotalDocRef";
    const SaldoDocRef = "FCO_Aplicacion.SaldoDocRef";
    const FechaDocRef = "FCO_Aplicacion.FechaDocRef";
    const FechaDocVenRef = "FCO_Aplicacion.FechaDocVenRef";
    const IdMonedaRef = "FCO_Aplicacion.IdMonedaRef";
    const TipoCambioRef = "FCO_Aplicacion.TipoCambioRef";
    const CodVendedorRef = "FCO_Aplicacion.CodVendedorRef";
    const IdAlmacenRef = "FCO_Aplicacion.IdAlmacenRef";
    const Periodo = "FCO_Aplicacion.Periodo";
    const FechaAplicacion = "FCO_Aplicacion.FechaAplicacion";
    const MontoAplicado = "FCO_Aplicacion.MontoAplicado";
    const MontoAplicacionMN = "FCO_Aplicacion.MontoAplicacionMN";
    const MontoAplicacionME = "FCO_Aplicacion.MontoAplicacionME";
    const Mostrar = "FCO_Aplicacion.Mostrar";
    const Estado = "FCO_Aplicacion.Estado";
    const FechaCreacion = "FCO_Aplicacion.FechaCreacion";
    const UsuarioCreacion = "FCO_Aplicacion.UsuarioCreacion";
    const FechaModificacion = "FCO_Aplicacion.FechaModificacion";
    const UsuarioModificacion = "FCO_Aplicacion.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "FCO_Aplicacion.IdAplicacion AS IdAplicacion, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdParent AS IdParent, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdCierre AS IdCierre, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdCuenta AS IdCuenta, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "FCO_Aplicacion.MonedaDes AS MonedaDes, ";
        $s_SQLQuery .= "FCO_Aplicacion.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "FCO_Aplicacion.TipoPagoNombre AS TipoPagoNombre, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "FCO_Aplicacion.TipoDocCliente AS TipoDocCliente, ";
        $s_SQLQuery .= "FCO_Aplicacion.NumTipoDocCliente AS NumTipoDocCliente, ";
        $s_SQLQuery .= "FCO_Aplicacion.NombreCliente AS NombreCliente, ";
        $s_SQLQuery .= "FCO_Aplicacion.NombreTipo AS NombreTipo, ";
        $s_SQLQuery .= "FCO_Aplicacion.ClaseNombre AS ClaseNombre, ";
        $s_SQLQuery .= "FCO_Aplicacion.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "FCO_Aplicacion.ReciboNumero AS ReciboNumero, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdDocNumRef AS IdDocNumRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.CodDocRef AS CodDocRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.SerieNumeroDocRef AS SerieNumeroDocRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.MontoTotalDocRef AS MontoTotalDocRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.SaldoDocRef AS SaldoDocRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.FechaDocRef AS FechaDocRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.FechaDocVenRef AS FechaDocVenRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdMonedaRef AS IdMonedaRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.TipoCambioRef AS TipoCambioRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.CodVendedorRef AS CodVendedorRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.IdAlmacenRef AS IdAlmacenRef, ";
        $s_SQLQuery .= "FCO_Aplicacion.Periodo AS Periodo, ";
        $s_SQLQuery .= "FCO_Aplicacion.FechaAplicacion AS FechaAplicacion, ";
        $s_SQLQuery .= "FCO_Aplicacion.MontoAplicado AS MontoAplicado, ";
        $s_SQLQuery .= "FCO_Aplicacion.MontoAplicacionMN AS MontoAplicacionMN, ";
        $s_SQLQuery .= "FCO_Aplicacion.MontoAplicacionME AS MontoAplicacionME, ";
        $s_SQLQuery .= "FCO_Aplicacion.Mostrar AS Mostrar, ";
        $s_SQLQuery .= "FCO_Aplicacion.Estado AS Estado, ";
        $s_SQLQuery .= "FCO_Aplicacion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "FCO_Aplicacion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "FCO_Aplicacion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "FCO_Aplicacion.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto FCO_AplicacionBN */
    public function setByBN( FCO_AplicacionBN $o_FCO_AplicacionBN )
    {
        if ( !is_null( $o_FCO_AplicacionBN->getIdAplicacion() ) )
        {
            $this->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdParent() ) )
        {
            $this->setIdParent( $o_FCO_AplicacionBN->getIdParent() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_AplicacionBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_AplicacionBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_FCO_AplicacionBN->getIdTipoPago() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_AplicacionBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_FCO_AplicacionBN->getIdTurno() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_FCO_AplicacionBN->getIdCierre() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_FCO_AplicacionBN->getIdBanco() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdCuenta() ) )
        {
            $this->setIdCuenta( $o_FCO_AplicacionBN->getIdCuenta() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_AplicacionBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_FCO_AplicacionBN->getMonedaDes() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_FCO_AplicacionBN->getTipoCambio() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getTipoPagoNombre() ) )
        {
            $this->setTipoPagoNombre( $o_FCO_AplicacionBN->getTipoPagoNombre() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_FCO_AplicacionBN->getIdPersona() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getTipoDocCliente() ) )
        {
            $this->setTipoDocCliente( $o_FCO_AplicacionBN->getTipoDocCliente() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getNumTipoDocCliente() ) )
        {
            $this->setNumTipoDocCliente( $o_FCO_AplicacionBN->getNumTipoDocCliente() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getNombreCliente() ) )
        {
            $this->setNombreCliente( $o_FCO_AplicacionBN->getNombreCliente() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getNombreTipo() ) )
        {
            $this->setNombreTipo( $o_FCO_AplicacionBN->getNombreTipo() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getClaseNombre() ) )
        {
            $this->setClaseNombre( $o_FCO_AplicacionBN->getClaseNombre() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_FCO_AplicacionBN->getDescripcion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getReciboNumero() ) )
        {
            $this->setReciboNumero( $o_FCO_AplicacionBN->getReciboNumero() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_AplicacionBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_FCO_AplicacionBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdDocNumRef() ) )
        {
            $this->setIdDocNumRef( $o_FCO_AplicacionBN->getIdDocNumRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getCodDocRef() ) )
        {
            $this->setCodDocRef( $o_FCO_AplicacionBN->getCodDocRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getSerieNumeroDocRef() ) )
        {
            $this->setSerieNumeroDocRef( $o_FCO_AplicacionBN->getSerieNumeroDocRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMontoTotalDocRef() ) )
        {
            $this->setMontoTotalDocRef( $o_FCO_AplicacionBN->getMontoTotalDocRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getSaldoDocRef() ) )
        {
            $this->setSaldoDocRef( $o_FCO_AplicacionBN->getSaldoDocRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getFechaDocRef() ) )
        {
            $this->setFechaDocRef( $o_FCO_AplicacionBN->getFechaDocRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getFechaDocVenRef() ) )
        {
            $this->setFechaDocVenRef( $o_FCO_AplicacionBN->getFechaDocVenRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdMonedaRef() ) )
        {
            $this->setIdMonedaRef( $o_FCO_AplicacionBN->getIdMonedaRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getTipoCambioRef() ) )
        {
            $this->setTipoCambioRef( $o_FCO_AplicacionBN->getTipoCambioRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getCodVendedorRef() ) )
        {
            $this->setCodVendedorRef( $o_FCO_AplicacionBN->getCodVendedorRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getIdAlmacenRef() ) )
        {
            $this->setIdAlmacenRef( $o_FCO_AplicacionBN->getIdAlmacenRef() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_FCO_AplicacionBN->getPeriodo() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getFechaAplicacion() ) )
        {
            $this->setFechaAplicacion( $o_FCO_AplicacionBN->getFechaAplicacion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMontoAplicado() ) )
        {
            $this->setMontoAplicado( $o_FCO_AplicacionBN->getMontoAplicado() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMontoAplicacionMN() ) )
        {
            $this->setMontoAplicacionMN( $o_FCO_AplicacionBN->getMontoAplicacionMN() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMontoAplicacionME() ) )
        {
            $this->setMontoAplicacionME( $o_FCO_AplicacionBN->getMontoAplicacionME() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getMostrar() ) )
        {
            $this->setMostrar( $o_FCO_AplicacionBN->getMostrar() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_AplicacionBN->getEstado() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_AplicacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_AplicacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_AplicacionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_AplicacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_AplicacionBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return FCO_AplicacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdAplicacion )
    {
        if( is_null( $i_IdAplicacion ) ){ $i_IdAplicacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Aplicacion ";
        $s_SQLQuery .= "WHERE IdAplicacion = ".$i_IdAplicacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_FCO_AplicacionBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_FCO_AplicacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_FCO_AplicacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAplicacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdAplicacion = ".$this->getIdAplicacion()." AND ";
        if ( !is_null( $this->getIdParent() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdParent = ".$this->getIdParent()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdCierre() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdCierre = ".$this->getIdCierre()." AND ";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getIdCuenta() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdCuenta = ".$this->getIdCuenta()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getMonedaDes() ) ) $s_SQLQuery .= "FCO_Aplicacion.MonedaDes = '".$this->getMonedaDes()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "FCO_Aplicacion.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getTipoPagoNombre() ) ) $s_SQLQuery .= "FCO_Aplicacion.TipoPagoNombre = '".$this->getTipoPagoNombre()."' AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getTipoDocCliente() ) ) $s_SQLQuery .= "FCO_Aplicacion.TipoDocCliente = '".$this->getTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNumTipoDocCliente() ) ) $s_SQLQuery .= "FCO_Aplicacion.NumTipoDocCliente = '".$this->getNumTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNombreCliente() ) ) $s_SQLQuery .= "FCO_Aplicacion.NombreCliente = '".$this->getNombreCliente()."' AND ";
        if ( !is_null( $this->getNombreTipo() ) ) $s_SQLQuery .= "FCO_Aplicacion.NombreTipo = '".$this->getNombreTipo()."' AND ";
        if ( !is_null( $this->getClaseNombre() ) ) $s_SQLQuery .= "FCO_Aplicacion.ClaseNombre = '".$this->getClaseNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "FCO_Aplicacion.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getReciboNumero() ) ) $s_SQLQuery .= "FCO_Aplicacion.ReciboNumero = '".$this->getReciboNumero()."' AND ";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdDocNumRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdDocNumRef = '".$this->getIdDocNumRef()."' AND ";
        if ( !is_null( $this->getCodDocRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.CodDocRef = '".$this->getCodDocRef()."' AND ";
        if ( !is_null( $this->getSerieNumeroDocRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.SerieNumeroDocRef = '".$this->getSerieNumeroDocRef()."' AND ";
        if ( !is_null( $this->getMontoTotalDocRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.MontoTotalDocRef = ".$this->getMontoTotalDocRef()." AND ";
        if ( !is_null( $this->getSaldoDocRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.SaldoDocRef = ".$this->getSaldoDocRef()." AND ";
        if ( !is_null( $this->getFechaDocRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.FechaDocRef = '".$this->getFechaDocRef()."' AND ";
        if ( !is_null( $this->getFechaDocVenRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.FechaDocVenRef = '".$this->getFechaDocVenRef()."' AND ";
        if ( !is_null( $this->getIdMonedaRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdMonedaRef = '".$this->getIdMonedaRef()."' AND ";
        if ( !is_null( $this->getTipoCambioRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.TipoCambioRef = ".$this->getTipoCambioRef()." AND ";
        if ( !is_null( $this->getCodVendedorRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.CodVendedorRef = '".$this->getCodVendedorRef()."' AND ";
        if ( !is_null( $this->getIdAlmacenRef() ) ) $s_SQLQuery .= "FCO_Aplicacion.IdAlmacenRef = '".$this->getIdAlmacenRef()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "FCO_Aplicacion.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getFechaAplicacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.FechaAplicacion = '".$this->getFechaAplicacion()."' AND ";
        if ( !is_null( $this->getMontoAplicado() ) ) $s_SQLQuery .= "FCO_Aplicacion.MontoAplicado = ".$this->getMontoAplicado()." AND ";
        if ( !is_null( $this->getMontoAplicacionMN() ) ) $s_SQLQuery .= "FCO_Aplicacion.MontoAplicacionMN = ".$this->getMontoAplicacionMN()." AND ";
        if ( !is_null( $this->getMontoAplicacionME() ) ) $s_SQLQuery .= "FCO_Aplicacion.MontoAplicacionME = ".$this->getMontoAplicacionME()." AND ";
        if ( !is_null( $this->getMostrar() ) ) $s_SQLQuery .= "FCO_Aplicacion.Mostrar = '".$this->getMostrar()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "FCO_Aplicacion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "FCO_Aplicacion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM FCO_Aplicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return FCO_AplicacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM FCO_Aplicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_FCO_AplicacionBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_FCO_AplicacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_FCO_AplicacionBN[] = $o_FCO_AplicacionBN;
            }
        }
        return $a_FCO_AplicacionBN;
    }

    /* Devuelve un objeto FCO_AplicacionBN desde un objeto propel */
    public function insertObjectBN( $a_FCO_Aplicacion )
    {
        $o_FCO_AplicacionBN = new FCO_AplicacionBN();
        if ( !is_null( $a_FCO_Aplicacion['IdAplicacion'] ) ) $o_FCO_AplicacionBN->setIdAplicacion( ( integer ) $a_FCO_Aplicacion['IdAplicacion'] );
        if ( !is_null( $a_FCO_Aplicacion['IdParent'] ) ) $o_FCO_AplicacionBN->setIdParent( ( integer ) $a_FCO_Aplicacion['IdParent'] );
        if ( !is_null( $a_FCO_Aplicacion['IdCompania'] ) ) $o_FCO_AplicacionBN->setIdCompania( ( integer ) $a_FCO_Aplicacion['IdCompania'] );
        if ( !is_null( $a_FCO_Aplicacion['IdSucursal'] ) ) $o_FCO_AplicacionBN->setIdSucursal( ( integer ) $a_FCO_Aplicacion['IdSucursal'] );
        if ( !is_null( $a_FCO_Aplicacion['IdTipoPago'] ) ) $o_FCO_AplicacionBN->setIdTipoPago( ( integer ) $a_FCO_Aplicacion['IdTipoPago'] );
        if ( !is_null( $a_FCO_Aplicacion['IdCaja'] ) ) $o_FCO_AplicacionBN->setIdCaja( ( integer ) $a_FCO_Aplicacion['IdCaja'] );
        if ( !is_null( $a_FCO_Aplicacion['IdTurno'] ) ) $o_FCO_AplicacionBN->setIdTurno( ( integer ) $a_FCO_Aplicacion['IdTurno'] );
        if ( !is_null( $a_FCO_Aplicacion['IdCierre'] ) ) $o_FCO_AplicacionBN->setIdCierre( ( integer ) $a_FCO_Aplicacion['IdCierre'] );
        if ( !is_null( $a_FCO_Aplicacion['IdBanco'] ) ) $o_FCO_AplicacionBN->setIdBanco( ( integer ) $a_FCO_Aplicacion['IdBanco'] );
        if ( !is_null( $a_FCO_Aplicacion['IdCuenta'] ) ) $o_FCO_AplicacionBN->setIdCuenta( ( integer ) $a_FCO_Aplicacion['IdCuenta'] );
        if ( !is_null( $a_FCO_Aplicacion['IdMoneda'] ) ) $o_FCO_AplicacionBN->setIdMoneda( $a_FCO_Aplicacion['IdMoneda'] );
        if ( !is_null( $a_FCO_Aplicacion['MonedaDes'] ) ) $o_FCO_AplicacionBN->setMonedaDes( $a_FCO_Aplicacion['MonedaDes'] );
        if ( !is_null( $a_FCO_Aplicacion['TipoCambio'] ) ) $o_FCO_AplicacionBN->setTipoCambio( ( float ) $a_FCO_Aplicacion['TipoCambio'] );
        if ( !is_null( $a_FCO_Aplicacion['TipoPagoNombre'] ) ) $o_FCO_AplicacionBN->setTipoPagoNombre( $a_FCO_Aplicacion['TipoPagoNombre'] );
        if ( !is_null( $a_FCO_Aplicacion['IdPersona'] ) ) $o_FCO_AplicacionBN->setIdPersona( ( integer ) $a_FCO_Aplicacion['IdPersona'] );
        if ( !is_null( $a_FCO_Aplicacion['TipoDocCliente'] ) ) $o_FCO_AplicacionBN->setTipoDocCliente( $a_FCO_Aplicacion['TipoDocCliente'] );
        if ( !is_null( $a_FCO_Aplicacion['NumTipoDocCliente'] ) ) $o_FCO_AplicacionBN->setNumTipoDocCliente( $a_FCO_Aplicacion['NumTipoDocCliente'] );
        if ( !is_null( $a_FCO_Aplicacion['NombreCliente'] ) ) $o_FCO_AplicacionBN->setNombreCliente( $a_FCO_Aplicacion['NombreCliente'] );
        if ( !is_null( $a_FCO_Aplicacion['NombreTipo'] ) ) $o_FCO_AplicacionBN->setNombreTipo( $a_FCO_Aplicacion['NombreTipo'] );
        if ( !is_null( $a_FCO_Aplicacion['ClaseNombre'] ) ) $o_FCO_AplicacionBN->setClaseNombre( $a_FCO_Aplicacion['ClaseNombre'] );
        if ( !is_null( $a_FCO_Aplicacion['Descripcion'] ) ) $o_FCO_AplicacionBN->setDescripcion( $a_FCO_Aplicacion['Descripcion'] );
        if ( !is_null( $a_FCO_Aplicacion['ReciboNumero'] ) ) $o_FCO_AplicacionBN->setReciboNumero( $a_FCO_Aplicacion['ReciboNumero'] );
        if ( !is_null( $a_FCO_Aplicacion['IdDocRecibo'] ) ) $o_FCO_AplicacionBN->setIdDocRecibo( ( integer ) $a_FCO_Aplicacion['IdDocRecibo'] );
        if ( !is_null( $a_FCO_Aplicacion['IdNumeroDocumento'] ) ) $o_FCO_AplicacionBN->setIdNumeroDocumento( $a_FCO_Aplicacion['IdNumeroDocumento'] );
        if ( !is_null( $a_FCO_Aplicacion['IdDocNumRef'] ) ) $o_FCO_AplicacionBN->setIdDocNumRef( $a_FCO_Aplicacion['IdDocNumRef'] );
        if ( !is_null( $a_FCO_Aplicacion['CodDocRef'] ) ) $o_FCO_AplicacionBN->setCodDocRef( $a_FCO_Aplicacion['CodDocRef'] );
        if ( !is_null( $a_FCO_Aplicacion['SerieNumeroDocRef'] ) ) $o_FCO_AplicacionBN->setSerieNumeroDocRef( $a_FCO_Aplicacion['SerieNumeroDocRef'] );
        if ( !is_null( $a_FCO_Aplicacion['MontoTotalDocRef'] ) ) $o_FCO_AplicacionBN->setMontoTotalDocRef( ( float ) $a_FCO_Aplicacion['MontoTotalDocRef'] );
        if ( !is_null( $a_FCO_Aplicacion['SaldoDocRef'] ) ) $o_FCO_AplicacionBN->setSaldoDocRef( ( float ) $a_FCO_Aplicacion['SaldoDocRef'] );
        if ( !is_null( $a_FCO_Aplicacion['FechaDocRef'] ) ) $o_FCO_AplicacionBN->setFechaDocRef( utilTimestamp::getTimestamp( $a_FCO_Aplicacion['FechaDocRef'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Aplicacion['FechaDocVenRef'] ) ) $o_FCO_AplicacionBN->setFechaDocVenRef( utilTimestamp::getTimestamp( $a_FCO_Aplicacion['FechaDocVenRef'], "Y-m-d" ) );
        if ( !is_null( $a_FCO_Aplicacion['IdMonedaRef'] ) ) $o_FCO_AplicacionBN->setIdMonedaRef( $a_FCO_Aplicacion['IdMonedaRef'] );
        if ( !is_null( $a_FCO_Aplicacion['TipoCambioRef'] ) ) $o_FCO_AplicacionBN->setTipoCambioRef( ( float ) $a_FCO_Aplicacion['TipoCambioRef'] );
        if ( !is_null( $a_FCO_Aplicacion['CodVendedorRef'] ) ) $o_FCO_AplicacionBN->setCodVendedorRef( $a_FCO_Aplicacion['CodVendedorRef'] );
        if ( !is_null( $a_FCO_Aplicacion['IdAlmacenRef'] ) ) $o_FCO_AplicacionBN->setIdAlmacenRef( $a_FCO_Aplicacion['IdAlmacenRef'] );
        if ( !is_null( $a_FCO_Aplicacion['Periodo'] ) ) $o_FCO_AplicacionBN->setPeriodo( $a_FCO_Aplicacion['Periodo'] );
        if ( !is_null( $a_FCO_Aplicacion['FechaAplicacion'] ) ) $o_FCO_AplicacionBN->setFechaAplicacion( utilTimestamp::getTimestamp( $a_FCO_Aplicacion['FechaAplicacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Aplicacion['MontoAplicado'] ) ) $o_FCO_AplicacionBN->setMontoAplicado( ( float ) $a_FCO_Aplicacion['MontoAplicado'] );
        if ( !is_null( $a_FCO_Aplicacion['MontoAplicacionMN'] ) ) $o_FCO_AplicacionBN->setMontoAplicacionMN( ( float ) $a_FCO_Aplicacion['MontoAplicacionMN'] );
        if ( !is_null( $a_FCO_Aplicacion['MontoAplicacionME'] ) ) $o_FCO_AplicacionBN->setMontoAplicacionME( ( float ) $a_FCO_Aplicacion['MontoAplicacionME'] );
        if ( !is_null( $a_FCO_Aplicacion['Mostrar'] ) ) $o_FCO_AplicacionBN->setMostrar( $a_FCO_Aplicacion['Mostrar'] );
        if ( !is_null( $a_FCO_Aplicacion['Estado'] ) ) $o_FCO_AplicacionBN->setEstado( $a_FCO_Aplicacion['Estado'] );
        if ( !is_null( $a_FCO_Aplicacion['FechaCreacion'] ) ) $o_FCO_AplicacionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_FCO_Aplicacion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Aplicacion['UsuarioCreacion'] ) ) $o_FCO_AplicacionBN->setUsuarioCreacion( $a_FCO_Aplicacion['UsuarioCreacion'] );
        if ( !is_null( $a_FCO_Aplicacion['FechaModificacion'] ) ) $o_FCO_AplicacionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_FCO_Aplicacion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_FCO_Aplicacion['UsuarioModificacion'] ) ) $o_FCO_AplicacionBN->setUsuarioModificacion( $a_FCO_Aplicacion['UsuarioModificacion'] );
        return $o_FCO_AplicacionBN;
    }
}
?>