<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: exp_producto.xml */
/* Generado: 2021-06-26 00:00:09 */

/* Busqueda de registros de la tabla exp_producto. */
abstract class BaseExp_productoFN extends Exp_productoBN
{
    /* Declaracion de constantes */
    const Codigo = "exp_producto.codigo";
    const Id_product = "exp_producto.id_product";
    const Estado = "exp_producto.estado";
    const Nombre = "exp_producto.nombre";
    const Minicodigo = "exp_producto.minicodigo";
    const Descripcion_largo = "exp_producto.descripcion_largo";
    const Descripcion_corto = "exp_producto.descripcion_corto";
    const Item_tipo_id = "exp_producto.item_tipo_id";
    const Item_tipo_desc = "exp_producto.item_tipo_desc";
    const Linea_prod_id = "exp_producto.linea_prod_id";
    const Linea_prod_desc = "exp_producto.linea_prod_desc";
    const Marca_id = "exp_producto.marca_id";
    const Marca_desc = "exp_producto.marca_desc";
    const Numero_parte = "exp_producto.numero_parte";
    const Tipo_uso_desc = "exp_producto.tipo_uso_desc";
    const Garantia_desc = "exp_producto.garantia_desc";
    const Dim_longitud = "exp_producto.dim_longitud";
    const Dim_alto = "exp_producto.dim_alto";
    const Dim_ancho = "exp_producto.dim_ancho";
    const Dim_peso = "exp_producto.dim_peso";
    const Dir_imagen_medio = "exp_producto.dir_imagen_medio";
    const Dir_imagen_accesorio = "exp_producto.dir_imagen_accesorio";
    const Dir_imagen_largo = "exp_producto.dir_imagen_largo";
    const Precio_dol = "exp_producto.precio_dol";
    const Precio_sol = "exp_producto.precio_sol";
    const Stock = "exp_producto.stock";
    const Caracteristicas = "exp_producto.caracteristicas";
    const Fecha_reg = "exp_producto.fecha_reg";
    const Fecha_upd = "exp_producto.fecha_upd";
    const Fecha_precio_act = "exp_producto.fecha_precio_act";
    const Fecha_caracteristica = "exp_producto.fecha_caracteristica";
    const Fecha_imagen_act = "exp_producto.fecha_imagen_act";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "exp_producto.codigo AS codigo, ";
        $s_SQLQuery .= "exp_producto.id_product AS id_product, ";
        $s_SQLQuery .= "exp_producto.estado AS estado, ";
        $s_SQLQuery .= "exp_producto.nombre AS nombre, ";
        $s_SQLQuery .= "exp_producto.minicodigo AS minicodigo, ";
        $s_SQLQuery .= "exp_producto.descripcion_largo AS descripcion_largo, ";
        $s_SQLQuery .= "exp_producto.descripcion_corto AS descripcion_corto, ";
        $s_SQLQuery .= "exp_producto.item_tipo_id AS item_tipo_id, ";
        $s_SQLQuery .= "exp_producto.item_tipo_desc AS item_tipo_desc, ";
        $s_SQLQuery .= "exp_producto.linea_prod_id AS linea_prod_id, ";
        $s_SQLQuery .= "exp_producto.linea_prod_desc AS linea_prod_desc, ";
        $s_SQLQuery .= "exp_producto.marca_id AS marca_id, ";
        $s_SQLQuery .= "exp_producto.marca_desc AS marca_desc, ";
        $s_SQLQuery .= "exp_producto.numero_parte AS numero_parte, ";
        $s_SQLQuery .= "exp_producto.tipo_uso_desc AS tipo_uso_desc, ";
        $s_SQLQuery .= "exp_producto.garantia_desc AS garantia_desc, ";
        $s_SQLQuery .= "exp_producto.dim_longitud AS dim_longitud, ";
        $s_SQLQuery .= "exp_producto.dim_alto AS dim_alto, ";
        $s_SQLQuery .= "exp_producto.dim_ancho AS dim_ancho, ";
        $s_SQLQuery .= "exp_producto.dim_peso AS dim_peso, ";
        $s_SQLQuery .= "exp_producto.dir_imagen_medio AS dir_imagen_medio, ";
        $s_SQLQuery .= "exp_producto.dir_imagen_accesorio AS dir_imagen_accesorio, ";
        $s_SQLQuery .= "exp_producto.dir_imagen_largo AS dir_imagen_largo, ";
        $s_SQLQuery .= "exp_producto.precio_dol AS precio_dol, ";
        $s_SQLQuery .= "exp_producto.precio_sol AS precio_sol, ";
        $s_SQLQuery .= "exp_producto.stock AS stock, ";
        $s_SQLQuery .= "exp_producto.caracteristicas AS caracteristicas, ";
        $s_SQLQuery .= "exp_producto.fecha_reg AS fecha_reg, ";
        $s_SQLQuery .= "exp_producto.fecha_upd AS fecha_upd, ";
        $s_SQLQuery .= "exp_producto.fecha_precio_act AS fecha_precio_act, ";
        $s_SQLQuery .= "exp_producto.fecha_caracteristica AS fecha_caracteristica, ";
        $s_SQLQuery .= "exp_producto.fecha_imagen_act AS fecha_imagen_act ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto Exp_productoBN */
    public function setByBN( Exp_productoBN $o_Exp_productoBN )
    {
        if ( !is_null( $o_Exp_productoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_Exp_productoBN->getCodigo() );
        }
        if ( !is_null( $o_Exp_productoBN->getId_product() ) )
        {
            $this->setId_product( $o_Exp_productoBN->getId_product() );
        }
        if ( !is_null( $o_Exp_productoBN->getEstado() ) )
        {
            $this->setEstado( $o_Exp_productoBN->getEstado() );
        }
        if ( !is_null( $o_Exp_productoBN->getNombre() ) )
        {
            $this->setNombre( $o_Exp_productoBN->getNombre() );
        }
        if ( !is_null( $o_Exp_productoBN->getMinicodigo() ) )
        {
            $this->setMinicodigo( $o_Exp_productoBN->getMinicodigo() );
        }
        if ( !is_null( $o_Exp_productoBN->getDescripcion_largo() ) )
        {
            $this->setDescripcion_largo( $o_Exp_productoBN->getDescripcion_largo() );
        }
        if ( !is_null( $o_Exp_productoBN->getDescripcion_corto() ) )
        {
            $this->setDescripcion_corto( $o_Exp_productoBN->getDescripcion_corto() );
        }
        if ( !is_null( $o_Exp_productoBN->getItem_tipo_id() ) )
        {
            $this->setItem_tipo_id( $o_Exp_productoBN->getItem_tipo_id() );
        }
        if ( !is_null( $o_Exp_productoBN->getItem_tipo_desc() ) )
        {
            $this->setItem_tipo_desc( $o_Exp_productoBN->getItem_tipo_desc() );
        }
        if ( !is_null( $o_Exp_productoBN->getLinea_prod_id() ) )
        {
            $this->setLinea_prod_id( $o_Exp_productoBN->getLinea_prod_id() );
        }
        if ( !is_null( $o_Exp_productoBN->getLinea_prod_desc() ) )
        {
            $this->setLinea_prod_desc( $o_Exp_productoBN->getLinea_prod_desc() );
        }
        if ( !is_null( $o_Exp_productoBN->getMarca_id() ) )
        {
            $this->setMarca_id( $o_Exp_productoBN->getMarca_id() );
        }
        if ( !is_null( $o_Exp_productoBN->getMarca_desc() ) )
        {
            $this->setMarca_desc( $o_Exp_productoBN->getMarca_desc() );
        }
        if ( !is_null( $o_Exp_productoBN->getNumero_parte() ) )
        {
            $this->setNumero_parte( $o_Exp_productoBN->getNumero_parte() );
        }
        if ( !is_null( $o_Exp_productoBN->getTipo_uso_desc() ) )
        {
            $this->setTipo_uso_desc( $o_Exp_productoBN->getTipo_uso_desc() );
        }
        if ( !is_null( $o_Exp_productoBN->getGarantia_desc() ) )
        {
            $this->setGarantia_desc( $o_Exp_productoBN->getGarantia_desc() );
        }
        if ( !is_null( $o_Exp_productoBN->getDim_longitud() ) )
        {
            $this->setDim_longitud( $o_Exp_productoBN->getDim_longitud() );
        }
        if ( !is_null( $o_Exp_productoBN->getDim_alto() ) )
        {
            $this->setDim_alto( $o_Exp_productoBN->getDim_alto() );
        }
        if ( !is_null( $o_Exp_productoBN->getDim_ancho() ) )
        {
            $this->setDim_ancho( $o_Exp_productoBN->getDim_ancho() );
        }
        if ( !is_null( $o_Exp_productoBN->getDim_peso() ) )
        {
            $this->setDim_peso( $o_Exp_productoBN->getDim_peso() );
        }
        if ( !is_null( $o_Exp_productoBN->getDir_imagen_medio() ) )
        {
            $this->setDir_imagen_medio( $o_Exp_productoBN->getDir_imagen_medio() );
        }
        if ( !is_null( $o_Exp_productoBN->getDir_imagen_accesorio() ) )
        {
            $this->setDir_imagen_accesorio( $o_Exp_productoBN->getDir_imagen_accesorio() );
        }
        if ( !is_null( $o_Exp_productoBN->getDir_imagen_largo() ) )
        {
            $this->setDir_imagen_largo( $o_Exp_productoBN->getDir_imagen_largo() );
        }
        if ( !is_null( $o_Exp_productoBN->getPrecio_dol() ) )
        {
            $this->setPrecio_dol( $o_Exp_productoBN->getPrecio_dol() );
        }
        if ( !is_null( $o_Exp_productoBN->getPrecio_sol() ) )
        {
            $this->setPrecio_sol( $o_Exp_productoBN->getPrecio_sol() );
        }
        if ( !is_null( $o_Exp_productoBN->getStock() ) )
        {
            $this->setStock( $o_Exp_productoBN->getStock() );
        }
        if ( !is_null( $o_Exp_productoBN->getCaracteristicas() ) )
        {
            $this->setCaracteristicas( $o_Exp_productoBN->getCaracteristicas() );
        }
        if ( !is_null( $o_Exp_productoBN->getFecha_reg() ) )
        {
            $this->setFecha_reg( $o_Exp_productoBN->getFecha_reg() );
        }
        if ( !is_null( $o_Exp_productoBN->getFecha_upd() ) )
        {
            $this->setFecha_upd( $o_Exp_productoBN->getFecha_upd() );
        }
        if ( !is_null( $o_Exp_productoBN->getFecha_precio_act() ) )
        {
            $this->setFecha_precio_act( $o_Exp_productoBN->getFecha_precio_act() );
        }
        if ( !is_null( $o_Exp_productoBN->getFecha_caracteristica() ) )
        {
            $this->setFecha_caracteristica( $o_Exp_productoBN->getFecha_caracteristica() );
        }
        if ( !is_null( $o_Exp_productoBN->getFecha_imagen_act() ) )
        {
            $this->setFecha_imagen_act( $o_Exp_productoBN->getFecha_imagen_act() );
        }
    }

    /**
    * @return Exp_productoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_Codigo )
    {
        if( is_null( $s_Codigo ) ){ $s_Codigo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM exp_producto ";
        $s_SQLQuery .= "WHERE codigo = '".$s_Codigo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Exp_productoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_Exp_productoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_Exp_productoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "exp_producto.codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getId_product() ) ) $s_SQLQuery .= "exp_producto.id_product = '".$this->getId_product()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "exp_producto.estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "exp_producto.nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getMinicodigo() ) ) $s_SQLQuery .= "exp_producto.minicodigo = '".$this->getMinicodigo()."' AND ";
        if ( !is_null( $this->getDescripcion_largo() ) ) $s_SQLQuery .= "exp_producto.descripcion_largo = '".$this->getDescripcion_largo()."' AND ";
        if ( !is_null( $this->getDescripcion_corto() ) ) $s_SQLQuery .= "exp_producto.descripcion_corto = '".$this->getDescripcion_corto()."' AND ";
        if ( !is_null( $this->getItem_tipo_id() ) ) $s_SQLQuery .= "exp_producto.item_tipo_id = '".$this->getItem_tipo_id()."' AND ";
        if ( !is_null( $this->getItem_tipo_desc() ) ) $s_SQLQuery .= "exp_producto.item_tipo_desc = '".$this->getItem_tipo_desc()."' AND ";
        if ( !is_null( $this->getLinea_prod_id() ) ) $s_SQLQuery .= "exp_producto.linea_prod_id = '".$this->getLinea_prod_id()."' AND ";
        if ( !is_null( $this->getLinea_prod_desc() ) ) $s_SQLQuery .= "exp_producto.linea_prod_desc = '".$this->getLinea_prod_desc()."' AND ";
        if ( !is_null( $this->getMarca_id() ) ) $s_SQLQuery .= "exp_producto.marca_id = '".$this->getMarca_id()."' AND ";
        if ( !is_null( $this->getMarca_desc() ) ) $s_SQLQuery .= "exp_producto.marca_desc = '".$this->getMarca_desc()."' AND ";
        if ( !is_null( $this->getNumero_parte() ) ) $s_SQLQuery .= "exp_producto.numero_parte = '".$this->getNumero_parte()."' AND ";
        if ( !is_null( $this->getTipo_uso_desc() ) ) $s_SQLQuery .= "exp_producto.tipo_uso_desc = '".$this->getTipo_uso_desc()."' AND ";
        if ( !is_null( $this->getGarantia_desc() ) ) $s_SQLQuery .= "exp_producto.garantia_desc = '".$this->getGarantia_desc()."' AND ";
        if ( !is_null( $this->getDim_longitud() ) ) $s_SQLQuery .= "exp_producto.dim_longitud = '".$this->getDim_longitud()."' AND ";
        if ( !is_null( $this->getDim_alto() ) ) $s_SQLQuery .= "exp_producto.dim_alto = '".$this->getDim_alto()."' AND ";
        if ( !is_null( $this->getDim_ancho() ) ) $s_SQLQuery .= "exp_producto.dim_ancho = '".$this->getDim_ancho()."' AND ";
        if ( !is_null( $this->getDim_peso() ) ) $s_SQLQuery .= "exp_producto.dim_peso = '".$this->getDim_peso()."' AND ";
        if ( !is_null( $this->getDir_imagen_medio() ) ) $s_SQLQuery .= "exp_producto.dir_imagen_medio = '".$this->getDir_imagen_medio()."' AND ";
        if ( !is_null( $this->getDir_imagen_accesorio() ) ) $s_SQLQuery .= "exp_producto.dir_imagen_accesorio = '".$this->getDir_imagen_accesorio()."' AND ";
        if ( !is_null( $this->getDir_imagen_largo() ) ) $s_SQLQuery .= "exp_producto.dir_imagen_largo = '".$this->getDir_imagen_largo()."' AND ";
        if ( !is_null( $this->getPrecio_dol() ) ) $s_SQLQuery .= "exp_producto.precio_dol = ".$this->getPrecio_dol()." AND ";
        if ( !is_null( $this->getPrecio_sol() ) ) $s_SQLQuery .= "exp_producto.precio_sol = ".$this->getPrecio_sol()." AND ";
        if ( !is_null( $this->getStock() ) ) $s_SQLQuery .= "exp_producto.stock = ".$this->getStock()." AND ";
        if ( !is_null( $this->getCaracteristicas() ) ) $s_SQLQuery .= "exp_producto.caracteristicas = '".$this->getCaracteristicas()."' AND ";
        if ( !is_null( $this->getFecha_reg() ) ) $s_SQLQuery .= "exp_producto.fecha_reg = '".$this->getFecha_reg()."' AND ";
        if ( !is_null( $this->getFecha_upd() ) ) $s_SQLQuery .= "exp_producto.fecha_upd = '".$this->getFecha_upd()."' AND ";
        if ( !is_null( $this->getFecha_precio_act() ) ) $s_SQLQuery .= "exp_producto.fecha_precio_act = '".$this->getFecha_precio_act()."' AND ";
        if ( !is_null( $this->getFecha_caracteristica() ) ) $s_SQLQuery .= "exp_producto.fecha_caracteristica = '".$this->getFecha_caracteristica()."' AND ";
        if ( !is_null( $this->getFecha_imagen_act() ) ) $s_SQLQuery .= "exp_producto.fecha_imagen_act = '".$this->getFecha_imagen_act()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM exp_producto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return Exp_productoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM exp_producto WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_Exp_productoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_Exp_productoBN = $this->insertObjectBN( $a_SQLRow );
                $a_Exp_productoBN[] = $o_Exp_productoBN;
            }
        }
        return $a_Exp_productoBN;
    }

    /* Devuelve un objeto Exp_productoBN desde un objeto propel */
    public function insertObjectBN( $a_Exp_producto )
    {
        $o_Exp_productoBN = new Exp_productoBN();
        if ( !is_null( $a_Exp_producto['codigo'] ) ) $o_Exp_productoBN->setCodigo( $a_Exp_producto['codigo'] );
        if ( !is_null( $a_Exp_producto['id_product'] ) ) $o_Exp_productoBN->setId_product( $a_Exp_producto['id_product'] );
        if ( !is_null( $a_Exp_producto['estado'] ) ) $o_Exp_productoBN->setEstado( $a_Exp_producto['estado'] );
        if ( !is_null( $a_Exp_producto['nombre'] ) ) $o_Exp_productoBN->setNombre( $a_Exp_producto['nombre'] );
        if ( !is_null( $a_Exp_producto['minicodigo'] ) ) $o_Exp_productoBN->setMinicodigo( $a_Exp_producto['minicodigo'] );
        if ( !is_null( $a_Exp_producto['descripcion_largo'] ) ) $o_Exp_productoBN->setDescripcion_largo( $a_Exp_producto['descripcion_largo'] );
        if ( !is_null( $a_Exp_producto['descripcion_corto'] ) ) $o_Exp_productoBN->setDescripcion_corto( $a_Exp_producto['descripcion_corto'] );
        if ( !is_null( $a_Exp_producto['item_tipo_id'] ) ) $o_Exp_productoBN->setItem_tipo_id( $a_Exp_producto['item_tipo_id'] );
        if ( !is_null( $a_Exp_producto['item_tipo_desc'] ) ) $o_Exp_productoBN->setItem_tipo_desc( $a_Exp_producto['item_tipo_desc'] );
        if ( !is_null( $a_Exp_producto['linea_prod_id'] ) ) $o_Exp_productoBN->setLinea_prod_id( $a_Exp_producto['linea_prod_id'] );
        if ( !is_null( $a_Exp_producto['linea_prod_desc'] ) ) $o_Exp_productoBN->setLinea_prod_desc( $a_Exp_producto['linea_prod_desc'] );
        if ( !is_null( $a_Exp_producto['marca_id'] ) ) $o_Exp_productoBN->setMarca_id( $a_Exp_producto['marca_id'] );
        if ( !is_null( $a_Exp_producto['marca_desc'] ) ) $o_Exp_productoBN->setMarca_desc( $a_Exp_producto['marca_desc'] );
        if ( !is_null( $a_Exp_producto['numero_parte'] ) ) $o_Exp_productoBN->setNumero_parte( $a_Exp_producto['numero_parte'] );
        if ( !is_null( $a_Exp_producto['tipo_uso_desc'] ) ) $o_Exp_productoBN->setTipo_uso_desc( $a_Exp_producto['tipo_uso_desc'] );
        if ( !is_null( $a_Exp_producto['garantia_desc'] ) ) $o_Exp_productoBN->setGarantia_desc( $a_Exp_producto['garantia_desc'] );
        if ( !is_null( $a_Exp_producto['dim_longitud'] ) ) $o_Exp_productoBN->setDim_longitud( $a_Exp_producto['dim_longitud'] );
        if ( !is_null( $a_Exp_producto['dim_alto'] ) ) $o_Exp_productoBN->setDim_alto( $a_Exp_producto['dim_alto'] );
        if ( !is_null( $a_Exp_producto['dim_ancho'] ) ) $o_Exp_productoBN->setDim_ancho( $a_Exp_producto['dim_ancho'] );
        if ( !is_null( $a_Exp_producto['dim_peso'] ) ) $o_Exp_productoBN->setDim_peso( $a_Exp_producto['dim_peso'] );
        if ( !is_null( $a_Exp_producto['dir_imagen_medio'] ) ) $o_Exp_productoBN->setDir_imagen_medio( $a_Exp_producto['dir_imagen_medio'] );
        if ( !is_null( $a_Exp_producto['dir_imagen_accesorio'] ) ) $o_Exp_productoBN->setDir_imagen_accesorio( $a_Exp_producto['dir_imagen_accesorio'] );
        if ( !is_null( $a_Exp_producto['dir_imagen_largo'] ) ) $o_Exp_productoBN->setDir_imagen_largo( $a_Exp_producto['dir_imagen_largo'] );
        if ( !is_null( $a_Exp_producto['precio_dol'] ) ) $o_Exp_productoBN->setPrecio_dol( ( float ) $a_Exp_producto['precio_dol'] );
        if ( !is_null( $a_Exp_producto['precio_sol'] ) ) $o_Exp_productoBN->setPrecio_sol( ( float ) $a_Exp_producto['precio_sol'] );
        if ( !is_null( $a_Exp_producto['stock'] ) ) $o_Exp_productoBN->setStock( ( integer ) $a_Exp_producto['stock'] );
        if ( !is_null( $a_Exp_producto['caracteristicas'] ) ) $o_Exp_productoBN->setCaracteristicas( $a_Exp_producto['caracteristicas'] );
        if ( !is_null( $a_Exp_producto['fecha_reg'] ) ) $o_Exp_productoBN->setFecha_reg( utilTimestamp::getTimestamp( $a_Exp_producto['fecha_reg'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_Exp_producto['fecha_upd'] ) ) $o_Exp_productoBN->setFecha_upd( utilTimestamp::getTimestamp( $a_Exp_producto['fecha_upd'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_Exp_producto['fecha_precio_act'] ) ) $o_Exp_productoBN->setFecha_precio_act( utilTimestamp::getTimestamp( $a_Exp_producto['fecha_precio_act'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_Exp_producto['fecha_caracteristica'] ) ) $o_Exp_productoBN->setFecha_caracteristica( utilTimestamp::getTimestamp( $a_Exp_producto['fecha_caracteristica'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_Exp_producto['fecha_imagen_act'] ) ) $o_Exp_productoBN->setFecha_imagen_act( utilTimestamp::getTimestamp( $a_Exp_producto['fecha_imagen_act'], "Y-m-d H:i:s" ) );
        return $o_Exp_productoBN;
    }
}
?>