<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_DocRecibo.xml */
/* Generado: 2021-10-19 07:59:09 */

/* Busqueda de registros de la tabla CP_DocRecibo. */
abstract class BaseCP_DocReciboFN extends CP_DocReciboBN
{
    /* Declaracion de constantes */
    const IdDocRecibo = "CP_DocRecibo.IdDocRecibo";
    const IdCompania = "CP_DocRecibo.IdCompania";
    const IdSucursal = "CP_DocRecibo.IdSucursal";
    const ParentId = "CP_DocRecibo.ParentId";
    const ParentCod = "CP_DocRecibo.ParentCod";
    const IdTipoPago = "CP_DocRecibo.IdTipoPago";
    const IdMoneda = "CP_DocRecibo.IdMoneda";
    const MonedaDes = "CP_DocRecibo.MonedaDes";
    const ReciboNumero = "CP_DocRecibo.ReciboNumero";
    const ReciboFecha = "CP_DocRecibo.ReciboFecha";
    const IdBanco = "CP_DocRecibo.IdBanco";
    const IdCuenta = "CP_DocRecibo.IdCuenta";
    const NumeroCuenta = "CP_DocRecibo.NumeroCuenta";
    const TerminoPago = "CP_DocRecibo.TerminoPago";
    const FechaVencimiento = "CP_DocRecibo.FechaVencimiento";
    const IdNumeroDocumento = "CP_DocRecibo.IdNumeroDocumento";
    const ClaseNombre = "CP_DocRecibo.ClaseNombre";
    const TipoCambio = "CP_DocRecibo.TipoCambio";
    const IdPersona = "CP_DocRecibo.IdPersona";
    const TipoDocCliente = "CP_DocRecibo.TipoDocCliente";
    const NumTipoDocCliente = "CP_DocRecibo.NumTipoDocCliente";
    const NombreCliente = "CP_DocRecibo.NombreCliente";
    const Descripcion = "CP_DocRecibo.Descripcion";
    const Monto = "CP_DocRecibo.Monto";
    const Saldo = "CP_DocRecibo.Saldo";
    const MontoMN = "CP_DocRecibo.MontoMN";
    const SaldoMN = "CP_DocRecibo.SaldoMN";
    const MontoME = "CP_DocRecibo.MontoME";
    const SaldoME = "CP_DocRecibo.SaldoME";
    const FechaAprobacion = "CP_DocRecibo.FechaAprobacion";
    const ApruebaUsuario = "CP_DocRecibo.ApruebaUsuario";
    const FechaCobranza = "CP_DocRecibo.FechaCobranza";
    const CobranzaEstado = "CP_DocRecibo.CobranzaEstado";
    const FlujoEstado = "CP_DocRecibo.FlujoEstado";
    const Estado = "CP_DocRecibo.Estado";
    const FechaCreacion = "CP_DocRecibo.FechaCreacion";
    const UsuarioCreacion = "CP_DocRecibo.UsuarioCreacion";
    const FechaModificacion = "CP_DocRecibo.FechaModificacion";
    const UsuarioModificacion = "CP_DocRecibo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "CP_DocRecibo.IdDocRecibo AS IdDocRecibo, ";
        $s_SQLQuery .= "CP_DocRecibo.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "CP_DocRecibo.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "CP_DocRecibo.ParentId AS ParentId, ";
        $s_SQLQuery .= "CP_DocRecibo.ParentCod AS ParentCod, ";
        $s_SQLQuery .= "CP_DocRecibo.IdTipoPago AS IdTipoPago, ";
        $s_SQLQuery .= "CP_DocRecibo.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "CP_DocRecibo.MonedaDes AS MonedaDes, ";
        $s_SQLQuery .= "CP_DocRecibo.ReciboNumero AS ReciboNumero, ";
        $s_SQLQuery .= "CP_DocRecibo.ReciboFecha AS ReciboFecha, ";
        $s_SQLQuery .= "CP_DocRecibo.IdBanco AS IdBanco, ";
        $s_SQLQuery .= "CP_DocRecibo.IdCuenta AS IdCuenta, ";
        $s_SQLQuery .= "CP_DocRecibo.NumeroCuenta AS NumeroCuenta, ";
        $s_SQLQuery .= "CP_DocRecibo.TerminoPago AS TerminoPago, ";
        $s_SQLQuery .= "CP_DocRecibo.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "CP_DocRecibo.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "CP_DocRecibo.ClaseNombre AS ClaseNombre, ";
        $s_SQLQuery .= "CP_DocRecibo.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "CP_DocRecibo.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "CP_DocRecibo.TipoDocCliente AS TipoDocCliente, ";
        $s_SQLQuery .= "CP_DocRecibo.NumTipoDocCliente AS NumTipoDocCliente, ";
        $s_SQLQuery .= "CP_DocRecibo.NombreCliente AS NombreCliente, ";
        $s_SQLQuery .= "CP_DocRecibo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "CP_DocRecibo.Monto AS Monto, ";
        $s_SQLQuery .= "CP_DocRecibo.Saldo AS Saldo, ";
        $s_SQLQuery .= "CP_DocRecibo.MontoMN AS MontoMN, ";
        $s_SQLQuery .= "CP_DocRecibo.SaldoMN AS SaldoMN, ";
        $s_SQLQuery .= "CP_DocRecibo.MontoME AS MontoME, ";
        $s_SQLQuery .= "CP_DocRecibo.SaldoME AS SaldoME, ";
        $s_SQLQuery .= "CP_DocRecibo.FechaAprobacion AS FechaAprobacion, ";
        $s_SQLQuery .= "CP_DocRecibo.ApruebaUsuario AS ApruebaUsuario, ";
        $s_SQLQuery .= "CP_DocRecibo.FechaCobranza AS FechaCobranza, ";
        $s_SQLQuery .= "CP_DocRecibo.CobranzaEstado AS CobranzaEstado, ";
        $s_SQLQuery .= "CP_DocRecibo.FlujoEstado AS FlujoEstado, ";
        $s_SQLQuery .= "CP_DocRecibo.Estado AS Estado, ";
        $s_SQLQuery .= "CP_DocRecibo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "CP_DocRecibo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "CP_DocRecibo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "CP_DocRecibo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto CP_DocReciboBN */
    public function setByBN( CP_DocReciboBN $o_CP_DocReciboBN )
    {
        if ( !is_null( $o_CP_DocReciboBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_CP_DocReciboBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_CP_DocReciboBN->getIdCompania() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_CP_DocReciboBN->getIdSucursal() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getParentId() ) )
        {
            $this->setParentId( $o_CP_DocReciboBN->getParentId() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getParentCod() ) )
        {
            $this->setParentCod( $o_CP_DocReciboBN->getParentCod() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_CP_DocReciboBN->getIdTipoPago() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_CP_DocReciboBN->getIdMoneda() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_CP_DocReciboBN->getMonedaDes() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getReciboNumero() ) )
        {
            $this->setReciboNumero( $o_CP_DocReciboBN->getReciboNumero() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getReciboFecha() ) )
        {
            $this->setReciboFecha( $o_CP_DocReciboBN->getReciboFecha() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_CP_DocReciboBN->getIdBanco() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdCuenta() ) )
        {
            $this->setIdCuenta( $o_CP_DocReciboBN->getIdCuenta() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getNumeroCuenta() ) )
        {
            $this->setNumeroCuenta( $o_CP_DocReciboBN->getNumeroCuenta() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getTerminoPago() ) )
        {
            $this->setTerminoPago( $o_CP_DocReciboBN->getTerminoPago() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_CP_DocReciboBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_CP_DocReciboBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getClaseNombre() ) )
        {
            $this->setClaseNombre( $o_CP_DocReciboBN->getClaseNombre() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_CP_DocReciboBN->getTipoCambio() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_CP_DocReciboBN->getIdPersona() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getTipoDocCliente() ) )
        {
            $this->setTipoDocCliente( $o_CP_DocReciboBN->getTipoDocCliente() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getNumTipoDocCliente() ) )
        {
            $this->setNumTipoDocCliente( $o_CP_DocReciboBN->getNumTipoDocCliente() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getNombreCliente() ) )
        {
            $this->setNombreCliente( $o_CP_DocReciboBN->getNombreCliente() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_DocReciboBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getMonto() ) )
        {
            $this->setMonto( $o_CP_DocReciboBN->getMonto() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getSaldo() ) )
        {
            $this->setSaldo( $o_CP_DocReciboBN->getSaldo() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getMontoMN() ) )
        {
            $this->setMontoMN( $o_CP_DocReciboBN->getMontoMN() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getSaldoMN() ) )
        {
            $this->setSaldoMN( $o_CP_DocReciboBN->getSaldoMN() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getMontoME() ) )
        {
            $this->setMontoME( $o_CP_DocReciboBN->getMontoME() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getSaldoME() ) )
        {
            $this->setSaldoME( $o_CP_DocReciboBN->getSaldoME() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFechaAprobacion() ) )
        {
            $this->setFechaAprobacion( $o_CP_DocReciboBN->getFechaAprobacion() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getApruebaUsuario() ) )
        {
            $this->setApruebaUsuario( $o_CP_DocReciboBN->getApruebaUsuario() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFechaCobranza() ) )
        {
            $this->setFechaCobranza( $o_CP_DocReciboBN->getFechaCobranza() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getCobranzaEstado() ) )
        {
            $this->setCobranzaEstado( $o_CP_DocReciboBN->getCobranzaEstado() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFlujoEstado() ) )
        {
            $this->setFlujoEstado( $o_CP_DocReciboBN->getFlujoEstado() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_DocReciboBN->getEstado() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_DocReciboBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_DocReciboBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_DocReciboBN->getFechaModificacion() );
        }
        if ( !is_null( $o_CP_DocReciboBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_DocReciboBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return CP_DocReciboBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDocRecibo )
    {
        if( is_null( $i_IdDocRecibo ) ){ $i_IdDocRecibo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_DocRecibo ";
        $s_SQLQuery .= "WHERE IdDocRecibo = ".$i_IdDocRecibo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_CP_DocReciboBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_CP_DocReciboBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_CP_DocReciboBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDocRecibo() ) ) $s_SQLQuery .= "CP_DocRecibo.IdDocRecibo = ".$this->getIdDocRecibo()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "CP_DocRecibo.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "CP_DocRecibo.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getParentId() ) ) $s_SQLQuery .= "CP_DocRecibo.ParentId = ".$this->getParentId()." AND ";
        if ( !is_null( $this->getParentCod() ) ) $s_SQLQuery .= "CP_DocRecibo.ParentCod = '".$this->getParentCod()."' AND ";
        if ( !is_null( $this->getIdTipoPago() ) ) $s_SQLQuery .= "CP_DocRecibo.IdTipoPago = ".$this->getIdTipoPago()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "CP_DocRecibo.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getMonedaDes() ) ) $s_SQLQuery .= "CP_DocRecibo.MonedaDes = '".$this->getMonedaDes()."' AND ";
        if ( !is_null( $this->getReciboNumero() ) ) $s_SQLQuery .= "CP_DocRecibo.ReciboNumero = '".$this->getReciboNumero()."' AND ";
        if ( !is_null( $this->getReciboFecha() ) ) $s_SQLQuery .= "CP_DocRecibo.ReciboFecha = '".$this->getReciboFecha()."' AND ";
        if ( !is_null( $this->getIdBanco() ) ) $s_SQLQuery .= "CP_DocRecibo.IdBanco = ".$this->getIdBanco()." AND ";
        if ( !is_null( $this->getIdCuenta() ) ) $s_SQLQuery .= "CP_DocRecibo.IdCuenta = ".$this->getIdCuenta()." AND ";
        if ( !is_null( $this->getNumeroCuenta() ) ) $s_SQLQuery .= "CP_DocRecibo.NumeroCuenta = '".$this->getNumeroCuenta()."' AND ";
        if ( !is_null( $this->getTerminoPago() ) ) $s_SQLQuery .= "CP_DocRecibo.TerminoPago = ".$this->getTerminoPago()." AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "CP_DocRecibo.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "CP_DocRecibo.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getClaseNombre() ) ) $s_SQLQuery .= "CP_DocRecibo.ClaseNombre = '".$this->getClaseNombre()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "CP_DocRecibo.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "CP_DocRecibo.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getTipoDocCliente() ) ) $s_SQLQuery .= "CP_DocRecibo.TipoDocCliente = '".$this->getTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNumTipoDocCliente() ) ) $s_SQLQuery .= "CP_DocRecibo.NumTipoDocCliente = '".$this->getNumTipoDocCliente()."' AND ";
        if ( !is_null( $this->getNombreCliente() ) ) $s_SQLQuery .= "CP_DocRecibo.NombreCliente = '".$this->getNombreCliente()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "CP_DocRecibo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getMonto() ) ) $s_SQLQuery .= "CP_DocRecibo.Monto = ".$this->getMonto()." AND ";
        if ( !is_null( $this->getSaldo() ) ) $s_SQLQuery .= "CP_DocRecibo.Saldo = ".$this->getSaldo()." AND ";
        if ( !is_null( $this->getMontoMN() ) ) $s_SQLQuery .= "CP_DocRecibo.MontoMN = ".$this->getMontoMN()." AND ";
        if ( !is_null( $this->getSaldoMN() ) ) $s_SQLQuery .= "CP_DocRecibo.SaldoMN = ".$this->getSaldoMN()." AND ";
        if ( !is_null( $this->getMontoME() ) ) $s_SQLQuery .= "CP_DocRecibo.MontoME = ".$this->getMontoME()." AND ";
        if ( !is_null( $this->getSaldoME() ) ) $s_SQLQuery .= "CP_DocRecibo.SaldoME = ".$this->getSaldoME()." AND ";
        if ( !is_null( $this->getFechaAprobacion() ) ) $s_SQLQuery .= "CP_DocRecibo.FechaAprobacion = '".$this->getFechaAprobacion()."' AND ";
        if ( !is_null( $this->getApruebaUsuario() ) ) $s_SQLQuery .= "CP_DocRecibo.ApruebaUsuario = '".$this->getApruebaUsuario()."' AND ";
        if ( !is_null( $this->getFechaCobranza() ) ) $s_SQLQuery .= "CP_DocRecibo.FechaCobranza = '".$this->getFechaCobranza()."' AND ";
        if ( !is_null( $this->getCobranzaEstado() ) ) $s_SQLQuery .= "CP_DocRecibo.CobranzaEstado = '".$this->getCobranzaEstado()."' AND ";
        if ( !is_null( $this->getFlujoEstado() ) ) $s_SQLQuery .= "CP_DocRecibo.FlujoEstado = '".$this->getFlujoEstado()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "CP_DocRecibo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "CP_DocRecibo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "CP_DocRecibo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "CP_DocRecibo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "CP_DocRecibo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM CP_DocRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return CP_DocReciboBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM CP_DocRecibo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_CP_DocReciboBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_CP_DocReciboBN = $this->insertObjectBN( $a_SQLRow );
                $a_CP_DocReciboBN[] = $o_CP_DocReciboBN;
            }
        }
        return $a_CP_DocReciboBN;
    }

    /* Devuelve un objeto CP_DocReciboBN desde un objeto propel */
    public function insertObjectBN( $a_CP_DocRecibo )
    {
        $o_CP_DocReciboBN = new CP_DocReciboBN();
        if ( !is_null( $a_CP_DocRecibo['IdDocRecibo'] ) ) $o_CP_DocReciboBN->setIdDocRecibo( ( integer ) $a_CP_DocRecibo['IdDocRecibo'] );
        if ( !is_null( $a_CP_DocRecibo['IdCompania'] ) ) $o_CP_DocReciboBN->setIdCompania( ( integer ) $a_CP_DocRecibo['IdCompania'] );
        if ( !is_null( $a_CP_DocRecibo['IdSucursal'] ) ) $o_CP_DocReciboBN->setIdSucursal( ( integer ) $a_CP_DocRecibo['IdSucursal'] );
        if ( !is_null( $a_CP_DocRecibo['ParentId'] ) ) $o_CP_DocReciboBN->setParentId( ( integer ) $a_CP_DocRecibo['ParentId'] );
        if ( !is_null( $a_CP_DocRecibo['ParentCod'] ) ) $o_CP_DocReciboBN->setParentCod( $a_CP_DocRecibo['ParentCod'] );
        if ( !is_null( $a_CP_DocRecibo['IdTipoPago'] ) ) $o_CP_DocReciboBN->setIdTipoPago( ( integer ) $a_CP_DocRecibo['IdTipoPago'] );
        if ( !is_null( $a_CP_DocRecibo['IdMoneda'] ) ) $o_CP_DocReciboBN->setIdMoneda( $a_CP_DocRecibo['IdMoneda'] );
        if ( !is_null( $a_CP_DocRecibo['MonedaDes'] ) ) $o_CP_DocReciboBN->setMonedaDes( $a_CP_DocRecibo['MonedaDes'] );
        if ( !is_null( $a_CP_DocRecibo['ReciboNumero'] ) ) $o_CP_DocReciboBN->setReciboNumero( $a_CP_DocRecibo['ReciboNumero'] );
        if ( !is_null( $a_CP_DocRecibo['ReciboFecha'] ) ) $o_CP_DocReciboBN->setReciboFecha( utilTimestamp::getTimestamp( $a_CP_DocRecibo['ReciboFecha'], "Y-m-d" ) );
        if ( !is_null( $a_CP_DocRecibo['IdBanco'] ) ) $o_CP_DocReciboBN->setIdBanco( ( integer ) $a_CP_DocRecibo['IdBanco'] );
        if ( !is_null( $a_CP_DocRecibo['IdCuenta'] ) ) $o_CP_DocReciboBN->setIdCuenta( ( integer ) $a_CP_DocRecibo['IdCuenta'] );
        if ( !is_null( $a_CP_DocRecibo['NumeroCuenta'] ) ) $o_CP_DocReciboBN->setNumeroCuenta( $a_CP_DocRecibo['NumeroCuenta'] );
        if ( !is_null( $a_CP_DocRecibo['TerminoPago'] ) ) $o_CP_DocReciboBN->setTerminoPago( ( integer ) $a_CP_DocRecibo['TerminoPago'] );
        if ( !is_null( $a_CP_DocRecibo['FechaVencimiento'] ) ) $o_CP_DocReciboBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_CP_DocRecibo['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_CP_DocRecibo['IdNumeroDocumento'] ) ) $o_CP_DocReciboBN->setIdNumeroDocumento( $a_CP_DocRecibo['IdNumeroDocumento'] );
        if ( !is_null( $a_CP_DocRecibo['ClaseNombre'] ) ) $o_CP_DocReciboBN->setClaseNombre( $a_CP_DocRecibo['ClaseNombre'] );
        if ( !is_null( $a_CP_DocRecibo['TipoCambio'] ) ) $o_CP_DocReciboBN->setTipoCambio( ( float ) $a_CP_DocRecibo['TipoCambio'] );
        if ( !is_null( $a_CP_DocRecibo['IdPersona'] ) ) $o_CP_DocReciboBN->setIdPersona( ( integer ) $a_CP_DocRecibo['IdPersona'] );
        if ( !is_null( $a_CP_DocRecibo['TipoDocCliente'] ) ) $o_CP_DocReciboBN->setTipoDocCliente( $a_CP_DocRecibo['TipoDocCliente'] );
        if ( !is_null( $a_CP_DocRecibo['NumTipoDocCliente'] ) ) $o_CP_DocReciboBN->setNumTipoDocCliente( $a_CP_DocRecibo['NumTipoDocCliente'] );
        if ( !is_null( $a_CP_DocRecibo['NombreCliente'] ) ) $o_CP_DocReciboBN->setNombreCliente( $a_CP_DocRecibo['NombreCliente'] );
        if ( !is_null( $a_CP_DocRecibo['Descripcion'] ) ) $o_CP_DocReciboBN->setDescripcion( $a_CP_DocRecibo['Descripcion'] );
        if ( !is_null( $a_CP_DocRecibo['Monto'] ) ) $o_CP_DocReciboBN->setMonto( ( float ) $a_CP_DocRecibo['Monto'] );
        if ( !is_null( $a_CP_DocRecibo['Saldo'] ) ) $o_CP_DocReciboBN->setSaldo( ( float ) $a_CP_DocRecibo['Saldo'] );
        if ( !is_null( $a_CP_DocRecibo['MontoMN'] ) ) $o_CP_DocReciboBN->setMontoMN( ( float ) $a_CP_DocRecibo['MontoMN'] );
        if ( !is_null( $a_CP_DocRecibo['SaldoMN'] ) ) $o_CP_DocReciboBN->setSaldoMN( ( float ) $a_CP_DocRecibo['SaldoMN'] );
        if ( !is_null( $a_CP_DocRecibo['MontoME'] ) ) $o_CP_DocReciboBN->setMontoME( ( float ) $a_CP_DocRecibo['MontoME'] );
        if ( !is_null( $a_CP_DocRecibo['SaldoME'] ) ) $o_CP_DocReciboBN->setSaldoME( ( float ) $a_CP_DocRecibo['SaldoME'] );
        if ( !is_null( $a_CP_DocRecibo['FechaAprobacion'] ) ) $o_CP_DocReciboBN->setFechaAprobacion( utilTimestamp::getTimestamp( $a_CP_DocRecibo['FechaAprobacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_DocRecibo['ApruebaUsuario'] ) ) $o_CP_DocReciboBN->setApruebaUsuario( $a_CP_DocRecibo['ApruebaUsuario'] );
        if ( !is_null( $a_CP_DocRecibo['FechaCobranza'] ) ) $o_CP_DocReciboBN->setFechaCobranza( utilTimestamp::getTimestamp( $a_CP_DocRecibo['FechaCobranza'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_DocRecibo['CobranzaEstado'] ) ) $o_CP_DocReciboBN->setCobranzaEstado( $a_CP_DocRecibo['CobranzaEstado'] );
        if ( !is_null( $a_CP_DocRecibo['FlujoEstado'] ) ) $o_CP_DocReciboBN->setFlujoEstado( $a_CP_DocRecibo['FlujoEstado'] );
        if ( !is_null( $a_CP_DocRecibo['Estado'] ) ) $o_CP_DocReciboBN->setEstado( $a_CP_DocRecibo['Estado'] );
        if ( !is_null( $a_CP_DocRecibo['FechaCreacion'] ) ) $o_CP_DocReciboBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_CP_DocRecibo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_DocRecibo['UsuarioCreacion'] ) ) $o_CP_DocReciboBN->setUsuarioCreacion( $a_CP_DocRecibo['UsuarioCreacion'] );
        if ( !is_null( $a_CP_DocRecibo['FechaModificacion'] ) ) $o_CP_DocReciboBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_CP_DocRecibo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_CP_DocRecibo['UsuarioModificacion'] ) ) $o_CP_DocReciboBN->setUsuarioModificacion( $a_CP_DocRecibo['UsuarioModificacion'] );
        return $o_CP_DocReciboBN;
    }
}
?>