<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_OrdenCompraDetalle.xml */
/* Generado: 2021-08-14 08:48:00 */

/* Busqueda de registros de la tabla COM_OrdenCompraDetalle. */
abstract class BaseCOM_OrdenCompraDetalleFN extends COM_OrdenCompraDetalleBN
{
    /* Declaracion de constantes */
    const IdOrdenCompra = "COM_OrdenCompraDetalle.IdOrdenCompra";
    const IdCompania = "COM_OrdenCompraDetalle.IdCompania";
    const IdSecuencia = "COM_OrdenCompraDetalle.IdSecuencia";
    const IdItem = "COM_OrdenCompraDetalle.IdItem";
    const Descripcion = "COM_OrdenCompraDetalle.Descripcion";
    const CantidadPedida = "COM_OrdenCompraDetalle.CantidadPedida";
    const CantidadRecibida = "COM_OrdenCompraDetalle.CantidadRecibida";
    const MuestraUni = "COM_OrdenCompraDetalle.MuestraUni";
    const MuestraKgr = "COM_OrdenCompraDetalle.MuestraKgr";
    const IdUnidad = "COM_OrdenCompraDetalle.IdUnidad";
    const IdCondicion = "COM_OrdenCompraDetalle.IdCondicion";
    const IdLote = "COM_OrdenCompraDetalle.IdLote";
    const FechaVencimiento = "COM_OrdenCompraDetalle.FechaVencimiento";
    const PrecioUnitarioInicial = "COM_OrdenCompraDetalle.PrecioUnitarioInicial";
    const PrecioUnitario = "COM_OrdenCompraDetalle.PrecioUnitario";
    const PrecioUnitarioFinal = "COM_OrdenCompraDetalle.PrecioUnitarioFinal";
    const SubTotal = "COM_OrdenCompraDetalle.SubTotal";
    const ValorIGV = "COM_OrdenCompraDetalle.ValorIGV";
    const PrecioTotalConIGV = "COM_OrdenCompraDetalle.PrecioTotalConIGV";
    const IGVExonerado = "COM_OrdenCompraDetalle.IGVExonerado";
    const Estado = "COM_OrdenCompraDetalle.Estado";
    const Comentario = "COM_OrdenCompraDetalle.Comentario";
    const Descuento = "COM_OrdenCompraDetalle.Descuento";
    const PrecioUnitarioIGV = "COM_OrdenCompraDetalle.PrecioUnitarioIGV";
    const CostoFinalDolares = "COM_OrdenCompraDetalle.CostoFinalDolares";
    const CostoFinalSoles = "COM_OrdenCompraDetalle.CostoFinalSoles";
    const IdRequerimientoDetalle = "COM_OrdenCompraDetalle.IdRequerimientoDetalle";
    const FechaCreacion = "COM_OrdenCompraDetalle.FechaCreacion";
    const UsuarioCreacion = "COM_OrdenCompraDetalle.UsuarioCreacion";
    const FechaModificacion = "COM_OrdenCompraDetalle.FechaModificacion";
    const UsuarioModificacion = "COM_OrdenCompraDetalle.UsuarioModificacion";
    const FechaEntrega = "COM_OrdenCompraDetalle.FechaEntrega";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "COM_OrdenCompraDetalle.IdOrdenCompra AS IdOrdenCompra, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.CantidadPedida AS CantidadPedida, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.CantidadRecibida AS CantidadRecibida, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.MuestraUni AS MuestraUni, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.MuestraKgr AS MuestraKgr, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdLote AS IdLote, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioInicial AS PrecioUnitarioInicial, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioFinal AS PrecioUnitarioFinal, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.SubTotal AS SubTotal, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.ValorIGV AS ValorIGV, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioTotalConIGV AS PrecioTotalConIGV, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IGVExonerado AS IGVExonerado, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.Comentario AS Comentario, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.Descuento AS Descuento, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioIGV AS PrecioUnitarioIGV, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.CostoFinalDolares AS CostoFinalDolares, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.CostoFinalSoles AS CostoFinalSoles, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.IdRequerimientoDetalle AS IdRequerimientoDetalle, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaEntrega AS FechaEntrega ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto COM_OrdenCompraDetalleBN */
    public function setByBN( COM_OrdenCompraDetalleBN $o_COM_OrdenCompraDetalleBN )
    {
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdOrdenCompra() ) )
        {
            $this->setIdOrdenCompra( $o_COM_OrdenCompraDetalleBN->getIdOrdenCompra() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_COM_OrdenCompraDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_COM_OrdenCompraDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_COM_OrdenCompraDetalleBN->getDescripcion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getCantidadPedida() ) )
        {
            $this->setCantidadPedida( $o_COM_OrdenCompraDetalleBN->getCantidadPedida() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getCantidadRecibida() ) )
        {
            $this->setCantidadRecibida( $o_COM_OrdenCompraDetalleBN->getCantidadRecibida() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getMuestraUni() ) )
        {
            $this->setMuestraUni( $o_COM_OrdenCompraDetalleBN->getMuestraUni() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getMuestraKgr() ) )
        {
            $this->setMuestraKgr( $o_COM_OrdenCompraDetalleBN->getMuestraKgr() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_COM_OrdenCompraDetalleBN->getIdUnidad() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_COM_OrdenCompraDetalleBN->getIdCondicion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdLote() ) )
        {
            $this->setIdLote( $o_COM_OrdenCompraDetalleBN->getIdLote() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_COM_OrdenCompraDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioInicial() ) )
        {
            $this->setPrecioUnitarioInicial( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioInicial() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_COM_OrdenCompraDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioFinal() ) )
        {
            $this->setPrecioUnitarioFinal( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioFinal() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getSubTotal() ) )
        {
            $this->setSubTotal( $o_COM_OrdenCompraDetalleBN->getSubTotal() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getValorIGV() ) )
        {
            $this->setValorIGV( $o_COM_OrdenCompraDetalleBN->getValorIGV() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getPrecioTotalConIGV() ) )
        {
            $this->setPrecioTotalConIGV( $o_COM_OrdenCompraDetalleBN->getPrecioTotalConIGV() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIGVExonerado() ) )
        {
            $this->setIGVExonerado( $o_COM_OrdenCompraDetalleBN->getIGVExonerado() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_COM_OrdenCompraDetalleBN->getEstado() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getComentario() ) )
        {
            $this->setComentario( $o_COM_OrdenCompraDetalleBN->getComentario() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getDescuento() ) )
        {
            $this->setDescuento( $o_COM_OrdenCompraDetalleBN->getDescuento() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioIGV() ) )
        {
            $this->setPrecioUnitarioIGV( $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioIGV() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getCostoFinalDolares() ) )
        {
            $this->setCostoFinalDolares( $o_COM_OrdenCompraDetalleBN->getCostoFinalDolares() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getCostoFinalSoles() ) )
        {
            $this->setCostoFinalSoles( $o_COM_OrdenCompraDetalleBN->getCostoFinalSoles() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getIdRequerimientoDetalle() ) )
        {
            $this->setIdRequerimientoDetalle( $o_COM_OrdenCompraDetalleBN->getIdRequerimientoDetalle() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_COM_OrdenCompraDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_COM_OrdenCompraDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_COM_OrdenCompraDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_COM_OrdenCompraDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraDetalleBN->getFechaEntrega() ) )
        {
            $this->setFechaEntrega( $o_COM_OrdenCompraDetalleBN->getFechaEntrega() );
        }
    }

    /**
    * @return COM_OrdenCompraDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdOrdenCompra, $i_IdCompania, $i_IdSecuencia )
    {
        if( is_null( $i_IdOrdenCompra ) ){ $i_IdOrdenCompra = -1; } 
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_OrdenCompraDetalle ";
        $s_SQLQuery .= "WHERE IdOrdenCompra = ".$i_IdOrdenCompra." ";
        $s_SQLQuery .= "AND IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_COM_OrdenCompraDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_COM_OrdenCompraDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_COM_OrdenCompraDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOrdenCompra() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdOrdenCompra = ".$this->getIdOrdenCompra()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantidadPedida() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.CantidadPedida = ".$this->getCantidadPedida()." AND ";
        if ( !is_null( $this->getCantidadRecibida() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.CantidadRecibida = ".$this->getCantidadRecibida()." AND ";
        if ( !is_null( $this->getMuestraUni() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.MuestraUni = ".$this->getMuestraUni()." AND ";
        if ( !is_null( $this->getMuestraKgr() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.MuestraKgr = ".$this->getMuestraKgr()." AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdUnidad = '".$this->getIdUnidad()."' AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdCondicion = ".$this->getIdCondicion()." AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getPrecioUnitarioInicial() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioInicial = ".$this->getPrecioUnitarioInicial()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getPrecioUnitarioFinal() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioFinal = ".$this->getPrecioUnitarioFinal()." AND ";
        if ( !is_null( $this->getSubTotal() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.SubTotal = ".$this->getSubTotal()." AND ";
        if ( !is_null( $this->getValorIGV() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.ValorIGV = ".$this->getValorIGV()." AND ";
        if ( !is_null( $this->getPrecioTotalConIGV() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioTotalConIGV = ".$this->getPrecioTotalConIGV()." AND ";
        if ( !is_null( $this->getIGVExonerado() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IGVExonerado = '".$this->getIGVExonerado()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getDescuento() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.Descuento = ".$this->getDescuento()." AND ";
        if ( !is_null( $this->getPrecioUnitarioIGV() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.PrecioUnitarioIGV = ".$this->getPrecioUnitarioIGV()." AND ";
        if ( !is_null( $this->getCostoFinalDolares() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.CostoFinalDolares = ".$this->getCostoFinalDolares()." AND ";
        if ( !is_null( $this->getCostoFinalSoles() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.CostoFinalSoles = ".$this->getCostoFinalSoles()." AND ";
        if ( !is_null( $this->getIdRequerimientoDetalle() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.IdRequerimientoDetalle = ".$this->getIdRequerimientoDetalle()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaEntrega() ) ) $s_SQLQuery .= "COM_OrdenCompraDetalle.FechaEntrega = '".$this->getFechaEntrega()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM COM_OrdenCompraDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return COM_OrdenCompraDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_OrdenCompraDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_COM_OrdenCompraDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_COM_OrdenCompraDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_COM_OrdenCompraDetalleBN[] = $o_COM_OrdenCompraDetalleBN;
            }
        }
        return $a_COM_OrdenCompraDetalleBN;
    }

    /* Devuelve un objeto COM_OrdenCompraDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_COM_OrdenCompraDetalle )
    {
        $o_COM_OrdenCompraDetalleBN = new COM_OrdenCompraDetalleBN();
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdOrdenCompra'] ) ) $o_COM_OrdenCompraDetalleBN->setIdOrdenCompra( ( integer ) $a_COM_OrdenCompraDetalle['IdOrdenCompra'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdCompania'] ) ) $o_COM_OrdenCompraDetalleBN->setIdCompania( ( integer ) $a_COM_OrdenCompraDetalle['IdCompania'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdSecuencia'] ) ) $o_COM_OrdenCompraDetalleBN->setIdSecuencia( ( integer ) $a_COM_OrdenCompraDetalle['IdSecuencia'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdItem'] ) ) $o_COM_OrdenCompraDetalleBN->setIdItem( $a_COM_OrdenCompraDetalle['IdItem'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['Descripcion'] ) ) $o_COM_OrdenCompraDetalleBN->setDescripcion( $a_COM_OrdenCompraDetalle['Descripcion'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['CantidadPedida'] ) ) $o_COM_OrdenCompraDetalleBN->setCantidadPedida( ( float ) $a_COM_OrdenCompraDetalle['CantidadPedida'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['CantidadRecibida'] ) ) $o_COM_OrdenCompraDetalleBN->setCantidadRecibida( ( float ) $a_COM_OrdenCompraDetalle['CantidadRecibida'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['MuestraUni'] ) ) $o_COM_OrdenCompraDetalleBN->setMuestraUni( ( float ) $a_COM_OrdenCompraDetalle['MuestraUni'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['MuestraKgr'] ) ) $o_COM_OrdenCompraDetalleBN->setMuestraKgr( ( float ) $a_COM_OrdenCompraDetalle['MuestraKgr'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdUnidad'] ) ) $o_COM_OrdenCompraDetalleBN->setIdUnidad( $a_COM_OrdenCompraDetalle['IdUnidad'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdCondicion'] ) ) $o_COM_OrdenCompraDetalleBN->setIdCondicion( ( integer ) $a_COM_OrdenCompraDetalle['IdCondicion'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdLote'] ) ) $o_COM_OrdenCompraDetalleBN->setIdLote( $a_COM_OrdenCompraDetalle['IdLote'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['FechaVencimiento'] ) ) $o_COM_OrdenCompraDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_COM_OrdenCompraDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_COM_OrdenCompraDetalle['PrecioUnitarioInicial'] ) ) $o_COM_OrdenCompraDetalleBN->setPrecioUnitarioInicial( ( float ) $a_COM_OrdenCompraDetalle['PrecioUnitarioInicial'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['PrecioUnitario'] ) ) $o_COM_OrdenCompraDetalleBN->setPrecioUnitario( ( float ) $a_COM_OrdenCompraDetalle['PrecioUnitario'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['PrecioUnitarioFinal'] ) ) $o_COM_OrdenCompraDetalleBN->setPrecioUnitarioFinal( ( float ) $a_COM_OrdenCompraDetalle['PrecioUnitarioFinal'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['SubTotal'] ) ) $o_COM_OrdenCompraDetalleBN->setSubTotal( ( float ) $a_COM_OrdenCompraDetalle['SubTotal'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['ValorIGV'] ) ) $o_COM_OrdenCompraDetalleBN->setValorIGV( ( float ) $a_COM_OrdenCompraDetalle['ValorIGV'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['PrecioTotalConIGV'] ) ) $o_COM_OrdenCompraDetalleBN->setPrecioTotalConIGV( ( float ) $a_COM_OrdenCompraDetalle['PrecioTotalConIGV'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IGVExonerado'] ) ) $o_COM_OrdenCompraDetalleBN->setIGVExonerado( $a_COM_OrdenCompraDetalle['IGVExonerado'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['Estado'] ) ) $o_COM_OrdenCompraDetalleBN->setEstado( $a_COM_OrdenCompraDetalle['Estado'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['Comentario'] ) ) $o_COM_OrdenCompraDetalleBN->setComentario( $a_COM_OrdenCompraDetalle['Comentario'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['Descuento'] ) ) $o_COM_OrdenCompraDetalleBN->setDescuento( ( float ) $a_COM_OrdenCompraDetalle['Descuento'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['PrecioUnitarioIGV'] ) ) $o_COM_OrdenCompraDetalleBN->setPrecioUnitarioIGV( ( float ) $a_COM_OrdenCompraDetalle['PrecioUnitarioIGV'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['CostoFinalDolares'] ) ) $o_COM_OrdenCompraDetalleBN->setCostoFinalDolares( ( float ) $a_COM_OrdenCompraDetalle['CostoFinalDolares'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['CostoFinalSoles'] ) ) $o_COM_OrdenCompraDetalleBN->setCostoFinalSoles( ( float ) $a_COM_OrdenCompraDetalle['CostoFinalSoles'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['IdRequerimientoDetalle'] ) ) $o_COM_OrdenCompraDetalleBN->setIdRequerimientoDetalle( ( integer ) $a_COM_OrdenCompraDetalle['IdRequerimientoDetalle'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['FechaCreacion'] ) ) $o_COM_OrdenCompraDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraDetalle['UsuarioCreacion'] ) ) $o_COM_OrdenCompraDetalleBN->setUsuarioCreacion( $a_COM_OrdenCompraDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['FechaModificacion'] ) ) $o_COM_OrdenCompraDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraDetalle['UsuarioModificacion'] ) ) $o_COM_OrdenCompraDetalleBN->setUsuarioModificacion( $a_COM_OrdenCompraDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_COM_OrdenCompraDetalle['FechaEntrega'] ) ) $o_COM_OrdenCompraDetalleBN->setFechaEntrega( utilTimestamp::getTimestamp( $a_COM_OrdenCompraDetalle['FechaEntrega'], "Y-m-d H:i:s" ) );
        return $o_COM_OrdenCompraDetalleBN;
    }
}
?>