<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_OrdenCompraCabecera.xml */
/* Generado: 2021-08-03 03:19:01 */

/* Busqueda de registros de la tabla COM_OrdenCompraCabecera. */
abstract class BaseCOM_OrdenCompraCabeceraFN extends COM_OrdenCompraCabeceraBN
{
    /* Declaracion de constantes */
    const IdCompania = "COM_OrdenCompraCabecera.IdCompania";
    const IdSucursal = "COM_OrdenCompraCabecera.IdSucursal";
    const IdOrdenCompra = "COM_OrdenCompraCabecera.IdOrdenCompra";
    const TipoOrden = "COM_OrdenCompraCabecera.TipoOrden";
    const IdProyecto = "COM_OrdenCompraCabecera.IdProyecto";
    const ProyectoNombre = "COM_OrdenCompraCabecera.ProyectoNombre";
    const IdProveedor = "COM_OrdenCompraCabecera.IdProveedor";
    const NombreProveedor = "COM_OrdenCompraCabecera.NombreProveedor";
    const NumeroInterno = "COM_OrdenCompraCabecera.NumeroInterno";
    const IdOrdenClasificacion = "COM_OrdenCompraCabecera.IdOrdenClasificacion";
    const IdMoneda = "COM_OrdenCompraCabecera.IdMoneda";
    const IdMonedaPago = "COM_OrdenCompraCabecera.IdMonedaPago";
    const TerminoId = "COM_OrdenCompraCabecera.TerminoId";
    const Descripcion = "COM_OrdenCompraCabecera.Descripcion";
    const Observacion = "COM_OrdenCompraCabecera.Observacion";
    const ObservacionEntrega = "COM_OrdenCompraCabecera.ObservacionEntrega";
    const ObservacionRechazo = "COM_OrdenCompraCabecera.ObservacionRechazo";
    const AfectoIGV = "COM_OrdenCompraCabecera.AfectoIGV";
    const MontoAfecto = "COM_OrdenCompraCabecera.MontoAfecto";
    const MontoNoAfecto = "COM_OrdenCompraCabecera.MontoNoAfecto";
    const MontoIGV = "COM_OrdenCompraCabecera.MontoIGV";
    const MontoBruto = "COM_OrdenCompraCabecera.MontoBruto";
    const MontoPendientePago = "COM_OrdenCompraCabecera.MontoPendientePago";
    const Estado = "COM_OrdenCompraCabecera.Estado";
    const TipoCambio = "COM_OrdenCompraCabecera.TipoCambio";
    const FechaCreacion = "COM_OrdenCompraCabecera.FechaCreacion";
    const UsuarioCreacion = "COM_OrdenCompraCabecera.UsuarioCreacion";
    const FechaModificacion = "COM_OrdenCompraCabecera.FechaModificacion";
    const UsuarioModificacion = "COM_OrdenCompraCabecera.UsuarioModificacion";
    const IdAlmacenEntrega = "COM_OrdenCompraCabecera.IdAlmacenEntrega";
    const FechaEntrega = "COM_OrdenCompraCabecera.FechaEntrega";
    const IdAlmacenIngreso = "COM_OrdenCompraCabecera.IdAlmacenIngreso";
    const PreparadoPor = "COM_OrdenCompraCabecera.PreparadoPor";
    const FechaPreparacion = "COM_OrdenCompraCabecera.FechaPreparacion";
    const AprobadoPor = "COM_OrdenCompraCabecera.AprobadoPor";
    const FechaAprobacion = "COM_OrdenCompraCabecera.FechaAprobacion";
    const RevisadoPor = "COM_OrdenCompraCabecera.RevisadoPor";
    const FechaRevision = "COM_OrdenCompraCabecera.FechaRevision";
    const IdRequerimiento = "COM_OrdenCompraCabecera.IdRequerimiento";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "COM_OrdenCompraCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdOrdenCompra AS IdOrdenCompra, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.TipoOrden AS TipoOrden, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.ProyectoNombre AS ProyectoNombre, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdProveedor AS IdProveedor, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.NombreProveedor AS NombreProveedor, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.NumeroInterno AS NumeroInterno, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdOrdenClasificacion AS IdOrdenClasificacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdMonedaPago AS IdMonedaPago, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.TerminoId AS TerminoId, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.Observacion AS Observacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.ObservacionEntrega AS ObservacionEntrega, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.ObservacionRechazo AS ObservacionRechazo, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.AfectoIGV AS AfectoIGV, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoAfecto AS MontoAfecto, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoNoAfecto AS MontoNoAfecto, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoBruto AS MontoBruto, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoPendientePago AS MontoPendientePago, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.Estado AS Estado, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdAlmacenEntrega AS IdAlmacenEntrega, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaEntrega AS FechaEntrega, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdAlmacenIngreso AS IdAlmacenIngreso, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.PreparadoPor AS PreparadoPor, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaPreparacion AS FechaPreparacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.AprobadoPor AS AprobadoPor, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaAprobacion AS FechaAprobacion, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.RevisadoPor AS RevisadoPor, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaRevision AS FechaRevision, ";
        $s_SQLQuery .= "COM_OrdenCompraCabecera.IdRequerimiento AS IdRequerimiento ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto COM_OrdenCompraCabeceraBN */
    public function setByBN( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() ) )
        {
            $this->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getTipoOrden() ) )
        {
            $this->setTipoOrden( $o_COM_OrdenCompraCabeceraBN->getTipoOrden() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_COM_OrdenCompraCabeceraBN->getIdProyecto() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getProyectoNombre() ) )
        {
            $this->setProyectoNombre( $o_COM_OrdenCompraCabeceraBN->getProyectoNombre() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getNombreProveedor() ) )
        {
            $this->setNombreProveedor( $o_COM_OrdenCompraCabeceraBN->getNombreProveedor() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getNumeroInterno() ) )
        {
            $this->setNumeroInterno( $o_COM_OrdenCompraCabeceraBN->getNumeroInterno() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() ) )
        {
            $this->setIdOrdenClasificacion( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdMonedaPago() ) )
        {
            $this->setIdMonedaPago( $o_COM_OrdenCompraCabeceraBN->getIdMonedaPago() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getTerminoId() ) )
        {
            $this->setTerminoId( $o_COM_OrdenCompraCabeceraBN->getTerminoId() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_COM_OrdenCompraCabeceraBN->getDescripcion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getObservacion() ) )
        {
            $this->setObservacion( $o_COM_OrdenCompraCabeceraBN->getObservacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getObservacionEntrega() ) )
        {
            $this->setObservacionEntrega( $o_COM_OrdenCompraCabeceraBN->getObservacionEntrega() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getObservacionRechazo() ) )
        {
            $this->setObservacionRechazo( $o_COM_OrdenCompraCabeceraBN->getObservacionRechazo() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getAfectoIGV() ) )
        {
            $this->setAfectoIGV( $o_COM_OrdenCompraCabeceraBN->getAfectoIGV() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getMontoAfecto() ) )
        {
            $this->setMontoAfecto( $o_COM_OrdenCompraCabeceraBN->getMontoAfecto() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getMontoNoAfecto() ) )
        {
            $this->setMontoNoAfecto( $o_COM_OrdenCompraCabeceraBN->getMontoNoAfecto() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_COM_OrdenCompraCabeceraBN->getMontoIGV() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getMontoBruto() ) )
        {
            $this->setMontoBruto( $o_COM_OrdenCompraCabeceraBN->getMontoBruto() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getMontoPendientePago() ) )
        {
            $this->setMontoPendientePago( $o_COM_OrdenCompraCabeceraBN->getMontoPendientePago() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getEstado() ) )
        {
            $this->setEstado( $o_COM_OrdenCompraCabeceraBN->getEstado() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_COM_OrdenCompraCabeceraBN->getTipoCambio() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_COM_OrdenCompraCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_COM_OrdenCompraCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_COM_OrdenCompraCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_COM_OrdenCompraCabeceraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() ) )
        {
            $this->setIdAlmacenEntrega( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaEntrega() ) )
        {
            $this->setFechaEntrega( $o_COM_OrdenCompraCabeceraBN->getFechaEntrega() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenIngreso() ) )
        {
            $this->setIdAlmacenIngreso( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenIngreso() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getPreparadoPor() ) )
        {
            $this->setPreparadoPor( $o_COM_OrdenCompraCabeceraBN->getPreparadoPor() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaPreparacion() ) )
        {
            $this->setFechaPreparacion( $o_COM_OrdenCompraCabeceraBN->getFechaPreparacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getAprobadoPor() ) )
        {
            $this->setAprobadoPor( $o_COM_OrdenCompraCabeceraBN->getAprobadoPor() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaAprobacion() ) )
        {
            $this->setFechaAprobacion( $o_COM_OrdenCompraCabeceraBN->getFechaAprobacion() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getRevisadoPor() ) )
        {
            $this->setRevisadoPor( $o_COM_OrdenCompraCabeceraBN->getRevisadoPor() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getFechaRevision() ) )
        {
            $this->setFechaRevision( $o_COM_OrdenCompraCabeceraBN->getFechaRevision() );
        }
        if ( !is_null( $o_COM_OrdenCompraCabeceraBN->getIdRequerimiento() ) )
        {
            $this->setIdRequerimiento( $o_COM_OrdenCompraCabeceraBN->getIdRequerimiento() );
        }
    }

    /**
    * @return COM_OrdenCompraCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $i_IdOrdenCompra )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdOrdenCompra ) ){ $i_IdOrdenCompra = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_OrdenCompraCabecera ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdOrdenCompra = ".$i_IdOrdenCompra." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_COM_OrdenCompraCabeceraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_COM_OrdenCompraCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_COM_OrdenCompraCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdOrdenCompra() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdOrdenCompra = ".$this->getIdOrdenCompra()." AND ";
        if ( !is_null( $this->getTipoOrden() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.TipoOrden = '".$this->getTipoOrden()."' AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getProyectoNombre() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.ProyectoNombre = '".$this->getProyectoNombre()."' AND ";
        if ( !is_null( $this->getIdProveedor() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdProveedor = ".$this->getIdProveedor()." AND ";
        if ( !is_null( $this->getNombreProveedor() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.NombreProveedor = '".$this->getNombreProveedor()."' AND ";
        if ( !is_null( $this->getNumeroInterno() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.NumeroInterno = '".$this->getNumeroInterno()."' AND ";
        if ( !is_null( $this->getIdOrdenClasificacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdOrdenClasificacion = '".$this->getIdOrdenClasificacion()."' AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getIdMonedaPago() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdMonedaPago = '".$this->getIdMonedaPago()."' AND ";
        if ( !is_null( $this->getTerminoId() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.TerminoId = ".$this->getTerminoId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getObservacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.Observacion = '".$this->getObservacion()."' AND ";
        if ( !is_null( $this->getObservacionEntrega() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.ObservacionEntrega = '".$this->getObservacionEntrega()."' AND ";
        if ( !is_null( $this->getObservacionRechazo() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.ObservacionRechazo = '".$this->getObservacionRechazo()."' AND ";
        if ( !is_null( $this->getAfectoIGV() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.AfectoIGV = ".$this->getAfectoIGV()." AND ";
        if ( !is_null( $this->getMontoAfecto() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoAfecto = ".$this->getMontoAfecto()." AND ";
        if ( !is_null( $this->getMontoNoAfecto() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoNoAfecto = ".$this->getMontoNoAfecto()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getMontoBruto() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoBruto = ".$this->getMontoBruto()." AND ";
        if ( !is_null( $this->getMontoPendientePago() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.MontoPendientePago = ".$this->getMontoPendientePago()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getIdAlmacenEntrega() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdAlmacenEntrega = '".$this->getIdAlmacenEntrega()."' AND ";
        if ( !is_null( $this->getFechaEntrega() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaEntrega = '".$this->getFechaEntrega()."' AND ";
        if ( !is_null( $this->getIdAlmacenIngreso() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdAlmacenIngreso = '".$this->getIdAlmacenIngreso()."' AND ";
        if ( !is_null( $this->getPreparadoPor() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.PreparadoPor = '".$this->getPreparadoPor()."' AND ";
        if ( !is_null( $this->getFechaPreparacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaPreparacion = '".$this->getFechaPreparacion()."' AND ";
        if ( !is_null( $this->getAprobadoPor() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.AprobadoPor = '".$this->getAprobadoPor()."' AND ";
        if ( !is_null( $this->getFechaAprobacion() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaAprobacion = '".$this->getFechaAprobacion()."' AND ";
        if ( !is_null( $this->getRevisadoPor() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.RevisadoPor = '".$this->getRevisadoPor()."' AND ";
        if ( !is_null( $this->getFechaRevision() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.FechaRevision = '".$this->getFechaRevision()."' AND ";
        if ( !is_null( $this->getIdRequerimiento() ) ) $s_SQLQuery .= "COM_OrdenCompraCabecera.IdRequerimiento = ".$this->getIdRequerimiento()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM COM_OrdenCompraCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return COM_OrdenCompraCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_OrdenCompraCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_COM_OrdenCompraCabeceraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_COM_OrdenCompraCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_COM_OrdenCompraCabeceraBN[] = $o_COM_OrdenCompraCabeceraBN;
            }
        }
        return $a_COM_OrdenCompraCabeceraBN;
    }

    /* Devuelve un objeto COM_OrdenCompraCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_COM_OrdenCompraCabecera )
    {
        $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdCompania'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdCompania( ( integer ) $a_COM_OrdenCompraCabecera['IdCompania'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdSucursal'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdSucursal( ( integer ) $a_COM_OrdenCompraCabecera['IdSucursal'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdOrdenCompra'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( integer ) $a_COM_OrdenCompraCabecera['IdOrdenCompra'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['TipoOrden'] ) ) $o_COM_OrdenCompraCabeceraBN->setTipoOrden( $a_COM_OrdenCompraCabecera['TipoOrden'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdProyecto'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdProyecto( ( integer ) $a_COM_OrdenCompraCabecera['IdProyecto'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['ProyectoNombre'] ) ) $o_COM_OrdenCompraCabeceraBN->setProyectoNombre( $a_COM_OrdenCompraCabecera['ProyectoNombre'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdProveedor'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdProveedor( ( integer ) $a_COM_OrdenCompraCabecera['IdProveedor'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['NombreProveedor'] ) ) $o_COM_OrdenCompraCabeceraBN->setNombreProveedor( $a_COM_OrdenCompraCabecera['NombreProveedor'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['NumeroInterno'] ) ) $o_COM_OrdenCompraCabeceraBN->setNumeroInterno( $a_COM_OrdenCompraCabecera['NumeroInterno'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdOrdenClasificacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdOrdenClasificacion( $a_COM_OrdenCompraCabecera['IdOrdenClasificacion'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdMoneda'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdMoneda( $a_COM_OrdenCompraCabecera['IdMoneda'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdMonedaPago'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdMonedaPago( $a_COM_OrdenCompraCabecera['IdMonedaPago'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['TerminoId'] ) ) $o_COM_OrdenCompraCabeceraBN->setTerminoId( ( integer ) $a_COM_OrdenCompraCabecera['TerminoId'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['Descripcion'] ) ) $o_COM_OrdenCompraCabeceraBN->setDescripcion( $a_COM_OrdenCompraCabecera['Descripcion'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['Observacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setObservacion( $a_COM_OrdenCompraCabecera['Observacion'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['ObservacionEntrega'] ) ) $o_COM_OrdenCompraCabeceraBN->setObservacionEntrega( $a_COM_OrdenCompraCabecera['ObservacionEntrega'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['ObservacionRechazo'] ) ) $o_COM_OrdenCompraCabeceraBN->setObservacionRechazo( $a_COM_OrdenCompraCabecera['ObservacionRechazo'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['AfectoIGV'] ) ) $o_COM_OrdenCompraCabeceraBN->setAfectoIGV( ( integer ) $a_COM_OrdenCompraCabecera['AfectoIGV'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['MontoAfecto'] ) ) $o_COM_OrdenCompraCabeceraBN->setMontoAfecto( ( float ) $a_COM_OrdenCompraCabecera['MontoAfecto'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['MontoNoAfecto'] ) ) $o_COM_OrdenCompraCabeceraBN->setMontoNoAfecto( ( float ) $a_COM_OrdenCompraCabecera['MontoNoAfecto'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['MontoIGV'] ) ) $o_COM_OrdenCompraCabeceraBN->setMontoIGV( ( float ) $a_COM_OrdenCompraCabecera['MontoIGV'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['MontoBruto'] ) ) $o_COM_OrdenCompraCabeceraBN->setMontoBruto( ( float ) $a_COM_OrdenCompraCabecera['MontoBruto'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['MontoPendientePago'] ) ) $o_COM_OrdenCompraCabeceraBN->setMontoPendientePago( ( float ) $a_COM_OrdenCompraCabecera['MontoPendientePago'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['Estado'] ) ) $o_COM_OrdenCompraCabeceraBN->setEstado( $a_COM_OrdenCompraCabecera['Estado'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['TipoCambio'] ) ) $o_COM_OrdenCompraCabeceraBN->setTipoCambio( ( float ) $a_COM_OrdenCompraCabecera['TipoCambio'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaCreacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['UsuarioCreacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setUsuarioCreacion( $a_COM_OrdenCompraCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaModificacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['UsuarioModificacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setUsuarioModificacion( $a_COM_OrdenCompraCabecera['UsuarioModificacion'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdAlmacenEntrega'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdAlmacenEntrega( $a_COM_OrdenCompraCabecera['IdAlmacenEntrega'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaEntrega'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaEntrega( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaEntrega'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdAlmacenIngreso'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdAlmacenIngreso( $a_COM_OrdenCompraCabecera['IdAlmacenIngreso'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['PreparadoPor'] ) ) $o_COM_OrdenCompraCabeceraBN->setPreparadoPor( $a_COM_OrdenCompraCabecera['PreparadoPor'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaPreparacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaPreparacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaPreparacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['AprobadoPor'] ) ) $o_COM_OrdenCompraCabeceraBN->setAprobadoPor( $a_COM_OrdenCompraCabecera['AprobadoPor'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaAprobacion'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaAprobacion( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaAprobacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['RevisadoPor'] ) ) $o_COM_OrdenCompraCabeceraBN->setRevisadoPor( $a_COM_OrdenCompraCabecera['RevisadoPor'] );
        if ( !is_null( $a_COM_OrdenCompraCabecera['FechaRevision'] ) ) $o_COM_OrdenCompraCabeceraBN->setFechaRevision( utilTimestamp::getTimestamp( $a_COM_OrdenCompraCabecera['FechaRevision'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_COM_OrdenCompraCabecera['IdRequerimiento'] ) ) $o_COM_OrdenCompraCabeceraBN->setIdRequerimiento( ( integer ) $a_COM_OrdenCompraCabecera['IdRequerimiento'] );
        return $o_COM_OrdenCompraCabeceraBN;
    }
}
?>