<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_GastosImportacionDet.xml */
/* Generado: 2021-08-14 18:19:48 */

/* Busqueda de registros de la tabla COM_GastosImportacionDet. */
abstract class BaseCOM_GastosImportacionDetFN extends COM_GastosImportacionDetBN
{
    /* Declaracion de constantes */
    const IdOrdenCompra = "COM_GastosImportacionDet.IdOrdenCompra";
    const GastosImportacionId = "COM_GastosImportacionDet.GastosImportacionId";
    const Secuencia = "COM_GastosImportacionDet.Secuencia";
    const TipoGastoId = "COM_GastosImportacionDet.TipoGastoId";
    const TipoGastoDesc = "COM_GastosImportacionDet.TipoGastoDesc";
    const Descripcion = "COM_GastosImportacionDet.Descripcion";
    const TipoCambio = "COM_GastosImportacionDet.TipoCambio";
    const MontoDolares = "COM_GastosImportacionDet.MontoDolares";
    const MontoSoles = "COM_GastosImportacionDet.MontoSoles";
    const Estado = "COM_GastosImportacionDet.Estado";
    const UsuarioCreacion = "COM_GastosImportacionDet.UsuarioCreacion";
    const FechaCreacion = "COM_GastosImportacionDet.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "COM_GastosImportacionDet.IdOrdenCompra AS IdOrdenCompra, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.GastosImportacionId AS GastosImportacionId, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.TipoGastoId AS TipoGastoId, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.TipoGastoDesc AS TipoGastoDesc, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.MontoDolares AS MontoDolares, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.MontoSoles AS MontoSoles, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.Estado AS Estado, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "COM_GastosImportacionDet.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto COM_GastosImportacionDetBN */
    public function setByBN( COM_GastosImportacionDetBN $o_COM_GastosImportacionDetBN )
    {
        if ( !is_null( $o_COM_GastosImportacionDetBN->getIdOrdenCompra() ) )
        {
            $this->setIdOrdenCompra( $o_COM_GastosImportacionDetBN->getIdOrdenCompra() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getGastosImportacionId() ) )
        {
            $this->setGastosImportacionId( $o_COM_GastosImportacionDetBN->getGastosImportacionId() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_COM_GastosImportacionDetBN->getSecuencia() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getTipoGastoId() ) )
        {
            $this->setTipoGastoId( $o_COM_GastosImportacionDetBN->getTipoGastoId() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getTipoGastoDesc() ) )
        {
            $this->setTipoGastoDesc( $o_COM_GastosImportacionDetBN->getTipoGastoDesc() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_COM_GastosImportacionDetBN->getDescripcion() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_COM_GastosImportacionDetBN->getTipoCambio() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getMontoDolares() ) )
        {
            $this->setMontoDolares( $o_COM_GastosImportacionDetBN->getMontoDolares() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getMontoSoles() ) )
        {
            $this->setMontoSoles( $o_COM_GastosImportacionDetBN->getMontoSoles() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getEstado() ) )
        {
            $this->setEstado( $o_COM_GastosImportacionDetBN->getEstado() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_COM_GastosImportacionDetBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_COM_GastosImportacionDetBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_COM_GastosImportacionDetBN->getFechaCreacion() );
        }
    }

    /**
    * @return COM_GastosImportacionDetBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdOrdenCompra, $i_GastosImportacionId )
    {
        if( is_null( $i_IdOrdenCompra ) ){ $i_IdOrdenCompra = -1; } 
        if( is_null( $i_GastosImportacionId ) ){ $i_GastosImportacionId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_GastosImportacionDet ";
        $s_SQLQuery .= "WHERE IdOrdenCompra = ".$i_IdOrdenCompra." ";
        $s_SQLQuery .= "AND GastosImportacionId = ".$i_GastosImportacionId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_COM_GastosImportacionDetBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_COM_GastosImportacionDetBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_COM_GastosImportacionDetBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOrdenCompra() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.IdOrdenCompra = ".$this->getIdOrdenCompra()." AND ";
        if ( !is_null( $this->getGastosImportacionId() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.GastosImportacionId = ".$this->getGastosImportacionId()." AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getTipoGastoId() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.TipoGastoId = '".$this->getTipoGastoId()."' AND ";
        if ( !is_null( $this->getTipoGastoDesc() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.TipoGastoDesc = '".$this->getTipoGastoDesc()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getMontoDolares() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.MontoDolares = ".$this->getMontoDolares()." AND ";
        if ( !is_null( $this->getMontoSoles() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.MontoSoles = ".$this->getMontoSoles()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "COM_GastosImportacionDet.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM COM_GastosImportacionDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return COM_GastosImportacionDetBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM COM_GastosImportacionDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_COM_GastosImportacionDetBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_COM_GastosImportacionDetBN = $this->insertObjectBN( $a_SQLRow );
                $a_COM_GastosImportacionDetBN[] = $o_COM_GastosImportacionDetBN;
            }
        }
        return $a_COM_GastosImportacionDetBN;
    }

    /* Devuelve un objeto COM_GastosImportacionDetBN desde un objeto propel */
    public function insertObjectBN( $a_COM_GastosImportacionDet )
    {
        $o_COM_GastosImportacionDetBN = new COM_GastosImportacionDetBN();
        if ( !is_null( $a_COM_GastosImportacionDet['IdOrdenCompra'] ) ) $o_COM_GastosImportacionDetBN->setIdOrdenCompra( ( integer ) $a_COM_GastosImportacionDet['IdOrdenCompra'] );
        if ( !is_null( $a_COM_GastosImportacionDet['GastosImportacionId'] ) ) $o_COM_GastosImportacionDetBN->setGastosImportacionId( ( integer ) $a_COM_GastosImportacionDet['GastosImportacionId'] );
        if ( !is_null( $a_COM_GastosImportacionDet['Secuencia'] ) ) $o_COM_GastosImportacionDetBN->setSecuencia( $a_COM_GastosImportacionDet['Secuencia'] );
        if ( !is_null( $a_COM_GastosImportacionDet['TipoGastoId'] ) ) $o_COM_GastosImportacionDetBN->setTipoGastoId( $a_COM_GastosImportacionDet['TipoGastoId'] );
        if ( !is_null( $a_COM_GastosImportacionDet['TipoGastoDesc'] ) ) $o_COM_GastosImportacionDetBN->setTipoGastoDesc( $a_COM_GastosImportacionDet['TipoGastoDesc'] );
        if ( !is_null( $a_COM_GastosImportacionDet['Descripcion'] ) ) $o_COM_GastosImportacionDetBN->setDescripcion( $a_COM_GastosImportacionDet['Descripcion'] );
        if ( !is_null( $a_COM_GastosImportacionDet['TipoCambio'] ) ) $o_COM_GastosImportacionDetBN->setTipoCambio( ( float ) $a_COM_GastosImportacionDet['TipoCambio'] );
        if ( !is_null( $a_COM_GastosImportacionDet['MontoDolares'] ) ) $o_COM_GastosImportacionDetBN->setMontoDolares( ( float ) $a_COM_GastosImportacionDet['MontoDolares'] );
        if ( !is_null( $a_COM_GastosImportacionDet['MontoSoles'] ) ) $o_COM_GastosImportacionDetBN->setMontoSoles( ( float ) $a_COM_GastosImportacionDet['MontoSoles'] );
        if ( !is_null( $a_COM_GastosImportacionDet['Estado'] ) ) $o_COM_GastosImportacionDetBN->setEstado( $a_COM_GastosImportacionDet['Estado'] );
        if ( !is_null( $a_COM_GastosImportacionDet['UsuarioCreacion'] ) ) $o_COM_GastosImportacionDetBN->setUsuarioCreacion( $a_COM_GastosImportacionDet['UsuarioCreacion'] );
        if ( !is_null( $a_COM_GastosImportacionDet['FechaCreacion'] ) ) $o_COM_GastosImportacionDetBN->setFechaCreacion( $a_COM_GastosImportacionDet['FechaCreacion'] );
        return $o_COM_GastosImportacionDetBN;
    }
}
?>