<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionMast.xml */
/* Generado: 2021-06-25 23:59:44 */

/* Busqueda de registros de la tabla ALM_TransaccionMast. */
abstract class BaseALM_TransaccionMastFN extends ALM_TransaccionMastBN
{
    /* Declaracion de constantes */
    const IdTransaccion = "ALM_TransaccionMast.IdTransaccion";
    const CodigoSunat = "ALM_TransaccionMast.CodigoSunat";
    const DescripcionLocal = "ALM_TransaccionMast.DescripcionLocal";
    const DescripcionIngles = "ALM_TransaccionMast.DescripcionIngles";
    const IngresoEgresoFlag = "ALM_TransaccionMast.IngresoEgresoFlag";
    const TipoDocumentoGenerado = "ALM_TransaccionMast.TipoDocumentoGenerado";
    const TipoDocumentoValidado = "ALM_TransaccionMast.TipoDocumentoValidado";
    const TransacciondelSistemaFlag = "ALM_TransaccionMast.TransacciondelSistemaFlag";
    const NumeracionAutomaticaFlag = "ALM_TransaccionMast.NumeracionAutomaticaFlag";
    const CampoReferenciaFlag = "ALM_TransaccionMast.CampoReferenciaFlag";
    const GenerarVoucherFlag = "ALM_TransaccionMast.GenerarVoucherFlag";
    const AjusteInventarioFlag = "ALM_TransaccionMast.AjusteInventarioFlag";
    const AjusteInventarioCuenta = "ALM_TransaccionMast.AjusteInventarioCuenta";
    const TransaccionVentaFlag = "ALM_TransaccionMast.TransaccionVentaFlag";
    const DireccionDestinoFlag = "ALM_TransaccionMast.DireccionDestinoFlag";
    const ValorizacionManualFlag = "ALM_TransaccionMast.ValorizacionManualFlag";
    const Clasificacion = "ALM_TransaccionMast.Clasificacion";
    const Estado = "ALM_TransaccionMast.Estado";
    const UsuarioModificacion = "ALM_TransaccionMast.UsuarioModificacion";
    const FechaModificacion = "ALM_TransaccionMast.FechaModificacion";
    const UsuarioCreacion = "ALM_TransaccionMast.UsuarioCreacion";
    const FechaCreacion = "ALM_TransaccionMast.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransaccionMast.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "ALM_TransaccionMast.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "ALM_TransaccionMast.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "ALM_TransaccionMast.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "ALM_TransaccionMast.IngresoEgresoFlag AS IngresoEgresoFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.TipoDocumentoGenerado AS TipoDocumentoGenerado, ";
        $s_SQLQuery .= "ALM_TransaccionMast.TipoDocumentoValidado AS TipoDocumentoValidado, ";
        $s_SQLQuery .= "ALM_TransaccionMast.TransacciondelSistemaFlag AS TransacciondelSistemaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.NumeracionAutomaticaFlag AS NumeracionAutomaticaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.CampoReferenciaFlag AS CampoReferenciaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.GenerarVoucherFlag AS GenerarVoucherFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.AjusteInventarioFlag AS AjusteInventarioFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.AjusteInventarioCuenta AS AjusteInventarioCuenta, ";
        $s_SQLQuery .= "ALM_TransaccionMast.TransaccionVentaFlag AS TransaccionVentaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.DireccionDestinoFlag AS DireccionDestinoFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.ValorizacionManualFlag AS ValorizacionManualFlag, ";
        $s_SQLQuery .= "ALM_TransaccionMast.Clasificacion AS Clasificacion, ";
        $s_SQLQuery .= "ALM_TransaccionMast.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_TransaccionMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransaccionMast.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransaccionMastBN */
    public function setByBN( ALM_TransaccionMastBN $o_ALM_TransaccionMastBN )
    {
        if ( !is_null( $o_ALM_TransaccionMastBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_ALM_TransaccionMastBN->getIdTransaccion() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_TransaccionMastBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_ALM_TransaccionMastBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_TransaccionMastBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getIngresoEgresoFlag() ) )
        {
            $this->setIngresoEgresoFlag( $o_ALM_TransaccionMastBN->getIngresoEgresoFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getTipoDocumentoGenerado() ) )
        {
            $this->setTipoDocumentoGenerado( $o_ALM_TransaccionMastBN->getTipoDocumentoGenerado() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getTipoDocumentoValidado() ) )
        {
            $this->setTipoDocumentoValidado( $o_ALM_TransaccionMastBN->getTipoDocumentoValidado() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getTransacciondelSistemaFlag() ) )
        {
            $this->setTransacciondelSistemaFlag( $o_ALM_TransaccionMastBN->getTransacciondelSistemaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getNumeracionAutomaticaFlag() ) )
        {
            $this->setNumeracionAutomaticaFlag( $o_ALM_TransaccionMastBN->getNumeracionAutomaticaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getCampoReferenciaFlag() ) )
        {
            $this->setCampoReferenciaFlag( $o_ALM_TransaccionMastBN->getCampoReferenciaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getGenerarVoucherFlag() ) )
        {
            $this->setGenerarVoucherFlag( $o_ALM_TransaccionMastBN->getGenerarVoucherFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getAjusteInventarioFlag() ) )
        {
            $this->setAjusteInventarioFlag( $o_ALM_TransaccionMastBN->getAjusteInventarioFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getAjusteInventarioCuenta() ) )
        {
            $this->setAjusteInventarioCuenta( $o_ALM_TransaccionMastBN->getAjusteInventarioCuenta() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getTransaccionVentaFlag() ) )
        {
            $this->setTransaccionVentaFlag( $o_ALM_TransaccionMastBN->getTransaccionVentaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getDireccionDestinoFlag() ) )
        {
            $this->setDireccionDestinoFlag( $o_ALM_TransaccionMastBN->getDireccionDestinoFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getValorizacionManualFlag() ) )
        {
            $this->setValorizacionManualFlag( $o_ALM_TransaccionMastBN->getValorizacionManualFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getClasificacion() ) )
        {
            $this->setClasificacion( $o_ALM_TransaccionMastBN->getClasificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_TransaccionMastBN->getEstado() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransaccionMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransaccionMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransaccionMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransaccionMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransaccionMastBN->getFechaCreacion() );
        }
    }

    /**
    * @return ALM_TransaccionMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTransaccion )
    {
        if( is_null( $s_IdTransaccion ) ){ $s_IdTransaccion = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionMast ";
        $s_SQLQuery .= "WHERE IdTransaccion = '".$s_IdTransaccion."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_TransaccionMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransaccionMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransaccionMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "ALM_TransaccionMast.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "ALM_TransaccionMast.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "ALM_TransaccionMast.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getIngresoEgresoFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.IngresoEgresoFlag = '".$this->getIngresoEgresoFlag()."' AND ";
        if ( !is_null( $this->getTipoDocumentoGenerado() ) ) $s_SQLQuery .= "ALM_TransaccionMast.TipoDocumentoGenerado = '".$this->getTipoDocumentoGenerado()."' AND ";
        if ( !is_null( $this->getTipoDocumentoValidado() ) ) $s_SQLQuery .= "ALM_TransaccionMast.TipoDocumentoValidado = '".$this->getTipoDocumentoValidado()."' AND ";
        if ( !is_null( $this->getTransacciondelSistemaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.TransacciondelSistemaFlag = '".$this->getTransacciondelSistemaFlag()."' AND ";
        if ( !is_null( $this->getNumeracionAutomaticaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.NumeracionAutomaticaFlag = '".$this->getNumeracionAutomaticaFlag()."' AND ";
        if ( !is_null( $this->getCampoReferenciaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.CampoReferenciaFlag = '".$this->getCampoReferenciaFlag()."' AND ";
        if ( !is_null( $this->getGenerarVoucherFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.GenerarVoucherFlag = '".$this->getGenerarVoucherFlag()."' AND ";
        if ( !is_null( $this->getAjusteInventarioFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.AjusteInventarioFlag = '".$this->getAjusteInventarioFlag()."' AND ";
        if ( !is_null( $this->getAjusteInventarioCuenta() ) ) $s_SQLQuery .= "ALM_TransaccionMast.AjusteInventarioCuenta = '".$this->getAjusteInventarioCuenta()."' AND ";
        if ( !is_null( $this->getTransaccionVentaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.TransaccionVentaFlag = '".$this->getTransaccionVentaFlag()."' AND ";
        if ( !is_null( $this->getDireccionDestinoFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.DireccionDestinoFlag = '".$this->getDireccionDestinoFlag()."' AND ";
        if ( !is_null( $this->getValorizacionManualFlag() ) ) $s_SQLQuery .= "ALM_TransaccionMast.ValorizacionManualFlag = '".$this->getValorizacionManualFlag()."' AND ";
        if ( !is_null( $this->getClasificacion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.Clasificacion = '".$this->getClasificacion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_TransaccionMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransaccionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransaccionMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_TransaccionMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransaccionMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransaccionMastBN[] = $o_ALM_TransaccionMastBN;
            }
        }
        return $a_ALM_TransaccionMastBN;
    }

    /* Devuelve un objeto ALM_TransaccionMastBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransaccionMast )
    {
        $o_ALM_TransaccionMastBN = new ALM_TransaccionMastBN();
        if ( !is_null( $a_ALM_TransaccionMast['IdTransaccion'] ) ) $o_ALM_TransaccionMastBN->setIdTransaccion( $a_ALM_TransaccionMast['IdTransaccion'] );
        if ( !is_null( $a_ALM_TransaccionMast['CodigoSunat'] ) ) $o_ALM_TransaccionMastBN->setCodigoSunat( $a_ALM_TransaccionMast['CodigoSunat'] );
        if ( !is_null( $a_ALM_TransaccionMast['DescripcionLocal'] ) ) $o_ALM_TransaccionMastBN->setDescripcionLocal( $a_ALM_TransaccionMast['DescripcionLocal'] );
        if ( !is_null( $a_ALM_TransaccionMast['DescripcionIngles'] ) ) $o_ALM_TransaccionMastBN->setDescripcionIngles( $a_ALM_TransaccionMast['DescripcionIngles'] );
        if ( !is_null( $a_ALM_TransaccionMast['IngresoEgresoFlag'] ) ) $o_ALM_TransaccionMastBN->setIngresoEgresoFlag( $a_ALM_TransaccionMast['IngresoEgresoFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['TipoDocumentoGenerado'] ) ) $o_ALM_TransaccionMastBN->setTipoDocumentoGenerado( $a_ALM_TransaccionMast['TipoDocumentoGenerado'] );
        if ( !is_null( $a_ALM_TransaccionMast['TipoDocumentoValidado'] ) ) $o_ALM_TransaccionMastBN->setTipoDocumentoValidado( $a_ALM_TransaccionMast['TipoDocumentoValidado'] );
        if ( !is_null( $a_ALM_TransaccionMast['TransacciondelSistemaFlag'] ) ) $o_ALM_TransaccionMastBN->setTransacciondelSistemaFlag( $a_ALM_TransaccionMast['TransacciondelSistemaFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['NumeracionAutomaticaFlag'] ) ) $o_ALM_TransaccionMastBN->setNumeracionAutomaticaFlag( $a_ALM_TransaccionMast['NumeracionAutomaticaFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['CampoReferenciaFlag'] ) ) $o_ALM_TransaccionMastBN->setCampoReferenciaFlag( $a_ALM_TransaccionMast['CampoReferenciaFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['GenerarVoucherFlag'] ) ) $o_ALM_TransaccionMastBN->setGenerarVoucherFlag( $a_ALM_TransaccionMast['GenerarVoucherFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['AjusteInventarioFlag'] ) ) $o_ALM_TransaccionMastBN->setAjusteInventarioFlag( $a_ALM_TransaccionMast['AjusteInventarioFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['AjusteInventarioCuenta'] ) ) $o_ALM_TransaccionMastBN->setAjusteInventarioCuenta( $a_ALM_TransaccionMast['AjusteInventarioCuenta'] );
        if ( !is_null( $a_ALM_TransaccionMast['TransaccionVentaFlag'] ) ) $o_ALM_TransaccionMastBN->setTransaccionVentaFlag( $a_ALM_TransaccionMast['TransaccionVentaFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['DireccionDestinoFlag'] ) ) $o_ALM_TransaccionMastBN->setDireccionDestinoFlag( $a_ALM_TransaccionMast['DireccionDestinoFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['ValorizacionManualFlag'] ) ) $o_ALM_TransaccionMastBN->setValorizacionManualFlag( $a_ALM_TransaccionMast['ValorizacionManualFlag'] );
        if ( !is_null( $a_ALM_TransaccionMast['Clasificacion'] ) ) $o_ALM_TransaccionMastBN->setClasificacion( $a_ALM_TransaccionMast['Clasificacion'] );
        if ( !is_null( $a_ALM_TransaccionMast['Estado'] ) ) $o_ALM_TransaccionMastBN->setEstado( $a_ALM_TransaccionMast['Estado'] );
        if ( !is_null( $a_ALM_TransaccionMast['UsuarioModificacion'] ) ) $o_ALM_TransaccionMastBN->setUsuarioModificacion( $a_ALM_TransaccionMast['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransaccionMast['FechaModificacion'] ) ) $o_ALM_TransaccionMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionMast['UsuarioCreacion'] ) ) $o_ALM_TransaccionMastBN->setUsuarioCreacion( $a_ALM_TransaccionMast['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransaccionMast['FechaCreacion'] ) ) $o_ALM_TransaccionMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_TransaccionMastBN;
    }
}
?>