<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionDetalle.xml */
/* Generado: 2021-11-07 00:42:13 */

/* Busqueda de registros de la tabla ALM_TransaccionDetalle. */
abstract class BaseALM_TransaccionDetalleFN extends ALM_TransaccionDetalleBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_TransaccionDetalle.IdCompania";
    const IdTipoDocumento = "ALM_TransaccionDetalle.IdTipoDocumento";
    const IdNumeroDocumento = "ALM_TransaccionDetalle.IdNumeroDocumento";
    const IdSucursal = "ALM_TransaccionDetalle.IdSucursal";
    const IdCondicion = "ALM_TransaccionDetalle.IdCondicion";
    const IdSecuencia = "ALM_TransaccionDetalle.IdSecuencia";
    const IdItem = "ALM_TransaccionDetalle.IdItem";
    const Lote = "ALM_TransaccionDetalle.Lote";
    const IdTransaccionCab = "ALM_TransaccionDetalle.IdTransaccionCab";
    const FechaDocumentoCab = "ALM_TransaccionDetalle.FechaDocumentoCab";
    const IdAlmacen = "ALM_TransaccionDetalle.IdAlmacen";
    const IdAlmacenDestino = "ALM_TransaccionDetalle.IdAlmacenDestino";
    const FechaVencimiento = "ALM_TransaccionDetalle.FechaVencimiento";
    const UnidadCodigo = "ALM_TransaccionDetalle.UnidadCodigo";
    const Cantidad = "ALM_TransaccionDetalle.Cantidad";
    const CantidadDoble = "ALM_TransaccionDetalle.CantidadDoble";
    const CantidadFIFO = "ALM_TransaccionDetalle.CantidadFIFO";
    const IdMoneda = "ALM_TransaccionDetalle.IdMoneda";
    const PrecioUnitario = "ALM_TransaccionDetalle.PrecioUnitario";
    const MontoTotal = "ALM_TransaccionDetalle.MontoTotal";
    const PrecioUnitarioDolares = "ALM_TransaccionDetalle.PrecioUnitarioDolares";
    const MontoTotalDolares = "ALM_TransaccionDetalle.MontoTotalDolares";
    const ReferenciaCompaniaSocio = "ALM_TransaccionDetalle.ReferenciaCompaniaSocio";
    const ReferenciaTipoDocumento = "ALM_TransaccionDetalle.ReferenciaTipoDocumento";
    const ReferenciaNumeroDocumento = "ALM_TransaccionDetalle.ReferenciaNumeroDocumento";
    const ReferenciaSecuencia = "ALM_TransaccionDetalle.ReferenciaSecuencia";
    const AprobacionTecnicaFlag = "ALM_TransaccionDetalle.AprobacionTecnicaFlag";
    const AprobacionTecnicaDocumento = "ALM_TransaccionDetalle.AprobacionTecnicaDocumento";
    const FallaFlag = "ALM_TransaccionDetalle.FallaFlag";
    const Observaciones = "ALM_TransaccionDetalle.Observaciones";
    const FacturadoFlag = "ALM_TransaccionDetalle.FacturadoFlag";
    const ValorizacionExternaFlag = "ALM_TransaccionDetalle.ValorizacionExternaFlag";
    const LoteProduccion = "ALM_TransaccionDetalle.LoteProduccion";
    const UsuarioModificacion = "ALM_TransaccionDetalle.UsuarioModificacion";
    const FechaModificacion = "ALM_TransaccionDetalle.FechaModificacion";
    const UsuarioCreacion = "ALM_TransaccionDetalle.UsuarioCreacion";
    const FechaCreacion = "ALM_TransaccionDetalle.FechaCreacion";
    const DescripcionItem = "ALM_TransaccionDetalle.DescripcionItem";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransaccionDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.Lote AS Lote, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdTransaccionCab AS IdTransaccionCab, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FechaDocumentoCab AS FechaDocumentoCab, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdAlmacenDestino AS IdAlmacenDestino, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.UnidadCodigo AS UnidadCodigo, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.CantidadDoble AS CantidadDoble, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.CantidadFIFO AS CantidadFIFO, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.IdMoneda AS IdMoneda, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.PrecioUnitarioDolares AS PrecioUnitarioDolares, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.MontoTotalDolares AS MontoTotalDolares, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaCompaniaSocio AS ReferenciaCompaniaSocio, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaSecuencia AS ReferenciaSecuencia, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.AprobacionTecnicaFlag AS AprobacionTecnicaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.AprobacionTecnicaDocumento AS AprobacionTecnicaDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FallaFlag AS FallaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.Observaciones AS Observaciones, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FacturadoFlag AS FacturadoFlag, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.ValorizacionExternaFlag AS ValorizacionExternaFlag, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.LoteProduccion AS LoteProduccion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TransaccionDetalle.DescripcionItem AS DescripcionItem ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransaccionDetalleBN */
    public function setByBN( ALM_TransaccionDetalleBN $o_ALM_TransaccionDetalleBN )
    {
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_TransaccionDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_ALM_TransaccionDetalleBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_ALM_TransaccionDetalleBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_TransaccionDetalleBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_TransaccionDetalleBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_TransaccionDetalleBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getLote() ) )
        {
            $this->setLote( $o_ALM_TransaccionDetalleBN->getLote() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdTransaccionCab() ) )
        {
            $this->setIdTransaccionCab( $o_ALM_TransaccionDetalleBN->getIdTransaccionCab() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFechaDocumentoCab() ) )
        {
            $this->setFechaDocumentoCab( $o_ALM_TransaccionDetalleBN->getFechaDocumentoCab() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_TransaccionDetalleBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdAlmacenDestino() ) )
        {
            $this->setIdAlmacenDestino( $o_ALM_TransaccionDetalleBN->getIdAlmacenDestino() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_TransaccionDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getUnidadCodigo() ) )
        {
            $this->setUnidadCodigo( $o_ALM_TransaccionDetalleBN->getUnidadCodigo() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getCantidadDoble() ) )
        {
            $this->setCantidadDoble( $o_ALM_TransaccionDetalleBN->getCantidadDoble() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getCantidadFIFO() ) )
        {
            $this->setCantidadFIFO( $o_ALM_TransaccionDetalleBN->getCantidadFIFO() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_ALM_TransaccionDetalleBN->getIdMoneda() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_TransaccionDetalleBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_TransaccionDetalleBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getMontoTotalDolares() ) )
        {
            $this->setMontoTotalDolares( $o_ALM_TransaccionDetalleBN->getMontoTotalDolares() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getReferenciaCompaniaSocio() ) )
        {
            $this->setReferenciaCompaniaSocio( $o_ALM_TransaccionDetalleBN->getReferenciaCompaniaSocio() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_TransaccionDetalleBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_TransaccionDetalleBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() ) )
        {
            $this->setReferenciaSecuencia( $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getAprobacionTecnicaFlag() ) )
        {
            $this->setAprobacionTecnicaFlag( $o_ALM_TransaccionDetalleBN->getAprobacionTecnicaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getAprobacionTecnicaDocumento() ) )
        {
            $this->setAprobacionTecnicaDocumento( $o_ALM_TransaccionDetalleBN->getAprobacionTecnicaDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFallaFlag() ) )
        {
            $this->setFallaFlag( $o_ALM_TransaccionDetalleBN->getFallaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_ALM_TransaccionDetalleBN->getObservaciones() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFacturadoFlag() ) )
        {
            $this->setFacturadoFlag( $o_ALM_TransaccionDetalleBN->getFacturadoFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getValorizacionExternaFlag() ) )
        {
            $this->setValorizacionExternaFlag( $o_ALM_TransaccionDetalleBN->getValorizacionExternaFlag() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getLoteProduccion() ) )
        {
            $this->setLoteProduccion( $o_ALM_TransaccionDetalleBN->getLoteProduccion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransaccionDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransaccionDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransaccionDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransaccionDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TransaccionDetalleBN->getDescripcionItem() ) )
        {
            $this->setDescripcionItem( $o_ALM_TransaccionDetalleBN->getDescripcionItem() );
        }
    }

    /**
    * @return ALM_TransaccionDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdTipoDocumento, $s_IdNumeroDocumento, $i_IdSecuencia )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
        if( is_null( $s_IdNumeroDocumento ) ){ $s_IdNumeroDocumento = '-1'; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionDetalle ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "AND IdNumeroDocumento = '".$s_IdNumeroDocumento."' ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_TransaccionDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransaccionDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransaccionDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdCondicion = '".$this->getIdCondicion()."' AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getLote() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.Lote = '".$this->getLote()."' AND ";
        if ( !is_null( $this->getIdTransaccionCab() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdTransaccionCab = '".$this->getIdTransaccionCab()."' AND ";
        if ( !is_null( $this->getFechaDocumentoCab() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FechaDocumentoCab = '".$this->getFechaDocumentoCab()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdAlmacenDestino() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdAlmacenDestino = '".$this->getIdAlmacenDestino()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getUnidadCodigo() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.UnidadCodigo = '".$this->getUnidadCodigo()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getCantidadDoble() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.CantidadDoble = ".$this->getCantidadDoble()." AND ";
        if ( !is_null( $this->getCantidadFIFO() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.CantidadFIFO = ".$this->getCantidadFIFO()." AND ";
        if ( !is_null( $this->getIdMoneda() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.IdMoneda = '".$this->getIdMoneda()."' AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioDolares() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()." AND ";
        if ( !is_null( $this->getMontoTotalDolares() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.MontoTotalDolares = ".$this->getMontoTotalDolares()." AND ";
        if ( !is_null( $this->getReferenciaCompaniaSocio() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaCompaniaSocio = '".$this->getReferenciaCompaniaSocio()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaSecuencia() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.ReferenciaSecuencia = ".$this->getReferenciaSecuencia()." AND ";
        if ( !is_null( $this->getAprobacionTecnicaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.AprobacionTecnicaFlag = '".$this->getAprobacionTecnicaFlag()."' AND ";
        if ( !is_null( $this->getAprobacionTecnicaDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.AprobacionTecnicaDocumento = '".$this->getAprobacionTecnicaDocumento()."' AND ";
        if ( !is_null( $this->getFallaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FallaFlag = '".$this->getFallaFlag()."' AND ";
        if ( !is_null( $this->getObservaciones() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.Observaciones = '".$this->getObservaciones()."' AND ";
        if ( !is_null( $this->getFacturadoFlag() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FacturadoFlag = '".$this->getFacturadoFlag()."' AND ";
        if ( !is_null( $this->getValorizacionExternaFlag() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.ValorizacionExternaFlag = '".$this->getValorizacionExternaFlag()."' AND ";
        if ( !is_null( $this->getLoteProduccion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.LoteProduccion = '".$this->getLoteProduccion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getDescripcionItem() ) ) $s_SQLQuery .= "ALM_TransaccionDetalle.DescripcionItem = '".$this->getDescripcionItem()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransaccionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransaccionDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_TransaccionDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransaccionDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransaccionDetalleBN[] = $o_ALM_TransaccionDetalleBN;
            }
        }
        return $a_ALM_TransaccionDetalleBN;
    }

    /* Devuelve un objeto ALM_TransaccionDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransaccionDetalle )
    {
        $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
        if ( !is_null( $a_ALM_TransaccionDetalle['IdCompania'] ) ) $o_ALM_TransaccionDetalleBN->setIdCompania( ( integer ) $a_ALM_TransaccionDetalle['IdCompania'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdTipoDocumento'] ) ) $o_ALM_TransaccionDetalleBN->setIdTipoDocumento( $a_ALM_TransaccionDetalle['IdTipoDocumento'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdNumeroDocumento'] ) ) $o_ALM_TransaccionDetalleBN->setIdNumeroDocumento( $a_ALM_TransaccionDetalle['IdNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdSucursal'] ) ) $o_ALM_TransaccionDetalleBN->setIdSucursal( ( integer ) $a_ALM_TransaccionDetalle['IdSucursal'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdCondicion'] ) ) $o_ALM_TransaccionDetalleBN->setIdCondicion( $a_ALM_TransaccionDetalle['IdCondicion'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdSecuencia'] ) ) $o_ALM_TransaccionDetalleBN->setIdSecuencia( ( integer ) $a_ALM_TransaccionDetalle['IdSecuencia'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdItem'] ) ) $o_ALM_TransaccionDetalleBN->setIdItem( $a_ALM_TransaccionDetalle['IdItem'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['Lote'] ) ) $o_ALM_TransaccionDetalleBN->setLote( $a_ALM_TransaccionDetalle['Lote'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdTransaccionCab'] ) ) $o_ALM_TransaccionDetalleBN->setIdTransaccionCab( $a_ALM_TransaccionDetalle['IdTransaccionCab'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FechaDocumentoCab'] ) ) $o_ALM_TransaccionDetalleBN->setFechaDocumentoCab( utilTimestamp::getTimestamp( $a_ALM_TransaccionDetalle['FechaDocumentoCab'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdAlmacen'] ) ) $o_ALM_TransaccionDetalleBN->setIdAlmacen( $a_ALM_TransaccionDetalle['IdAlmacen'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdAlmacenDestino'] ) ) $o_ALM_TransaccionDetalleBN->setIdAlmacenDestino( $a_ALM_TransaccionDetalle['IdAlmacenDestino'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FechaVencimiento'] ) ) $o_ALM_TransaccionDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_TransaccionDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_TransaccionDetalle['UnidadCodigo'] ) ) $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $a_ALM_TransaccionDetalle['UnidadCodigo'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['Cantidad'] ) ) $o_ALM_TransaccionDetalleBN->setCantidad( ( float ) $a_ALM_TransaccionDetalle['Cantidad'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['CantidadDoble'] ) ) $o_ALM_TransaccionDetalleBN->setCantidadDoble( ( float ) $a_ALM_TransaccionDetalle['CantidadDoble'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['CantidadFIFO'] ) ) $o_ALM_TransaccionDetalleBN->setCantidadFIFO( ( float ) $a_ALM_TransaccionDetalle['CantidadFIFO'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['IdMoneda'] ) ) $o_ALM_TransaccionDetalleBN->setIdMoneda( $a_ALM_TransaccionDetalle['IdMoneda'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['PrecioUnitario'] ) ) $o_ALM_TransaccionDetalleBN->setPrecioUnitario( ( float ) $a_ALM_TransaccionDetalle['PrecioUnitario'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['MontoTotal'] ) ) $o_ALM_TransaccionDetalleBN->setMontoTotal( ( float ) $a_ALM_TransaccionDetalle['MontoTotal'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['PrecioUnitarioDolares'] ) ) $o_ALM_TransaccionDetalleBN->setPrecioUnitarioDolares( ( float ) $a_ALM_TransaccionDetalle['PrecioUnitarioDolares'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['MontoTotalDolares'] ) ) $o_ALM_TransaccionDetalleBN->setMontoTotalDolares( ( float ) $a_ALM_TransaccionDetalle['MontoTotalDolares'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['ReferenciaCompaniaSocio'] ) ) $o_ALM_TransaccionDetalleBN->setReferenciaCompaniaSocio( $a_ALM_TransaccionDetalle['ReferenciaCompaniaSocio'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['ReferenciaTipoDocumento'] ) ) $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( $a_ALM_TransaccionDetalle['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['ReferenciaNumeroDocumento'] ) ) $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $a_ALM_TransaccionDetalle['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['ReferenciaSecuencia'] ) ) $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( ( integer ) $a_ALM_TransaccionDetalle['ReferenciaSecuencia'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['AprobacionTecnicaFlag'] ) ) $o_ALM_TransaccionDetalleBN->setAprobacionTecnicaFlag( $a_ALM_TransaccionDetalle['AprobacionTecnicaFlag'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['AprobacionTecnicaDocumento'] ) ) $o_ALM_TransaccionDetalleBN->setAprobacionTecnicaDocumento( $a_ALM_TransaccionDetalle['AprobacionTecnicaDocumento'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FallaFlag'] ) ) $o_ALM_TransaccionDetalleBN->setFallaFlag( $a_ALM_TransaccionDetalle['FallaFlag'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['Observaciones'] ) ) $o_ALM_TransaccionDetalleBN->setObservaciones( $a_ALM_TransaccionDetalle['Observaciones'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FacturadoFlag'] ) ) $o_ALM_TransaccionDetalleBN->setFacturadoFlag( $a_ALM_TransaccionDetalle['FacturadoFlag'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['ValorizacionExternaFlag'] ) ) $o_ALM_TransaccionDetalleBN->setValorizacionExternaFlag( $a_ALM_TransaccionDetalle['ValorizacionExternaFlag'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['LoteProduccion'] ) ) $o_ALM_TransaccionDetalleBN->setLoteProduccion( $a_ALM_TransaccionDetalle['LoteProduccion'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['UsuarioModificacion'] ) ) $o_ALM_TransaccionDetalleBN->setUsuarioModificacion( $a_ALM_TransaccionDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FechaModificacion'] ) ) $o_ALM_TransaccionDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionDetalle['UsuarioCreacion'] ) ) $o_ALM_TransaccionDetalleBN->setUsuarioCreacion( $a_ALM_TransaccionDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransaccionDetalle['FechaCreacion'] ) ) $o_ALM_TransaccionDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionDetalle['DescripcionItem'] ) ) $o_ALM_TransaccionDetalleBN->setDescripcionItem( $a_ALM_TransaccionDetalle['DescripcionItem'] );
        return $o_ALM_TransaccionDetalleBN;
    }
}
?>