<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransaccionCabecera.xml */
/* Generado: 2021-11-05 13:49:02 */

/* Busqueda de registros de la tabla ALM_TransaccionCabecera. */
abstract class BaseALM_TransaccionCabeceraFN extends ALM_TransaccionCabeceraBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_TransaccionCabecera.IdCompania";
    const IdSucursal = "ALM_TransaccionCabecera.IdSucursal";
    const IdTipoDocumento = "ALM_TransaccionCabecera.IdTipoDocumento";
    const IdNumeroDocumento = "ALM_TransaccionCabecera.IdNumeroDocumento";
    const IdTransaccion = "ALM_TransaccionCabecera.IdTransaccion";
    const AlmacenTraslado = "ALM_TransaccionCabecera.AlmacenTraslado";
    const IdAlmacen = "ALM_TransaccionCabecera.IdAlmacen";
    const IdTransaccionOperacion = "ALM_TransaccionCabecera.IdTransaccionOperacion";
    const FechaDocumento = "ALM_TransaccionCabecera.FechaDocumento";
    const TipodeCambio = "ALM_TransaccionCabecera.TipodeCambio";
    const MonedaCod = "ALM_TransaccionCabecera.MonedaCod";
    const Periodo = "ALM_TransaccionCabecera.Periodo";
    const PeriodoAnulacion = "ALM_TransaccionCabecera.PeriodoAnulacion";
    const Voucher = "ALM_TransaccionCabecera.Voucher";
    const CentroCostoConsumo = "ALM_TransaccionCabecera.CentroCostoConsumo";
    const ReferenciaTipoDocumento = "ALM_TransaccionCabecera.ReferenciaTipoDocumento";
    const ReferenciaNumeroDocumento = "ALM_TransaccionCabecera.ReferenciaNumeroDocumento";
    const GuiaProveedor = "ALM_TransaccionCabecera.GuiaProveedor";
    const ReferenciaNumeroInterno = "ALM_TransaccionCabecera.ReferenciaNumeroInterno";
    const ReferenciaInterno = "ALM_TransaccionCabecera.ReferenciaInterno";
    const Descripcion = "ALM_TransaccionCabecera.Descripcion";
    const IdProyecto = "ALM_TransaccionCabecera.IdProyecto";
    const CodigoCliente = "ALM_TransaccionCabecera.CodigoCliente";
    const CodigoProveedor = "ALM_TransaccionCabecera.CodigoProveedor";
    const TipoDocumentoFiscal = "ALM_TransaccionCabecera.TipoDocumentoFiscal";
    const SerieDocumentoFiscal = "ALM_TransaccionCabecera.SerieDocumentoFiscal";
    const NumeroDocumentoFiscal = "ALM_TransaccionCabecera.NumeroDocumentoFiscal";
    const Transportista = "ALM_TransaccionCabecera.Transportista";
    const ControlEstadoSerie = "ALM_TransaccionCabecera.ControlEstadoSerie";
    const MotivoDevolucion = "ALM_TransaccionCabecera.MotivoDevolucion";
    const UnidadNegocio = "ALM_TransaccionCabecera.UnidadNegocio";
    const UsuarioModificacion = "ALM_TransaccionCabecera.UsuarioModificacion";
    const FechaModificacion = "ALM_TransaccionCabecera.FechaModificacion";
    const UsuarioCreacion = "ALM_TransaccionCabecera.UsuarioCreacion";
    const FechaCreacion = "ALM_TransaccionCabecera.FechaCreacion";
    const CompaniaDescripcion = "ALM_TransaccionCabecera.CompaniaDescripcion";
    const Comentario = "ALM_TransaccionCabecera.Comentario";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransaccionCabecera.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.AlmacenTraslado AS AlmacenTraslado, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdTransaccionOperacion AS IdTransaccionOperacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.FechaDocumento AS FechaDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.TipodeCambio AS TipodeCambio, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.MonedaCod AS MonedaCod, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.Periodo AS Periodo, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.PeriodoAnulacion AS PeriodoAnulacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.Voucher AS Voucher, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.CentroCostoConsumo AS CentroCostoConsumo, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.GuiaProveedor AS GuiaProveedor, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaNumeroInterno AS ReferenciaNumeroInterno, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaInterno AS ReferenciaInterno, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.CodigoCliente AS CodigoCliente, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.CodigoProveedor AS CodigoProveedor, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.TipoDocumentoFiscal AS TipoDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.SerieDocumentoFiscal AS SerieDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.NumeroDocumentoFiscal AS NumeroDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.Transportista AS Transportista, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.ControlEstadoSerie AS ControlEstadoSerie, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.MotivoDevolucion AS MotivoDevolucion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.UnidadNegocio AS UnidadNegocio, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.CompaniaDescripcion AS CompaniaDescripcion, ";
        $s_SQLQuery .= "ALM_TransaccionCabecera.Comentario AS Comentario ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransaccionCabeceraBN */
    public function setByBN( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_TransaccionCabeceraBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() ) )
        {
            $this->setAlmacenTraslado( $o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() ) )
        {
            $this->setIdTransaccionOperacion( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_ALM_TransaccionCabeceraBN->getFechaDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getTipodeCambio() ) )
        {
            $this->setTipodeCambio( $o_ALM_TransaccionCabeceraBN->getTipodeCambio() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getMonedaCod() ) )
        {
            $this->setMonedaCod( $o_ALM_TransaccionCabeceraBN->getMonedaCod() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_ALM_TransaccionCabeceraBN->getPeriodo() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getPeriodoAnulacion() ) )
        {
            $this->setPeriodoAnulacion( $o_ALM_TransaccionCabeceraBN->getPeriodoAnulacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getVoucher() ) )
        {
            $this->setVoucher( $o_ALM_TransaccionCabeceraBN->getVoucher() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getCentroCostoConsumo() ) )
        {
            $this->setCentroCostoConsumo( $o_ALM_TransaccionCabeceraBN->getCentroCostoConsumo() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getGuiaProveedor() ) )
        {
            $this->setGuiaProveedor( $o_ALM_TransaccionCabeceraBN->getGuiaProveedor() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroInterno() ) )
        {
            $this->setReferenciaNumeroInterno( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroInterno() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getReferenciaInterno() ) )
        {
            $this->setReferenciaInterno( $o_ALM_TransaccionCabeceraBN->getReferenciaInterno() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_TransaccionCabeceraBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_ALM_TransaccionCabeceraBN->getIdProyecto() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() ) )
        {
            $this->setCodigoCliente( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() ) )
        {
            $this->setCodigoProveedor( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() ) )
        {
            $this->setTipoDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() ) )
        {
            $this->setSerieDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() ) )
        {
            $this->setNumeroDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getTransportista() ) )
        {
            $this->setTransportista( $o_ALM_TransaccionCabeceraBN->getTransportista() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getControlEstadoSerie() ) )
        {
            $this->setControlEstadoSerie( $o_ALM_TransaccionCabeceraBN->getControlEstadoSerie() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getMotivoDevolucion() ) )
        {
            $this->setMotivoDevolucion( $o_ALM_TransaccionCabeceraBN->getMotivoDevolucion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getUnidadNegocio() ) )
        {
            $this->setUnidadNegocio( $o_ALM_TransaccionCabeceraBN->getUnidadNegocio() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransaccionCabeceraBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransaccionCabeceraBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransaccionCabeceraBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransaccionCabeceraBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getCompaniaDescripcion() ) )
        {
            $this->setCompaniaDescripcion( $o_ALM_TransaccionCabeceraBN->getCompaniaDescripcion() );
        }
        if ( !is_null( $o_ALM_TransaccionCabeceraBN->getComentario() ) )
        {
            $this->setComentario( $o_ALM_TransaccionCabeceraBN->getComentario() );
        }
    }

    /**
    * @return ALM_TransaccionCabeceraBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdTipoDocumento, $s_IdNumeroDocumento )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
        if( is_null( $s_IdNumeroDocumento ) ){ $s_IdNumeroDocumento = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionCabecera ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "AND IdNumeroDocumento = '".$s_IdNumeroDocumento."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_TransaccionCabeceraBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransaccionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransaccionCabeceraBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getAlmacenTraslado() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.AlmacenTraslado = '".$this->getAlmacenTraslado()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdTransaccionOperacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdTransaccionOperacion = '".$this->getIdTransaccionOperacion()."' AND ";
        if ( !is_null( $this->getFechaDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.FechaDocumento = '".$this->getFechaDocumento()."' AND ";
        if ( !is_null( $this->getTipodeCambio() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.TipodeCambio = ".$this->getTipodeCambio()." AND ";
        if ( !is_null( $this->getMonedaCod() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.MonedaCod = '".$this->getMonedaCod()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getPeriodoAnulacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.PeriodoAnulacion = '".$this->getPeriodoAnulacion()."' AND ";
        if ( !is_null( $this->getVoucher() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.Voucher = '".$this->getVoucher()."' AND ";
        if ( !is_null( $this->getCentroCostoConsumo() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.CentroCostoConsumo = '".$this->getCentroCostoConsumo()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getGuiaProveedor() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.GuiaProveedor = '".$this->getGuiaProveedor()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroInterno() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaNumeroInterno = '".$this->getReferenciaNumeroInterno()."' AND ";
        if ( !is_null( $this->getReferenciaInterno() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.ReferenciaInterno = '".$this->getReferenciaInterno()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getCodigoCliente() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.CodigoCliente = '".$this->getCodigoCliente()."' AND ";
        if ( !is_null( $this->getCodigoProveedor() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.CodigoProveedor = '".$this->getCodigoProveedor()."' AND ";
        if ( !is_null( $this->getTipoDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.TipoDocumentoFiscal = '".$this->getTipoDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getSerieDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.SerieDocumentoFiscal = '".$this->getSerieDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getNumeroDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.NumeroDocumentoFiscal = '".$this->getNumeroDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getTransportista() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.Transportista = ".$this->getTransportista()." AND ";
        if ( !is_null( $this->getControlEstadoSerie() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.ControlEstadoSerie = '".$this->getControlEstadoSerie()."' AND ";
        if ( !is_null( $this->getMotivoDevolucion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.MotivoDevolucion = '".$this->getMotivoDevolucion()."' AND ";
        if ( !is_null( $this->getUnidadNegocio() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.UnidadNegocio = '".$this->getUnidadNegocio()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getCompaniaDescripcion() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.CompaniaDescripcion = '".$this->getCompaniaDescripcion()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "ALM_TransaccionCabecera.Comentario = '".$this->getComentario()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransaccionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransaccionCabeceraBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransaccionCabecera WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_TransaccionCabeceraBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransaccionCabeceraBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransaccionCabeceraBN[] = $o_ALM_TransaccionCabeceraBN;
            }
        }
        return $a_ALM_TransaccionCabeceraBN;
    }

    /* Devuelve un objeto ALM_TransaccionCabeceraBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransaccionCabecera )
    {
        $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
        if ( !is_null( $a_ALM_TransaccionCabecera['IdCompania'] ) ) $o_ALM_TransaccionCabeceraBN->setIdCompania( ( integer ) $a_ALM_TransaccionCabecera['IdCompania'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdSucursal'] ) ) $o_ALM_TransaccionCabeceraBN->setIdSucursal( ( integer ) $a_ALM_TransaccionCabecera['IdSucursal'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdTipoDocumento'] ) ) $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $a_ALM_TransaccionCabecera['IdTipoDocumento'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdNumeroDocumento'] ) ) $o_ALM_TransaccionCabeceraBN->setIdNumeroDocumento( $a_ALM_TransaccionCabecera['IdNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdTransaccion'] ) ) $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $a_ALM_TransaccionCabecera['IdTransaccion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['AlmacenTraslado'] ) ) $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $a_ALM_TransaccionCabecera['AlmacenTraslado'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdAlmacen'] ) ) $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $a_ALM_TransaccionCabecera['IdAlmacen'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdTransaccionOperacion'] ) ) $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $a_ALM_TransaccionCabecera['IdTransaccionOperacion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['FechaDocumento'] ) ) $o_ALM_TransaccionCabeceraBN->setFechaDocumento( utilTimestamp::getTimestamp( $a_ALM_TransaccionCabecera['FechaDocumento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionCabecera['TipodeCambio'] ) ) $o_ALM_TransaccionCabeceraBN->setTipodeCambio( ( float ) $a_ALM_TransaccionCabecera['TipodeCambio'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['MonedaCod'] ) ) $o_ALM_TransaccionCabeceraBN->setMonedaCod( $a_ALM_TransaccionCabecera['MonedaCod'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['Periodo'] ) ) $o_ALM_TransaccionCabeceraBN->setPeriodo( $a_ALM_TransaccionCabecera['Periodo'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['PeriodoAnulacion'] ) ) $o_ALM_TransaccionCabeceraBN->setPeriodoAnulacion( $a_ALM_TransaccionCabecera['PeriodoAnulacion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['Voucher'] ) ) $o_ALM_TransaccionCabeceraBN->setVoucher( $a_ALM_TransaccionCabecera['Voucher'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['CentroCostoConsumo'] ) ) $o_ALM_TransaccionCabeceraBN->setCentroCostoConsumo( $a_ALM_TransaccionCabecera['CentroCostoConsumo'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['ReferenciaTipoDocumento'] ) ) $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $a_ALM_TransaccionCabecera['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['ReferenciaNumeroDocumento'] ) ) $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $a_ALM_TransaccionCabecera['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['GuiaProveedor'] ) ) $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $a_ALM_TransaccionCabecera['GuiaProveedor'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['ReferenciaNumeroInterno'] ) ) $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroInterno( $a_ALM_TransaccionCabecera['ReferenciaNumeroInterno'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['ReferenciaInterno'] ) ) $o_ALM_TransaccionCabeceraBN->setReferenciaInterno( $a_ALM_TransaccionCabecera['ReferenciaInterno'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['Descripcion'] ) ) $o_ALM_TransaccionCabeceraBN->setDescripcion( $a_ALM_TransaccionCabecera['Descripcion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['IdProyecto'] ) ) $o_ALM_TransaccionCabeceraBN->setIdProyecto( ( integer ) $a_ALM_TransaccionCabecera['IdProyecto'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['CodigoCliente'] ) ) $o_ALM_TransaccionCabeceraBN->setCodigoCliente( $a_ALM_TransaccionCabecera['CodigoCliente'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['CodigoProveedor'] ) ) $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( $a_ALM_TransaccionCabecera['CodigoProveedor'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['TipoDocumentoFiscal'] ) ) $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $a_ALM_TransaccionCabecera['TipoDocumentoFiscal'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['SerieDocumentoFiscal'] ) ) $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $a_ALM_TransaccionCabecera['SerieDocumentoFiscal'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['NumeroDocumentoFiscal'] ) ) $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $a_ALM_TransaccionCabecera['NumeroDocumentoFiscal'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['Transportista'] ) ) $o_ALM_TransaccionCabeceraBN->setTransportista( ( integer ) $a_ALM_TransaccionCabecera['Transportista'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['ControlEstadoSerie'] ) ) $o_ALM_TransaccionCabeceraBN->setControlEstadoSerie( $a_ALM_TransaccionCabecera['ControlEstadoSerie'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['MotivoDevolucion'] ) ) $o_ALM_TransaccionCabeceraBN->setMotivoDevolucion( $a_ALM_TransaccionCabecera['MotivoDevolucion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['UnidadNegocio'] ) ) $o_ALM_TransaccionCabeceraBN->setUnidadNegocio( $a_ALM_TransaccionCabecera['UnidadNegocio'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['UsuarioModificacion'] ) ) $o_ALM_TransaccionCabeceraBN->setUsuarioModificacion( $a_ALM_TransaccionCabecera['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['FechaModificacion'] ) ) $o_ALM_TransaccionCabeceraBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionCabecera['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionCabecera['UsuarioCreacion'] ) ) $o_ALM_TransaccionCabeceraBN->setUsuarioCreacion( $a_ALM_TransaccionCabecera['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['FechaCreacion'] ) ) $o_ALM_TransaccionCabeceraBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransaccionCabecera['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransaccionCabecera['CompaniaDescripcion'] ) ) $o_ALM_TransaccionCabeceraBN->setCompaniaDescripcion( $a_ALM_TransaccionCabecera['CompaniaDescripcion'] );
        if ( !is_null( $a_ALM_TransaccionCabecera['Comentario'] ) ) $o_ALM_TransaccionCabeceraBN->setComentario( $a_ALM_TransaccionCabecera['Comentario'] );
        return $o_ALM_TransaccionCabeceraBN;
    }
}
?>