<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransParaRepInv.xml */
/* Generado: 2021-06-25 23:59:43 */

/* Busqueda de registros de la tabla ALM_TransParaRepInv. */
abstract class BaseALM_TransParaRepInvFN extends ALM_TransParaRepInvBN
{
    /* Declaracion de constantes */
    const IdTrx = "ALM_TransParaRepInv.IdTrx";
    const IdCompania = "ALM_TransParaRepInv.IdCompania";
    const IdSucursal = "ALM_TransParaRepInv.IdSucursal";
    const IdNumeroDocumento = "ALM_TransParaRepInv.IdNumeroDocumento";
    const IdTransaccion = "ALM_TransParaRepInv.IdTransaccion";
    const IdAlmacen = "ALM_TransParaRepInv.IdAlmacen";
    const FechaDocumento = "ALM_TransParaRepInv.FechaDocumento";
    const FechaDocumentoOriginal = "ALM_TransParaRepInv.FechaDocumentoOriginal";
    const ReferenciaTipoDocumento = "ALM_TransParaRepInv.ReferenciaTipoDocumento";
    const ReferenciaNumeroDocumento = "ALM_TransParaRepInv.ReferenciaNumeroDocumento";
    const ReferenciaTipoDocumentoOriginal = "ALM_TransParaRepInv.ReferenciaTipoDocumentoOriginal";
    const ReferenciaNumeroDocumentoOriginal = "ALM_TransParaRepInv.ReferenciaNumeroDocumentoOriginal";
    const IdItem = "ALM_TransParaRepInv.IdItem";
    const IdLote = "ALM_TransParaRepInv.IdLote";
    const IdSecuencia = "ALM_TransParaRepInv.IdSecuencia";
    const CantOriginal = "ALM_TransParaRepInv.CantOriginal";
    const CantEvaluada = "ALM_TransParaRepInv.CantEvaluada";
    const CantSaldo = "ALM_TransParaRepInv.CantSaldo";
    const StockFisico = "ALM_TransParaRepInv.StockFisico";
    const DiasCalculado = "ALM_TransParaRepInv.DiasCalculado";
    const UsuarioCreacion = "ALM_TransParaRepInv.UsuarioCreacion";
    const FechaCreacion = "ALM_TransParaRepInv.FechaCreacion";
    const UsuarioModificacion = "ALM_TransParaRepInv.UsuarioModificacion";
    const FechaModificacion = "ALM_TransParaRepInv.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_TransParaRepInv.IdTrx AS IdTrx, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdNumeroDocumento AS IdNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.FechaDocumento AS FechaDocumento, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.FechaDocumentoOriginal AS FechaDocumentoOriginal, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaTipoDocumentoOriginal AS ReferenciaTipoDocumentoOriginal, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaNumeroDocumentoOriginal AS ReferenciaNumeroDocumentoOriginal, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.CantOriginal AS CantOriginal, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.CantEvaluada AS CantEvaluada, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.CantSaldo AS CantSaldo, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.StockFisico AS StockFisico, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.DiasCalculado AS DiasCalculado, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_TransParaRepInv.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_TransParaRepInvBN */
    public function setByBN( ALM_TransParaRepInvBN $o_ALM_TransParaRepInvBN )
    {
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdTrx() ) )
        {
            $this->setIdTrx( $o_ALM_TransParaRepInvBN->getIdTrx() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_TransParaRepInvBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_TransParaRepInvBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdNumeroDocumento() ) )
        {
            $this->setIdNumeroDocumento( $o_ALM_TransParaRepInvBN->getIdNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_ALM_TransParaRepInvBN->getIdTransaccion() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_TransParaRepInvBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_ALM_TransParaRepInvBN->getFechaDocumento() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getFechaDocumentoOriginal() ) )
        {
            $this->setFechaDocumentoOriginal( $o_ALM_TransParaRepInvBN->getFechaDocumentoOriginal() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_TransParaRepInvBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumentoOriginal() ) )
        {
            $this->setReferenciaTipoDocumentoOriginal( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumentoOriginal() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getReferenciaNumeroDocumentoOriginal() ) )
        {
            $this->setReferenciaNumeroDocumentoOriginal( $o_ALM_TransParaRepInvBN->getReferenciaNumeroDocumentoOriginal() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_TransParaRepInvBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_TransParaRepInvBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_TransParaRepInvBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getCantOriginal() ) )
        {
            $this->setCantOriginal( $o_ALM_TransParaRepInvBN->getCantOriginal() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getCantEvaluada() ) )
        {
            $this->setCantEvaluada( $o_ALM_TransParaRepInvBN->getCantEvaluada() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getCantSaldo() ) )
        {
            $this->setCantSaldo( $o_ALM_TransParaRepInvBN->getCantSaldo() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_TransParaRepInvBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getDiasCalculado() ) )
        {
            $this->setDiasCalculado( $o_ALM_TransParaRepInvBN->getDiasCalculado() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TransParaRepInvBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TransParaRepInvBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TransParaRepInvBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_TransParaRepInvBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TransParaRepInvBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_TransParaRepInvBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTrx )
    {
        if( is_null( $i_IdTrx ) ){ $i_IdTrx = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransParaRepInv ";
        $s_SQLQuery .= "WHERE IdTrx = ".$i_IdTrx." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_TransParaRepInvBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_TransParaRepInvBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_TransParaRepInvBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTrx() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdTrx = ".$this->getIdTrx()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdNumeroDocumento = '".$this->getIdNumeroDocumento()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getFechaDocumento() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.FechaDocumento = '".$this->getFechaDocumento()."' AND ";
        if ( !is_null( $this->getFechaDocumentoOriginal() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.FechaDocumentoOriginal = '".$this->getFechaDocumentoOriginal()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumentoOriginal() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaTipoDocumentoOriginal = '".$this->getReferenciaTipoDocumentoOriginal()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumentoOriginal() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.ReferenciaNumeroDocumentoOriginal = '".$this->getReferenciaNumeroDocumentoOriginal()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getCantOriginal() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.CantOriginal = ".$this->getCantOriginal()." AND ";
        if ( !is_null( $this->getCantEvaluada() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.CantEvaluada = ".$this->getCantEvaluada()." AND ";
        if ( !is_null( $this->getCantSaldo() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.CantSaldo = ".$this->getCantSaldo()." AND ";
        if ( !is_null( $this->getStockFisico() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.StockFisico = ".$this->getStockFisico()." AND ";
        if ( !is_null( $this->getDiasCalculado() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.DiasCalculado = ".$this->getDiasCalculado()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_TransParaRepInv.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_TransParaRepInv WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_TransParaRepInvBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_TransParaRepInv WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_TransParaRepInvBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_TransParaRepInvBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_TransParaRepInvBN[] = $o_ALM_TransParaRepInvBN;
            }
        }
        return $a_ALM_TransParaRepInvBN;
    }

    /* Devuelve un objeto ALM_TransParaRepInvBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_TransParaRepInv )
    {
        $o_ALM_TransParaRepInvBN = new ALM_TransParaRepInvBN();
        if ( !is_null( $a_ALM_TransParaRepInv['IdTrx'] ) ) $o_ALM_TransParaRepInvBN->setIdTrx( ( integer ) $a_ALM_TransParaRepInv['IdTrx'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdCompania'] ) ) $o_ALM_TransParaRepInvBN->setIdCompania( ( integer ) $a_ALM_TransParaRepInv['IdCompania'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdSucursal'] ) ) $o_ALM_TransParaRepInvBN->setIdSucursal( ( integer ) $a_ALM_TransParaRepInv['IdSucursal'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdNumeroDocumento'] ) ) $o_ALM_TransParaRepInvBN->setIdNumeroDocumento( $a_ALM_TransParaRepInv['IdNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdTransaccion'] ) ) $o_ALM_TransParaRepInvBN->setIdTransaccion( $a_ALM_TransParaRepInv['IdTransaccion'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdAlmacen'] ) ) $o_ALM_TransParaRepInvBN->setIdAlmacen( $a_ALM_TransParaRepInv['IdAlmacen'] );
        if ( !is_null( $a_ALM_TransParaRepInv['FechaDocumento'] ) ) $o_ALM_TransParaRepInvBN->setFechaDocumento( utilTimestamp::getTimestamp( $a_ALM_TransParaRepInv['FechaDocumento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransParaRepInv['FechaDocumentoOriginal'] ) ) $o_ALM_TransParaRepInvBN->setFechaDocumentoOriginal( utilTimestamp::getTimestamp( $a_ALM_TransParaRepInv['FechaDocumentoOriginal'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransParaRepInv['ReferenciaTipoDocumento'] ) ) $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumento( $a_ALM_TransParaRepInv['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_TransParaRepInv['ReferenciaNumeroDocumento'] ) ) $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumento( $a_ALM_TransParaRepInv['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_TransParaRepInv['ReferenciaTipoDocumentoOriginal'] ) ) $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumentoOriginal( $a_ALM_TransParaRepInv['ReferenciaTipoDocumentoOriginal'] );
        if ( !is_null( $a_ALM_TransParaRepInv['ReferenciaNumeroDocumentoOriginal'] ) ) $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumentoOriginal( $a_ALM_TransParaRepInv['ReferenciaNumeroDocumentoOriginal'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdItem'] ) ) $o_ALM_TransParaRepInvBN->setIdItem( $a_ALM_TransParaRepInv['IdItem'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdLote'] ) ) $o_ALM_TransParaRepInvBN->setIdLote( $a_ALM_TransParaRepInv['IdLote'] );
        if ( !is_null( $a_ALM_TransParaRepInv['IdSecuencia'] ) ) $o_ALM_TransParaRepInvBN->setIdSecuencia( ( integer ) $a_ALM_TransParaRepInv['IdSecuencia'] );
        if ( !is_null( $a_ALM_TransParaRepInv['CantOriginal'] ) ) $o_ALM_TransParaRepInvBN->setCantOriginal( ( float ) $a_ALM_TransParaRepInv['CantOriginal'] );
        if ( !is_null( $a_ALM_TransParaRepInv['CantEvaluada'] ) ) $o_ALM_TransParaRepInvBN->setCantEvaluada( ( float ) $a_ALM_TransParaRepInv['CantEvaluada'] );
        if ( !is_null( $a_ALM_TransParaRepInv['CantSaldo'] ) ) $o_ALM_TransParaRepInvBN->setCantSaldo( ( float ) $a_ALM_TransParaRepInv['CantSaldo'] );
        if ( !is_null( $a_ALM_TransParaRepInv['StockFisico'] ) ) $o_ALM_TransParaRepInvBN->setStockFisico( ( float ) $a_ALM_TransParaRepInv['StockFisico'] );
        if ( !is_null( $a_ALM_TransParaRepInv['DiasCalculado'] ) ) $o_ALM_TransParaRepInvBN->setDiasCalculado( ( integer ) $a_ALM_TransParaRepInv['DiasCalculado'] );
        if ( !is_null( $a_ALM_TransParaRepInv['UsuarioCreacion'] ) ) $o_ALM_TransParaRepInvBN->setUsuarioCreacion( $a_ALM_TransParaRepInv['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_TransParaRepInv['FechaCreacion'] ) ) $o_ALM_TransParaRepInvBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_TransParaRepInv['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_TransParaRepInv['UsuarioModificacion'] ) ) $o_ALM_TransParaRepInvBN->setUsuarioModificacion( $a_ALM_TransParaRepInv['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_TransParaRepInv['FechaModificacion'] ) ) $o_ALM_TransParaRepInvBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_TransParaRepInv['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_TransParaRepInvBN;
    }
}
?>