<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ReservaItemStock.xml */
/* Generado: 2021-06-25 23:59:43 */

/* Busqueda de registros de la tabla ALM_ReservaItemStock. */
abstract class BaseALM_ReservaItemStockFN extends ALM_ReservaItemStockBN
{
    /* Declaracion de constantes */
    const ReservaId = "ALM_ReservaItemStock.ReservaId";
    const IdCompania = "ALM_ReservaItemStock.IdCompania";
    const IdSucursal = "ALM_ReservaItemStock.IdSucursal";
    const IdAlmacen = "ALM_ReservaItemStock.IdAlmacen";
    const IdItem = "ALM_ReservaItemStock.IdItem";
    const IdLote = "ALM_ReservaItemStock.IdLote";
    const TipoOperacion = "ALM_ReservaItemStock.TipoOperacion";
    const ReservaDocTipo = "ALM_ReservaItemStock.ReservaDocTipo";
    const ReservaDocNumero = "ALM_ReservaItemStock.ReservaDocNumero";
    const ReservaRefNumero = "ALM_ReservaItemStock.ReservaRefNumero";
    const ReservaSecuencia = "ALM_ReservaItemStock.ReservaSecuencia";
    const ReservaCantidad = "ALM_ReservaItemStock.ReservaCantidad";
    const UsuarioCreacion = "ALM_ReservaItemStock.UsuarioCreacion";
    const FechaCreacion = "ALM_ReservaItemStock.FechaCreacion";
    const UsuarioActualizacion = "ALM_ReservaItemStock.UsuarioActualizacion";
    const FechaActualizacion = "ALM_ReservaItemStock.FechaActualizacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ReservaItemStock.ReservaId AS ReservaId, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.TipoOperacion AS TipoOperacion, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.ReservaDocTipo AS ReservaDocTipo, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.ReservaDocNumero AS ReservaDocNumero, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.ReservaRefNumero AS ReservaRefNumero, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.ReservaSecuencia AS ReservaSecuencia, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.ReservaCantidad AS ReservaCantidad, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.UsuarioActualizacion AS UsuarioActualizacion, ";
        $s_SQLQuery .= "ALM_ReservaItemStock.FechaActualizacion AS FechaActualizacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ReservaItemStockBN */
    public function setByBN( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaId() ) )
        {
            $this->setReservaId( $o_ALM_ReservaItemStockBN->getReservaId() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ReservaItemStockBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_ReservaItemStockBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ReservaItemStockBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ReservaItemStockBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_ReservaItemStockBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getTipoOperacion() ) )
        {
            $this->setTipoOperacion( $o_ALM_ReservaItemStockBN->getTipoOperacion() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaDocTipo() ) )
        {
            $this->setReservaDocTipo( $o_ALM_ReservaItemStockBN->getReservaDocTipo() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaDocNumero() ) )
        {
            $this->setReservaDocNumero( $o_ALM_ReservaItemStockBN->getReservaDocNumero() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaRefNumero() ) )
        {
            $this->setReservaRefNumero( $o_ALM_ReservaItemStockBN->getReservaRefNumero() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaSecuencia() ) )
        {
            $this->setReservaSecuencia( $o_ALM_ReservaItemStockBN->getReservaSecuencia() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getReservaCantidad() ) )
        {
            $this->setReservaCantidad( $o_ALM_ReservaItemStockBN->getReservaCantidad() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ReservaItemStockBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ReservaItemStockBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getUsuarioActualizacion() ) )
        {
            $this->setUsuarioActualizacion( $o_ALM_ReservaItemStockBN->getUsuarioActualizacion() );
        }
        if ( !is_null( $o_ALM_ReservaItemStockBN->getFechaActualizacion() ) )
        {
            $this->setFechaActualizacion( $o_ALM_ReservaItemStockBN->getFechaActualizacion() );
        }
    }

    /**
    * @return ALM_ReservaItemStockBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_ReservaId )
    {
        if( is_null( $i_ReservaId ) ){ $i_ReservaId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ReservaItemStock ";
        $s_SQLQuery .= "WHERE ReservaId = ".$i_ReservaId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_ReservaItemStockBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ReservaItemStockBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ReservaItemStockBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getReservaId() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaId = ".$this->getReservaId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getTipoOperacion() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.TipoOperacion = '".$this->getTipoOperacion()."' AND ";
        if ( !is_null( $this->getReservaDocTipo() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaDocTipo = '".$this->getReservaDocTipo()."' AND ";
        if ( !is_null( $this->getReservaDocNumero() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaDocNumero = '".$this->getReservaDocNumero()."' AND ";
        if ( !is_null( $this->getReservaRefNumero() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaRefNumero = '".$this->getReservaRefNumero()."' AND ";
        if ( !is_null( $this->getReservaSecuencia() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaSecuencia = ".$this->getReservaSecuencia()." AND ";
        if ( !is_null( $this->getReservaCantidad() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.ReservaCantidad = ".$this->getReservaCantidad()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioActualizacion() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.UsuarioActualizacion = '".$this->getUsuarioActualizacion()."' AND ";
        if ( !is_null( $this->getFechaActualizacion() ) ) $s_SQLQuery .= "ALM_ReservaItemStock.FechaActualizacion = '".$this->getFechaActualizacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ReservaItemStock WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ReservaItemStockBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ReservaItemStock WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_ReservaItemStockBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ReservaItemStockBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ReservaItemStockBN[] = $o_ALM_ReservaItemStockBN;
            }
        }
        return $a_ALM_ReservaItemStockBN;
    }

    /* Devuelve un objeto ALM_ReservaItemStockBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ReservaItemStock )
    {
        $o_ALM_ReservaItemStockBN = new ALM_ReservaItemStockBN();
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaId'] ) ) $o_ALM_ReservaItemStockBN->setReservaId( ( integer ) $a_ALM_ReservaItemStock['ReservaId'] );
        if ( !is_null( $a_ALM_ReservaItemStock['IdCompania'] ) ) $o_ALM_ReservaItemStockBN->setIdCompania( ( integer ) $a_ALM_ReservaItemStock['IdCompania'] );
        if ( !is_null( $a_ALM_ReservaItemStock['IdSucursal'] ) ) $o_ALM_ReservaItemStockBN->setIdSucursal( ( integer ) $a_ALM_ReservaItemStock['IdSucursal'] );
        if ( !is_null( $a_ALM_ReservaItemStock['IdAlmacen'] ) ) $o_ALM_ReservaItemStockBN->setIdAlmacen( $a_ALM_ReservaItemStock['IdAlmacen'] );
        if ( !is_null( $a_ALM_ReservaItemStock['IdItem'] ) ) $o_ALM_ReservaItemStockBN->setIdItem( $a_ALM_ReservaItemStock['IdItem'] );
        if ( !is_null( $a_ALM_ReservaItemStock['IdLote'] ) ) $o_ALM_ReservaItemStockBN->setIdLote( $a_ALM_ReservaItemStock['IdLote'] );
        if ( !is_null( $a_ALM_ReservaItemStock['TipoOperacion'] ) ) $o_ALM_ReservaItemStockBN->setTipoOperacion( $a_ALM_ReservaItemStock['TipoOperacion'] );
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaDocTipo'] ) ) $o_ALM_ReservaItemStockBN->setReservaDocTipo( $a_ALM_ReservaItemStock['ReservaDocTipo'] );
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaDocNumero'] ) ) $o_ALM_ReservaItemStockBN->setReservaDocNumero( $a_ALM_ReservaItemStock['ReservaDocNumero'] );
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaRefNumero'] ) ) $o_ALM_ReservaItemStockBN->setReservaRefNumero( $a_ALM_ReservaItemStock['ReservaRefNumero'] );
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaSecuencia'] ) ) $o_ALM_ReservaItemStockBN->setReservaSecuencia( ( integer ) $a_ALM_ReservaItemStock['ReservaSecuencia'] );
        if ( !is_null( $a_ALM_ReservaItemStock['ReservaCantidad'] ) ) $o_ALM_ReservaItemStockBN->setReservaCantidad( ( float ) $a_ALM_ReservaItemStock['ReservaCantidad'] );
        if ( !is_null( $a_ALM_ReservaItemStock['UsuarioCreacion'] ) ) $o_ALM_ReservaItemStockBN->setUsuarioCreacion( $a_ALM_ReservaItemStock['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ReservaItemStock['FechaCreacion'] ) ) $o_ALM_ReservaItemStockBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ReservaItemStock['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ReservaItemStock['UsuarioActualizacion'] ) ) $o_ALM_ReservaItemStockBN->setUsuarioActualizacion( $a_ALM_ReservaItemStock['UsuarioActualizacion'] );
        if ( !is_null( $a_ALM_ReservaItemStock['FechaActualizacion'] ) ) $o_ALM_ReservaItemStockBN->setFechaActualizacion( utilTimestamp::getTimestamp( $a_ALM_ReservaItemStock['FechaActualizacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_ReservaItemStockBN;
    }
}
?>