<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_RequerimientoDetalleLote.xml */
/* Generado: 2021-06-25 23:59:43 */

/* Busqueda de registros de la tabla ALM_RequerimientoDetalleLote. */
abstract class BaseALM_RequerimientoDetalleLoteFN extends ALM_RequerimientoDetalleLoteBN
{
    /* Declaracion de constantes */
    const IdRequerimientoDetalleLote = "ALM_RequerimientoDetalleLote.IdRequerimientoDetalleLote";
    const IdRequerimientoDetalle = "ALM_RequerimientoDetalleLote.IdRequerimientoDetalle";
    const IdLote = "ALM_RequerimientoDetalleLote.IdLote";
    const FechaVencimiento = "ALM_RequerimientoDetalleLote.FechaVencimiento";
    const Cantidad = "ALM_RequerimientoDetalleLote.Cantidad";
    const FechaCreacion = "ALM_RequerimientoDetalleLote.FechaCreacion";
    const UsuarioCreacion = "ALM_RequerimientoDetalleLote.UsuarioCreacion";
    const FechaModificacion = "ALM_RequerimientoDetalleLote.FechaModificacion";
    const UsuarioModificacion = "ALM_RequerimientoDetalleLote.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_RequerimientoDetalleLote.IdRequerimientoDetalleLote AS IdRequerimientoDetalleLote, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.IdRequerimientoDetalle AS IdRequerimientoDetalle, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_RequerimientoDetalleLote.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_RequerimientoDetalleLoteBN */
    public function setByBN( ALM_RequerimientoDetalleLoteBN $o_ALM_RequerimientoDetalleLoteBN )
    {
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getIdRequerimientoDetalleLote() ) )
        {
            $this->setIdRequerimientoDetalleLote( $o_ALM_RequerimientoDetalleLoteBN->getIdRequerimientoDetalleLote() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getIdRequerimientoDetalle() ) )
        {
            $this->setIdRequerimientoDetalle( $o_ALM_RequerimientoDetalleLoteBN->getIdRequerimientoDetalle() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_RequerimientoDetalleLoteBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_RequerimientoDetalleLoteBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_RequerimientoDetalleLoteBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_RequerimientoDetalleLoteBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_RequerimientoDetalleLoteBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_RequerimientoDetalleLoteBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_RequerimientoDetalleLoteBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_RequerimientoDetalleLoteBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_RequerimientoDetalleLoteBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdRequerimientoDetalleLote )
    {
        if( is_null( $i_IdRequerimientoDetalleLote ) ){ $i_IdRequerimientoDetalleLote = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalleLote ";
        $s_SQLQuery .= "WHERE IdRequerimientoDetalleLote = ".$i_IdRequerimientoDetalleLote." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_RequerimientoDetalleLoteBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_RequerimientoDetalleLoteBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_RequerimientoDetalleLoteBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRequerimientoDetalleLote() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.IdRequerimientoDetalleLote = ".$this->getIdRequerimientoDetalleLote()." AND ";
        if ( !is_null( $this->getIdRequerimientoDetalle() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.IdRequerimientoDetalle = ".$this->getIdRequerimientoDetalle()." AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_RequerimientoDetalleLote.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalleLote WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_RequerimientoDetalleLoteBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_RequerimientoDetalleLote WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_RequerimientoDetalleLoteBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_RequerimientoDetalleLoteBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_RequerimientoDetalleLoteBN[] = $o_ALM_RequerimientoDetalleLoteBN;
            }
        }
        return $a_ALM_RequerimientoDetalleLoteBN;
    }

    /* Devuelve un objeto ALM_RequerimientoDetalleLoteBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_RequerimientoDetalleLote )
    {
        $o_ALM_RequerimientoDetalleLoteBN = new ALM_RequerimientoDetalleLoteBN();
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['IdRequerimientoDetalleLote'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setIdRequerimientoDetalleLote( ( integer ) $a_ALM_RequerimientoDetalleLote['IdRequerimientoDetalleLote'] );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['IdRequerimientoDetalle'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setIdRequerimientoDetalle( ( integer ) $a_ALM_RequerimientoDetalleLote['IdRequerimientoDetalle'] );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['IdLote'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setIdLote( $a_ALM_RequerimientoDetalleLote['IdLote'] );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['FechaVencimiento'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalleLote['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['Cantidad'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setCantidad( ( float ) $a_ALM_RequerimientoDetalleLote['Cantidad'] );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['FechaCreacion'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalleLote['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['UsuarioCreacion'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setUsuarioCreacion( $a_ALM_RequerimientoDetalleLote['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['FechaModificacion'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_RequerimientoDetalleLote['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_RequerimientoDetalleLote['UsuarioModificacion'] ) ) $o_ALM_RequerimientoDetalleLoteBN->setUsuarioModificacion( $a_ALM_RequerimientoDetalleLote['UsuarioModificacion'] );
        return $o_ALM_RequerimientoDetalleLoteBN;
    }
}
?>