<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_OrdenGuiaFactura.xml */
/* Generado: 2021-06-25 23:59:42 */

/* Busqueda de registros de la tabla ALM_OrdenGuiaFactura. */
abstract class BaseALM_OrdenGuiaFacturaFN extends ALM_OrdenGuiaFacturaBN
{
    /* Declaracion de constantes */
    const IdOrdenGuia = "ALM_OrdenGuiaFactura.IdOrdenGuia";
    const IdCompania = "ALM_OrdenGuiaFactura.IdCompania";
    const IdSucursal = "ALM_OrdenGuiaFactura.IdSucursal";
    const IdAlmacen = "ALM_OrdenGuiaFactura.IdAlmacen";
    const IdOrdenCompra = "ALM_OrdenGuiaFactura.IdOrdenCompra";
    const IdPersona = "ALM_OrdenGuiaFactura.IdPersona";
    const SerieGuia = "ALM_OrdenGuiaFactura.SerieGuia";
    const NumeroGuia = "ALM_OrdenGuiaFactura.NumeroGuia";
    const FechaGuia = "ALM_OrdenGuiaFactura.FechaGuia";
    const TipoDoc = "ALM_OrdenGuiaFactura.TipoDoc";
    const SerieFactura = "ALM_OrdenGuiaFactura.SerieFactura";
    const NumeroFactura = "ALM_OrdenGuiaFactura.NumeroFactura";
    const FechaFactura = "ALM_OrdenGuiaFactura.FechaFactura";
    const MontoFacturaInafecto = "ALM_OrdenGuiaFactura.MontoFacturaInafecto";
    const MontoFactura = "ALM_OrdenGuiaFactura.MontoFactura";
    const IGVFactura = "ALM_OrdenGuiaFactura.IGVFactura";
    const TotalFactura = "ALM_OrdenGuiaFactura.TotalFactura";
    const Comentario = "ALM_OrdenGuiaFactura.Comentario";
    const IdOrdenGuiaReferencia = "ALM_OrdenGuiaFactura.IdOrdenGuiaReferencia";
    const IdTipoDocumentoRef = "ALM_OrdenGuiaFactura.IdTipoDocumentoRef";
    const IdNumeroDocumentoRef = "ALM_OrdenGuiaFactura.IdNumeroDocumentoRef";
    const Estado = "ALM_OrdenGuiaFactura.Estado";
    const FechaCreacion = "ALM_OrdenGuiaFactura.FechaCreacion";
    const UsuarioCreacion = "ALM_OrdenGuiaFactura.UsuarioCreacion";
    const FechaModificacion = "ALM_OrdenGuiaFactura.FechaModificacion";
    const UsuarioModificacion = "ALM_OrdenGuiaFactura.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_OrdenGuiaFactura.IdOrdenGuia AS IdOrdenGuia, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdOrdenCompra AS IdOrdenCompra, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.SerieGuia AS SerieGuia, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.NumeroGuia AS NumeroGuia, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaGuia AS FechaGuia, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.TipoDoc AS TipoDoc, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.SerieFactura AS SerieFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.NumeroFactura AS NumeroFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaFactura AS FechaFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.MontoFacturaInafecto AS MontoFacturaInafecto, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.MontoFactura AS MontoFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IGVFactura AS IGVFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.TotalFactura AS TotalFactura, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.Comentario AS Comentario, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdOrdenGuiaReferencia AS IdOrdenGuiaReferencia, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdTipoDocumentoRef AS IdTipoDocumentoRef, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdNumeroDocumentoRef AS IdNumeroDocumentoRef, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_OrdenGuiaFactura.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_OrdenGuiaFacturaBN */
    public function setByBN( ALM_OrdenGuiaFacturaBN $o_ALM_OrdenGuiaFacturaBN )
    {
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia() ) )
        {
            $this->setIdOrdenGuia( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_OrdenGuiaFacturaBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_OrdenGuiaFacturaBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_OrdenGuiaFacturaBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenCompra() ) )
        {
            $this->setIdOrdenCompra( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenCompra() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_ALM_OrdenGuiaFacturaBN->getIdPersona() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getSerieGuia() ) )
        {
            $this->setSerieGuia( $o_ALM_OrdenGuiaFacturaBN->getSerieGuia() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getNumeroGuia() ) )
        {
            $this->setNumeroGuia( $o_ALM_OrdenGuiaFacturaBN->getNumeroGuia() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getFechaGuia() ) )
        {
            $this->setFechaGuia( $o_ALM_OrdenGuiaFacturaBN->getFechaGuia() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getTipoDoc() ) )
        {
            $this->setTipoDoc( $o_ALM_OrdenGuiaFacturaBN->getTipoDoc() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getSerieFactura() ) )
        {
            $this->setSerieFactura( $o_ALM_OrdenGuiaFacturaBN->getSerieFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getNumeroFactura() ) )
        {
            $this->setNumeroFactura( $o_ALM_OrdenGuiaFacturaBN->getNumeroFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getFechaFactura() ) )
        {
            $this->setFechaFactura( $o_ALM_OrdenGuiaFacturaBN->getFechaFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getMontoFacturaInafecto() ) )
        {
            $this->setMontoFacturaInafecto( $o_ALM_OrdenGuiaFacturaBN->getMontoFacturaInafecto() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getMontoFactura() ) )
        {
            $this->setMontoFactura( $o_ALM_OrdenGuiaFacturaBN->getMontoFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIGVFactura() ) )
        {
            $this->setIGVFactura( $o_ALM_OrdenGuiaFacturaBN->getIGVFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getTotalFactura() ) )
        {
            $this->setTotalFactura( $o_ALM_OrdenGuiaFacturaBN->getTotalFactura() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getComentario() ) )
        {
            $this->setComentario( $o_ALM_OrdenGuiaFacturaBN->getComentario() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuiaReferencia() ) )
        {
            $this->setIdOrdenGuiaReferencia( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuiaReferencia() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdTipoDocumentoRef() ) )
        {
            $this->setIdTipoDocumentoRef( $o_ALM_OrdenGuiaFacturaBN->getIdTipoDocumentoRef() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getIdNumeroDocumentoRef() ) )
        {
            $this->setIdNumeroDocumentoRef( $o_ALM_OrdenGuiaFacturaBN->getIdNumeroDocumentoRef() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_OrdenGuiaFacturaBN->getEstado() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_OrdenGuiaFacturaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_OrdenGuiaFacturaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_OrdenGuiaFacturaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_OrdenGuiaFacturaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_OrdenGuiaFacturaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_OrdenGuiaFacturaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdOrdenGuia )
    {
        if( is_null( $i_IdOrdenGuia ) ){ $i_IdOrdenGuia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_OrdenGuiaFactura ";
        $s_SQLQuery .= "WHERE IdOrdenGuia = ".$i_IdOrdenGuia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_OrdenGuiaFacturaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_OrdenGuiaFacturaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_OrdenGuiaFacturaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOrdenGuia() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdOrdenGuia = ".$this->getIdOrdenGuia()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdOrdenCompra() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdOrdenCompra = ".$this->getIdOrdenCompra()." AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getSerieGuia() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.SerieGuia = '".$this->getSerieGuia()."' AND ";
        if ( !is_null( $this->getNumeroGuia() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.NumeroGuia = '".$this->getNumeroGuia()."' AND ";
        if ( !is_null( $this->getFechaGuia() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaGuia = '".$this->getFechaGuia()."' AND ";
        if ( !is_null( $this->getTipoDoc() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.TipoDoc = '".$this->getTipoDoc()."' AND ";
        if ( !is_null( $this->getSerieFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.SerieFactura = '".$this->getSerieFactura()."' AND ";
        if ( !is_null( $this->getNumeroFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.NumeroFactura = '".$this->getNumeroFactura()."' AND ";
        if ( !is_null( $this->getFechaFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaFactura = '".$this->getFechaFactura()."' AND ";
        if ( !is_null( $this->getMontoFacturaInafecto() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.MontoFacturaInafecto = ".$this->getMontoFacturaInafecto()." AND ";
        if ( !is_null( $this->getMontoFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.MontoFactura = ".$this->getMontoFactura()." AND ";
        if ( !is_null( $this->getIGVFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IGVFactura = ".$this->getIGVFactura()." AND ";
        if ( !is_null( $this->getTotalFactura() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.TotalFactura = ".$this->getTotalFactura()." AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getIdOrdenGuiaReferencia() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdOrdenGuiaReferencia = ".$this->getIdOrdenGuiaReferencia()." AND ";
        if ( !is_null( $this->getIdTipoDocumentoRef() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdTipoDocumentoRef = '".$this->getIdTipoDocumentoRef()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoRef() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.IdNumeroDocumentoRef = '".$this->getIdNumeroDocumentoRef()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_OrdenGuiaFactura.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_OrdenGuiaFactura WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_OrdenGuiaFacturaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_OrdenGuiaFactura WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_OrdenGuiaFacturaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_OrdenGuiaFacturaBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_OrdenGuiaFacturaBN[] = $o_ALM_OrdenGuiaFacturaBN;
            }
        }
        return $a_ALM_OrdenGuiaFacturaBN;
    }

    /* Devuelve un objeto ALM_OrdenGuiaFacturaBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_OrdenGuiaFactura )
    {
        $o_ALM_OrdenGuiaFacturaBN = new ALM_OrdenGuiaFacturaBN();
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdOrdenGuia'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdOrdenGuia( ( integer ) $a_ALM_OrdenGuiaFactura['IdOrdenGuia'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdCompania'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdCompania( ( integer ) $a_ALM_OrdenGuiaFactura['IdCompania'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdSucursal'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdSucursal( ( integer ) $a_ALM_OrdenGuiaFactura['IdSucursal'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdAlmacen'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdAlmacen( $a_ALM_OrdenGuiaFactura['IdAlmacen'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdOrdenCompra'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdOrdenCompra( ( integer ) $a_ALM_OrdenGuiaFactura['IdOrdenCompra'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdPersona'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdPersona( ( integer ) $a_ALM_OrdenGuiaFactura['IdPersona'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['SerieGuia'] ) ) $o_ALM_OrdenGuiaFacturaBN->setSerieGuia( $a_ALM_OrdenGuiaFactura['SerieGuia'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['NumeroGuia'] ) ) $o_ALM_OrdenGuiaFacturaBN->setNumeroGuia( $a_ALM_OrdenGuiaFactura['NumeroGuia'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['FechaGuia'] ) ) $o_ALM_OrdenGuiaFacturaBN->setFechaGuia( utilTimestamp::getTimestamp( $a_ALM_OrdenGuiaFactura['FechaGuia'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['TipoDoc'] ) ) $o_ALM_OrdenGuiaFacturaBN->setTipoDoc( $a_ALM_OrdenGuiaFactura['TipoDoc'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['SerieFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setSerieFactura( $a_ALM_OrdenGuiaFactura['SerieFactura'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['NumeroFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setNumeroFactura( $a_ALM_OrdenGuiaFactura['NumeroFactura'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['FechaFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setFechaFactura( utilTimestamp::getTimestamp( $a_ALM_OrdenGuiaFactura['FechaFactura'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['MontoFacturaInafecto'] ) ) $o_ALM_OrdenGuiaFacturaBN->setMontoFacturaInafecto( ( float ) $a_ALM_OrdenGuiaFactura['MontoFacturaInafecto'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['MontoFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setMontoFactura( ( float ) $a_ALM_OrdenGuiaFactura['MontoFactura'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IGVFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIGVFactura( ( float ) $a_ALM_OrdenGuiaFactura['IGVFactura'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['TotalFactura'] ) ) $o_ALM_OrdenGuiaFacturaBN->setTotalFactura( ( float ) $a_ALM_OrdenGuiaFactura['TotalFactura'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['Comentario'] ) ) $o_ALM_OrdenGuiaFacturaBN->setComentario( $a_ALM_OrdenGuiaFactura['Comentario'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdOrdenGuiaReferencia'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdOrdenGuiaReferencia( ( integer ) $a_ALM_OrdenGuiaFactura['IdOrdenGuiaReferencia'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdTipoDocumentoRef'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdTipoDocumentoRef( $a_ALM_OrdenGuiaFactura['IdTipoDocumentoRef'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['IdNumeroDocumentoRef'] ) ) $o_ALM_OrdenGuiaFacturaBN->setIdNumeroDocumentoRef( $a_ALM_OrdenGuiaFactura['IdNumeroDocumentoRef'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['Estado'] ) ) $o_ALM_OrdenGuiaFacturaBN->setEstado( $a_ALM_OrdenGuiaFactura['Estado'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['FechaCreacion'] ) ) $o_ALM_OrdenGuiaFacturaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_OrdenGuiaFactura['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['UsuarioCreacion'] ) ) $o_ALM_OrdenGuiaFacturaBN->setUsuarioCreacion( $a_ALM_OrdenGuiaFactura['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['FechaModificacion'] ) ) $o_ALM_OrdenGuiaFacturaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_OrdenGuiaFactura['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_OrdenGuiaFactura['UsuarioModificacion'] ) ) $o_ALM_OrdenGuiaFacturaBN->setUsuarioModificacion( $a_ALM_OrdenGuiaFactura['UsuarioModificacion'] );
        return $o_ALM_OrdenGuiaFacturaBN;
    }
}
?>