<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Marca.xml */
/* Generado: 2021-06-25 23:59:42 */

/* Busqueda de registros de la tabla ALM_Marca. */
abstract class BaseALM_MarcaFN extends ALM_MarcaBN
{
    /* Declaracion de constantes */
    const IdMarca = "ALM_Marca.IdMarca";
    const DescripcionLocal = "ALM_Marca.DescripcionLocal";
    const DescripcionIngles = "ALM_Marca.DescripcionIngles";
    const Persona = "ALM_Marca.Persona";
    const Estado = "ALM_Marca.Estado";
    const UsuarioModificacion = "ALM_Marca.UsuarioModificacion";
    const FechaModificacion = "ALM_Marca.FechaModificacion";
    const UsuarioCreacion = "ALM_Marca.UsuarioCreacion";
    const FechaCreacion = "ALM_Marca.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_Marca.IdMarca AS IdMarca, ";
        $s_SQLQuery .= "ALM_Marca.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "ALM_Marca.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "ALM_Marca.Persona AS Persona, ";
        $s_SQLQuery .= "ALM_Marca.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_Marca.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_Marca.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_Marca.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_Marca.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_MarcaBN */
    public function setByBN( ALM_MarcaBN $o_ALM_MarcaBN )
    {
        if ( !is_null( $o_ALM_MarcaBN->getIdMarca() ) )
        {
            $this->setIdMarca( $o_ALM_MarcaBN->getIdMarca() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_ALM_MarcaBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_MarcaBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getPersona() ) )
        {
            $this->setPersona( $o_ALM_MarcaBN->getPersona() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_MarcaBN->getEstado() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_MarcaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_MarcaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_MarcaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_MarcaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_MarcaBN->getFechaCreacion() );
        }
    }

    /**
    * @return ALM_MarcaBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdMarca )
    {
        if( is_null( $s_IdMarca ) ){ $s_IdMarca = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Marca ";
        $s_SQLQuery .= "WHERE IdMarca = '".$s_IdMarca."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_MarcaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_MarcaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_MarcaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdMarca() ) ) $s_SQLQuery .= "ALM_Marca.IdMarca = '".$this->getIdMarca()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "ALM_Marca.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "ALM_Marca.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getPersona() ) ) $s_SQLQuery .= "ALM_Marca.Persona = ".$this->getPersona()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_Marca.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_Marca.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_Marca.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_Marca.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_Marca.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_Marca WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_MarcaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Marca WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_MarcaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_MarcaBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_MarcaBN[] = $o_ALM_MarcaBN;
            }
        }
        return $a_ALM_MarcaBN;
    }

    /* Devuelve un objeto ALM_MarcaBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_Marca )
    {
        $o_ALM_MarcaBN = new ALM_MarcaBN();
        if ( !is_null( $a_ALM_Marca['IdMarca'] ) ) $o_ALM_MarcaBN->setIdMarca( $a_ALM_Marca['IdMarca'] );
        if ( !is_null( $a_ALM_Marca['DescripcionLocal'] ) ) $o_ALM_MarcaBN->setDescripcionLocal( $a_ALM_Marca['DescripcionLocal'] );
        if ( !is_null( $a_ALM_Marca['DescripcionIngles'] ) ) $o_ALM_MarcaBN->setDescripcionIngles( $a_ALM_Marca['DescripcionIngles'] );
        if ( !is_null( $a_ALM_Marca['Persona'] ) ) $o_ALM_MarcaBN->setPersona( ( integer ) $a_ALM_Marca['Persona'] );
        if ( !is_null( $a_ALM_Marca['Estado'] ) ) $o_ALM_MarcaBN->setEstado( $a_ALM_Marca['Estado'] );
        if ( !is_null( $a_ALM_Marca['UsuarioModificacion'] ) ) $o_ALM_MarcaBN->setUsuarioModificacion( $a_ALM_Marca['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_Marca['FechaModificacion'] ) ) $o_ALM_MarcaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_Marca['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_Marca['UsuarioCreacion'] ) ) $o_ALM_MarcaBN->setUsuarioCreacion( $a_ALM_Marca['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_Marca['FechaCreacion'] ) ) $o_ALM_MarcaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_Marca['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_MarcaBN;
    }
}
?>