<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Lote.xml */
/* Generado: 2021-11-07 23:55:52 */

/* Busqueda de registros de la tabla ALM_Lote. */
abstract class BaseALM_LoteFN extends ALM_LoteBN
{
    /* Declaracion de constantes */
    const IdLote = "ALM_Lote.IdLote";
    const IdCompania = "ALM_Lote.IdCompania";
    const IdSucursal = "ALM_Lote.IdSucursal";
    const IdItem = "ALM_Lote.IdItem";
    const ProductoDescripcion = "ALM_Lote.ProductoDescripcion";
    const LoteNumero = "ALM_Lote.LoteNumero";
    const FechaVencimiento = "ALM_Lote.FechaVencimiento";
    const FechaOrigen = "ALM_Lote.FechaOrigen";
    const Descripcion = "ALM_Lote.Descripcion";
    const Estado = "ALM_Lote.Estado";
    const ProveedorId = "ALM_Lote.ProveedorId";
    const ProveedorNombre = "ALM_Lote.ProveedorNombre";
    const LoteNumeroProveedor = "ALM_Lote.LoteNumeroProveedor";
    const Anio = "ALM_Lote.Anio";
    const FechaCreacion = "ALM_Lote.FechaCreacion";
    const UsuarioCreacion = "ALM_Lote.UsuarioCreacion";
    const FechaModificacion = "ALM_Lote.FechaModificacion";
    const UsuarioModificacion = "ALM_Lote.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_Lote.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_Lote.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_Lote.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_Lote.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_Lote.ProductoDescripcion AS ProductoDescripcion, ";
        $s_SQLQuery .= "ALM_Lote.LoteNumero AS LoteNumero, ";
        $s_SQLQuery .= "ALM_Lote.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_Lote.FechaOrigen AS FechaOrigen, ";
        $s_SQLQuery .= "ALM_Lote.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_Lote.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_Lote.ProveedorId AS ProveedorId, ";
        $s_SQLQuery .= "ALM_Lote.ProveedorNombre AS ProveedorNombre, ";
        $s_SQLQuery .= "ALM_Lote.LoteNumeroProveedor AS LoteNumeroProveedor, ";
        $s_SQLQuery .= "ALM_Lote.Anio AS Anio, ";
        $s_SQLQuery .= "ALM_Lote.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_Lote.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_Lote.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_Lote.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_LoteBN */
    public function setByBN( ALM_LoteBN $o_ALM_LoteBN )
    {
        if ( !is_null( $o_ALM_LoteBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_LoteBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_LoteBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_LoteBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_LoteBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_LoteBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProductoDescripcion() ) )
        {
            $this->setProductoDescripcion( $o_ALM_LoteBN->getProductoDescripcion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getLoteNumero() ) )
        {
            $this->setLoteNumero( $o_ALM_LoteBN->getLoteNumero() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_LoteBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaOrigen() ) )
        {
            $this->setFechaOrigen( $o_ALM_LoteBN->getFechaOrigen() );
        }
        if ( !is_null( $o_ALM_LoteBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_LoteBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_LoteBN->getEstado() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProveedorId() ) )
        {
            $this->setProveedorId( $o_ALM_LoteBN->getProveedorId() );
        }
        if ( !is_null( $o_ALM_LoteBN->getProveedorNombre() ) )
        {
            $this->setProveedorNombre( $o_ALM_LoteBN->getProveedorNombre() );
        }
        if ( !is_null( $o_ALM_LoteBN->getLoteNumeroProveedor() ) )
        {
            $this->setLoteNumeroProveedor( $o_ALM_LoteBN->getLoteNumeroProveedor() );
        }
        if ( !is_null( $o_ALM_LoteBN->getAnio() ) )
        {
            $this->setAnio( $o_ALM_LoteBN->getAnio() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_LoteBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_LoteBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_LoteBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_LoteBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_LoteBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_LoteBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdLote )
    {
        if( is_null( $i_IdLote ) ){ $i_IdLote = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Lote ";
        $s_SQLQuery .= "WHERE IdLote = ".$i_IdLote." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_LoteBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_LoteBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_LoteBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_Lote.IdLote = ".$this->getIdLote()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_Lote.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_Lote.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_Lote.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getProductoDescripcion() ) ) $s_SQLQuery .= "ALM_Lote.ProductoDescripcion = '".$this->getProductoDescripcion()."' AND ";
        if ( !is_null( $this->getLoteNumero() ) ) $s_SQLQuery .= "ALM_Lote.LoteNumero = '".$this->getLoteNumero()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_Lote.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getFechaOrigen() ) ) $s_SQLQuery .= "ALM_Lote.FechaOrigen = '".$this->getFechaOrigen()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_Lote.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_Lote.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getProveedorId() ) ) $s_SQLQuery .= "ALM_Lote.ProveedorId = ".$this->getProveedorId()." AND ";
        if ( !is_null( $this->getProveedorNombre() ) ) $s_SQLQuery .= "ALM_Lote.ProveedorNombre = '".$this->getProveedorNombre()."' AND ";
        if ( !is_null( $this->getLoteNumeroProveedor() ) ) $s_SQLQuery .= "ALM_Lote.LoteNumeroProveedor = '".$this->getLoteNumeroProveedor()."' AND ";
        if ( !is_null( $this->getAnio() ) ) $s_SQLQuery .= "ALM_Lote.Anio = '".$this->getAnio()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_Lote.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_Lote.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_Lote.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_Lote.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_Lote WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_LoteBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Lote WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_LoteBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_LoteBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_LoteBN[] = $o_ALM_LoteBN;
            }
        }
        return $a_ALM_LoteBN;
    }

    /* Devuelve un objeto ALM_LoteBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_Lote )
    {
        $o_ALM_LoteBN = new ALM_LoteBN();
        if ( !is_null( $a_ALM_Lote['IdLote'] ) ) $o_ALM_LoteBN->setIdLote( ( integer ) $a_ALM_Lote['IdLote'] );
        if ( !is_null( $a_ALM_Lote['IdCompania'] ) ) $o_ALM_LoteBN->setIdCompania( ( integer ) $a_ALM_Lote['IdCompania'] );
        if ( !is_null( $a_ALM_Lote['IdSucursal'] ) ) $o_ALM_LoteBN->setIdSucursal( ( integer ) $a_ALM_Lote['IdSucursal'] );
        if ( !is_null( $a_ALM_Lote['IdItem'] ) ) $o_ALM_LoteBN->setIdItem( $a_ALM_Lote['IdItem'] );
        if ( !is_null( $a_ALM_Lote['ProductoDescripcion'] ) ) $o_ALM_LoteBN->setProductoDescripcion( $a_ALM_Lote['ProductoDescripcion'] );
        if ( !is_null( $a_ALM_Lote['LoteNumero'] ) ) $o_ALM_LoteBN->setLoteNumero( $a_ALM_Lote['LoteNumero'] );
        if ( !is_null( $a_ALM_Lote['FechaVencimiento'] ) ) $o_ALM_LoteBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_Lote['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_Lote['FechaOrigen'] ) ) $o_ALM_LoteBN->setFechaOrigen( utilTimestamp::getTimestamp( $a_ALM_Lote['FechaOrigen'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_Lote['Descripcion'] ) ) $o_ALM_LoteBN->setDescripcion( $a_ALM_Lote['Descripcion'] );
        if ( !is_null( $a_ALM_Lote['Estado'] ) ) $o_ALM_LoteBN->setEstado( $a_ALM_Lote['Estado'] );
        if ( !is_null( $a_ALM_Lote['ProveedorId'] ) ) $o_ALM_LoteBN->setProveedorId( ( integer ) $a_ALM_Lote['ProveedorId'] );
        if ( !is_null( $a_ALM_Lote['ProveedorNombre'] ) ) $o_ALM_LoteBN->setProveedorNombre( $a_ALM_Lote['ProveedorNombre'] );
        if ( !is_null( $a_ALM_Lote['LoteNumeroProveedor'] ) ) $o_ALM_LoteBN->setLoteNumeroProveedor( $a_ALM_Lote['LoteNumeroProveedor'] );
        if ( !is_null( $a_ALM_Lote['Anio'] ) ) $o_ALM_LoteBN->setAnio( $a_ALM_Lote['Anio'] );
        if ( !is_null( $a_ALM_Lote['FechaCreacion'] ) ) $o_ALM_LoteBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_Lote['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_Lote['UsuarioCreacion'] ) ) $o_ALM_LoteBN->setUsuarioCreacion( $a_ALM_Lote['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_Lote['FechaModificacion'] ) ) $o_ALM_LoteBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_Lote['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_Lote['UsuarioModificacion'] ) ) $o_ALM_LoteBN->setUsuarioModificacion( $a_ALM_Lote['UsuarioModificacion'] );
        return $o_ALM_LoteBN;
    }
}
?>