<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Kardex.xml */
/* Generado: 2021-06-25 23:59:41 */

/* Busqueda de registros de la tabla ALM_Kardex. */
abstract class BaseALM_KardexFN extends ALM_KardexBN
{
    /* Declaracion de constantes */
    const IdAlmacen = "ALM_Kardex.IdAlmacen";
    const IdCompania = "ALM_Kardex.IdCompania";
    const IdSucursal = "ALM_Kardex.IdSucursal";
    const IdItem = "ALM_Kardex.IdItem";
    const IdCondicion = "ALM_Kardex.IdCondicion";
    const IdLote = "ALM_Kardex.IdLote";
    const IdFecha = "ALM_Kardex.IdFecha";
    const IdTransaccion = "ALM_Kardex.IdTransaccion";
    const ReferenciaNumeroInterno = "ALM_Kardex.ReferenciaNumeroInterno";
    const ReferenciaCompaniaSocio = "ALM_Kardex.ReferenciaCompaniaSocio";
    const ReferenciaTipoDocumento = "ALM_Kardex.ReferenciaTipoDocumento";
    const ReferenciaNumeroDocumento = "ALM_Kardex.ReferenciaNumeroDocumento";
    const ReferenciaSecuencia = "ALM_Kardex.ReferenciaSecuencia";
    const IdUnidadMedida = "ALM_Kardex.IdUnidadMedida";
    const Cantidad = "ALM_Kardex.Cantidad";
    const CantidadDoble = "ALM_Kardex.CantidadDoble";
    const PrecioUnitario = "ALM_Kardex.PrecioUnitario";
    const PrecioUnitarioDolares = "ALM_Kardex.PrecioUnitarioDolares";
    const MontoTotal = "ALM_Kardex.MontoTotal";
    const MontoTotalDolares = "ALM_Kardex.MontoTotalDolares";
    const PrecioCosto = "ALM_Kardex.PrecioCosto";
    const CostoTotal = "ALM_Kardex.CostoTotal";
    const SaldoCantidad = "ALM_Kardex.SaldoCantidad";
    const SaldoPrecioCosto = "ALM_Kardex.SaldoPrecioCosto";
    const SaldoCostoTotal = "ALM_Kardex.SaldoCostoTotal";
    const Periodo = "ALM_Kardex.Periodo";
    const CodigoCliente = "ALM_Kardex.CodigoCliente";
    const CodigoProveedor = "ALM_Kardex.CodigoProveedor";
    const TipoDocumentoFiscal = "ALM_Kardex.TipoDocumentoFiscal";
    const SerieDocumentoFiscal = "ALM_Kardex.SerieDocumentoFiscal";
    const NumeroDocumentoFiscal = "ALM_Kardex.NumeroDocumentoFiscal";
    const AcumuladoCantidad = "ALM_Kardex.AcumuladoCantidad";
    const AcumuladoLocal = "ALM_Kardex.AcumuladoLocal";
    const AcumuladoDolares = "ALM_Kardex.AcumuladoDolares";
    const ParentRef = "ALM_Kardex.ParentRef";
    const UsuarioModificacion = "ALM_Kardex.UsuarioModificacion";
    const FechaModificacion = "ALM_Kardex.FechaModificacion";
    const UsuarioCreacion = "ALM_Kardex.UsuarioCreacion";
    const FechCreacion = "ALM_Kardex.FechCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_Kardex.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_Kardex.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_Kardex.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_Kardex.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_Kardex.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "ALM_Kardex.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_Kardex.IdFecha AS IdFecha, ";
        $s_SQLQuery .= "ALM_Kardex.IdTransaccion AS IdTransaccion, ";
        $s_SQLQuery .= "ALM_Kardex.ReferenciaNumeroInterno AS ReferenciaNumeroInterno, ";
        $s_SQLQuery .= "ALM_Kardex.ReferenciaCompaniaSocio AS ReferenciaCompaniaSocio, ";
        $s_SQLQuery .= "ALM_Kardex.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_Kardex.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_Kardex.ReferenciaSecuencia AS ReferenciaSecuencia, ";
        $s_SQLQuery .= "ALM_Kardex.IdUnidadMedida AS IdUnidadMedida, ";
        $s_SQLQuery .= "ALM_Kardex.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "ALM_Kardex.CantidadDoble AS CantidadDoble, ";
        $s_SQLQuery .= "ALM_Kardex.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_Kardex.PrecioUnitarioDolares AS PrecioUnitarioDolares, ";
        $s_SQLQuery .= "ALM_Kardex.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_Kardex.MontoTotalDolares AS MontoTotalDolares, ";
        $s_SQLQuery .= "ALM_Kardex.PrecioCosto AS PrecioCosto, ";
        $s_SQLQuery .= "ALM_Kardex.CostoTotal AS CostoTotal, ";
        $s_SQLQuery .= "ALM_Kardex.SaldoCantidad AS SaldoCantidad, ";
        $s_SQLQuery .= "ALM_Kardex.SaldoPrecioCosto AS SaldoPrecioCosto, ";
        $s_SQLQuery .= "ALM_Kardex.SaldoCostoTotal AS SaldoCostoTotal, ";
        $s_SQLQuery .= "ALM_Kardex.Periodo AS Periodo, ";
        $s_SQLQuery .= "ALM_Kardex.CodigoCliente AS CodigoCliente, ";
        $s_SQLQuery .= "ALM_Kardex.CodigoProveedor AS CodigoProveedor, ";
        $s_SQLQuery .= "ALM_Kardex.TipoDocumentoFiscal AS TipoDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_Kardex.SerieDocumentoFiscal AS SerieDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_Kardex.NumeroDocumentoFiscal AS NumeroDocumentoFiscal, ";
        $s_SQLQuery .= "ALM_Kardex.AcumuladoCantidad AS AcumuladoCantidad, ";
        $s_SQLQuery .= "ALM_Kardex.AcumuladoLocal AS AcumuladoLocal, ";
        $s_SQLQuery .= "ALM_Kardex.AcumuladoDolares AS AcumuladoDolares, ";
        $s_SQLQuery .= "ALM_Kardex.ParentRef AS ParentRef, ";
        $s_SQLQuery .= "ALM_Kardex.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_Kardex.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_Kardex.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_Kardex.FechCreacion AS FechCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_KardexBN */
    public function setByBN( ALM_KardexBN $o_ALM_KardexBN )
    {
        if ( !is_null( $o_ALM_KardexBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_KardexBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_KardexBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_KardexBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_KardexBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_KardexBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_KardexBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdFecha() ) )
        {
            $this->setIdFecha( $o_ALM_KardexBN->getIdFecha() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdTransaccion() ) )
        {
            $this->setIdTransaccion( $o_ALM_KardexBN->getIdTransaccion() );
        }
        if ( !is_null( $o_ALM_KardexBN->getReferenciaNumeroInterno() ) )
        {
            $this->setReferenciaNumeroInterno( $o_ALM_KardexBN->getReferenciaNumeroInterno() );
        }
        if ( !is_null( $o_ALM_KardexBN->getReferenciaCompaniaSocio() ) )
        {
            $this->setReferenciaCompaniaSocio( $o_ALM_KardexBN->getReferenciaCompaniaSocio() );
        }
        if ( !is_null( $o_ALM_KardexBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_KardexBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_KardexBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_KardexBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_KardexBN->getReferenciaSecuencia() ) )
        {
            $this->setReferenciaSecuencia( $o_ALM_KardexBN->getReferenciaSecuencia() );
        }
        if ( !is_null( $o_ALM_KardexBN->getIdUnidadMedida() ) )
        {
            $this->setIdUnidadMedida( $o_ALM_KardexBN->getIdUnidadMedida() );
        }
        if ( !is_null( $o_ALM_KardexBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_KardexBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_KardexBN->getCantidadDoble() ) )
        {
            $this->setCantidadDoble( $o_ALM_KardexBN->getCantidadDoble() );
        }
        if ( !is_null( $o_ALM_KardexBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_KardexBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_KardexBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_KardexBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_KardexBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_KardexBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getMontoTotalDolares() ) )
        {
            $this->setMontoTotalDolares( $o_ALM_KardexBN->getMontoTotalDolares() );
        }
        if ( !is_null( $o_ALM_KardexBN->getPrecioCosto() ) )
        {
            $this->setPrecioCosto( $o_ALM_KardexBN->getPrecioCosto() );
        }
        if ( !is_null( $o_ALM_KardexBN->getCostoTotal() ) )
        {
            $this->setCostoTotal( $o_ALM_KardexBN->getCostoTotal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getSaldoCantidad() ) )
        {
            $this->setSaldoCantidad( $o_ALM_KardexBN->getSaldoCantidad() );
        }
        if ( !is_null( $o_ALM_KardexBN->getSaldoPrecioCosto() ) )
        {
            $this->setSaldoPrecioCosto( $o_ALM_KardexBN->getSaldoPrecioCosto() );
        }
        if ( !is_null( $o_ALM_KardexBN->getSaldoCostoTotal() ) )
        {
            $this->setSaldoCostoTotal( $o_ALM_KardexBN->getSaldoCostoTotal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_ALM_KardexBN->getPeriodo() );
        }
        if ( !is_null( $o_ALM_KardexBN->getCodigoCliente() ) )
        {
            $this->setCodigoCliente( $o_ALM_KardexBN->getCodigoCliente() );
        }
        if ( !is_null( $o_ALM_KardexBN->getCodigoProveedor() ) )
        {
            $this->setCodigoProveedor( $o_ALM_KardexBN->getCodigoProveedor() );
        }
        if ( !is_null( $o_ALM_KardexBN->getTipoDocumentoFiscal() ) )
        {
            $this->setTipoDocumentoFiscal( $o_ALM_KardexBN->getTipoDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getSerieDocumentoFiscal() ) )
        {
            $this->setSerieDocumentoFiscal( $o_ALM_KardexBN->getSerieDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getNumeroDocumentoFiscal() ) )
        {
            $this->setNumeroDocumentoFiscal( $o_ALM_KardexBN->getNumeroDocumentoFiscal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getAcumuladoCantidad() ) )
        {
            $this->setAcumuladoCantidad( $o_ALM_KardexBN->getAcumuladoCantidad() );
        }
        if ( !is_null( $o_ALM_KardexBN->getAcumuladoLocal() ) )
        {
            $this->setAcumuladoLocal( $o_ALM_KardexBN->getAcumuladoLocal() );
        }
        if ( !is_null( $o_ALM_KardexBN->getAcumuladoDolares() ) )
        {
            $this->setAcumuladoDolares( $o_ALM_KardexBN->getAcumuladoDolares() );
        }
        if ( !is_null( $o_ALM_KardexBN->getParentRef() ) )
        {
            $this->setParentRef( $o_ALM_KardexBN->getParentRef() );
        }
        if ( !is_null( $o_ALM_KardexBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_KardexBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_KardexBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_KardexBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_KardexBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_KardexBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_KardexBN->getFechCreacion() ) )
        {
            $this->setFechCreacion( $o_ALM_KardexBN->getFechCreacion() );
        }
    }

    /**
    * @return ALM_KardexBN|null
    * @throws SQLException
    */
    public function selectByPK(  )
    {
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Kardex ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_KardexBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_KardexBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_KardexBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_Kardex.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_Kardex.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_Kardex.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_Kardex.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "ALM_Kardex.IdCondicion = '".$this->getIdCondicion()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_Kardex.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getIdFecha() ) ) $s_SQLQuery .= "ALM_Kardex.IdFecha = '".$this->getIdFecha()."' AND ";
        if ( !is_null( $this->getIdTransaccion() ) ) $s_SQLQuery .= "ALM_Kardex.IdTransaccion = '".$this->getIdTransaccion()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroInterno() ) ) $s_SQLQuery .= "ALM_Kardex.ReferenciaNumeroInterno = '".$this->getReferenciaNumeroInterno()."' AND ";
        if ( !is_null( $this->getReferenciaCompaniaSocio() ) ) $s_SQLQuery .= "ALM_Kardex.ReferenciaCompaniaSocio = '".$this->getReferenciaCompaniaSocio()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_Kardex.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_Kardex.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaSecuencia() ) ) $s_SQLQuery .= "ALM_Kardex.ReferenciaSecuencia = '".$this->getReferenciaSecuencia()."' AND ";
        if ( !is_null( $this->getIdUnidadMedida() ) ) $s_SQLQuery .= "ALM_Kardex.IdUnidadMedida = '".$this->getIdUnidadMedida()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "ALM_Kardex.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getCantidadDoble() ) ) $s_SQLQuery .= "ALM_Kardex.CantidadDoble = ".$this->getCantidadDoble()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_Kardex.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getPrecioUnitarioDolares() ) ) $s_SQLQuery .= "ALM_Kardex.PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_Kardex.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getMontoTotalDolares() ) ) $s_SQLQuery .= "ALM_Kardex.MontoTotalDolares = ".$this->getMontoTotalDolares()." AND ";
        if ( !is_null( $this->getPrecioCosto() ) ) $s_SQLQuery .= "ALM_Kardex.PrecioCosto = ".$this->getPrecioCosto()." AND ";
        if ( !is_null( $this->getCostoTotal() ) ) $s_SQLQuery .= "ALM_Kardex.CostoTotal = ".$this->getCostoTotal()." AND ";
        if ( !is_null( $this->getSaldoCantidad() ) ) $s_SQLQuery .= "ALM_Kardex.SaldoCantidad = ".$this->getSaldoCantidad()." AND ";
        if ( !is_null( $this->getSaldoPrecioCosto() ) ) $s_SQLQuery .= "ALM_Kardex.SaldoPrecioCosto = ".$this->getSaldoPrecioCosto()." AND ";
        if ( !is_null( $this->getSaldoCostoTotal() ) ) $s_SQLQuery .= "ALM_Kardex.SaldoCostoTotal = ".$this->getSaldoCostoTotal()." AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "ALM_Kardex.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getCodigoCliente() ) ) $s_SQLQuery .= "ALM_Kardex.CodigoCliente = '".$this->getCodigoCliente()."' AND ";
        if ( !is_null( $this->getCodigoProveedor() ) ) $s_SQLQuery .= "ALM_Kardex.CodigoProveedor = '".$this->getCodigoProveedor()."' AND ";
        if ( !is_null( $this->getTipoDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_Kardex.TipoDocumentoFiscal = '".$this->getTipoDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getSerieDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_Kardex.SerieDocumentoFiscal = '".$this->getSerieDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getNumeroDocumentoFiscal() ) ) $s_SQLQuery .= "ALM_Kardex.NumeroDocumentoFiscal = '".$this->getNumeroDocumentoFiscal()."' AND ";
        if ( !is_null( $this->getAcumuladoCantidad() ) ) $s_SQLQuery .= "ALM_Kardex.AcumuladoCantidad = ".$this->getAcumuladoCantidad()." AND ";
        if ( !is_null( $this->getAcumuladoLocal() ) ) $s_SQLQuery .= "ALM_Kardex.AcumuladoLocal = ".$this->getAcumuladoLocal()." AND ";
        if ( !is_null( $this->getAcumuladoDolares() ) ) $s_SQLQuery .= "ALM_Kardex.AcumuladoDolares = ".$this->getAcumuladoDolares()." AND ";
        if ( !is_null( $this->getParentRef() ) ) $s_SQLQuery .= "ALM_Kardex.ParentRef = '".$this->getParentRef()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_Kardex.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_Kardex.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_Kardex.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechCreacion() ) ) $s_SQLQuery .= "ALM_Kardex.FechCreacion = '".$this->getFechCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_Kardex WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_KardexBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Kardex WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_KardexBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_KardexBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_KardexBN[] = $o_ALM_KardexBN;
            }
        }
        return $a_ALM_KardexBN;
    }

    /* Devuelve un objeto ALM_KardexBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_Kardex )
    {
        $o_ALM_KardexBN = new ALM_KardexBN();
        if ( !is_null( $a_ALM_Kardex['IdAlmacen'] ) ) $o_ALM_KardexBN->setIdAlmacen( $a_ALM_Kardex['IdAlmacen'] );
        if ( !is_null( $a_ALM_Kardex['IdCompania'] ) ) $o_ALM_KardexBN->setIdCompania( ( integer ) $a_ALM_Kardex['IdCompania'] );
        if ( !is_null( $a_ALM_Kardex['IdSucursal'] ) ) $o_ALM_KardexBN->setIdSucursal( ( integer ) $a_ALM_Kardex['IdSucursal'] );
        if ( !is_null( $a_ALM_Kardex['IdItem'] ) ) $o_ALM_KardexBN->setIdItem( $a_ALM_Kardex['IdItem'] );
        if ( !is_null( $a_ALM_Kardex['IdCondicion'] ) ) $o_ALM_KardexBN->setIdCondicion( $a_ALM_Kardex['IdCondicion'] );
        if ( !is_null( $a_ALM_Kardex['IdLote'] ) ) $o_ALM_KardexBN->setIdLote( $a_ALM_Kardex['IdLote'] );
        if ( !is_null( $a_ALM_Kardex['IdFecha'] ) ) $o_ALM_KardexBN->setIdFecha( utilTimestamp::getTimestamp( $a_ALM_Kardex['IdFecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_Kardex['IdTransaccion'] ) ) $o_ALM_KardexBN->setIdTransaccion( $a_ALM_Kardex['IdTransaccion'] );
        if ( !is_null( $a_ALM_Kardex['ReferenciaNumeroInterno'] ) ) $o_ALM_KardexBN->setReferenciaNumeroInterno( $a_ALM_Kardex['ReferenciaNumeroInterno'] );
        if ( !is_null( $a_ALM_Kardex['ReferenciaCompaniaSocio'] ) ) $o_ALM_KardexBN->setReferenciaCompaniaSocio( $a_ALM_Kardex['ReferenciaCompaniaSocio'] );
        if ( !is_null( $a_ALM_Kardex['ReferenciaTipoDocumento'] ) ) $o_ALM_KardexBN->setReferenciaTipoDocumento( $a_ALM_Kardex['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_Kardex['ReferenciaNumeroDocumento'] ) ) $o_ALM_KardexBN->setReferenciaNumeroDocumento( $a_ALM_Kardex['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_Kardex['ReferenciaSecuencia'] ) ) $o_ALM_KardexBN->setReferenciaSecuencia( $a_ALM_Kardex['ReferenciaSecuencia'] );
        if ( !is_null( $a_ALM_Kardex['IdUnidadMedida'] ) ) $o_ALM_KardexBN->setIdUnidadMedida( $a_ALM_Kardex['IdUnidadMedida'] );
        if ( !is_null( $a_ALM_Kardex['Cantidad'] ) ) $o_ALM_KardexBN->setCantidad( ( float ) $a_ALM_Kardex['Cantidad'] );
        if ( !is_null( $a_ALM_Kardex['CantidadDoble'] ) ) $o_ALM_KardexBN->setCantidadDoble( ( float ) $a_ALM_Kardex['CantidadDoble'] );
        if ( !is_null( $a_ALM_Kardex['PrecioUnitario'] ) ) $o_ALM_KardexBN->setPrecioUnitario( ( float ) $a_ALM_Kardex['PrecioUnitario'] );
        if ( !is_null( $a_ALM_Kardex['PrecioUnitarioDolares'] ) ) $o_ALM_KardexBN->setPrecioUnitarioDolares( ( float ) $a_ALM_Kardex['PrecioUnitarioDolares'] );
        if ( !is_null( $a_ALM_Kardex['MontoTotal'] ) ) $o_ALM_KardexBN->setMontoTotal( ( float ) $a_ALM_Kardex['MontoTotal'] );
        if ( !is_null( $a_ALM_Kardex['MontoTotalDolares'] ) ) $o_ALM_KardexBN->setMontoTotalDolares( ( float ) $a_ALM_Kardex['MontoTotalDolares'] );
        if ( !is_null( $a_ALM_Kardex['PrecioCosto'] ) ) $o_ALM_KardexBN->setPrecioCosto( ( float ) $a_ALM_Kardex['PrecioCosto'] );
        if ( !is_null( $a_ALM_Kardex['CostoTotal'] ) ) $o_ALM_KardexBN->setCostoTotal( ( float ) $a_ALM_Kardex['CostoTotal'] );
        if ( !is_null( $a_ALM_Kardex['SaldoCantidad'] ) ) $o_ALM_KardexBN->setSaldoCantidad( ( float ) $a_ALM_Kardex['SaldoCantidad'] );
        if ( !is_null( $a_ALM_Kardex['SaldoPrecioCosto'] ) ) $o_ALM_KardexBN->setSaldoPrecioCosto( ( float ) $a_ALM_Kardex['SaldoPrecioCosto'] );
        if ( !is_null( $a_ALM_Kardex['SaldoCostoTotal'] ) ) $o_ALM_KardexBN->setSaldoCostoTotal( ( float ) $a_ALM_Kardex['SaldoCostoTotal'] );
        if ( !is_null( $a_ALM_Kardex['Periodo'] ) ) $o_ALM_KardexBN->setPeriodo( $a_ALM_Kardex['Periodo'] );
        if ( !is_null( $a_ALM_Kardex['CodigoCliente'] ) ) $o_ALM_KardexBN->setCodigoCliente( $a_ALM_Kardex['CodigoCliente'] );
        if ( !is_null( $a_ALM_Kardex['CodigoProveedor'] ) ) $o_ALM_KardexBN->setCodigoProveedor( $a_ALM_Kardex['CodigoProveedor'] );
        if ( !is_null( $a_ALM_Kardex['TipoDocumentoFiscal'] ) ) $o_ALM_KardexBN->setTipoDocumentoFiscal( $a_ALM_Kardex['TipoDocumentoFiscal'] );
        if ( !is_null( $a_ALM_Kardex['SerieDocumentoFiscal'] ) ) $o_ALM_KardexBN->setSerieDocumentoFiscal( $a_ALM_Kardex['SerieDocumentoFiscal'] );
        if ( !is_null( $a_ALM_Kardex['NumeroDocumentoFiscal'] ) ) $o_ALM_KardexBN->setNumeroDocumentoFiscal( $a_ALM_Kardex['NumeroDocumentoFiscal'] );
        if ( !is_null( $a_ALM_Kardex['AcumuladoCantidad'] ) ) $o_ALM_KardexBN->setAcumuladoCantidad( ( float ) $a_ALM_Kardex['AcumuladoCantidad'] );
        if ( !is_null( $a_ALM_Kardex['AcumuladoLocal'] ) ) $o_ALM_KardexBN->setAcumuladoLocal( ( float ) $a_ALM_Kardex['AcumuladoLocal'] );
        if ( !is_null( $a_ALM_Kardex['AcumuladoDolares'] ) ) $o_ALM_KardexBN->setAcumuladoDolares( ( float ) $a_ALM_Kardex['AcumuladoDolares'] );
        if ( !is_null( $a_ALM_Kardex['ParentRef'] ) ) $o_ALM_KardexBN->setParentRef( $a_ALM_Kardex['ParentRef'] );
        if ( !is_null( $a_ALM_Kardex['UsuarioModificacion'] ) ) $o_ALM_KardexBN->setUsuarioModificacion( $a_ALM_Kardex['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_Kardex['FechaModificacion'] ) ) $o_ALM_KardexBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_Kardex['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_Kardex['UsuarioCreacion'] ) ) $o_ALM_KardexBN->setUsuarioCreacion( $a_ALM_Kardex['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_Kardex['FechCreacion'] ) ) $o_ALM_KardexBN->setFechCreacion( utilTimestamp::getTimestamp( $a_ALM_Kardex['FechCreacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_KardexBN;
    }
}
?>