<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemStockDetHis.xml */
/* Generado: 2021-06-25 23:59:41 */

/* Busqueda de registros de la tabla ALM_ItemStockDetHis. */
abstract class BaseALM_ItemStockDetHisFN extends ALM_ItemStockDetHisBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_ItemStockDetHis.IdCompania";
    const IdSucursal = "ALM_ItemStockDetHis.IdSucursal";
    const IdFecha = "ALM_ItemStockDetHis.IdFecha";
    const IdAlmacen = "ALM_ItemStockDetHis.IdAlmacen";
    const IdLote = "ALM_ItemStockDetHis.IdLote";
    const IdItem = "ALM_ItemStockDetHis.IdItem";
    const StockFisico = "ALM_ItemStockDetHis.StockFisico";
    const Costo = "ALM_ItemStockDetHis.Costo";
    const CostoDolares = "ALM_ItemStockDetHis.CostoDolares";
    const FechaCreacion = "ALM_ItemStockDetHis.FechaCreacion";
    const UsuarioCreacion = "ALM_ItemStockDetHis.UsuarioCreacion";
    const FechaModificacion = "ALM_ItemStockDetHis.FechaModificacion";
    const UsuarioModificacion = "ALM_ItemStockDetHis.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ItemStockDetHis.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.IdFecha AS IdFecha, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.StockFisico AS StockFisico, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.Costo AS Costo, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.CostoDolares AS CostoDolares, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_ItemStockDetHis.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ItemStockDetHisBN */
    public function setByBN( ALM_ItemStockDetHisBN $o_ALM_ItemStockDetHisBN )
    {
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ItemStockDetHisBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_ItemStockDetHisBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdFecha() ) )
        {
            $this->setIdFecha( $o_ALM_ItemStockDetHisBN->getIdFecha() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ItemStockDetHisBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_ItemStockDetHisBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemStockDetHisBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_ItemStockDetHisBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getCosto() ) )
        {
            $this->setCosto( $o_ALM_ItemStockDetHisBN->getCosto() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getCostoDolares() ) )
        {
            $this->setCostoDolares( $o_ALM_ItemStockDetHisBN->getCostoDolares() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemStockDetHisBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemStockDetHisBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemStockDetHisBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemStockDetHisBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_ItemStockDetHisBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $i_IdSucursal, $d_IdFecha, $s_IdAlmacen, $s_IdLote, $s_IdItem )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
        if( is_null( $d_IdFecha ) ){ $d_IdFecha = '-1'; } 
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
        if( is_null( $s_IdLote ) ){ $s_IdLote = '-1'; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemStockDetHis ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "AND IdFecha = '".$d_IdFecha."' ";
        $s_SQLQuery .= "AND IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "AND IdLote = '".$s_IdLote."' ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_ItemStockDetHisBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ItemStockDetHisBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemStockDetHisBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdFecha() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdFecha = '".$this->getIdFecha()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getStockFisico() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.StockFisico = ".$this->getStockFisico()." AND ";
        if ( !is_null( $this->getCosto() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.Costo = ".$this->getCosto()." AND ";
        if ( !is_null( $this->getCostoDolares() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.CostoDolares = ".$this->getCostoDolares()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_ItemStockDetHis.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ItemStockDetHis WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ItemStockDetHisBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemStockDetHis WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_ItemStockDetHisBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ItemStockDetHisBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ItemStockDetHisBN[] = $o_ALM_ItemStockDetHisBN;
            }
        }
        return $a_ALM_ItemStockDetHisBN;
    }

    /* Devuelve un objeto ALM_ItemStockDetHisBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ItemStockDetHis )
    {
        $o_ALM_ItemStockDetHisBN = new ALM_ItemStockDetHisBN();
        if ( !is_null( $a_ALM_ItemStockDetHis['IdCompania'] ) ) $o_ALM_ItemStockDetHisBN->setIdCompania( ( integer ) $a_ALM_ItemStockDetHis['IdCompania'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['IdSucursal'] ) ) $o_ALM_ItemStockDetHisBN->setIdSucursal( ( integer ) $a_ALM_ItemStockDetHis['IdSucursal'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['IdFecha'] ) ) $o_ALM_ItemStockDetHisBN->setIdFecha( utilTimestamp::getTimestamp( $a_ALM_ItemStockDetHis['IdFecha'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_ItemStockDetHis['IdAlmacen'] ) ) $o_ALM_ItemStockDetHisBN->setIdAlmacen( $a_ALM_ItemStockDetHis['IdAlmacen'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['IdLote'] ) ) $o_ALM_ItemStockDetHisBN->setIdLote( $a_ALM_ItemStockDetHis['IdLote'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['IdItem'] ) ) $o_ALM_ItemStockDetHisBN->setIdItem( $a_ALM_ItemStockDetHis['IdItem'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['StockFisico'] ) ) $o_ALM_ItemStockDetHisBN->setStockFisico( ( float ) $a_ALM_ItemStockDetHis['StockFisico'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['Costo'] ) ) $o_ALM_ItemStockDetHisBN->setCosto( ( float ) $a_ALM_ItemStockDetHis['Costo'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['CostoDolares'] ) ) $o_ALM_ItemStockDetHisBN->setCostoDolares( ( float ) $a_ALM_ItemStockDetHis['CostoDolares'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['FechaCreacion'] ) ) $o_ALM_ItemStockDetHisBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ItemStockDetHis['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemStockDetHis['UsuarioCreacion'] ) ) $o_ALM_ItemStockDetHisBN->setUsuarioCreacion( $a_ALM_ItemStockDetHis['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ItemStockDetHis['FechaModificacion'] ) ) $o_ALM_ItemStockDetHisBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_ItemStockDetHis['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemStockDetHis['UsuarioModificacion'] ) ) $o_ALM_ItemStockDetHisBN->setUsuarioModificacion( $a_ALM_ItemStockDetHis['UsuarioModificacion'] );
        return $o_ALM_ItemStockDetHisBN;
    }
}
?>