<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemMast.xml */
/* Generado: 2021-06-25 23:59:41 */

/* Busqueda de registros de la tabla ALM_ItemMast. */
abstract class BaseALM_ItemMastFN extends ALM_ItemMastBN
{
    /* Declaracion de constantes */
    const IdItem = "ALM_ItemMast.IdItem";
    const IdMarca = "ALM_ItemMast.IdMarca";
    const IdItemTipo = "ALM_ItemMast.IdItemTipo";
    const DescripcionIngles = "ALM_ItemMast.DescripcionIngles";
    const DescripcionCompleta = "ALM_ItemMast.DescripcionCompleta";
    const UrlAmigable = "ALM_ItemMast.UrlAmigable";
    const NumeroDeParte = "ALM_ItemMast.NumeroDeParte";
    const CodigoInterno = "ALM_ItemMast.CodigoInterno";
    const IdItemFiscal = "ALM_ItemMast.IdItemFiscal";
    const CodigoSunat = "ALM_ItemMast.CodigoSunat";
    const UnidadCodigo = "ALM_ItemMast.UnidadCodigo";
    const UnidadCompra = "ALM_ItemMast.UnidadCompra";
    const UnidadVenta = "ALM_ItemMast.UnidadVenta";
    const UnidadAlmacenaje = "ALM_ItemMast.UnidadAlmacenaje";
    const UnidadEmbalaje = "ALM_ItemMast.UnidadEmbalaje";
    const ClasificacionComercial = "ALM_ItemMast.ClasificacionComercial";
    const CodigoBarras = "ALM_ItemMast.CodigoBarras";
    const CodigoBarrasFabricante = "ALM_ItemMast.CodigoBarrasFabricante";
    const CodigoBarras2 = "ALM_ItemMast.CodigoBarras2";
    const MonedaCodigo = "ALM_ItemMast.MonedaCodigo";
    const PrecioCosto = "ALM_ItemMast.PrecioCosto";
    const PrecioVenta = "ALM_ItemMast.PrecioVenta";
    const UtilidadPorcentaje = "ALM_ItemMast.UtilidadPorcentaje";
    const PrecioUnitarioLocal = "ALM_ItemMast.PrecioUnitarioLocal";
    const PrecioUnitarioDolares = "ALM_ItemMast.PrecioUnitarioDolares";
    const DisponibleVentaFlag = "ALM_ItemMast.DisponibleVentaFlag";
    const ManejoxLoteFlag = "ALM_ItemMast.ManejoxLoteFlag";
    const ManejoxSerieFlag = "ALM_ItemMast.ManejoxSerieFlag";
    const ManejoxUnidadFlag = "ALM_ItemMast.ManejoxUnidadFlag";
    const NoAfectoImpuestoVentasFlag = "ALM_ItemMast.NoAfectoImpuestoVentasFlag";
    const DisponibleTransferenciaFlag = "ALM_ItemMast.DisponibleTransferenciaFlag";
    const StockMinimo = "ALM_ItemMast.StockMinimo";
    const StockMaximo = "ALM_ItemMast.StockMaximo";
    const StockMinFlag = "ALM_ItemMast.StockMinFlag";
    const LotedeVenta = "ALM_ItemMast.LotedeVenta";
    const Estado = "ALM_ItemMast.Estado";
    const NombreArchivo = "ALM_ItemMast.NombreArchivo";
    const UbicacionURL = "ALM_ItemMast.UbicacionURL";
    const UbicacionFisica = "ALM_ItemMast.UbicacionFisica";
    const UsuarioCreacion = "ALM_ItemMast.UsuarioCreacion";
    const FechaCreacion = "ALM_ItemMast.FechaCreacion";
    const UsuarioModificacion = "ALM_ItemMast.UsuarioModificacion";
    const FechaModificacion = "ALM_ItemMast.FechaModificacion";
    const IdLinea = "ALM_ItemMast.IdLinea";
    const IdFamilia = "ALM_ItemMast.IdFamilia";
    const IdSubFamilia = "ALM_ItemMast.IdSubFamilia";
    const IdProcedencia = "ALM_ItemMast.IdProcedencia";
    const TipoGarantiaId = "ALM_ItemMast.TipoGarantiaId";
    const IdTipoOperatividad = "ALM_ItemMast.IdTipoOperatividad";
    const PesoGramos = "ALM_ItemMast.PesoGramos";
    const AfectoPercepcionIGVFlag = "ALM_ItemMast.AfectoPercepcionIGVFlag";
    const AfectoDetraccionFlag = "ALM_ItemMast.AfectoDetraccionFlag";
    const IdDetraccion = "ALM_ItemMast.IdDetraccion";
    const IdPersona = "ALM_ItemMast.IdPersona";
    const CantidadUnidad = "ALM_ItemMast.CantidadUnidad";
    const CantidadUnidadCompra = "ALM_ItemMast.CantidadUnidadCompra";
    const DescripcionLarga = "ALM_ItemMast.DescripcionLarga";
    const EsInventariableFlag = "ALM_ItemMast.EsInventariableFlag";
    const FusionarLoteFlag = "ALM_ItemMast.FusionarLoteFlag";
    const EsServicioConDias = "ALM_ItemMast.EsServicioConDias";
    const UsarDisponibleStock = "ALM_ItemMast.UsarDisponibleStock";
    const UsarResevableStock = "ALM_ItemMast.UsarResevableStock";
    const EsParaVenta = "ALM_ItemMast.EsParaVenta";
    const IdRangoVenta = "ALM_ItemMast.IdRangoVenta";
    const EsParaAlquiler = "ALM_ItemMast.EsParaAlquiler";
    const IdRangoAlquiler = "ALM_ItemMast.IdRangoAlquiler";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ItemMast.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_ItemMast.IdMarca AS IdMarca, ";
        $s_SQLQuery .= "ALM_ItemMast.IdItemTipo AS IdItemTipo, ";
        $s_SQLQuery .= "ALM_ItemMast.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "ALM_ItemMast.DescripcionCompleta AS DescripcionCompleta, ";
        $s_SQLQuery .= "ALM_ItemMast.UrlAmigable AS UrlAmigable, ";
        $s_SQLQuery .= "ALM_ItemMast.NumeroDeParte AS NumeroDeParte, ";
        $s_SQLQuery .= "ALM_ItemMast.CodigoInterno AS CodigoInterno, ";
        $s_SQLQuery .= "ALM_ItemMast.IdItemFiscal AS IdItemFiscal, ";
        $s_SQLQuery .= "ALM_ItemMast.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "ALM_ItemMast.UnidadCodigo AS UnidadCodigo, ";
        $s_SQLQuery .= "ALM_ItemMast.UnidadCompra AS UnidadCompra, ";
        $s_SQLQuery .= "ALM_ItemMast.UnidadVenta AS UnidadVenta, ";
        $s_SQLQuery .= "ALM_ItemMast.UnidadAlmacenaje AS UnidadAlmacenaje, ";
        $s_SQLQuery .= "ALM_ItemMast.UnidadEmbalaje AS UnidadEmbalaje, ";
        $s_SQLQuery .= "ALM_ItemMast.ClasificacionComercial AS ClasificacionComercial, ";
        $s_SQLQuery .= "ALM_ItemMast.CodigoBarras AS CodigoBarras, ";
        $s_SQLQuery .= "ALM_ItemMast.CodigoBarrasFabricante AS CodigoBarrasFabricante, ";
        $s_SQLQuery .= "ALM_ItemMast.CodigoBarras2 AS CodigoBarras2, ";
        $s_SQLQuery .= "ALM_ItemMast.MonedaCodigo AS MonedaCodigo, ";
        $s_SQLQuery .= "ALM_ItemMast.PrecioCosto AS PrecioCosto, ";
        $s_SQLQuery .= "ALM_ItemMast.PrecioVenta AS PrecioVenta, ";
        $s_SQLQuery .= "ALM_ItemMast.UtilidadPorcentaje AS UtilidadPorcentaje, ";
        $s_SQLQuery .= "ALM_ItemMast.PrecioUnitarioLocal AS PrecioUnitarioLocal, ";
        $s_SQLQuery .= "ALM_ItemMast.PrecioUnitarioDolares AS PrecioUnitarioDolares, ";
        $s_SQLQuery .= "ALM_ItemMast.DisponibleVentaFlag AS DisponibleVentaFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.ManejoxLoteFlag AS ManejoxLoteFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.ManejoxSerieFlag AS ManejoxSerieFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.ManejoxUnidadFlag AS ManejoxUnidadFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.NoAfectoImpuestoVentasFlag AS NoAfectoImpuestoVentasFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.DisponibleTransferenciaFlag AS DisponibleTransferenciaFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.StockMinimo AS StockMinimo, ";
        $s_SQLQuery .= "ALM_ItemMast.StockMaximo AS StockMaximo, ";
        $s_SQLQuery .= "ALM_ItemMast.StockMinFlag AS StockMinFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.LotedeVenta AS LotedeVenta, ";
        $s_SQLQuery .= "ALM_ItemMast.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_ItemMast.NombreArchivo AS NombreArchivo, ";
        $s_SQLQuery .= "ALM_ItemMast.UbicacionURL AS UbicacionURL, ";
        $s_SQLQuery .= "ALM_ItemMast.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "ALM_ItemMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ItemMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_ItemMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_ItemMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_ItemMast.IdLinea AS IdLinea, ";
        $s_SQLQuery .= "ALM_ItemMast.IdFamilia AS IdFamilia, ";
        $s_SQLQuery .= "ALM_ItemMast.IdSubFamilia AS IdSubFamilia, ";
        $s_SQLQuery .= "ALM_ItemMast.IdProcedencia AS IdProcedencia, ";
        $s_SQLQuery .= "ALM_ItemMast.TipoGarantiaId AS TipoGarantiaId, ";
        $s_SQLQuery .= "ALM_ItemMast.IdTipoOperatividad AS IdTipoOperatividad, ";
        $s_SQLQuery .= "ALM_ItemMast.PesoGramos AS PesoGramos, ";
        $s_SQLQuery .= "ALM_ItemMast.AfectoPercepcionIGVFlag AS AfectoPercepcionIGVFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.AfectoDetraccionFlag AS AfectoDetraccionFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.IdDetraccion AS IdDetraccion, ";
        $s_SQLQuery .= "ALM_ItemMast.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "ALM_ItemMast.CantidadUnidad AS CantidadUnidad, ";
        $s_SQLQuery .= "ALM_ItemMast.CantidadUnidadCompra AS CantidadUnidadCompra, ";
        $s_SQLQuery .= "ALM_ItemMast.DescripcionLarga AS DescripcionLarga, ";
        $s_SQLQuery .= "ALM_ItemMast.EsInventariableFlag AS EsInventariableFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.FusionarLoteFlag AS FusionarLoteFlag, ";
        $s_SQLQuery .= "ALM_ItemMast.EsServicioConDias AS EsServicioConDias, ";
        $s_SQLQuery .= "ALM_ItemMast.UsarDisponibleStock AS UsarDisponibleStock, ";
        $s_SQLQuery .= "ALM_ItemMast.UsarResevableStock AS UsarResevableStock, ";
        $s_SQLQuery .= "ALM_ItemMast.EsParaVenta AS EsParaVenta, ";
        $s_SQLQuery .= "ALM_ItemMast.IdRangoVenta AS IdRangoVenta, ";
        $s_SQLQuery .= "ALM_ItemMast.EsParaAlquiler AS EsParaAlquiler, ";
        $s_SQLQuery .= "ALM_ItemMast.IdRangoAlquiler AS IdRangoAlquiler ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ItemMastBN */
    public function setByBN( ALM_ItemMastBN $o_ALM_ItemMastBN )
    {
        if ( !is_null( $o_ALM_ItemMastBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdMarca() ) )
        {
            $this->setIdMarca( $o_ALM_ItemMastBN->getIdMarca() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdItemTipo() ) )
        {
            $this->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_ItemMastBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionCompleta() ) )
        {
            $this->setDescripcionCompleta( $o_ALM_ItemMastBN->getDescripcionCompleta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDUrlAmigable() ) )
        {
            $this->setUrlAmigable( $o_ALM_ItemMastBN->getUrlAmigable() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNumeroDeParte() ) )
        {
            $this->setNumeroDeParte( $o_ALM_ItemMastBN->getNumeroDeParte() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoInterno() ) )
        {
            $this->setCodigoInterno( $o_ALM_ItemMastBN->getCodigoInterno() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdItemFiscal() ) )
        {
            $this->setIdItemFiscal( $o_ALM_ItemMastBN->getIdItemFiscal() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_ItemMastBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadCodigo() ) )
        {
            $this->setUnidadCodigo( $o_ALM_ItemMastBN->getUnidadCodigo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadCompra() ) )
        {
            $this->setUnidadCompra( $o_ALM_ItemMastBN->getUnidadCompra() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadVenta() ) )
        {
            $this->setUnidadVenta( $o_ALM_ItemMastBN->getUnidadVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadAlmacenaje() ) )
        {
            $this->setUnidadAlmacenaje( $o_ALM_ItemMastBN->getUnidadAlmacenaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadEmbalaje() ) )
        {
            $this->setUnidadEmbalaje( $o_ALM_ItemMastBN->getUnidadEmbalaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getClasificacionComercial() ) )
        {
            $this->setClasificacionComercial( $o_ALM_ItemMastBN->getClasificacionComercial() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarras() ) )
        {
            $this->setCodigoBarras( $o_ALM_ItemMastBN->getCodigoBarras() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarrasFabricante() ) )
        {
            $this->setCodigoBarrasFabricante( $o_ALM_ItemMastBN->getCodigoBarrasFabricante() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarras2() ) )
        {
            $this->setCodigoBarras2( $o_ALM_ItemMastBN->getCodigoBarras2() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getMonedaCodigo() ) )
        {
            $this->setMonedaCodigo( $o_ALM_ItemMastBN->getMonedaCodigo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioCosto() ) )
        {
            $this->setPrecioCosto( $o_ALM_ItemMastBN->getPrecioCosto() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioVenta() ) )
        {
            $this->setPrecioVenta( $o_ALM_ItemMastBN->getPrecioVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUtilidadPorcentaje() ) )
        {
            $this->setUtilidadPorcentaje( $o_ALM_ItemMastBN->getUtilidadPorcentaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioUnitarioLocal() ) )
        {
            $this->setPrecioUnitarioLocal( $o_ALM_ItemMastBN->getPrecioUnitarioLocal() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_ItemMastBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDisponibleVentaFlag() ) )
        {
            $this->setDisponibleVentaFlag( $o_ALM_ItemMastBN->getDisponibleVentaFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxLoteFlag() ) )
        {
            $this->setManejoxLoteFlag( $o_ALM_ItemMastBN->getManejoxLoteFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxSerieFlag() ) )
        {
            $this->setManejoxSerieFlag( $o_ALM_ItemMastBN->getManejoxSerieFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxUnidadFlag() ) )
        {
            $this->setManejoxUnidadFlag( $o_ALM_ItemMastBN->getManejoxUnidadFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() ) )
        {
            $this->setNoAfectoImpuestoVentasFlag( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDisponibleTransferenciaFlag() ) )
        {
            $this->setDisponibleTransferenciaFlag( $o_ALM_ItemMastBN->getDisponibleTransferenciaFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_ALM_ItemMastBN->getStockMinimo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_ALM_ItemMastBN->getStockMaximo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMinFlag() ) )
        {
            $this->setStockMinFlag( $o_ALM_ItemMastBN->getStockMinFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getLotedeVenta() ) )
        {
            $this->setLotedeVenta( $o_ALM_ItemMastBN->getLotedeVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_ItemMastBN->getEstado() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNombreArchivo() ) )
        {
            $this->setNombreArchivo( $o_ALM_ItemMastBN->getNombreArchivo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_ALM_ItemMastBN->getUbicacionURL() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_ALM_ItemMastBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_ALM_ItemMastBN->getIdLinea() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_ALM_ItemMastBN->getIdFamilia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdSubFamilia() ) )
        {
            $this->setIdSubFamilia( $o_ALM_ItemMastBN->getIdSubFamilia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdProcedencia() ) )
        {
            $this->setIdProcedencia( $o_ALM_ItemMastBN->getIdProcedencia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getTipoGarantiaId() ) )
        {
            $this->setTipoGarantiaId( $o_ALM_ItemMastBN->getTipoGarantiaId() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdTipoOperatividad() ) )
        {
            $this->setIdTipoOperatividad( $o_ALM_ItemMastBN->getIdTipoOperatividad() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPesoGramos() ) )
        {
            $this->setPesoGramos( $o_ALM_ItemMastBN->getPesoGramos() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getAfectoPercepcionIGVFlag() ) )
        {
            $this->setAfectoPercepcionIGVFlag( $o_ALM_ItemMastBN->getAfectoPercepcionIGVFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getAfectoDetraccionFlag() ) )
        {
            $this->setAfectoDetraccionFlag( $o_ALM_ItemMastBN->getAfectoDetraccionFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdDetraccion() ) )
        {
            $this->setIdDetraccion( $o_ALM_ItemMastBN->getIdDetraccion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_ALM_ItemMastBN->getIdPersona() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCantidadUnidad() ) )
        {
            $this->setCantidadUnidad( $o_ALM_ItemMastBN->getCantidadUnidad() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCantidadUnidadCompra() ) )
        {
            $this->setCantidadUnidadCompra( $o_ALM_ItemMastBN->getCantidadUnidadCompra() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionLarga() ) )
        {
            $this->setDescripcionLarga( $o_ALM_ItemMastBN->getDescripcionLarga() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsInventariableFlag() ) )
        {
            $this->setEsInventariableFlag( $o_ALM_ItemMastBN->getEsInventariableFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFusionarLoteFlag() ) )
        {
            $this->setFusionarLoteFlag( $o_ALM_ItemMastBN->getFusionarLoteFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsServicioConDias() ) )
        {
            $this->setEsServicioConDias( $o_ALM_ItemMastBN->getEsServicioConDias() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsarDisponibleStock() ) )
        {
            $this->setUsarDisponibleStock( $o_ALM_ItemMastBN->getUsarDisponibleStock() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsarResevableStock() ) )
        {
            $this->setUsarResevableStock( $o_ALM_ItemMastBN->getUsarResevableStock() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsParaVenta() ) )
        {
            $this->setEsParaVenta( $o_ALM_ItemMastBN->getEsParaVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdRangoVenta() ) )
        {
            $this->setIdRangoVenta( $o_ALM_ItemMastBN->getIdRangoVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsParaAlquiler() ) )
        {
            $this->setEsParaAlquiler( $o_ALM_ItemMastBN->getEsParaAlquiler() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdRangoAlquiler() ) )
        {
            $this->setIdRangoAlquiler( $o_ALM_ItemMastBN->getIdRangoAlquiler() );
        }
    }

    /**
    * @return ALM_ItemMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdItem )
    {
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemMast ";
        $s_SQLQuery .= "WHERE IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_ItemMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ItemMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_ItemMast.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdMarca() ) ) $s_SQLQuery .= "ALM_ItemMast.IdMarca = '".$this->getIdMarca()."' AND ";
        if ( !is_null( $this->getIdItemTipo() ) ) $s_SQLQuery .= "ALM_ItemMast.IdItemTipo = '".$this->getIdItemTipo()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "ALM_ItemMast.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getDescripcionCompleta() ) ) $s_SQLQuery .= "ALM_ItemMast.DescripcionCompleta = '".$this->getDescripcionCompleta()."' AND ";
        if ( !is_null( $this->getUrlAmigable() ) ) $s_SQLQuery .= "ALM_ItemMast.UrlAmigable = '".$this->getUrlAmigable()."' AND ";
        if ( !is_null( $this->getNumeroDeParte() ) ) $s_SQLQuery .= "ALM_ItemMast.NumeroDeParte = '".$this->getNumeroDeParte()."' AND ";
        if ( !is_null( $this->getCodigoInterno() ) ) $s_SQLQuery .= "ALM_ItemMast.CodigoInterno = '".$this->getCodigoInterno()."' AND ";
        if ( !is_null( $this->getIdItemFiscal() ) ) $s_SQLQuery .= "ALM_ItemMast.IdItemFiscal = ".$this->getIdItemFiscal()." AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "ALM_ItemMast.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getUnidadCodigo() ) ) $s_SQLQuery .= "ALM_ItemMast.UnidadCodigo = '".$this->getUnidadCodigo()."' AND ";
        if ( !is_null( $this->getUnidadCompra() ) ) $s_SQLQuery .= "ALM_ItemMast.UnidadCompra = '".$this->getUnidadCompra()."' AND ";
        if ( !is_null( $this->getUnidadVenta() ) ) $s_SQLQuery .= "ALM_ItemMast.UnidadVenta = '".$this->getUnidadVenta()."' AND ";
        if ( !is_null( $this->getUnidadAlmacenaje() ) ) $s_SQLQuery .= "ALM_ItemMast.UnidadAlmacenaje = '".$this->getUnidadAlmacenaje()."' AND ";
        if ( !is_null( $this->getUnidadEmbalaje() ) ) $s_SQLQuery .= "ALM_ItemMast.UnidadEmbalaje = '".$this->getUnidadEmbalaje()."' AND ";
        if ( !is_null( $this->getClasificacionComercial() ) ) $s_SQLQuery .= "ALM_ItemMast.ClasificacionComercial = '".$this->getClasificacionComercial()."' AND ";
        if ( !is_null( $this->getCodigoBarras() ) ) $s_SQLQuery .= "ALM_ItemMast.CodigoBarras = '".$this->getCodigoBarras()."' AND ";
        if ( !is_null( $this->getCodigoBarrasFabricante() ) ) $s_SQLQuery .= "ALM_ItemMast.CodigoBarrasFabricante = '".$this->getCodigoBarrasFabricante()."' AND ";
        if ( !is_null( $this->getCodigoBarras2() ) ) $s_SQLQuery .= "ALM_ItemMast.CodigoBarras2 = '".$this->getCodigoBarras2()."' AND ";
        if ( !is_null( $this->getMonedaCodigo() ) ) $s_SQLQuery .= "ALM_ItemMast.MonedaCodigo = '".$this->getMonedaCodigo()."' AND ";
        if ( !is_null( $this->getPrecioCosto() ) ) $s_SQLQuery .= "ALM_ItemMast.PrecioCosto = ".$this->getPrecioCosto()." AND ";
        if ( !is_null( $this->getPrecioVenta() ) ) $s_SQLQuery .= "ALM_ItemMast.PrecioVenta = ".$this->getPrecioVenta()." AND ";
        if ( !is_null( $this->getUtilidadPorcentaje() ) ) $s_SQLQuery .= "ALM_ItemMast.UtilidadPorcentaje = ".$this->getUtilidadPorcentaje()." AND ";
        if ( !is_null( $this->getPrecioUnitarioLocal() ) ) $s_SQLQuery .= "ALM_ItemMast.PrecioUnitarioLocal = ".$this->getPrecioUnitarioLocal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioDolares() ) ) $s_SQLQuery .= "ALM_ItemMast.PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()." AND ";
        if ( !is_null( $this->getDisponibleVentaFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.DisponibleVentaFlag = '".$this->getDisponibleVentaFlag()."' AND ";
        if ( !is_null( $this->getManejoxLoteFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.ManejoxLoteFlag = '".$this->getManejoxLoteFlag()."' AND ";
        if ( !is_null( $this->getManejoxSerieFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.ManejoxSerieFlag = '".$this->getManejoxSerieFlag()."' AND ";
        if ( !is_null( $this->getManejoxUnidadFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.ManejoxUnidadFlag = '".$this->getManejoxUnidadFlag()."' AND ";
        if ( !is_null( $this->getNoAfectoImpuestoVentasFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.NoAfectoImpuestoVentasFlag = '".$this->getNoAfectoImpuestoVentasFlag()."' AND ";
        if ( !is_null( $this->getDisponibleTransferenciaFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.DisponibleTransferenciaFlag = '".$this->getDisponibleTransferenciaFlag()."' AND ";
        if ( !is_null( $this->getStockMinimo() ) ) $s_SQLQuery .= "ALM_ItemMast.StockMinimo = ".$this->getStockMinimo()." AND ";
        if ( !is_null( $this->getStockMaximo() ) ) $s_SQLQuery .= "ALM_ItemMast.StockMaximo = ".$this->getStockMaximo()." AND ";
        if ( !is_null( $this->getStockMinFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.StockMinFlag = '".$this->getStockMinFlag()."' AND ";
        if ( !is_null( $this->getLotedeVenta() ) ) $s_SQLQuery .= "ALM_ItemMast.LotedeVenta = ".$this->getLotedeVenta()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_ItemMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getNombreArchivo() ) ) $s_SQLQuery .= "ALM_ItemMast.NombreArchivo = '".$this->getNombreArchivo()."' AND ";
        if ( !is_null( $this->getUbicacionURL() ) ) $s_SQLQuery .= "ALM_ItemMast.UbicacionURL = '".$this->getUbicacionURL()."' AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "ALM_ItemMast.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ItemMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ItemMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_ItemMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_ItemMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getIdLinea() ) ) $s_SQLQuery .= "ALM_ItemMast.IdLinea = ".$this->getIdLinea()." AND ";
        if ( !is_null( $this->getIdFamilia() ) ) $s_SQLQuery .= "ALM_ItemMast.IdFamilia = ".$this->getIdFamilia()." AND ";
        if ( !is_null( $this->getIdSubFamilia() ) ) $s_SQLQuery .= "ALM_ItemMast.IdSubFamilia = ".$this->getIdSubFamilia()." AND ";
        if ( !is_null( $this->getIdProcedencia() ) ) $s_SQLQuery .= "ALM_ItemMast.IdProcedencia = '".$this->getIdProcedencia()."' AND ";
        if ( !is_null( $this->getTipoGarantiaId() ) ) $s_SQLQuery .= "ALM_ItemMast.TipoGarantiaId = '".$this->getTipoGarantiaId()."' AND ";
        if ( !is_null( $this->getIdTipoOperatividad() ) ) $s_SQLQuery .= "ALM_ItemMast.IdTipoOperatividad = '".$this->getIdTipoOperatividad()."' AND ";
        if ( !is_null( $this->getPesoGramos() ) ) $s_SQLQuery .= "ALM_ItemMast.PesoGramos = ".$this->getPesoGramos()." AND ";
        if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.AfectoPercepcionIGVFlag = '".$this->getAfectoPercepcionIGVFlag()."' AND ";
        if ( !is_null( $this->getAfectoDetraccionFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.AfectoDetraccionFlag = '".$this->getAfectoDetraccionFlag()."' AND ";
        if ( !is_null( $this->getIdDetraccion() ) ) $s_SQLQuery .= "ALM_ItemMast.IdDetraccion = ".$this->getIdDetraccion()." AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "ALM_ItemMast.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getCantidadUnidad() ) ) $s_SQLQuery .= "ALM_ItemMast.CantidadUnidad = ".$this->getCantidadUnidad()." AND ";
        if ( !is_null( $this->getCantidadUnidadCompra() ) ) $s_SQLQuery .= "ALM_ItemMast.CantidadUnidadCompra = ".$this->getCantidadUnidadCompra()." AND ";
        if ( !is_null( $this->getDescripcionLarga() ) ) $s_SQLQuery .= "ALM_ItemMast.DescripcionLarga = '".$this->getDescripcionLarga()."' AND ";
        if ( !is_null( $this->getEsInventariableFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.EsInventariableFlag = '".$this->getEsInventariableFlag()."' AND ";
        if ( !is_null( $this->getFusionarLoteFlag() ) ) $s_SQLQuery .= "ALM_ItemMast.FusionarLoteFlag = '".$this->getFusionarLoteFlag()."' AND ";
        if ( !is_null( $this->getEsServicioConDias() ) ) $s_SQLQuery .= "ALM_ItemMast.EsServicioConDias = '".$this->getEsServicioConDias()."' AND ";
        if ( !is_null( $this->getUsarDisponibleStock() ) ) $s_SQLQuery .= "ALM_ItemMast.UsarDisponibleStock = '".$this->getUsarDisponibleStock()."' AND ";
        if ( !is_null( $this->getUsarResevableStock() ) ) $s_SQLQuery .= "ALM_ItemMast.UsarResevableStock = '".$this->getUsarResevableStock()."' AND ";
        if ( !is_null( $this->getEsParaVenta() ) ) $s_SQLQuery .= "ALM_ItemMast.EsParaVenta = '".$this->getEsParaVenta()."' AND ";
        if ( !is_null( $this->getIdRangoVenta() ) ) $s_SQLQuery .= "ALM_ItemMast.IdRangoVenta = ".$this->getIdRangoVenta()." AND ";
        if ( !is_null( $this->getEsParaAlquiler() ) ) $s_SQLQuery .= "ALM_ItemMast.EsParaAlquiler = '".$this->getEsParaAlquiler()."' AND ";
        if ( !is_null( $this->getIdRangoAlquiler() ) ) $s_SQLQuery .= "ALM_ItemMast.IdRangoAlquiler = ".$this->getIdRangoAlquiler()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ItemMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ItemMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_ItemMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ItemMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ItemMastBN[] = $o_ALM_ItemMastBN;
            }
        }
        return $a_ALM_ItemMastBN;
    }

    /* Devuelve un objeto ALM_ItemMastBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ItemMast )
    {
        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        if ( !is_null( $a_ALM_ItemMast['IdItem'] ) ) $o_ALM_ItemMastBN->setIdItem( $a_ALM_ItemMast['IdItem'] );
        if ( !is_null( $a_ALM_ItemMast['IdMarca'] ) ) $o_ALM_ItemMastBN->setIdMarca( $a_ALM_ItemMast['IdMarca'] );
        if ( !is_null( $a_ALM_ItemMast['IdItemTipo'] ) ) $o_ALM_ItemMastBN->setIdItemTipo( $a_ALM_ItemMast['IdItemTipo'] );
        if ( !is_null( $a_ALM_ItemMast['DescripcionIngles'] ) ) $o_ALM_ItemMastBN->setDescripcionIngles( $a_ALM_ItemMast['DescripcionIngles'] );
        if ( !is_null( $a_ALM_ItemMast['DescripcionCompleta'] ) ) $o_ALM_ItemMastBN->setDescripcionCompleta( $a_ALM_ItemMast['DescripcionCompleta'] );
        if ( !is_null( $a_ALM_ItemMast['UrlAmigable'] ) ) $o_ALM_ItemMastBN->setUrlAmigable( $a_ALM_ItemMast['UrlAmigable'] );
        if ( !is_null( $a_ALM_ItemMast['NumeroDeParte'] ) ) $o_ALM_ItemMastBN->setNumeroDeParte( $a_ALM_ItemMast['NumeroDeParte'] );
        if ( !is_null( $a_ALM_ItemMast['CodigoInterno'] ) ) $o_ALM_ItemMastBN->setCodigoInterno( $a_ALM_ItemMast['CodigoInterno'] );
        if ( !is_null( $a_ALM_ItemMast['IdItemFiscal'] ) ) $o_ALM_ItemMastBN->setIdItemFiscal( ( integer ) $a_ALM_ItemMast['IdItemFiscal'] );
        if ( !is_null( $a_ALM_ItemMast['CodigoSunat'] ) ) $o_ALM_ItemMastBN->setCodigoSunat( $a_ALM_ItemMast['CodigoSunat'] );
        if ( !is_null( $a_ALM_ItemMast['UnidadCodigo'] ) ) $o_ALM_ItemMastBN->setUnidadCodigo( $a_ALM_ItemMast['UnidadCodigo'] );
        if ( !is_null( $a_ALM_ItemMast['UnidadCompra'] ) ) $o_ALM_ItemMastBN->setUnidadCompra( $a_ALM_ItemMast['UnidadCompra'] );
        if ( !is_null( $a_ALM_ItemMast['UnidadVenta'] ) ) $o_ALM_ItemMastBN->setUnidadVenta( $a_ALM_ItemMast['UnidadVenta'] );
        if ( !is_null( $a_ALM_ItemMast['UnidadAlmacenaje'] ) ) $o_ALM_ItemMastBN->setUnidadAlmacenaje( $a_ALM_ItemMast['UnidadAlmacenaje'] );
        if ( !is_null( $a_ALM_ItemMast['UnidadEmbalaje'] ) ) $o_ALM_ItemMastBN->setUnidadEmbalaje( $a_ALM_ItemMast['UnidadEmbalaje'] );
        if ( !is_null( $a_ALM_ItemMast['ClasificacionComercial'] ) ) $o_ALM_ItemMastBN->setClasificacionComercial( $a_ALM_ItemMast['ClasificacionComercial'] );
        if ( !is_null( $a_ALM_ItemMast['CodigoBarras'] ) ) $o_ALM_ItemMastBN->setCodigoBarras( $a_ALM_ItemMast['CodigoBarras'] );
        if ( !is_null( $a_ALM_ItemMast['CodigoBarrasFabricante'] ) ) $o_ALM_ItemMastBN->setCodigoBarrasFabricante( $a_ALM_ItemMast['CodigoBarrasFabricante'] );
        if ( !is_null( $a_ALM_ItemMast['CodigoBarras2'] ) ) $o_ALM_ItemMastBN->setCodigoBarras2( $a_ALM_ItemMast['CodigoBarras2'] );
        if ( !is_null( $a_ALM_ItemMast['MonedaCodigo'] ) ) $o_ALM_ItemMastBN->setMonedaCodigo( $a_ALM_ItemMast['MonedaCodigo'] );
        if ( !is_null( $a_ALM_ItemMast['PrecioCosto'] ) ) $o_ALM_ItemMastBN->setPrecioCosto( ( float ) $a_ALM_ItemMast['PrecioCosto'] );
        if ( !is_null( $a_ALM_ItemMast['PrecioVenta'] ) ) $o_ALM_ItemMastBN->setPrecioVenta( ( float ) $a_ALM_ItemMast['PrecioVenta'] );
        if ( !is_null( $a_ALM_ItemMast['UtilidadPorcentaje'] ) ) $o_ALM_ItemMastBN->setUtilidadPorcentaje( ( float ) $a_ALM_ItemMast['UtilidadPorcentaje'] );
        if ( !is_null( $a_ALM_ItemMast['PrecioUnitarioLocal'] ) ) $o_ALM_ItemMastBN->setPrecioUnitarioLocal( ( float ) $a_ALM_ItemMast['PrecioUnitarioLocal'] );
        if ( !is_null( $a_ALM_ItemMast['PrecioUnitarioDolares'] ) ) $o_ALM_ItemMastBN->setPrecioUnitarioDolares( ( float ) $a_ALM_ItemMast['PrecioUnitarioDolares'] );
        if ( !is_null( $a_ALM_ItemMast['DisponibleVentaFlag'] ) ) $o_ALM_ItemMastBN->setDisponibleVentaFlag( $a_ALM_ItemMast['DisponibleVentaFlag'] );
        if ( !is_null( $a_ALM_ItemMast['ManejoxLoteFlag'] ) ) $o_ALM_ItemMastBN->setManejoxLoteFlag( $a_ALM_ItemMast['ManejoxLoteFlag'] );
        if ( !is_null( $a_ALM_ItemMast['ManejoxSerieFlag'] ) ) $o_ALM_ItemMastBN->setManejoxSerieFlag( $a_ALM_ItemMast['ManejoxSerieFlag'] );
        if ( !is_null( $a_ALM_ItemMast['ManejoxUnidadFlag'] ) ) $o_ALM_ItemMastBN->setManejoxUnidadFlag( $a_ALM_ItemMast['ManejoxUnidadFlag'] );
        if ( !is_null( $a_ALM_ItemMast['NoAfectoImpuestoVentasFlag'] ) ) $o_ALM_ItemMastBN->setNoAfectoImpuestoVentasFlag( $a_ALM_ItemMast['NoAfectoImpuestoVentasFlag'] );
        if ( !is_null( $a_ALM_ItemMast['DisponibleTransferenciaFlag'] ) ) $o_ALM_ItemMastBN->setDisponibleTransferenciaFlag( $a_ALM_ItemMast['DisponibleTransferenciaFlag'] );
        if ( !is_null( $a_ALM_ItemMast['StockMinimo'] ) ) $o_ALM_ItemMastBN->setStockMinimo( ( float ) $a_ALM_ItemMast['StockMinimo'] );
        if ( !is_null( $a_ALM_ItemMast['StockMaximo'] ) ) $o_ALM_ItemMastBN->setStockMaximo( ( float ) $a_ALM_ItemMast['StockMaximo'] );
        if ( !is_null( $a_ALM_ItemMast['StockMinFlag'] ) ) $o_ALM_ItemMastBN->setStockMinFlag( $a_ALM_ItemMast['StockMinFlag'] );
        if ( !is_null( $a_ALM_ItemMast['LotedeVenta'] ) ) $o_ALM_ItemMastBN->setLotedeVenta( ( integer ) $a_ALM_ItemMast['LotedeVenta'] );
        if ( !is_null( $a_ALM_ItemMast['Estado'] ) ) $o_ALM_ItemMastBN->setEstado( $a_ALM_ItemMast['Estado'] );
        if ( !is_null( $a_ALM_ItemMast['NombreArchivo'] ) ) $o_ALM_ItemMastBN->setNombreArchivo( $a_ALM_ItemMast['NombreArchivo'] );
        if ( !is_null( $a_ALM_ItemMast['UbicacionURL'] ) ) $o_ALM_ItemMastBN->setUbicacionURL( $a_ALM_ItemMast['UbicacionURL'] );
        if ( !is_null( $a_ALM_ItemMast['UbicacionFisica'] ) ) $o_ALM_ItemMastBN->setUbicacionFisica( $a_ALM_ItemMast['UbicacionFisica'] );
        if ( !is_null( $a_ALM_ItemMast['UsuarioCreacion'] ) ) $o_ALM_ItemMastBN->setUsuarioCreacion( $a_ALM_ItemMast['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ItemMast['FechaCreacion'] ) ) $o_ALM_ItemMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ItemMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemMast['UsuarioModificacion'] ) ) $o_ALM_ItemMastBN->setUsuarioModificacion( $a_ALM_ItemMast['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_ItemMast['FechaModificacion'] ) ) $o_ALM_ItemMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_ItemMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemMast['IdLinea'] ) ) $o_ALM_ItemMastBN->setIdLinea( ( integer ) $a_ALM_ItemMast['IdLinea'] );
        if ( !is_null( $a_ALM_ItemMast['IdFamilia'] ) ) $o_ALM_ItemMastBN->setIdFamilia( ( integer ) $a_ALM_ItemMast['IdFamilia'] );
        if ( !is_null( $a_ALM_ItemMast['IdSubFamilia'] ) ) $o_ALM_ItemMastBN->setIdSubFamilia( ( integer ) $a_ALM_ItemMast['IdSubFamilia'] );
        if ( !is_null( $a_ALM_ItemMast['IdProcedencia'] ) ) $o_ALM_ItemMastBN->setIdProcedencia( $a_ALM_ItemMast['IdProcedencia'] );
        if ( !is_null( $a_ALM_ItemMast['TipoGarantiaId'] ) ) $o_ALM_ItemMastBN->setTipoGarantiaId( $a_ALM_ItemMast['TipoGarantiaId'] );
        if ( !is_null( $a_ALM_ItemMast['IdTipoOperatividad'] ) ) $o_ALM_ItemMastBN->setIdTipoOperatividad( $a_ALM_ItemMast['IdTipoOperatividad'] );
        if ( !is_null( $a_ALM_ItemMast['PesoGramos'] ) ) $o_ALM_ItemMastBN->setPesoGramos( ( float ) $a_ALM_ItemMast['PesoGramos'] );
        if ( !is_null( $a_ALM_ItemMast['AfectoPercepcionIGVFlag'] ) ) $o_ALM_ItemMastBN->setAfectoPercepcionIGVFlag( $a_ALM_ItemMast['AfectoPercepcionIGVFlag'] );
        if ( !is_null( $a_ALM_ItemMast['AfectoDetraccionFlag'] ) ) $o_ALM_ItemMastBN->setAfectoDetraccionFlag( $a_ALM_ItemMast['AfectoDetraccionFlag'] );
        if ( !is_null( $a_ALM_ItemMast['IdDetraccion'] ) ) $o_ALM_ItemMastBN->setIdDetraccion( ( integer ) $a_ALM_ItemMast['IdDetraccion'] );
        if ( !is_null( $a_ALM_ItemMast['IdPersona'] ) ) $o_ALM_ItemMastBN->setIdPersona( ( integer ) $a_ALM_ItemMast['IdPersona'] );
        if ( !is_null( $a_ALM_ItemMast['CantidadUnidad'] ) ) $o_ALM_ItemMastBN->setCantidadUnidad( ( float ) $a_ALM_ItemMast['CantidadUnidad'] );
        if ( !is_null( $a_ALM_ItemMast['CantidadUnidadCompra'] ) ) $o_ALM_ItemMastBN->setCantidadUnidadCompra( ( float ) $a_ALM_ItemMast['CantidadUnidadCompra'] );
        if ( !is_null( $a_ALM_ItemMast['DescripcionLarga'] ) ) $o_ALM_ItemMastBN->setDescripcionLarga( $a_ALM_ItemMast['DescripcionLarga'] );
        if ( !is_null( $a_ALM_ItemMast['EsInventariableFlag'] ) ) $o_ALM_ItemMastBN->setEsInventariableFlag( $a_ALM_ItemMast['EsInventariableFlag'] );
        if ( !is_null( $a_ALM_ItemMast['FusionarLoteFlag'] ) ) $o_ALM_ItemMastBN->setFusionarLoteFlag( $a_ALM_ItemMast['FusionarLoteFlag'] );
        if ( !is_null( $a_ALM_ItemMast['EsServicioConDias'] ) ) $o_ALM_ItemMastBN->setEsServicioConDias( $a_ALM_ItemMast['EsServicioConDias'] );
        if ( !is_null( $a_ALM_ItemMast['UsarDisponibleStock'] ) ) $o_ALM_ItemMastBN->setUsarDisponibleStock( $a_ALM_ItemMast['UsarDisponibleStock'] );
        if ( !is_null( $a_ALM_ItemMast['UsarResevableStock'] ) ) $o_ALM_ItemMastBN->setUsarResevableStock( $a_ALM_ItemMast['UsarResevableStock'] );
        if ( !is_null( $a_ALM_ItemMast['EsParaVenta'] ) ) $o_ALM_ItemMastBN->setEsParaVenta( $a_ALM_ItemMast['EsParaVenta'] );
        if ( !is_null( $a_ALM_ItemMast['IdRangoVenta'] ) ) $o_ALM_ItemMastBN->setIdRangoVenta( ( integer ) $a_ALM_ItemMast['IdRangoVenta'] );
        if ( !is_null( $a_ALM_ItemMast['EsParaAlquiler'] ) ) $o_ALM_ItemMastBN->setEsParaAlquiler( $a_ALM_ItemMast['EsParaAlquiler'] );
        if ( !is_null( $a_ALM_ItemMast['IdRangoAlquiler'] ) ) $o_ALM_ItemMastBN->setIdRangoAlquiler( ( integer ) $a_ALM_ItemMast['IdRangoAlquiler'] );
        return $o_ALM_ItemMastBN;
    }
}
?>