<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemAlmacenStock.xml */
/* Generado: 2021-06-25 23:59:40 */

/* Busqueda de registros de la tabla ALM_ItemAlmacenStock. */
abstract class BaseALM_ItemAlmacenStockFN extends ALM_ItemAlmacenStockBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_ItemAlmacenStock.IdCompania";
    const IdItem = "ALM_ItemAlmacenStock.IdItem";
    const IdAlmacen = "ALM_ItemAlmacenStock.IdAlmacen";
    const IdCondicion = "ALM_ItemAlmacenStock.IdCondicion";
    const IdLote = "ALM_ItemAlmacenStock.IdLote";
    const IdSucursal = "ALM_ItemAlmacenStock.IdSucursal";
    const LoteEquivalente = "ALM_ItemAlmacenStock.LoteEquivalente";
    const Donante = "ALM_ItemAlmacenStock.Donante";
    const FechaIngreso = "ALM_ItemAlmacenStock.FechaIngreso";
    const FechaVencimiento = "ALM_ItemAlmacenStock.FechaVencimiento";
    const StockIngreso = "ALM_ItemAlmacenStock.StockIngreso";
    const StockActual = "ALM_ItemAlmacenStock.StockActual";
    const StockComprometido = "ALM_ItemAlmacenStock.StockComprometido";
    const StockActualDoble = "ALM_ItemAlmacenStock.StockActualDoble";
    const StockFisico = "ALM_ItemAlmacenStock.StockFisico";
    const StockReservado = "ALM_ItemAlmacenStock.StockReservado";
    const StockDisponible = "ALM_ItemAlmacenStock.StockDisponible";
    const PrecioUnitario = "ALM_ItemAlmacenStock.PrecioUnitario";
    const PrecioUnitarioDolares = "ALM_ItemAlmacenStock.PrecioUnitarioDolares";
    const Prioridad = "ALM_ItemAlmacenStock.Prioridad";
    const PrecioPromedioLocal = "ALM_ItemAlmacenStock.PrecioPromedioLocal";
    const PrecioPromedioDolares = "ALM_ItemAlmacenStock.PrecioPromedioDolares";
    const DocumentoReferencia = "ALM_ItemAlmacenStock.DocumentoReferencia";
    const Observaciones = "ALM_ItemAlmacenStock.Observaciones";
    const ObservacionesCorrectivas = "ALM_ItemAlmacenStock.ObservacionesCorrectivas";
    const FechaCreacion = "ALM_ItemAlmacenStock.FechaCreacion";
    const UsuarioCreacion = "ALM_ItemAlmacenStock.UsuarioCreacion";
    const FechaModificacion = "ALM_ItemAlmacenStock.FechaModificacion";
    const UsuarioModificacion = "ALM_ItemAlmacenStock.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_ItemAlmacenStock.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.IdCondicion AS IdCondicion, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.IdLote AS IdLote, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.LoteEquivalente AS LoteEquivalente, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.Donante AS Donante, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaIngreso AS FechaIngreso, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockIngreso AS StockIngreso, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockActual AS StockActual, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockComprometido AS StockComprometido, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockActualDoble AS StockActualDoble, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockFisico AS StockFisico, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockReservado AS StockReservado, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.StockDisponible AS StockDisponible, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioUnitarioDolares AS PrecioUnitarioDolares, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.Prioridad AS Prioridad, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioPromedioLocal AS PrecioPromedioLocal, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioPromedioDolares AS PrecioPromedioDolares, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.DocumentoReferencia AS DocumentoReferencia, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.Observaciones AS Observaciones, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.ObservacionesCorrectivas AS ObservacionesCorrectivas, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_ItemAlmacenStock.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_ItemAlmacenStockBN */
    public function setByBN( ALM_ItemAlmacenStockBN $o_ALM_ItemAlmacenStockBN )
    {
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ItemAlmacenStockBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemAlmacenStockBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ItemAlmacenStockBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdCondicion() ) )
        {
            $this->setIdCondicion( $o_ALM_ItemAlmacenStockBN->getIdCondicion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_ItemAlmacenStockBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_ItemAlmacenStockBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getLoteEquivalente() ) )
        {
            $this->setLoteEquivalente( $o_ALM_ItemAlmacenStockBN->getLoteEquivalente() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getDonante() ) )
        {
            $this->setDonante( $o_ALM_ItemAlmacenStockBN->getDonante() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaIngreso() ) )
        {
            $this->setFechaIngreso( $o_ALM_ItemAlmacenStockBN->getFechaIngreso() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockIngreso() ) )
        {
            $this->setStockIngreso( $o_ALM_ItemAlmacenStockBN->getStockIngreso() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockActual() ) )
        {
            $this->setStockActual( $o_ALM_ItemAlmacenStockBN->getStockActual() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockComprometido() ) )
        {
            $this->setStockComprometido( $o_ALM_ItemAlmacenStockBN->getStockComprometido() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockActualDoble() ) )
        {
            $this->setStockActualDoble( $o_ALM_ItemAlmacenStockBN->getStockActualDoble() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_ItemAlmacenStockBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockReservado() ) )
        {
            $this->setStockReservado( $o_ALM_ItemAlmacenStockBN->getStockReservado() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getStockDisponible() ) )
        {
            $this->setStockDisponible( $o_ALM_ItemAlmacenStockBN->getStockDisponible() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrioridad() ) )
        {
            $this->setPrioridad( $o_ALM_ItemAlmacenStockBN->getPrioridad() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioLocal() ) )
        {
            $this->setPrecioPromedioLocal( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioLocal() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioDolares() ) )
        {
            $this->setPrecioPromedioDolares( $o_ALM_ItemAlmacenStockBN->getPrecioPromedioDolares() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getDocumentoReferencia() ) )
        {
            $this->setDocumentoReferencia( $o_ALM_ItemAlmacenStockBN->getDocumentoReferencia() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_ALM_ItemAlmacenStockBN->getObservaciones() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getObservacionesCorrectivas() ) )
        {
            $this->setObservacionesCorrectivas( $o_ALM_ItemAlmacenStockBN->getObservacionesCorrectivas() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemAlmacenStockBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemAlmacenStockBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemAlmacenStockBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemAlmacenStockBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemAlmacenStockBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_ItemAlmacenStockBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion, $s_IdLote )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdItem ) ){ $s_IdItem = '-1'; } 
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
        if( is_null( $s_IdCondicion ) ){ $s_IdCondicion = '-1'; } 
        if( is_null( $s_IdLote ) ){ $s_IdLote = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemAlmacenStock ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdItem = '".$s_IdItem."' ";
        $s_SQLQuery .= "AND IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "AND IdCondicion = '".$s_IdCondicion."' ";
        $s_SQLQuery .= "AND IdLote = '".$s_IdLote."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_ItemAlmacenStockBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_ItemAlmacenStockBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemAlmacenStockBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdCondicion() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdCondicion = '".$this->getIdCondicion()."' AND ";
        if ( !is_null( $this->getIdLote() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdLote = '".$this->getIdLote()."' AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getLoteEquivalente() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.LoteEquivalente = '".$this->getLoteEquivalente()."' AND ";
        if ( !is_null( $this->getDonante() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.Donante = ".$this->getDonante()." AND ";
        if ( !is_null( $this->getFechaIngreso() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaIngreso = '".$this->getFechaIngreso()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getStockIngreso() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockIngreso = ".$this->getStockIngreso()." AND ";
        if ( !is_null( $this->getStockActual() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockActual = ".$this->getStockActual()." AND ";
        if ( !is_null( $this->getStockComprometido() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockComprometido = ".$this->getStockComprometido()." AND ";
        if ( !is_null( $this->getStockActualDoble() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockActualDoble = ".$this->getStockActualDoble()." AND ";
        if ( !is_null( $this->getStockFisico() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockFisico = ".$this->getStockFisico()." AND ";
        if ( !is_null( $this->getStockReservado() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockReservado = ".$this->getStockReservado()." AND ";
        if ( !is_null( $this->getStockDisponible() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.StockDisponible = ".$this->getStockDisponible()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getPrecioUnitarioDolares() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()." AND ";
        if ( !is_null( $this->getPrioridad() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.Prioridad = ".$this->getPrioridad()." AND ";
        if ( !is_null( $this->getPrecioPromedioLocal() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioPromedioLocal = ".$this->getPrecioPromedioLocal()." AND ";
        if ( !is_null( $this->getPrecioPromedioDolares() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.PrecioPromedioDolares = ".$this->getPrecioPromedioDolares()." AND ";
        if ( !is_null( $this->getDocumentoReferencia() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.DocumentoReferencia = '".$this->getDocumentoReferencia()."' AND ";
        if ( !is_null( $this->getObservaciones() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.Observaciones = '".$this->getObservaciones()."' AND ";
        if ( !is_null( $this->getObservacionesCorrectivas() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.ObservacionesCorrectivas = '".$this->getObservacionesCorrectivas()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_ItemAlmacenStock.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_ItemAlmacenStock WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_ItemAlmacenStockBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_ItemAlmacenStock WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_ItemAlmacenStockBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_ItemAlmacenStockBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_ItemAlmacenStockBN[] = $o_ALM_ItemAlmacenStockBN;
            }
        }
        return $a_ALM_ItemAlmacenStockBN;
    }

    /* Devuelve un objeto ALM_ItemAlmacenStockBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_ItemAlmacenStock )
    {
        $o_ALM_ItemAlmacenStockBN = new ALM_ItemAlmacenStockBN();
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdCompania'] ) ) $o_ALM_ItemAlmacenStockBN->setIdCompania( ( integer ) $a_ALM_ItemAlmacenStock['IdCompania'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdItem'] ) ) $o_ALM_ItemAlmacenStockBN->setIdItem( $a_ALM_ItemAlmacenStock['IdItem'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdAlmacen'] ) ) $o_ALM_ItemAlmacenStockBN->setIdAlmacen( $a_ALM_ItemAlmacenStock['IdAlmacen'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdCondicion'] ) ) $o_ALM_ItemAlmacenStockBN->setIdCondicion( $a_ALM_ItemAlmacenStock['IdCondicion'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdLote'] ) ) $o_ALM_ItemAlmacenStockBN->setIdLote( $a_ALM_ItemAlmacenStock['IdLote'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['IdSucursal'] ) ) $o_ALM_ItemAlmacenStockBN->setIdSucursal( ( integer ) $a_ALM_ItemAlmacenStock['IdSucursal'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['LoteEquivalente'] ) ) $o_ALM_ItemAlmacenStockBN->setLoteEquivalente( $a_ALM_ItemAlmacenStock['LoteEquivalente'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['Donante'] ) ) $o_ALM_ItemAlmacenStockBN->setDonante( ( integer ) $a_ALM_ItemAlmacenStock['Donante'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['FechaIngreso'] ) ) $o_ALM_ItemAlmacenStockBN->setFechaIngreso( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacenStock['FechaIngreso'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemAlmacenStock['FechaVencimiento'] ) ) $o_ALM_ItemAlmacenStockBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacenStock['FechaVencimiento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockIngreso'] ) ) $o_ALM_ItemAlmacenStockBN->setStockIngreso( ( float ) $a_ALM_ItemAlmacenStock['StockIngreso'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockActual'] ) ) $o_ALM_ItemAlmacenStockBN->setStockActual( ( float ) $a_ALM_ItemAlmacenStock['StockActual'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockComprometido'] ) ) $o_ALM_ItemAlmacenStockBN->setStockComprometido( ( float ) $a_ALM_ItemAlmacenStock['StockComprometido'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockActualDoble'] ) ) $o_ALM_ItemAlmacenStockBN->setStockActualDoble( ( float ) $a_ALM_ItemAlmacenStock['StockActualDoble'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockFisico'] ) ) $o_ALM_ItemAlmacenStockBN->setStockFisico( ( float ) $a_ALM_ItemAlmacenStock['StockFisico'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockReservado'] ) ) $o_ALM_ItemAlmacenStockBN->setStockReservado( ( float ) $a_ALM_ItemAlmacenStock['StockReservado'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['StockDisponible'] ) ) $o_ALM_ItemAlmacenStockBN->setStockDisponible( ( float ) $a_ALM_ItemAlmacenStock['StockDisponible'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['PrecioUnitario'] ) ) $o_ALM_ItemAlmacenStockBN->setPrecioUnitario( ( float ) $a_ALM_ItemAlmacenStock['PrecioUnitario'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['PrecioUnitarioDolares'] ) ) $o_ALM_ItemAlmacenStockBN->setPrecioUnitarioDolares( ( float ) $a_ALM_ItemAlmacenStock['PrecioUnitarioDolares'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['Prioridad'] ) ) $o_ALM_ItemAlmacenStockBN->setPrioridad( ( integer ) $a_ALM_ItemAlmacenStock['Prioridad'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['PrecioPromedioLocal'] ) ) $o_ALM_ItemAlmacenStockBN->setPrecioPromedioLocal( ( float ) $a_ALM_ItemAlmacenStock['PrecioPromedioLocal'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['PrecioPromedioDolares'] ) ) $o_ALM_ItemAlmacenStockBN->setPrecioPromedioDolares( ( float ) $a_ALM_ItemAlmacenStock['PrecioPromedioDolares'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['DocumentoReferencia'] ) ) $o_ALM_ItemAlmacenStockBN->setDocumentoReferencia( $a_ALM_ItemAlmacenStock['DocumentoReferencia'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['Observaciones'] ) ) $o_ALM_ItemAlmacenStockBN->setObservaciones( $a_ALM_ItemAlmacenStock['Observaciones'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['ObservacionesCorrectivas'] ) ) $o_ALM_ItemAlmacenStockBN->setObservacionesCorrectivas( $a_ALM_ItemAlmacenStock['ObservacionesCorrectivas'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['FechaCreacion'] ) ) $o_ALM_ItemAlmacenStockBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacenStock['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemAlmacenStock['UsuarioCreacion'] ) ) $o_ALM_ItemAlmacenStockBN->setUsuarioCreacion( $a_ALM_ItemAlmacenStock['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_ItemAlmacenStock['FechaModificacion'] ) ) $o_ALM_ItemAlmacenStockBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_ItemAlmacenStock['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_ItemAlmacenStock['UsuarioModificacion'] ) ) $o_ALM_ItemAlmacenStockBN->setUsuarioModificacion( $a_ALM_ItemAlmacenStock['UsuarioModificacion'] );
        return $o_ALM_ItemAlmacenStockBN;
    }
}
?>