<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisicoPesaje.xml */
/* Generado: 2021-06-25 23:59:40 */

/* Busqueda de registros de la tabla ALM_InventarioFisicoPesaje. */
abstract class BaseALM_InventarioFisicoPesajeFN extends ALM_InventarioFisicoPesajeBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_InventarioFisicoPesaje.IdCompania";
    const IdNumeroInventario = "ALM_InventarioFisicoPesaje.IdNumeroInventario";
    const IdSecuencia = "ALM_InventarioFisicoPesaje.IdSecuencia";
    const IdPesaje = "ALM_InventarioFisicoPesaje.IdPesaje";
    const StockFisico = "ALM_InventarioFisicoPesaje.StockFisico";
    const StockUnidades = "ALM_InventarioFisicoPesaje.StockUnidades";
    const IdAlmacenDestino = "ALM_InventarioFisicoPesaje.IdAlmacenDestino";
    const IdItemDestino = "ALM_InventarioFisicoPesaje.IdItemDestino";
    const IdUnidad = "ALM_InventarioFisicoPesaje.IdUnidad";
    const IdTipoDocumentoRef = "ALM_InventarioFisicoPesaje.IdTipoDocumentoRef";
    const IdNumeroDocumentoRef = "ALM_InventarioFisicoPesaje.IdNumeroDocumentoRef";
    const IdSecuenciaRef = "ALM_InventarioFisicoPesaje.IdSecuenciaRef";
    const UsuarioCreacion = "ALM_InventarioFisicoPesaje.UsuarioCreacion";
    const FechaCreacion = "ALM_InventarioFisicoPesaje.FechaCreacion";
    const UsuarioModificacion = "ALM_InventarioFisicoPesaje.UsuarioModificacion";
    const FechaModificacion = "ALM_InventarioFisicoPesaje.FechaModificacion";
    const Longitud = "ALM_InventarioFisicoPesaje.Longitud";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_InventarioFisicoPesaje.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdNumeroInventario AS IdNumeroInventario, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdPesaje AS IdPesaje, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.StockFisico AS StockFisico, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.StockUnidades AS StockUnidades, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdAlmacenDestino AS IdAlmacenDestino, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdItemDestino AS IdItemDestino, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdTipoDocumentoRef AS IdTipoDocumentoRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdNumeroDocumentoRef AS IdNumeroDocumentoRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdSecuenciaRef AS IdSecuenciaRef, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_InventarioFisicoPesaje.Longitud AS Longitud ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_InventarioFisicoPesajeBN */
    public function setByBN( ALM_InventarioFisicoPesajeBN $o_ALM_InventarioFisicoPesajeBN )
    {
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_InventarioFisicoPesajeBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario() ) )
        {
            $this->setIdNumeroInventario( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_InventarioFisicoPesajeBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdPesaje() ) )
        {
            $this->setIdPesaje( $o_ALM_InventarioFisicoPesajeBN->getIdPesaje() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_InventarioFisicoPesajeBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getStockUnidades() ) )
        {
            $this->setStockUnidades( $o_ALM_InventarioFisicoPesajeBN->getStockUnidades() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdAlmacenDestino() ) )
        {
            $this->setIdAlmacenDestino( $o_ALM_InventarioFisicoPesajeBN->getIdAlmacenDestino() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdItemDestino() ) )
        {
            $this->setIdItemDestino( $o_ALM_InventarioFisicoPesajeBN->getIdItemDestino() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_ALM_InventarioFisicoPesajeBN->getIdUnidad() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdTipoDocumentoRef() ) )
        {
            $this->setIdTipoDocumentoRef( $o_ALM_InventarioFisicoPesajeBN->getIdTipoDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroDocumentoRef() ) )
        {
            $this->setIdNumeroDocumentoRef( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdSecuenciaRef() ) )
        {
            $this->setIdSecuenciaRef( $o_ALM_InventarioFisicoPesajeBN->getIdSecuenciaRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_InventarioFisicoPesajeBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_InventarioFisicoPesajeBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_InventarioFisicoPesajeBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_InventarioFisicoPesajeBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getLongitud() ) )
        {
            $this->setLongitud( $o_ALM_InventarioFisicoPesajeBN->getLongitud() );
        }
    }

    /**
    * @return ALM_InventarioFisicoPesajeBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdNumeroInventario, $i_IdSecuencia, $i_IdPesaje )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdNumeroInventario ) ){ $s_IdNumeroInventario = '-1'; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
        if( is_null( $i_IdPesaje ) ){ $i_IdPesaje = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisicoPesaje ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdNumeroInventario = '".$s_IdNumeroInventario."' ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "AND IdPesaje = ".$i_IdPesaje." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_InventarioFisicoPesajeBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_InventarioFisicoPesajeBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_InventarioFisicoPesajeBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdNumeroInventario() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdNumeroInventario = '".$this->getIdNumeroInventario()."' AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdPesaje() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdPesaje = ".$this->getIdPesaje()." AND ";
        if ( !is_null( $this->getStockFisico() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.StockFisico = ".$this->getStockFisico()." AND ";
        if ( !is_null( $this->getStockUnidades() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.StockUnidades = ".$this->getStockUnidades()." AND ";
        if ( !is_null( $this->getIdAlmacenDestino() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdAlmacenDestino = '".$this->getIdAlmacenDestino()."' AND ";
        if ( !is_null( $this->getIdItemDestino() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdItemDestino = '".$this->getIdItemDestino()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdUnidad = '".$this->getIdUnidad()."' AND ";
        if ( !is_null( $this->getIdTipoDocumentoRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdTipoDocumentoRef = '".$this->getIdTipoDocumentoRef()."' AND ";
        if ( !is_null( $this->getIdNumeroDocumentoRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdNumeroDocumentoRef = '".$this->getIdNumeroDocumentoRef()."' AND ";
        if ( !is_null( $this->getIdSecuenciaRef() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.IdSecuenciaRef = ".$this->getIdSecuenciaRef()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getLongitud() ) ) $s_SQLQuery .= "ALM_InventarioFisicoPesaje.Longitud = ".$this->getLongitud()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_InventarioFisicoPesaje WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_InventarioFisicoPesajeBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisicoPesaje WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_InventarioFisicoPesajeBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_InventarioFisicoPesajeBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_InventarioFisicoPesajeBN[] = $o_ALM_InventarioFisicoPesajeBN;
            }
        }
        return $a_ALM_InventarioFisicoPesajeBN;
    }

    /* Devuelve un objeto ALM_InventarioFisicoPesajeBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_InventarioFisicoPesaje )
    {
        $o_ALM_InventarioFisicoPesajeBN = new ALM_InventarioFisicoPesajeBN();
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdCompania'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdCompania( ( integer ) $a_ALM_InventarioFisicoPesaje['IdCompania'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdNumeroInventario'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdNumeroInventario( $a_ALM_InventarioFisicoPesaje['IdNumeroInventario'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdSecuencia'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdSecuencia( ( integer ) $a_ALM_InventarioFisicoPesaje['IdSecuencia'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdPesaje'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdPesaje( ( integer ) $a_ALM_InventarioFisicoPesaje['IdPesaje'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['StockFisico'] ) ) $o_ALM_InventarioFisicoPesajeBN->setStockFisico( ( float ) $a_ALM_InventarioFisicoPesaje['StockFisico'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['StockUnidades'] ) ) $o_ALM_InventarioFisicoPesajeBN->setStockUnidades( ( integer ) $a_ALM_InventarioFisicoPesaje['StockUnidades'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdAlmacenDestino'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdAlmacenDestino( $a_ALM_InventarioFisicoPesaje['IdAlmacenDestino'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdItemDestino'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdItemDestino( $a_ALM_InventarioFisicoPesaje['IdItemDestino'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdUnidad'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdUnidad( $a_ALM_InventarioFisicoPesaje['IdUnidad'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdTipoDocumentoRef'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdTipoDocumentoRef( $a_ALM_InventarioFisicoPesaje['IdTipoDocumentoRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdNumeroDocumentoRef'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdNumeroDocumentoRef( $a_ALM_InventarioFisicoPesaje['IdNumeroDocumentoRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['IdSecuenciaRef'] ) ) $o_ALM_InventarioFisicoPesajeBN->setIdSecuenciaRef( ( integer ) $a_ALM_InventarioFisicoPesaje['IdSecuenciaRef'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['UsuarioCreacion'] ) ) $o_ALM_InventarioFisicoPesajeBN->setUsuarioCreacion( $a_ALM_InventarioFisicoPesaje['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['FechaCreacion'] ) ) $o_ALM_InventarioFisicoPesajeBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisicoPesaje['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['UsuarioModificacion'] ) ) $o_ALM_InventarioFisicoPesajeBN->setUsuarioModificacion( $a_ALM_InventarioFisicoPesaje['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['FechaModificacion'] ) ) $o_ALM_InventarioFisicoPesajeBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisicoPesaje['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_InventarioFisicoPesaje['Longitud'] ) ) $o_ALM_InventarioFisicoPesajeBN->setLongitud( ( float ) $a_ALM_InventarioFisicoPesaje['Longitud'] );
        return $o_ALM_InventarioFisicoPesajeBN;
    }
}
?>