<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisico.xml */
/* Generado: 2021-06-25 23:59:40 */

/* Busqueda de registros de la tabla ALM_InventarioFisico. */
abstract class BaseALM_InventarioFisicoFN extends ALM_InventarioFisicoBN
{
    /* Declaracion de constantes */
    const IdCompania = "ALM_InventarioFisico.IdCompania";
    const IdNumeroInventario = "ALM_InventarioFisico.IdNumeroInventario";
    const FechaInventario = "ALM_InventarioFisico.FechaInventario";
    const InventariadoPor = "ALM_InventarioFisico.InventariadoPor";
    const Comentarios = "ALM_InventarioFisico.Comentarios";
    const Estado = "ALM_InventarioFisico.Estado";
    const UsuarioCreacion = "ALM_InventarioFisico.UsuarioCreacion";
    const FechaCreacion = "ALM_InventarioFisico.FechaCreacion";
    const UsuarioModificacion = "ALM_InventarioFisico.UsuarioModificacion";
    const FechaModificacion = "ALM_InventarioFisico.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_InventarioFisico.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_InventarioFisico.IdNumeroInventario AS IdNumeroInventario, ";
        $s_SQLQuery .= "ALM_InventarioFisico.FechaInventario AS FechaInventario, ";
        $s_SQLQuery .= "ALM_InventarioFisico.InventariadoPor AS InventariadoPor, ";
        $s_SQLQuery .= "ALM_InventarioFisico.Comentarios AS Comentarios, ";
        $s_SQLQuery .= "ALM_InventarioFisico.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_InventarioFisico.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisico.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_InventarioFisico.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_InventarioFisico.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_InventarioFisicoBN */
    public function setByBN( ALM_InventarioFisicoBN $o_ALM_InventarioFisicoBN )
    {
        if ( !is_null( $o_ALM_InventarioFisicoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_InventarioFisicoBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() ) )
        {
            $this->setIdNumeroInventario( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaInventario() ) )
        {
            $this->setFechaInventario( $o_ALM_InventarioFisicoBN->getFechaInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getInventariadoPor() ) )
        {
            $this->setInventariadoPor( $o_ALM_InventarioFisicoBN->getInventariadoPor() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getComentarios() ) )
        {
            $this->setComentarios( $o_ALM_InventarioFisicoBN->getComentarios() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_InventarioFisicoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_InventarioFisicoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_InventarioFisicoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_InventarioFisicoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_InventarioFisicoBN->getFechaModificacion() );
        }
    }

    /**
    * @return ALM_InventarioFisicoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdNumeroInventario )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdNumeroInventario ) ){ $s_IdNumeroInventario = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisico ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdNumeroInventario = '".$s_IdNumeroInventario."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_InventarioFisicoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_InventarioFisicoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_InventarioFisicoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_InventarioFisico.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdNumeroInventario() ) ) $s_SQLQuery .= "ALM_InventarioFisico.IdNumeroInventario = '".$this->getIdNumeroInventario()."' AND ";
        if ( !is_null( $this->getFechaInventario() ) ) $s_SQLQuery .= "ALM_InventarioFisico.FechaInventario = '".$this->getFechaInventario()."' AND ";
        if ( !is_null( $this->getInventariadoPor() ) ) $s_SQLQuery .= "ALM_InventarioFisico.InventariadoPor = '".$this->getInventariadoPor()."' AND ";
        if ( !is_null( $this->getComentarios() ) ) $s_SQLQuery .= "ALM_InventarioFisico.Comentarios = '".$this->getComentarios()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_InventarioFisico.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisico.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_InventarioFisico.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisico.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_InventarioFisico.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_InventarioFisico WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_InventarioFisicoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_InventarioFisico WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_InventarioFisicoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_InventarioFisicoBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_InventarioFisicoBN[] = $o_ALM_InventarioFisicoBN;
            }
        }
        return $a_ALM_InventarioFisicoBN;
    }

    /* Devuelve un objeto ALM_InventarioFisicoBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_InventarioFisico )
    {
        $o_ALM_InventarioFisicoBN = new ALM_InventarioFisicoBN();
        if ( !is_null( $a_ALM_InventarioFisico['IdCompania'] ) ) $o_ALM_InventarioFisicoBN->setIdCompania( ( integer ) $a_ALM_InventarioFisico['IdCompania'] );
        if ( !is_null( $a_ALM_InventarioFisico['IdNumeroInventario'] ) ) $o_ALM_InventarioFisicoBN->setIdNumeroInventario( $a_ALM_InventarioFisico['IdNumeroInventario'] );
        if ( !is_null( $a_ALM_InventarioFisico['FechaInventario'] ) ) $o_ALM_InventarioFisicoBN->setFechaInventario( utilTimestamp::getTimestamp( $a_ALM_InventarioFisico['FechaInventario'], "Y-m-d" ) );
        if ( !is_null( $a_ALM_InventarioFisico['InventariadoPor'] ) ) $o_ALM_InventarioFisicoBN->setInventariadoPor( $a_ALM_InventarioFisico['InventariadoPor'] );
        if ( !is_null( $a_ALM_InventarioFisico['Comentarios'] ) ) $o_ALM_InventarioFisicoBN->setComentarios( $a_ALM_InventarioFisico['Comentarios'] );
        if ( !is_null( $a_ALM_InventarioFisico['Estado'] ) ) $o_ALM_InventarioFisicoBN->setEstado( $a_ALM_InventarioFisico['Estado'] );
        if ( !is_null( $a_ALM_InventarioFisico['UsuarioCreacion'] ) ) $o_ALM_InventarioFisicoBN->setUsuarioCreacion( $a_ALM_InventarioFisico['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_InventarioFisico['FechaCreacion'] ) ) $o_ALM_InventarioFisicoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisico['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_InventarioFisico['UsuarioModificacion'] ) ) $o_ALM_InventarioFisicoBN->setUsuarioModificacion( $a_ALM_InventarioFisico['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_InventarioFisico['FechaModificacion'] ) ) $o_ALM_InventarioFisicoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_InventarioFisico['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_ALM_InventarioFisicoBN;
    }
}
?>