<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaLog.xml */
/* Generado: 2021-06-25 23:59:40 */

/* Busqueda de registros de la tabla ALM_CajaChicaLog. */
abstract class BaseALM_CajaChicaLogFN extends ALM_CajaChicaLogBN
{
    /* Declaracion de constantes */
    const IdCajaLog = "ALM_CajaChicaLog.IdCajaLog";
    const IdCaja = "ALM_CajaChicaLog.IdCaja";
    const TipoLog = "ALM_CajaChicaLog.TipoLog";
    const ValorAnterior = "ALM_CajaChicaLog.ValorAnterior";
    const ValorNuevo = "ALM_CajaChicaLog.ValorNuevo";
    const FechaCreacion = "ALM_CajaChicaLog.FechaCreacion";
    const UsuarioCreacion = "ALM_CajaChicaLog.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_CajaChicaLog.IdCajaLog AS IdCajaLog, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.TipoLog AS TipoLog, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.ValorAnterior AS ValorAnterior, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.ValorNuevo AS ValorNuevo, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaLog.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_CajaChicaLogBN */
    public function setByBN( ALM_CajaChicaLogBN $o_ALM_CajaChicaLogBN )
    {
        if ( !is_null( $o_ALM_CajaChicaLogBN->getIdCajaLog() ) )
        {
            $this->setIdCajaLog( $o_ALM_CajaChicaLogBN->getIdCajaLog() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_ALM_CajaChicaLogBN->getIdCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getTipoLog() ) )
        {
            $this->setTipoLog( $o_ALM_CajaChicaLogBN->getTipoLog() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getValorAnterior() ) )
        {
            $this->setValorAnterior( $o_ALM_CajaChicaLogBN->getValorAnterior() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getValorNuevo() ) )
        {
            $this->setValorNuevo( $o_ALM_CajaChicaLogBN->getValorNuevo() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaLogBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return ALM_CajaChicaLogBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCajaLog )
    {
        if( is_null( $i_IdCajaLog ) ){ $i_IdCajaLog = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaLog ";
        $s_SQLQuery .= "WHERE IdCajaLog = ".$i_IdCajaLog." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_CajaChicaLogBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_CajaChicaLogBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_CajaChicaLogBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCajaLog() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.IdCajaLog = ".$this->getIdCajaLog()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getTipoLog() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.TipoLog = ".$this->getTipoLog()." AND ";
        if ( !is_null( $this->getValorAnterior() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.ValorAnterior = '".$this->getValorAnterior()."' AND ";
        if ( !is_null( $this->getValorNuevo() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.ValorNuevo = '".$this->getValorNuevo()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaLog.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_CajaChicaLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_CajaChicaLogBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_CajaChicaLogBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_CajaChicaLogBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_CajaChicaLogBN[] = $o_ALM_CajaChicaLogBN;
            }
        }
        return $a_ALM_CajaChicaLogBN;
    }

    /* Devuelve un objeto ALM_CajaChicaLogBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_CajaChicaLog )
    {
        $o_ALM_CajaChicaLogBN = new ALM_CajaChicaLogBN();
        if ( !is_null( $a_ALM_CajaChicaLog['IdCajaLog'] ) ) $o_ALM_CajaChicaLogBN->setIdCajaLog( ( integer ) $a_ALM_CajaChicaLog['IdCajaLog'] );
        if ( !is_null( $a_ALM_CajaChicaLog['IdCaja'] ) ) $o_ALM_CajaChicaLogBN->setIdCaja( ( integer ) $a_ALM_CajaChicaLog['IdCaja'] );
        if ( !is_null( $a_ALM_CajaChicaLog['TipoLog'] ) ) $o_ALM_CajaChicaLogBN->setTipoLog( ( integer ) $a_ALM_CajaChicaLog['TipoLog'] );
        if ( !is_null( $a_ALM_CajaChicaLog['ValorAnterior'] ) ) $o_ALM_CajaChicaLogBN->setValorAnterior( $a_ALM_CajaChicaLog['ValorAnterior'] );
        if ( !is_null( $a_ALM_CajaChicaLog['ValorNuevo'] ) ) $o_ALM_CajaChicaLogBN->setValorNuevo( $a_ALM_CajaChicaLog['ValorNuevo'] );
        if ( !is_null( $a_ALM_CajaChicaLog['FechaCreacion'] ) ) $o_ALM_CajaChicaLogBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaLog['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaLog['UsuarioCreacion'] ) ) $o_ALM_CajaChicaLogBN->setUsuarioCreacion( $a_ALM_CajaChicaLog['UsuarioCreacion'] );
        return $o_ALM_CajaChicaLogBN;
    }
}
?>