<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaItem.xml */
/* Generado: 2021-06-25 23:59:40 */

/* Busqueda de registros de la tabla ALM_CajaChicaItem. */
abstract class BaseALM_CajaChicaItemFN extends ALM_CajaChicaItemBN
{
    /* Declaracion de constantes */
    const IdCajaDet = "ALM_CajaChicaItem.IdCajaDet";
    const IdSecuencia = "ALM_CajaChicaItem.IdSecuencia";
    const IdItem = "ALM_CajaChicaItem.IdItem";
    const Descripcion = "ALM_CajaChicaItem.Descripcion";
    const Cantidad = "ALM_CajaChicaItem.Cantidad";
    const MontoUnitarioConIGV = "ALM_CajaChicaItem.MontoUnitarioConIGV";
    const MontoSubTotal = "ALM_CajaChicaItem.MontoSubTotal";
    const MontoIGV = "ALM_CajaChicaItem.MontoIGV";
    const MontoTotal = "ALM_CajaChicaItem.MontoTotal";
    const FechaCreacion = "ALM_CajaChicaItem.FechaCreacion";
    const UsuarioCreacion = "ALM_CajaChicaItem.UsuarioCreacion";
    const FechaModificacion = "ALM_CajaChicaItem.FechaModificacion";
    const UsuarioModificacion = "ALM_CajaChicaItem.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_CajaChicaItem.IdCajaDet AS IdCajaDet, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.IdItem AS IdItem, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.MontoUnitarioConIGV AS MontoUnitarioConIGV, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.MontoSubTotal AS MontoSubTotal, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_CajaChicaItem.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_CajaChicaItemBN */
    public function setByBN( ALM_CajaChicaItemBN $o_ALM_CajaChicaItemBN )
    {
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdCajaDet() ) )
        {
            $this->setIdCajaDet( $o_ALM_CajaChicaItemBN->getIdCajaDet() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_CajaChicaItemBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_CajaChicaItemBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_CajaChicaItemBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_CajaChicaItemBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoUnitarioConIGV() ) )
        {
            $this->setMontoUnitarioConIGV( $o_ALM_CajaChicaItemBN->getMontoUnitarioConIGV() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_ALM_CajaChicaItemBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_ALM_CajaChicaItemBN->getMontoIGV() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_CajaChicaItemBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaItemBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaItemBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_CajaChicaItemBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_CajaChicaItemBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_CajaChicaItemBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCajaDet, $i_IdSecuencia )
    {
        if( is_null( $i_IdCajaDet ) ){ $i_IdCajaDet = -1; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaItem ";
        $s_SQLQuery .= "WHERE IdCajaDet = ".$i_IdCajaDet." ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_CajaChicaItemBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_CajaChicaItemBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_CajaChicaItemBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCajaDet() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.IdCajaDet = ".$this->getIdCajaDet()." AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getMontoUnitarioConIGV() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.MontoUnitarioConIGV = ".$this->getMontoUnitarioConIGV()." AND ";
        if ( !is_null( $this->getMontoSubTotal() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.MontoSubTotal = ".$this->getMontoSubTotal()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaItem.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_CajaChicaItem WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_CajaChicaItemBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaItem WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_CajaChicaItemBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_CajaChicaItemBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_CajaChicaItemBN[] = $o_ALM_CajaChicaItemBN;
            }
        }
        return $a_ALM_CajaChicaItemBN;
    }

    /* Devuelve un objeto ALM_CajaChicaItemBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_CajaChicaItem )
    {
        $o_ALM_CajaChicaItemBN = new ALM_CajaChicaItemBN();
        if ( !is_null( $a_ALM_CajaChicaItem['IdCajaDet'] ) ) $o_ALM_CajaChicaItemBN->setIdCajaDet( ( integer ) $a_ALM_CajaChicaItem['IdCajaDet'] );
        if ( !is_null( $a_ALM_CajaChicaItem['IdSecuencia'] ) ) $o_ALM_CajaChicaItemBN->setIdSecuencia( ( integer ) $a_ALM_CajaChicaItem['IdSecuencia'] );
        if ( !is_null( $a_ALM_CajaChicaItem['IdItem'] ) ) $o_ALM_CajaChicaItemBN->setIdItem( $a_ALM_CajaChicaItem['IdItem'] );
        if ( !is_null( $a_ALM_CajaChicaItem['Descripcion'] ) ) $o_ALM_CajaChicaItemBN->setDescripcion( $a_ALM_CajaChicaItem['Descripcion'] );
        if ( !is_null( $a_ALM_CajaChicaItem['Cantidad'] ) ) $o_ALM_CajaChicaItemBN->setCantidad( ( float ) $a_ALM_CajaChicaItem['Cantidad'] );
        if ( !is_null( $a_ALM_CajaChicaItem['MontoUnitarioConIGV'] ) ) $o_ALM_CajaChicaItemBN->setMontoUnitarioConIGV( ( float ) $a_ALM_CajaChicaItem['MontoUnitarioConIGV'] );
        if ( !is_null( $a_ALM_CajaChicaItem['MontoSubTotal'] ) ) $o_ALM_CajaChicaItemBN->setMontoSubTotal( ( float ) $a_ALM_CajaChicaItem['MontoSubTotal'] );
        if ( !is_null( $a_ALM_CajaChicaItem['MontoIGV'] ) ) $o_ALM_CajaChicaItemBN->setMontoIGV( ( float ) $a_ALM_CajaChicaItem['MontoIGV'] );
        if ( !is_null( $a_ALM_CajaChicaItem['MontoTotal'] ) ) $o_ALM_CajaChicaItemBN->setMontoTotal( ( float ) $a_ALM_CajaChicaItem['MontoTotal'] );
        if ( !is_null( $a_ALM_CajaChicaItem['FechaCreacion'] ) ) $o_ALM_CajaChicaItemBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaItem['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaItem['UsuarioCreacion'] ) ) $o_ALM_CajaChicaItemBN->setUsuarioCreacion( $a_ALM_CajaChicaItem['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_CajaChicaItem['FechaModificacion'] ) ) $o_ALM_CajaChicaItemBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaItem['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaItem['UsuarioModificacion'] ) ) $o_ALM_CajaChicaItemBN->setUsuarioModificacion( $a_ALM_CajaChicaItem['UsuarioModificacion'] );
        return $o_ALM_CajaChicaItemBN;
    }
}
?>