<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaDet.xml */
/* Generado: 2021-06-25 23:59:39 */

/* Busqueda de registros de la tabla ALM_CajaChicaDet. */
abstract class BaseALM_CajaChicaDetFN extends ALM_CajaChicaDetBN
{
    /* Declaracion de constantes */
    const IdCajaDet = "ALM_CajaChicaDet.IdCajaDet";
    const IdCaja = "ALM_CajaChicaDet.IdCaja";
    const FechaDocumento = "ALM_CajaChicaDet.FechaDocumento";
    const TipoDocProv = "ALM_CajaChicaDet.TipoDocProv";
    const NumDocProv = "ALM_CajaChicaDet.NumDocProv";
    const NomProv = "ALM_CajaChicaDet.NomProv";
    const EsInventariableFlag = "ALM_CajaChicaDet.EsInventariableFlag";
    const ReferenciaIdTransaccion = "ALM_CajaChicaDet.ReferenciaIdTransaccion";
    const ReferenciaTipoDocumento = "ALM_CajaChicaDet.ReferenciaTipoDocumento";
    const ReferenciaSerieDocumento = "ALM_CajaChicaDet.ReferenciaSerieDocumento";
    const ReferenciaNumeroDocumento = "ALM_CajaChicaDet.ReferenciaNumeroDocumento";
    const Estado = "ALM_CajaChicaDet.Estado";
    const MontoTotal = "ALM_CajaChicaDet.MontoTotal";
    const MontoSubTotal = "ALM_CajaChicaDet.MontoSubTotal";
    const MontoIGV = "ALM_CajaChicaDet.MontoIGV";
    const Comentario = "ALM_CajaChicaDet.Comentario";
    const FechaCreacion = "ALM_CajaChicaDet.FechaCreacion";
    const UsuarioCreacion = "ALM_CajaChicaDet.UsuarioCreacion";
    const FechaModificacion = "ALM_CajaChicaDet.FechaModificacion";
    const UsuarioModificacion = "ALM_CajaChicaDet.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_CajaChicaDet.IdCajaDet AS IdCajaDet, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.FechaDocumento AS FechaDocumento, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.TipoDocProv AS TipoDocProv, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.NumDocProv AS NumDocProv, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.NomProv AS NomProv, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.EsInventariableFlag AS EsInventariableFlag, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaIdTransaccion AS ReferenciaIdTransaccion, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaTipoDocumento AS ReferenciaTipoDocumento, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaSerieDocumento AS ReferenciaSerieDocumento, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaNumeroDocumento AS ReferenciaNumeroDocumento, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.MontoSubTotal AS MontoSubTotal, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.Comentario AS Comentario, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_CajaChicaDet.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_CajaChicaDetBN */
    public function setByBN( ALM_CajaChicaDetBN $o_ALM_CajaChicaDetBN )
    {
        if ( !is_null( $o_ALM_CajaChicaDetBN->getIdCajaDet() ) )
        {
            $this->setIdCajaDet( $o_ALM_CajaChicaDetBN->getIdCajaDet() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_ALM_CajaChicaDetBN->getIdCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_ALM_CajaChicaDetBN->getFechaDocumento() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getTipoDocProv() ) )
        {
            $this->setTipoDocProv( $o_ALM_CajaChicaDetBN->getTipoDocProv() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getNumDocProv() ) )
        {
            $this->setNumDocProv( $o_ALM_CajaChicaDetBN->getNumDocProv() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getNomProv() ) )
        {
            $this->setNomProv( $o_ALM_CajaChicaDetBN->getNomProv() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getEsInventariableFlag() ) )
        {
            $this->setEsInventariableFlag( $o_ALM_CajaChicaDetBN->getEsInventariableFlag() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getReferenciaIdTransaccion() ) )
        {
            $this->setReferenciaIdTransaccion( $o_ALM_CajaChicaDetBN->getReferenciaIdTransaccion() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getReferenciaTipoDocumento() ) )
        {
            $this->setReferenciaTipoDocumento( $o_ALM_CajaChicaDetBN->getReferenciaTipoDocumento() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getReferenciaSerieDocumento() ) )
        {
            $this->setReferenciaSerieDocumento( $o_ALM_CajaChicaDetBN->getReferenciaSerieDocumento() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getReferenciaNumeroDocumento() ) )
        {
            $this->setReferenciaNumeroDocumento( $o_ALM_CajaChicaDetBN->getReferenciaNumeroDocumento() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_CajaChicaDetBN->getEstado() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_CajaChicaDetBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_ALM_CajaChicaDetBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_ALM_CajaChicaDetBN->getMontoIGV() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getComentario() ) )
        {
            $this->setComentario( $o_ALM_CajaChicaDetBN->getComentario() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaDetBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaDetBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_CajaChicaDetBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaDetBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_CajaChicaDetBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_CajaChicaDetBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCajaDet )
    {
        if( is_null( $i_IdCajaDet ) ){ $i_IdCajaDet = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaDet ";
        $s_SQLQuery .= "WHERE IdCajaDet = ".$i_IdCajaDet." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_CajaChicaDetBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_CajaChicaDetBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_CajaChicaDetBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCajaDet() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.IdCajaDet = ".$this->getIdCajaDet()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getFechaDocumento() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.FechaDocumento = '".$this->getFechaDocumento()."' AND ";
        if ( !is_null( $this->getTipoDocProv() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.TipoDocProv = '".$this->getTipoDocProv()."' AND ";
        if ( !is_null( $this->getNumDocProv() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.NumDocProv = '".$this->getNumDocProv()."' AND ";
        if ( !is_null( $this->getNomProv() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.NomProv = '".$this->getNomProv()."' AND ";
        if ( !is_null( $this->getEsInventariableFlag() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.EsInventariableFlag = '".$this->getEsInventariableFlag()."' AND ";
        if ( !is_null( $this->getReferenciaIdTransaccion() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaIdTransaccion = '".$this->getReferenciaIdTransaccion()."' AND ";
        if ( !is_null( $this->getReferenciaTipoDocumento() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaTipoDocumento = '".$this->getReferenciaTipoDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaSerieDocumento() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaSerieDocumento = '".$this->getReferenciaSerieDocumento()."' AND ";
        if ( !is_null( $this->getReferenciaNumeroDocumento() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.ReferenciaNumeroDocumento = '".$this->getReferenciaNumeroDocumento()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getMontoSubTotal() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.MontoSubTotal = ".$this->getMontoSubTotal()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaDet.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_CajaChicaDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_CajaChicaDetBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_CajaChicaDetBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_CajaChicaDetBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_CajaChicaDetBN[] = $o_ALM_CajaChicaDetBN;
            }
        }
        return $a_ALM_CajaChicaDetBN;
    }

    /* Devuelve un objeto ALM_CajaChicaDetBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_CajaChicaDet )
    {
        $o_ALM_CajaChicaDetBN = new ALM_CajaChicaDetBN();
        if ( !is_null( $a_ALM_CajaChicaDet['IdCajaDet'] ) ) $o_ALM_CajaChicaDetBN->setIdCajaDet( ( integer ) $a_ALM_CajaChicaDet['IdCajaDet'] );
        if ( !is_null( $a_ALM_CajaChicaDet['IdCaja'] ) ) $o_ALM_CajaChicaDetBN->setIdCaja( ( integer ) $a_ALM_CajaChicaDet['IdCaja'] );
        if ( !is_null( $a_ALM_CajaChicaDet['FechaDocumento'] ) ) $o_ALM_CajaChicaDetBN->setFechaDocumento( utilTimestamp::getTimestamp( $a_ALM_CajaChicaDet['FechaDocumento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaDet['TipoDocProv'] ) ) $o_ALM_CajaChicaDetBN->setTipoDocProv( $a_ALM_CajaChicaDet['TipoDocProv'] );
        if ( !is_null( $a_ALM_CajaChicaDet['NumDocProv'] ) ) $o_ALM_CajaChicaDetBN->setNumDocProv( $a_ALM_CajaChicaDet['NumDocProv'] );
        if ( !is_null( $a_ALM_CajaChicaDet['NomProv'] ) ) $o_ALM_CajaChicaDetBN->setNomProv( $a_ALM_CajaChicaDet['NomProv'] );
        if ( !is_null( $a_ALM_CajaChicaDet['EsInventariableFlag'] ) ) $o_ALM_CajaChicaDetBN->setEsInventariableFlag( $a_ALM_CajaChicaDet['EsInventariableFlag'] );
        if ( !is_null( $a_ALM_CajaChicaDet['ReferenciaIdTransaccion'] ) ) $o_ALM_CajaChicaDetBN->setReferenciaIdTransaccion( $a_ALM_CajaChicaDet['ReferenciaIdTransaccion'] );
        if ( !is_null( $a_ALM_CajaChicaDet['ReferenciaTipoDocumento'] ) ) $o_ALM_CajaChicaDetBN->setReferenciaTipoDocumento( $a_ALM_CajaChicaDet['ReferenciaTipoDocumento'] );
        if ( !is_null( $a_ALM_CajaChicaDet['ReferenciaSerieDocumento'] ) ) $o_ALM_CajaChicaDetBN->setReferenciaSerieDocumento( $a_ALM_CajaChicaDet['ReferenciaSerieDocumento'] );
        if ( !is_null( $a_ALM_CajaChicaDet['ReferenciaNumeroDocumento'] ) ) $o_ALM_CajaChicaDetBN->setReferenciaNumeroDocumento( $a_ALM_CajaChicaDet['ReferenciaNumeroDocumento'] );
        if ( !is_null( $a_ALM_CajaChicaDet['Estado'] ) ) $o_ALM_CajaChicaDetBN->setEstado( $a_ALM_CajaChicaDet['Estado'] );
        if ( !is_null( $a_ALM_CajaChicaDet['MontoTotal'] ) ) $o_ALM_CajaChicaDetBN->setMontoTotal( ( float ) $a_ALM_CajaChicaDet['MontoTotal'] );
        if ( !is_null( $a_ALM_CajaChicaDet['MontoSubTotal'] ) ) $o_ALM_CajaChicaDetBN->setMontoSubTotal( ( float ) $a_ALM_CajaChicaDet['MontoSubTotal'] );
        if ( !is_null( $a_ALM_CajaChicaDet['MontoIGV'] ) ) $o_ALM_CajaChicaDetBN->setMontoIGV( ( float ) $a_ALM_CajaChicaDet['MontoIGV'] );
        if ( !is_null( $a_ALM_CajaChicaDet['Comentario'] ) ) $o_ALM_CajaChicaDetBN->setComentario( $a_ALM_CajaChicaDet['Comentario'] );
        if ( !is_null( $a_ALM_CajaChicaDet['FechaCreacion'] ) ) $o_ALM_CajaChicaDetBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaDet['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaDet['UsuarioCreacion'] ) ) $o_ALM_CajaChicaDetBN->setUsuarioCreacion( $a_ALM_CajaChicaDet['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_CajaChicaDet['FechaModificacion'] ) ) $o_ALM_CajaChicaDetBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaDet['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaDet['UsuarioModificacion'] ) ) $o_ALM_CajaChicaDetBN->setUsuarioModificacion( $a_ALM_CajaChicaDet['UsuarioModificacion'] );
        return $o_ALM_CajaChicaDetBN;
    }
}
?>