<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaCab.xml */
/* Generado: 2021-06-25 23:59:39 */

/* Busqueda de registros de la tabla ALM_CajaChicaCab. */
abstract class BaseALM_CajaChicaCabFN extends ALM_CajaChicaCabBN
{
    /* Declaracion de constantes */
    const IdCaja = "ALM_CajaChicaCab.IdCaja";
    const IdCompania = "ALM_CajaChicaCab.IdCompania";
    const IdSucursal = "ALM_CajaChicaCab.IdSucursal";
    const Descripcion = "ALM_CajaChicaCab.Descripcion";
    const FechaCaja = "ALM_CajaChicaCab.FechaCaja";
    const FechaCierreCaja = "ALM_CajaChicaCab.FechaCierreCaja";
    const MontoFondo = "ALM_CajaChicaCab.MontoFondo";
    const MontoSaldoAnt = "ALM_CajaChicaCab.MontoSaldoAnt";
    const MontoIngreso = "ALM_CajaChicaCab.MontoIngreso";
    const MontoSaldoAct = "ALM_CajaChicaCab.MontoSaldoAct";
    const Estado = "ALM_CajaChicaCab.Estado";
    const EnUsoFlag = "ALM_CajaChicaCab.EnUsoFlag";
    const FechaCreacion = "ALM_CajaChicaCab.FechaCreacion";
    const UsuarioCreacion = "ALM_CajaChicaCab.UsuarioCreacion";
    const FechaModificacion = "ALM_CajaChicaCab.FechaModificacion";
    const UsuarioModificacion = "ALM_CajaChicaCab.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_CajaChicaCab.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.FechaCaja AS FechaCaja, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.FechaCierreCaja AS FechaCierreCaja, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.MontoFondo AS MontoFondo, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.MontoSaldoAnt AS MontoSaldoAnt, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.MontoIngreso AS MontoIngreso, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.MontoSaldoAct AS MontoSaldoAct, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.EnUsoFlag AS EnUsoFlag, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_CajaChicaCab.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_CajaChicaCabBN */
    public function setByBN( ALM_CajaChicaCabBN $o_ALM_CajaChicaCabBN )
    {
        if ( !is_null( $o_ALM_CajaChicaCabBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_ALM_CajaChicaCabBN->getIdCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_CajaChicaCabBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_CajaChicaCabBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_CajaChicaCabBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getFechaCaja() ) )
        {
            $this->setFechaCaja( $o_ALM_CajaChicaCabBN->getFechaCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getFechaCierreCaja() ) )
        {
            $this->setFechaCierreCaja( $o_ALM_CajaChicaCabBN->getFechaCierreCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getMontoFondo() ) )
        {
            $this->setMontoFondo( $o_ALM_CajaChicaCabBN->getMontoFondo() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getMontoSaldoAnt() ) )
        {
            $this->setMontoSaldoAnt( $o_ALM_CajaChicaCabBN->getMontoSaldoAnt() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getMontoIngreso() ) )
        {
            $this->setMontoIngreso( $o_ALM_CajaChicaCabBN->getMontoIngreso() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getMontoSaldoAct() ) )
        {
            $this->setMontoSaldoAct( $o_ALM_CajaChicaCabBN->getMontoSaldoAct() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_CajaChicaCabBN->getEstado() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getEnUsoFlag() ) )
        {
            $this->setEnUsoFlag( $o_ALM_CajaChicaCabBN->getEnUsoFlag() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaCabBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaCabBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_CajaChicaCabBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaCabBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_CajaChicaCabBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_CajaChicaCabBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCaja )
    {
        if( is_null( $i_IdCaja ) ){ $i_IdCaja = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaCab ";
        $s_SQLQuery .= "WHERE IdCaja = ".$i_IdCaja." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_CajaChicaCabBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_CajaChicaCabBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_CajaChicaCabBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getFechaCaja() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.FechaCaja = '".$this->getFechaCaja()."' AND ";
        if ( !is_null( $this->getFechaCierreCaja() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.FechaCierreCaja = '".$this->getFechaCierreCaja()."' AND ";
        if ( !is_null( $this->getMontoFondo() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.MontoFondo = ".$this->getMontoFondo()." AND ";
        if ( !is_null( $this->getMontoSaldoAnt() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.MontoSaldoAnt = ".$this->getMontoSaldoAnt()." AND ";
        if ( !is_null( $this->getMontoIngreso() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.MontoIngreso = ".$this->getMontoIngreso()." AND ";
        if ( !is_null( $this->getMontoSaldoAct() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.MontoSaldoAct = ".$this->getMontoSaldoAct()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getEnUsoFlag() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.EnUsoFlag = '".$this->getEnUsoFlag()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_CajaChicaCab.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_CajaChicaCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_CajaChicaCabBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_CajaChicaCab WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_CajaChicaCabBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_CajaChicaCabBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_CajaChicaCabBN[] = $o_ALM_CajaChicaCabBN;
            }
        }
        return $a_ALM_CajaChicaCabBN;
    }

    /* Devuelve un objeto ALM_CajaChicaCabBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_CajaChicaCab )
    {
        $o_ALM_CajaChicaCabBN = new ALM_CajaChicaCabBN();
        if ( !is_null( $a_ALM_CajaChicaCab['IdCaja'] ) ) $o_ALM_CajaChicaCabBN->setIdCaja( ( integer ) $a_ALM_CajaChicaCab['IdCaja'] );
        if ( !is_null( $a_ALM_CajaChicaCab['IdCompania'] ) ) $o_ALM_CajaChicaCabBN->setIdCompania( ( integer ) $a_ALM_CajaChicaCab['IdCompania'] );
        if ( !is_null( $a_ALM_CajaChicaCab['IdSucursal'] ) ) $o_ALM_CajaChicaCabBN->setIdSucursal( ( integer ) $a_ALM_CajaChicaCab['IdSucursal'] );
        if ( !is_null( $a_ALM_CajaChicaCab['Descripcion'] ) ) $o_ALM_CajaChicaCabBN->setDescripcion( $a_ALM_CajaChicaCab['Descripcion'] );
        if ( !is_null( $a_ALM_CajaChicaCab['FechaCaja'] ) ) $o_ALM_CajaChicaCabBN->setFechaCaja( utilTimestamp::getTimestamp( $a_ALM_CajaChicaCab['FechaCaja'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaCab['FechaCierreCaja'] ) ) $o_ALM_CajaChicaCabBN->setFechaCierreCaja( utilTimestamp::getTimestamp( $a_ALM_CajaChicaCab['FechaCierreCaja'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaCab['MontoFondo'] ) ) $o_ALM_CajaChicaCabBN->setMontoFondo( ( float ) $a_ALM_CajaChicaCab['MontoFondo'] );
        if ( !is_null( $a_ALM_CajaChicaCab['MontoSaldoAnt'] ) ) $o_ALM_CajaChicaCabBN->setMontoSaldoAnt( ( float ) $a_ALM_CajaChicaCab['MontoSaldoAnt'] );
        if ( !is_null( $a_ALM_CajaChicaCab['MontoIngreso'] ) ) $o_ALM_CajaChicaCabBN->setMontoIngreso( ( float ) $a_ALM_CajaChicaCab['MontoIngreso'] );
        if ( !is_null( $a_ALM_CajaChicaCab['MontoSaldoAct'] ) ) $o_ALM_CajaChicaCabBN->setMontoSaldoAct( ( float ) $a_ALM_CajaChicaCab['MontoSaldoAct'] );
        if ( !is_null( $a_ALM_CajaChicaCab['Estado'] ) ) $o_ALM_CajaChicaCabBN->setEstado( $a_ALM_CajaChicaCab['Estado'] );
        if ( !is_null( $a_ALM_CajaChicaCab['EnUsoFlag'] ) ) $o_ALM_CajaChicaCabBN->setEnUsoFlag( $a_ALM_CajaChicaCab['EnUsoFlag'] );
        if ( !is_null( $a_ALM_CajaChicaCab['FechaCreacion'] ) ) $o_ALM_CajaChicaCabBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaCab['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaCab['UsuarioCreacion'] ) ) $o_ALM_CajaChicaCabBN->setUsuarioCreacion( $a_ALM_CajaChicaCab['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_CajaChicaCab['FechaModificacion'] ) ) $o_ALM_CajaChicaCabBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_CajaChicaCab['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_CajaChicaCab['UsuarioModificacion'] ) ) $o_ALM_CajaChicaCabBN->setUsuarioModificacion( $a_ALM_CajaChicaCab['UsuarioModificacion'] );
        return $o_ALM_CajaChicaCabBN;
    }
}
?>