<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_AlmacenMast.xml */
/* Generado: 2021-06-25 23:59:39 */

/* Busqueda de registros de la tabla ALM_AlmacenMast. */
abstract class BaseALM_AlmacenMastFN extends ALM_AlmacenMastBN
{
    /* Declaracion de constantes */
    const IdAlmacen = "ALM_AlmacenMast.IdAlmacen";
    const IdCompania = "ALM_AlmacenMast.IdCompania";
    const IdSucursal = "ALM_AlmacenMast.IdSucursal";
    const IdUnidadCrianza = "ALM_AlmacenMast.IdUnidadCrianza";
    const IdAlmacenGrupo = "ALM_AlmacenMast.IdAlmacenGrupo";
    const MultiCompaniaFlag = "ALM_AlmacenMast.MultiCompaniaFlag";
    const CompaniaSocio = "ALM_AlmacenMast.CompaniaSocio";
    const DescripcionLocal = "ALM_AlmacenMast.DescripcionLocal";
    const DescripcionIngles = "ALM_AlmacenMast.DescripcionIngles";
    const Direccion = "ALM_AlmacenMast.Direccion";
    const UnidadNegocio = "ALM_AlmacenMast.UnidadNegocio";
    const TipoAlmacen = "ALM_AlmacenMast.TipoAlmacen";
    const TipoUnidadCrianza = "ALM_AlmacenMast.TipoUnidadCrianza";
    const AlmacenTransitoPrincipal = "ALM_AlmacenMast.AlmacenTransitoPrincipal";
    const AlmacenVentaFlag = "ALM_AlmacenMast.AlmacenVentaFlag";
    const AlmacenProduccionFlag = "ALM_AlmacenMast.AlmacenProduccionFlag";
    const AlmacenConsignacionFlag = "ALM_AlmacenMast.AlmacenConsignacionFlag";
    const AlmacenCommodityFlag = "ALM_AlmacenMast.AlmacenCommodityFlag";
    const DisponiblePlanProduccionFlag = "ALM_AlmacenMast.DisponiblePlanProduccionFlag";
    const SubAlmacenFlag = "ALM_AlmacenMast.SubAlmacenFlag";
    const CuentaInventario = "ALM_AlmacenMast.CuentaInventario";
    const CuentaGasto = "ALM_AlmacenMast.CuentaGasto";
    const NumeroMesesStock = "ALM_AlmacenMast.NumeroMesesStock";
    const ComercialCajero = "ALM_AlmacenMast.ComercialCajero";
    const Encargado = "ALM_AlmacenMast.Encargado";
    const ComercialCobrador = "ALM_AlmacenMast.ComercialCobrador";
    const AlmacenGastoFlag = "ALM_AlmacenMast.AlmacenGastoFlag";
    const Estado = "ALM_AlmacenMast.Estado";
    const UsuarioModificacion = "ALM_AlmacenMast.UsuarioModificacion";
    const FechaModificacion = "ALM_AlmacenMast.FechaModificacion";
    const UsuarioCreacion = "ALM_AlmacenMast.UsuarioCreacion";
    const FechaCreacion = "ALM_AlmacenMast.FechaCreacion";
    const Codigo = "ALM_AlmacenMast.Codigo";
    const CodigoSunat = "ALM_AlmacenMast.CodigoSunat";
    const IdUnidadProduccion = "ALM_AlmacenMast.IdUnidadProduccion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_AlmacenMast.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "ALM_AlmacenMast.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_AlmacenMast.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_AlmacenMast.IdUnidadCrianza AS IdUnidadCrianza, ";
        $s_SQLQuery .= "ALM_AlmacenMast.IdAlmacenGrupo AS IdAlmacenGrupo, ";
        $s_SQLQuery .= "ALM_AlmacenMast.MultiCompaniaFlag AS MultiCompaniaFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.CompaniaSocio AS CompaniaSocio, ";
        $s_SQLQuery .= "ALM_AlmacenMast.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "ALM_AlmacenMast.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "ALM_AlmacenMast.Direccion AS Direccion, ";
        $s_SQLQuery .= "ALM_AlmacenMast.UnidadNegocio AS UnidadNegocio, ";
        $s_SQLQuery .= "ALM_AlmacenMast.TipoAlmacen AS TipoAlmacen, ";
        $s_SQLQuery .= "ALM_AlmacenMast.TipoUnidadCrianza AS TipoUnidadCrianza, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenTransitoPrincipal AS AlmacenTransitoPrincipal, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenVentaFlag AS AlmacenVentaFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenProduccionFlag AS AlmacenProduccionFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenConsignacionFlag AS AlmacenConsignacionFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenCommodityFlag AS AlmacenCommodityFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.DisponiblePlanProduccionFlag AS DisponiblePlanProduccionFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.SubAlmacenFlag AS SubAlmacenFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.CuentaInventario AS CuentaInventario, ";
        $s_SQLQuery .= "ALM_AlmacenMast.CuentaGasto AS CuentaGasto, ";
        $s_SQLQuery .= "ALM_AlmacenMast.NumeroMesesStock AS NumeroMesesStock, ";
        $s_SQLQuery .= "ALM_AlmacenMast.ComercialCajero AS ComercialCajero, ";
        $s_SQLQuery .= "ALM_AlmacenMast.Encargado AS Encargado, ";
        $s_SQLQuery .= "ALM_AlmacenMast.ComercialCobrador AS ComercialCobrador, ";
        $s_SQLQuery .= "ALM_AlmacenMast.AlmacenGastoFlag AS AlmacenGastoFlag, ";
        $s_SQLQuery .= "ALM_AlmacenMast.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_AlmacenMast.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "ALM_AlmacenMast.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_AlmacenMast.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_AlmacenMast.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_AlmacenMast.Codigo AS Codigo, ";
        $s_SQLQuery .= "ALM_AlmacenMast.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "ALM_AlmacenMast.IdUnidadProduccion AS IdUnidadProduccion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_AlmacenMastBN */
    public function setByBN( ALM_AlmacenMastBN $o_ALM_AlmacenMastBN )
    {
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_AlmacenMastBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_AlmacenMastBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_AlmacenMastBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdUnidadCrianza() ) )
        {
            $this->setIdUnidadCrianza( $o_ALM_AlmacenMastBN->getIdUnidadCrianza() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdAlmacenGrupo() ) )
        {
            $this->setIdAlmacenGrupo( $o_ALM_AlmacenMastBN->getIdAlmacenGrupo() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getMultiCompaniaFlag() ) )
        {
            $this->setMultiCompaniaFlag( $o_ALM_AlmacenMastBN->getMultiCompaniaFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getCompaniaSocio() ) )
        {
            $this->setCompaniaSocio( $o_ALM_AlmacenMastBN->getCompaniaSocio() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_ALM_AlmacenMastBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_AlmacenMastBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getDireccion() ) )
        {
            $this->setDireccion( $o_ALM_AlmacenMastBN->getDireccion() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getUnidadNegocio() ) )
        {
            $this->setUnidadNegocio( $o_ALM_AlmacenMastBN->getUnidadNegocio() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getTipoAlmacen() ) )
        {
            $this->setTipoAlmacen( $o_ALM_AlmacenMastBN->getTipoAlmacen() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getTipoUnidadCrianza() ) )
        {
            $this->setTipoUnidadCrianza( $o_ALM_AlmacenMastBN->getTipoUnidadCrianza() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenTransitoPrincipal() ) )
        {
            $this->setAlmacenTransitoPrincipal( $o_ALM_AlmacenMastBN->getAlmacenTransitoPrincipal() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenVentaFlag() ) )
        {
            $this->setAlmacenVentaFlag( $o_ALM_AlmacenMastBN->getAlmacenVentaFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenProduccionFlag() ) )
        {
            $this->setAlmacenProduccionFlag( $o_ALM_AlmacenMastBN->getAlmacenProduccionFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenConsignacionFlag() ) )
        {
            $this->setAlmacenConsignacionFlag( $o_ALM_AlmacenMastBN->getAlmacenConsignacionFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenCommodityFlag() ) )
        {
            $this->setAlmacenCommodityFlag( $o_ALM_AlmacenMastBN->getAlmacenCommodityFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getDisponiblePlanProduccionFlag() ) )
        {
            $this->setDisponiblePlanProduccionFlag( $o_ALM_AlmacenMastBN->getDisponiblePlanProduccionFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getSubAlmacenFlag() ) )
        {
            $this->setSubAlmacenFlag( $o_ALM_AlmacenMastBN->getSubAlmacenFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getCuentaInventario() ) )
        {
            $this->setCuentaInventario( $o_ALM_AlmacenMastBN->getCuentaInventario() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getCuentaGasto() ) )
        {
            $this->setCuentaGasto( $o_ALM_AlmacenMastBN->getCuentaGasto() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getNumeroMesesStock() ) )
        {
            $this->setNumeroMesesStock( $o_ALM_AlmacenMastBN->getNumeroMesesStock() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getComercialCajero() ) )
        {
            $this->setComercialCajero( $o_ALM_AlmacenMastBN->getComercialCajero() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getEncargado() ) )
        {
            $this->setEncargado( $o_ALM_AlmacenMastBN->getEncargado() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getComercialCobrador() ) )
        {
            $this->setComercialCobrador( $o_ALM_AlmacenMastBN->getComercialCobrador() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getAlmacenGastoFlag() ) )
        {
            $this->setAlmacenGastoFlag( $o_ALM_AlmacenMastBN->getAlmacenGastoFlag() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_AlmacenMastBN->getEstado() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_AlmacenMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_AlmacenMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_AlmacenMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_AlmacenMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getCodigo() ) )
        {
            $this->setCodigo( $o_ALM_AlmacenMastBN->getCodigo() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_AlmacenMastBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_AlmacenMastBN->getIdUnidadProduccion() ) )
        {
            $this->setIdUnidadProduccion( $o_ALM_AlmacenMastBN->getIdUnidadProduccion() );
        }
    }

    /**
    * @return ALM_AlmacenMastBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdAlmacen )
    {
        if( is_null( $s_IdAlmacen ) ){ $s_IdAlmacen = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_AlmacenMast ";
        $s_SQLQuery .= "WHERE IdAlmacen = '".$s_IdAlmacen."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_AlmacenMastBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_AlmacenMastBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_AlmacenMastBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdUnidadCrianza() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdUnidadCrianza = ".$this->getIdUnidadCrianza()." AND ";
        if ( !is_null( $this->getIdAlmacenGrupo() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdAlmacenGrupo = '".$this->getIdAlmacenGrupo()."' AND ";
        if ( !is_null( $this->getMultiCompaniaFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.MultiCompaniaFlag = '".$this->getMultiCompaniaFlag()."' AND ";
        if ( !is_null( $this->getCompaniaSocio() ) ) $s_SQLQuery .= "ALM_AlmacenMast.CompaniaSocio = '".$this->getCompaniaSocio()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "ALM_AlmacenMast.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "ALM_AlmacenMast.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getDireccion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.Direccion = '".$this->getDireccion()."' AND ";
        if ( !is_null( $this->getUnidadNegocio() ) ) $s_SQLQuery .= "ALM_AlmacenMast.UnidadNegocio = '".$this->getUnidadNegocio()."' AND ";
        if ( !is_null( $this->getTipoAlmacen() ) ) $s_SQLQuery .= "ALM_AlmacenMast.TipoAlmacen = '".$this->getTipoAlmacen()."' AND ";
        if ( !is_null( $this->getTipoUnidadCrianza() ) ) $s_SQLQuery .= "ALM_AlmacenMast.TipoUnidadCrianza = '".$this->getTipoUnidadCrianza()."' AND ";
        if ( !is_null( $this->getAlmacenTransitoPrincipal() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenTransitoPrincipal = '".$this->getAlmacenTransitoPrincipal()."' AND ";
        if ( !is_null( $this->getAlmacenVentaFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenVentaFlag = '".$this->getAlmacenVentaFlag()."' AND ";
        if ( !is_null( $this->getAlmacenProduccionFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenProduccionFlag = '".$this->getAlmacenProduccionFlag()."' AND ";
        if ( !is_null( $this->getAlmacenConsignacionFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenConsignacionFlag = '".$this->getAlmacenConsignacionFlag()."' AND ";
        if ( !is_null( $this->getAlmacenCommodityFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenCommodityFlag = '".$this->getAlmacenCommodityFlag()."' AND ";
        if ( !is_null( $this->getDisponiblePlanProduccionFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.DisponiblePlanProduccionFlag = '".$this->getDisponiblePlanProduccionFlag()."' AND ";
        if ( !is_null( $this->getSubAlmacenFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.SubAlmacenFlag = '".$this->getSubAlmacenFlag()."' AND ";
        if ( !is_null( $this->getCuentaInventario() ) ) $s_SQLQuery .= "ALM_AlmacenMast.CuentaInventario = '".$this->getCuentaInventario()."' AND ";
        if ( !is_null( $this->getCuentaGasto() ) ) $s_SQLQuery .= "ALM_AlmacenMast.CuentaGasto = '".$this->getCuentaGasto()."' AND ";
        if ( !is_null( $this->getNumeroMesesStock() ) ) $s_SQLQuery .= "ALM_AlmacenMast.NumeroMesesStock = ".$this->getNumeroMesesStock()." AND ";
        if ( !is_null( $this->getComercialCajero() ) ) $s_SQLQuery .= "ALM_AlmacenMast.ComercialCajero = ".$this->getComercialCajero()." AND ";
        if ( !is_null( $this->getEncargado() ) ) $s_SQLQuery .= "ALM_AlmacenMast.Encargado = ".$this->getEncargado()." AND ";
        if ( !is_null( $this->getComercialCobrador() ) ) $s_SQLQuery .= "ALM_AlmacenMast.ComercialCobrador = ".$this->getComercialCobrador()." AND ";
        if ( !is_null( $this->getAlmacenGastoFlag() ) ) $s_SQLQuery .= "ALM_AlmacenMast.AlmacenGastoFlag = '".$this->getAlmacenGastoFlag()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_AlmacenMast.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "ALM_AlmacenMast.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "ALM_AlmacenMast.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getIdUnidadProduccion() ) ) $s_SQLQuery .= "ALM_AlmacenMast.IdUnidadProduccion = ".$this->getIdUnidadProduccion()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_AlmacenMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_AlmacenMastBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_AlmacenMast WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_AlmacenMastBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_AlmacenMastBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_AlmacenMastBN[] = $o_ALM_AlmacenMastBN;
            }
        }
        return $a_ALM_AlmacenMastBN;
    }

    /* Devuelve un objeto ALM_AlmacenMastBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_AlmacenMast )
    {
        $o_ALM_AlmacenMastBN = new ALM_AlmacenMastBN();
        if ( !is_null( $a_ALM_AlmacenMast['IdAlmacen'] ) ) $o_ALM_AlmacenMastBN->setIdAlmacen( $a_ALM_AlmacenMast['IdAlmacen'] );
        if ( !is_null( $a_ALM_AlmacenMast['IdCompania'] ) ) $o_ALM_AlmacenMastBN->setIdCompania( ( integer ) $a_ALM_AlmacenMast['IdCompania'] );
        if ( !is_null( $a_ALM_AlmacenMast['IdSucursal'] ) ) $o_ALM_AlmacenMastBN->setIdSucursal( ( integer ) $a_ALM_AlmacenMast['IdSucursal'] );
        if ( !is_null( $a_ALM_AlmacenMast['IdUnidadCrianza'] ) ) $o_ALM_AlmacenMastBN->setIdUnidadCrianza( ( integer ) $a_ALM_AlmacenMast['IdUnidadCrianza'] );
        if ( !is_null( $a_ALM_AlmacenMast['IdAlmacenGrupo'] ) ) $o_ALM_AlmacenMastBN->setIdAlmacenGrupo( $a_ALM_AlmacenMast['IdAlmacenGrupo'] );
        if ( !is_null( $a_ALM_AlmacenMast['MultiCompaniaFlag'] ) ) $o_ALM_AlmacenMastBN->setMultiCompaniaFlag( $a_ALM_AlmacenMast['MultiCompaniaFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['CompaniaSocio'] ) ) $o_ALM_AlmacenMastBN->setCompaniaSocio( $a_ALM_AlmacenMast['CompaniaSocio'] );
        if ( !is_null( $a_ALM_AlmacenMast['DescripcionLocal'] ) ) $o_ALM_AlmacenMastBN->setDescripcionLocal( $a_ALM_AlmacenMast['DescripcionLocal'] );
        if ( !is_null( $a_ALM_AlmacenMast['DescripcionIngles'] ) ) $o_ALM_AlmacenMastBN->setDescripcionIngles( $a_ALM_AlmacenMast['DescripcionIngles'] );
        if ( !is_null( $a_ALM_AlmacenMast['Direccion'] ) ) $o_ALM_AlmacenMastBN->setDireccion( $a_ALM_AlmacenMast['Direccion'] );
        if ( !is_null( $a_ALM_AlmacenMast['UnidadNegocio'] ) ) $o_ALM_AlmacenMastBN->setUnidadNegocio( $a_ALM_AlmacenMast['UnidadNegocio'] );
        if ( !is_null( $a_ALM_AlmacenMast['TipoAlmacen'] ) ) $o_ALM_AlmacenMastBN->setTipoAlmacen( $a_ALM_AlmacenMast['TipoAlmacen'] );
        if ( !is_null( $a_ALM_AlmacenMast['TipoUnidadCrianza'] ) ) $o_ALM_AlmacenMastBN->setTipoUnidadCrianza( $a_ALM_AlmacenMast['TipoUnidadCrianza'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenTransitoPrincipal'] ) ) $o_ALM_AlmacenMastBN->setAlmacenTransitoPrincipal( $a_ALM_AlmacenMast['AlmacenTransitoPrincipal'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenVentaFlag'] ) ) $o_ALM_AlmacenMastBN->setAlmacenVentaFlag( $a_ALM_AlmacenMast['AlmacenVentaFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenProduccionFlag'] ) ) $o_ALM_AlmacenMastBN->setAlmacenProduccionFlag( $a_ALM_AlmacenMast['AlmacenProduccionFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenConsignacionFlag'] ) ) $o_ALM_AlmacenMastBN->setAlmacenConsignacionFlag( $a_ALM_AlmacenMast['AlmacenConsignacionFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenCommodityFlag'] ) ) $o_ALM_AlmacenMastBN->setAlmacenCommodityFlag( $a_ALM_AlmacenMast['AlmacenCommodityFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['DisponiblePlanProduccionFlag'] ) ) $o_ALM_AlmacenMastBN->setDisponiblePlanProduccionFlag( $a_ALM_AlmacenMast['DisponiblePlanProduccionFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['SubAlmacenFlag'] ) ) $o_ALM_AlmacenMastBN->setSubAlmacenFlag( $a_ALM_AlmacenMast['SubAlmacenFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['CuentaInventario'] ) ) $o_ALM_AlmacenMastBN->setCuentaInventario( $a_ALM_AlmacenMast['CuentaInventario'] );
        if ( !is_null( $a_ALM_AlmacenMast['CuentaGasto'] ) ) $o_ALM_AlmacenMastBN->setCuentaGasto( $a_ALM_AlmacenMast['CuentaGasto'] );
        if ( !is_null( $a_ALM_AlmacenMast['NumeroMesesStock'] ) ) $o_ALM_AlmacenMastBN->setNumeroMesesStock( ( integer ) $a_ALM_AlmacenMast['NumeroMesesStock'] );
        if ( !is_null( $a_ALM_AlmacenMast['ComercialCajero'] ) ) $o_ALM_AlmacenMastBN->setComercialCajero( ( integer ) $a_ALM_AlmacenMast['ComercialCajero'] );
        if ( !is_null( $a_ALM_AlmacenMast['Encargado'] ) ) $o_ALM_AlmacenMastBN->setEncargado( ( integer ) $a_ALM_AlmacenMast['Encargado'] );
        if ( !is_null( $a_ALM_AlmacenMast['ComercialCobrador'] ) ) $o_ALM_AlmacenMastBN->setComercialCobrador( ( integer ) $a_ALM_AlmacenMast['ComercialCobrador'] );
        if ( !is_null( $a_ALM_AlmacenMast['AlmacenGastoFlag'] ) ) $o_ALM_AlmacenMastBN->setAlmacenGastoFlag( $a_ALM_AlmacenMast['AlmacenGastoFlag'] );
        if ( !is_null( $a_ALM_AlmacenMast['Estado'] ) ) $o_ALM_AlmacenMastBN->setEstado( $a_ALM_AlmacenMast['Estado'] );
        if ( !is_null( $a_ALM_AlmacenMast['UsuarioModificacion'] ) ) $o_ALM_AlmacenMastBN->setUsuarioModificacion( $a_ALM_AlmacenMast['UsuarioModificacion'] );
        if ( !is_null( $a_ALM_AlmacenMast['FechaModificacion'] ) ) $o_ALM_AlmacenMastBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_AlmacenMast['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_AlmacenMast['UsuarioCreacion'] ) ) $o_ALM_AlmacenMastBN->setUsuarioCreacion( $a_ALM_AlmacenMast['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_AlmacenMast['FechaCreacion'] ) ) $o_ALM_AlmacenMastBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_AlmacenMast['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_AlmacenMast['Codigo'] ) ) $o_ALM_AlmacenMastBN->setCodigo( $a_ALM_AlmacenMast['Codigo'] );
        if ( !is_null( $a_ALM_AlmacenMast['CodigoSunat'] ) ) $o_ALM_AlmacenMastBN->setCodigoSunat( $a_ALM_AlmacenMast['CodigoSunat'] );
        if ( !is_null( $a_ALM_AlmacenMast['IdUnidadProduccion'] ) ) $o_ALM_AlmacenMastBN->setIdUnidadProduccion( ( integer ) $a_ALM_AlmacenMast['IdUnidadProduccion'] );
        return $o_ALM_AlmacenMastBN;
    }
}
?>