<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_AlmacenGrupo.xml */
/* Generado: 2021-06-25 23:59:38 */

/* Busqueda de registros de la tabla ALM_AlmacenGrupo. */
abstract class BaseALM_AlmacenGrupoFN extends ALM_AlmacenGrupoBN
{
    /* Declaracion de constantes */
    const IdAlmacenGrupo = "ALM_AlmacenGrupo.IdAlmacenGrupo";
    const IdCompania = "ALM_AlmacenGrupo.IdCompania";
    const IdSucursal = "ALM_AlmacenGrupo.IdSucursal";
    const Descripcion = "ALM_AlmacenGrupo.Descripcion";
    const Estado = "ALM_AlmacenGrupo.Estado";
    const FechaCreacion = "ALM_AlmacenGrupo.FechaCreacion";
    const UsuarioCreacion = "ALM_AlmacenGrupo.UsuarioCreacion";
    const FechaModificacion = "ALM_AlmacenGrupo.FechaModificacion";
    const UsuarioModificacion = "ALM_AlmacenGrupo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "ALM_AlmacenGrupo.IdAlmacenGrupo AS IdAlmacenGrupo, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.Estado AS Estado, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "ALM_AlmacenGrupo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto ALM_AlmacenGrupoBN */
    public function setByBN( ALM_AlmacenGrupoBN $o_ALM_AlmacenGrupoBN )
    {
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdAlmacenGrupo() ) )
        {
            $this->setIdAlmacenGrupo( $o_ALM_AlmacenGrupoBN->getIdAlmacenGrupo() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_AlmacenGrupoBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_AlmacenGrupoBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_AlmacenGrupoBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_AlmacenGrupoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_AlmacenGrupoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_AlmacenGrupoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_AlmacenGrupoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_AlmacenGrupoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return ALM_AlmacenGrupoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdAlmacenGrupo )
    {
        if( is_null( $s_IdAlmacenGrupo ) ){ $s_IdAlmacenGrupo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_AlmacenGrupo ";
        $s_SQLQuery .= "WHERE IdAlmacenGrupo = '".$s_IdAlmacenGrupo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_ALM_AlmacenGrupoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_ALM_AlmacenGrupoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_AlmacenGrupoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdAlmacenGrupo() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.IdAlmacenGrupo = '".$this->getIdAlmacenGrupo()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "ALM_AlmacenGrupo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM ALM_AlmacenGrupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return ALM_AlmacenGrupoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_AlmacenGrupo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_ALM_AlmacenGrupoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_ALM_AlmacenGrupoBN = $this->insertObjectBN( $a_SQLRow );
                $a_ALM_AlmacenGrupoBN[] = $o_ALM_AlmacenGrupoBN;
            }
        }
        return $a_ALM_AlmacenGrupoBN;
    }

    /* Devuelve un objeto ALM_AlmacenGrupoBN desde un objeto propel */
    public function insertObjectBN( $a_ALM_AlmacenGrupo )
    {
        $o_ALM_AlmacenGrupoBN = new ALM_AlmacenGrupoBN();
        if ( !is_null( $a_ALM_AlmacenGrupo['IdAlmacenGrupo'] ) ) $o_ALM_AlmacenGrupoBN->setIdAlmacenGrupo( $a_ALM_AlmacenGrupo['IdAlmacenGrupo'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['IdCompania'] ) ) $o_ALM_AlmacenGrupoBN->setIdCompania( ( integer ) $a_ALM_AlmacenGrupo['IdCompania'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['IdSucursal'] ) ) $o_ALM_AlmacenGrupoBN->setIdSucursal( ( integer ) $a_ALM_AlmacenGrupo['IdSucursal'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['Descripcion'] ) ) $o_ALM_AlmacenGrupoBN->setDescripcion( $a_ALM_AlmacenGrupo['Descripcion'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['Estado'] ) ) $o_ALM_AlmacenGrupoBN->setEstado( $a_ALM_AlmacenGrupo['Estado'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['FechaCreacion'] ) ) $o_ALM_AlmacenGrupoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_ALM_AlmacenGrupo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_AlmacenGrupo['UsuarioCreacion'] ) ) $o_ALM_AlmacenGrupoBN->setUsuarioCreacion( $a_ALM_AlmacenGrupo['UsuarioCreacion'] );
        if ( !is_null( $a_ALM_AlmacenGrupo['FechaModificacion'] ) ) $o_ALM_AlmacenGrupoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_ALM_AlmacenGrupo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_ALM_AlmacenGrupo['UsuarioModificacion'] ) ) $o_ALM_AlmacenGrupoBN->setUsuarioModificacion( $a_ALM_AlmacenGrupo['UsuarioModificacion'] );
        return $o_ALM_AlmacenGrupoBN;
    }
}
?>