<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipoArchivo.xml */
/* Generado: 2021-03-04 17:43:48 */

/* Mantenimiento de los registros de la tabla VTA_OrdenTipoArchivo */
abstract class BaseVTA_OrdenTipoArchivoDP extends VTA_OrdenTipoArchivoBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_OrdenTipoArchivoBN ) */
    public function __construct( VTA_OrdenTipoArchivoBN $o_VTA_OrdenTipoArchivoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN ) )
        {
            $this->setByBN( $o_VTA_OrdenTipoArchivoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_OrdenTipoArchivoBN */
    public function setByBN( VTA_OrdenTipoArchivoBN $o_VTA_OrdenTipoArchivoBN )
    {
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getTipoId() ) )
        {
            $this->setTipoId( $o_VTA_OrdenTipoArchivoBN->getTipoId() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_VTA_OrdenTipoArchivoBN->getDescripcion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_VTA_OrdenTipoArchivoBN->getSecuencia() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getFlagValidacion() ) )
        {
            $this->setFlagValidacion( $o_VTA_OrdenTipoArchivoBN->getFlagValidacion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_OrdenTipoArchivoBN->getEstado() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_OrdenTipoArchivoFN = new VTA_OrdenTipoArchivoFN();
        $o_VTA_OrdenTipoArchivoBN = $o_VTA_OrdenTipoArchivoFN->selectByPk( $this->getTipoId() );
        if ( is_null( $o_VTA_OrdenTipoArchivoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_OrdenTipoArchivo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagValidacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlagValidacion";
                $s_SQLQuery2 .= $s_Separator."".$this->getFlagValidacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_OrdenTipoArchivo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Secuencia = '".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlagValidacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FlagValidacion = ".$this->getFlagValidacion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  TipoId = ".$this->getTipoId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_OrdenTipoArchivo WHERE  TipoId = ".$this->getTipoId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>