<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Documento.xml */
/* Generado: 2021-12-22 04:05:37 */

/* Mantenimiento de los registros de la tabla VTA_Documento */
abstract class BaseVTA_DocumentoDP extends VTA_DocumentoBV
{
    /* Constructor ( Establece los valores desde un objeto VTA_DocumentoBN ) */
    public function __construct( VTA_DocumentoBN $o_VTA_DocumentoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_VTA_DocumentoBN ) )
        {
            $this->setByBN( $o_VTA_DocumentoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto VTA_DocumentoBN */
    public function setByBN( VTA_DocumentoBN $o_VTA_DocumentoBN )
    {
        if ( !is_null( $o_VTA_DocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getSucursal() ) )
        {
            $this->setSucursal( $o_VTA_DocumentoBN->getSucursal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_VTA_DocumentoBN->getIdAlmacen() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getAlmacenDespacho() ) )
        {
            $this->setAlmacenDespacho( $o_VTA_DocumentoBN->getAlmacenDespacho() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdFormaPago() ) )
        {
            $this->setIdFormaPago( $o_VTA_DocumentoBN->getIdFormaPago() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFormaPagoCod() ) )
        {
            $this->setFormaPagoCod( $o_VTA_DocumentoBN->getFormaPagoCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTerminoPago() ) )
        {
            $this->setTerminoPago( $o_VTA_DocumentoBN->getTerminoPago() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_VTA_DocumentoBN->getIdCierre() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_VTA_DocumentoBN->getIdCaja() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_VTA_DocumentoBN->getIdTurno() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_VTA_DocumentoBN->getIdProyecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoCod() ) )
        {
            $this->setDocumentoCod( $o_VTA_DocumentoBN->getDocumentoCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoSerie() ) )
        {
            $this->setDocumentoSerie( $o_VTA_DocumentoBN->getDocumentoSerie() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoNumero() ) )
        {
            $this->setDocumentoNumero( $o_VTA_DocumentoBN->getDocumentoNumero() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroComprobante() ) )
        {
            $this->setNumeroComprobante( $o_VTA_DocumentoBN->getNumeroComprobante() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_VTA_DocumentoBN->getPeriodo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_VTA_DocumentoBN->getFechaDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_VTA_DocumentoBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoParentId() ) )
        {
            $this->setDocumentoParentId( $o_VTA_DocumentoBN->getDocumentoParentId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoParentCod() ) )
        {
            $this->setDocumentoParentCod( $o_VTA_DocumentoBN->getDocumentoParentCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteNumero() ) )
        {
            $this->setClienteNumero( $o_VTA_DocumentoBN->getClienteNumero() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteTipoDoc() ) )
        {
            $this->setClienteTipoDoc( $o_VTA_DocumentoBN->getClienteTipoDoc() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteRUC() ) )
        {
            $this->setClienteRUC( $o_VTA_DocumentoBN->getClienteRUC() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteNombre() ) )
        {
            $this->setClienteNombre( $o_VTA_DocumentoBN->getClienteNombre() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteDireccionSecuencia() ) )
        {
            $this->setClienteDireccionSecuencia( $o_VTA_DocumentoBN->getClienteDireccionSecuencia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteDireccion() ) )
        {
            $this->setClienteDireccion( $o_VTA_DocumentoBN->getClienteDireccion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteReferencia() ) )
        {
            $this->setClienteReferencia( $o_VTA_DocumentoBN->getClienteReferencia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteContacto() ) )
        {
            $this->setClienteContacto( $o_VTA_DocumentoBN->getClienteContacto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_VTA_DocumentoBN->getDepartamento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getProvincia() ) )
        {
            $this->setProvincia( $o_VTA_DocumentoBN->getProvincia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDistrito() ) )
        {
            $this->setDistrito( $o_VTA_DocumentoBN->getDistrito() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUbigeo() ) )
        {
            $this->setUbigeo( $o_VTA_DocumentoBN->getUbigeo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipoFacturacion() ) )
        {
            $this->setTipoFacturacion( $o_VTA_DocumentoBN->getTipoFacturacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getOrdenCompraRef() ) )
        {
            $this->setOrdenCompraRef( $o_VTA_DocumentoBN->getOrdenCompraRef() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipoVenta() ) )
        {
            $this->setTipoVenta( $o_VTA_DocumentoBN->getTipoVenta() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getVendedor() ) )
        {
            $this->setVendedor( $o_VTA_DocumentoBN->getVendedor() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionTipoId() ) )
        {
            $this->setDetraccionTipoId( $o_VTA_DocumentoBN->getDetraccionTipoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionPorcentaje() ) )
        {
            $this->setDetraccionPorcentaje( $o_VTA_DocumentoBN->getDetraccionPorcentaje() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionMedPagoId() ) )
        {
            $this->setDetraccionMedPagoId( $o_VTA_DocumentoBN->getDetraccionMedPagoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionTotal() ) )
        {
            $this->setDetraccionTotal( $o_VTA_DocumentoBN->getDetraccionTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getEsAgenteRetenedor() ) )
        {
            $this->setEsAgenteRetenedor( $o_VTA_DocumentoBN->getEsAgenteRetenedor() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionTipoId() ) )
        {
            $this->setRetencionTipoId( $o_VTA_DocumentoBN->getRetencionTipoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionBaseImponible() ) )
        {
            $this->setRetencionBaseImponible( $o_VTA_DocumentoBN->getRetencionBaseImponible() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionPorcentaje() ) )
        {
            $this->setRetencionPorcentaje( $o_VTA_DocumentoBN->getRetencionPorcentaje() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionTotal() ) )
        {
            $this->setRetencionTotal( $o_VTA_DocumentoBN->getRetencionTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipodeCambio() ) )
        {
            $this->setTipodeCambio( $o_VTA_DocumentoBN->getTipodeCambio() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMonedaDocumento() ) )
        {
            $this->setMonedaDocumento( $o_VTA_DocumentoBN->getMonedaDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_VTA_DocumentoBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSubTotalMN() ) )
        {
            $this->setMontoSubTotalMN( $o_VTA_DocumentoBN->getMontoSubTotalMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAfecto() ) )
        {
            $this->setMontoAfecto( $o_VTA_DocumentoBN->getMontoAfecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAfectoMN() ) )
        {
            $this->setMontoAfectoMN( $o_VTA_DocumentoBN->getMontoAfectoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoNoAfecto() ) )
        {
            $this->setMontoNoAfecto( $o_VTA_DocumentoBN->getMontoNoAfecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoNoAfectoMN() ) )
        {
            $this->setMontoNoAfectoMN( $o_VTA_DocumentoBN->getMontoNoAfectoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoExonerado() ) )
        {
            $this->setMontoExonerado( $o_VTA_DocumentoBN->getMontoExonerado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoExoneradoMN() ) )
        {
            $this->setMontoExoneradoMN( $o_VTA_DocumentoBN->getMontoExoneradoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoGratuito() ) )
        {
            $this->setMontoGratuito( $o_VTA_DocumentoBN->getMontoGratuito() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoGratuitoMN() ) )
        {
            $this->setMontoGratuitoMN( $o_VTA_DocumentoBN->getMontoGratuitoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoImpuestos() ) )
        {
            $this->setMontoImpuestos( $o_VTA_DocumentoBN->getMontoImpuestos() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoImpuestoMN() ) )
        {
            $this->setMontoImpuestoMN( $o_VTA_DocumentoBN->getMontoImpuestoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentos() ) )
        {
            $this->setMontoDescuentos( $o_VTA_DocumentoBN->getMontoDescuentos() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentosMN() ) )
        {
            $this->setMontoDescuentosMN( $o_VTA_DocumentoBN->getMontoDescuentosMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAnticipo() ) )
        {
            $this->setMontoAnticipo( $o_VTA_DocumentoBN->getMontoAnticipo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAnticipoMN() ) )
        {
            $this->setMontoAnticipoMN( $o_VTA_DocumentoBN->getMontoAnticipoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoRedondeo() ) )
        {
            $this->setMontoRedondeo( $o_VTA_DocumentoBN->getMontoRedondeo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoRedondeoMN() ) )
        {
            $this->setMontoRedondeoMN( $o_VTA_DocumentoBN->getMontoRedondeoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_VTA_DocumentoBN->getMontoTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoTotalMN() ) )
        {
            $this->setMontoTotalMN( $o_VTA_DocumentoBN->getMontoTotalMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoPagado() ) )
        {
            $this->setMontoPagado( $o_VTA_DocumentoBN->getMontoPagado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoPagadoMN() ) )
        {
            $this->setMontoPagadoMN( $o_VTA_DocumentoBN->getMontoPagadoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSaldo() ) )
        {
            $this->setMontoSaldo( $o_VTA_DocumentoBN->getMontoSaldo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSaldoMN() ) )
        {
            $this->setMontoSaldoMN( $o_VTA_DocumentoBN->getMontoSaldoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaFacturacion() ) )
        {
            $this->setFechaFacturacion( $o_VTA_DocumentoBN->getFechaFacturacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaAprobacion() ) )
        {
            $this->setFechaAprobacion( $o_VTA_DocumentoBN->getFechaAprobacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNotaCreditoDocumento() ) )
        {
            $this->setNotaCreditoDocumento( $o_VTA_DocumentoBN->getNotaCreditoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getImpresionPendienteFlag() ) )
        {
            $this->setImpresionPendienteFlag( $o_VTA_DocumentoBN->getImpresionPendienteFlag() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaImpresion() ) )
        {
            $this->setFechaImpresion( $o_VTA_DocumentoBN->getFechaImpresion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getImpresionGuiaRemFlag() ) )
        {
            $this->setImpresionGuiaRemFlag( $o_VTA_DocumentoBN->getImpresionGuiaRemFlag() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaImpresionGuiRem() ) )
        {
            $this->setFechaImpresionGuiRem( $o_VTA_DocumentoBN->getFechaImpresionGuiRem() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroRefAdicional1() ) )
        {
            $this->setNumeroRefAdicional1( $o_VTA_DocumentoBN->getNumeroRefAdicional1() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaRefAdicional1() ) )
        {
            $this->setFechaRefAdicional1( $o_VTA_DocumentoBN->getFechaRefAdicional1() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getComentario() ) )
        {
            $this->setComentario( $o_VTA_DocumentoBN->getComentario() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getAnulacionComentario() ) )
        {
            $this->setAnulacionComentario( $o_VTA_DocumentoBN->getAnulacionComentario() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getCanalVenta() ) )
        {
            $this->setCanalVenta( $o_VTA_DocumentoBN->getCanalVenta() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaCobranza() ) )
        {
            $this->setFechaCobranza( $o_VTA_DocumentoBN->getFechaCobranza() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getCobranzaEstado() ) )
        {
            $this->setCobranzaEstado( $o_VTA_DocumentoBN->getCobranzaEstado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_DocumentoBN->getEstado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_DocumentoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_DocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_DocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_DocumentoBN->getFechaCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPk( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento() );
        if ( is_null( $o_VTA_DocumentoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO VTA_Documento ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNumeroDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Sucursal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSucursal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacenDespacho() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AlmacenDespacho";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacenDespacho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFormaPago() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFormaPago";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdFormaPago()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFormaPagoCod() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FormaPagoCod";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFormaPagoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTerminoPago() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TerminoPago";
                $s_SQLQuery2 .= $s_Separator."".$this->getTerminoPago()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCierre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCierre";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCierre()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProyecto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProyecto";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProyecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoCod() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoCod";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocumentoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoSerie() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoSerie";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocumentoSerie()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroComprobante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroComprobante";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNumeroComprobante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPeriodo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Periodo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPeriodo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaVencimiento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoParentId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoParentId";
                $s_SQLQuery2 .= $s_Separator."".$this->getDocumentoParentId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoParentCod() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DocumentoParentCod";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDocumentoParentCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteTipoDoc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteTipoDoc";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteTipoDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteRUC() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteRUC";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteRUC()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteNombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteDireccionSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteDireccionSecuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getClienteDireccionSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteDireccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteDireccion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteReferencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteReferencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteReferencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteContacto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClienteContacto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClienteContacto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Departamento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Provincia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Distrito";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Ubigeo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbigeo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoFacturacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoFacturacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoFacturacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenCompraRef() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenCompraRef";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenCompraRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoVenta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getVendedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Vendedor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getVendedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DetraccionTipoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getDetraccionTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionPorcentaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DetraccionPorcentaje";
                $s_SQLQuery2 .= $s_Separator."".$this->getDetraccionPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionMedPagoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DetraccionMedPagoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getDetraccionMedPagoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DetraccionTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getDetraccionTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsAgenteRetenedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsAgenteRetenedor";
                $s_SQLQuery2 .= $s_Separator."".$this->getEsAgenteRetenedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RetencionTipoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getRetencionTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionBaseImponible() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RetencionBaseImponible";
                $s_SQLQuery2 .= $s_Separator."".$this->getRetencionBaseImponible()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionPorcentaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RetencionPorcentaje";
                $s_SQLQuery2 .= $s_Separator."".$this->getRetencionPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RetencionTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getRetencionTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipodeCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipodeCambio";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipodeCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMonedaDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MonedaDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMonedaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoSubTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoSubTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotalMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoSubTotalMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoSubTotalMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAfecto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoAfecto";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoAfecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAfectoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoAfectoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoAfectoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoNoAfecto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoNoAfecto";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoNoAfecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoNoAfectoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoNoAfectoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoNoAfectoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoExonerado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoExonerado";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoExonerado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoExoneradoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoExoneradoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoExoneradoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoGratuito() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoGratuito";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoGratuito()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoGratuitoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoGratuitoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoGratuitoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoImpuestos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoImpuestos";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoImpuestos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoImpuestoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoImpuestoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoImpuestoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoDescuentos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoDescuentos";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoDescuentos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoDescuentosMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoDescuentosMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoDescuentosMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAnticipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoAnticipo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoAnticipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAnticipoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoAnticipoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoAnticipoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoRedondeo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoRedondeo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoRedondeo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoRedondeoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoRedondeoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoRedondeoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotalMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoTotalMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoTotalMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoPagado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoPagado";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoPagado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoPagadoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoPagadoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoPagadoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSaldo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoSaldo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoSaldo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSaldoMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoSaldoMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoSaldoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaFacturacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaFacturacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaFacturacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaAprobacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaAprobacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaAprobacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotaCreditoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NotaCreditoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNotaCreditoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImpresionPendienteFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ImpresionPendienteFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getImpresionPendienteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaImpresion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaImpresion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaImpresion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImpresionGuiaRemFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ImpresionGuiaRemFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getImpresionGuiaRemFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaImpresionGuiRem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaImpresionGuiRem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaImpresionGuiRem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroRefAdicional1() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroRefAdicional1";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNumeroRefAdicional1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRefAdicional1() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRefAdicional1";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRefAdicional1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnulacionComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AnulacionComentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAnulacionComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCanalVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CanalVenta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCanalVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCobranza() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCobranza";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCobranza()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCobranzaEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CobranzaEstado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCobranzaEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE VTA_Documento SET ";
            $s_Separator = "";
            if ( !is_null( $this->getSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."Sucursal = '".$this->getSucursal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."IdAlmacen = '".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacenDespacho() ) )
            {
                $s_SQLQuery .= $s_Separator."AlmacenDespacho = '".$this->getAlmacenDespacho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFormaPago() ) )
            {
                $s_SQLQuery .= $s_Separator."IdFormaPago = '".$this->getIdFormaPago()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFormaPagoCod() ) )
            {
                $s_SQLQuery .= $s_Separator."FormaPagoCod = '".$this->getFormaPagoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTerminoPago() ) )
            {
                $s_SQLQuery .= $s_Separator."TerminoPago = ".$this->getTerminoPago()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCierre() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCierre = ".$this->getIdCierre()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCaja = ".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTurno = ".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProyecto() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProyecto = ".$this->getIdProyecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoCod() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoCod = '".$this->getDocumentoCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoSerie() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoSerie = '".$this->getDocumentoSerie()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoNumero = '".$this->getDocumentoNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroComprobante() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroComprobante = '".$this->getNumeroComprobante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPeriodo() ) )
            {
                $s_SQLQuery .= $s_Separator."Periodo = '".$this->getPeriodo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaDocumento = '".$this->getFechaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaVencimiento() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaVencimiento = '".$this->getFechaVencimiento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoParentId() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoParentId = ".$this->getDocumentoParentId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDocumentoParentCod() ) )
            {
                $s_SQLQuery .= $s_Separator."DocumentoParentCod = '".$this->getDocumentoParentCod()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteNumero = '".$this->getClienteNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteTipoDoc() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteTipoDoc = '".$this->getClienteTipoDoc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteRUC() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteRUC = '".$this->getClienteRUC()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteNombre = '".$this->getClienteNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteDireccionSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteDireccionSecuencia = ".$this->getClienteDireccionSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteDireccion() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteDireccion = '".$this->getClienteDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteReferencia() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteReferencia = '".$this->getClienteReferencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClienteContacto() ) )
            {
                $s_SQLQuery .= $s_Separator."ClienteContacto = '".$this->getClienteContacto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery .= $s_Separator."Departamento = '".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery .= $s_Separator."Provincia = '".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery .= $s_Separator."Distrito = '".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeo() ) )
            {
                $s_SQLQuery .= $s_Separator."Ubigeo = '".$this->getUbigeo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoFacturacion() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoFacturacion = '".$this->getTipoFacturacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenCompraRef() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenCompraRef = '".$this->getOrdenCompraRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoVenta = '".$this->getTipoVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getVendedor() ) )
            {
                $s_SQLQuery .= $s_Separator."Vendedor = '".$this->getVendedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionTipoId() ) )
            {
                $s_SQLQuery .= $s_Separator."DetraccionTipoId = ".$this->getDetraccionTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionPorcentaje() ) )
            {
                $s_SQLQuery .= $s_Separator."DetraccionPorcentaje = ".$this->getDetraccionPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionMedPagoId() ) )
            {
                $s_SQLQuery .= $s_Separator."DetraccionMedPagoId = ".$this->getDetraccionMedPagoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDetraccionTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."DetraccionTotal = ".$this->getDetraccionTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsAgenteRetenedor() ) )
            {
                $s_SQLQuery .= $s_Separator."EsAgenteRetenedor = ".$this->getEsAgenteRetenedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionTipoId() ) )
            {
                $s_SQLQuery .= $s_Separator."RetencionTipoId = ".$this->getRetencionTipoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionBaseImponible() ) )
            {
                $s_SQLQuery .= $s_Separator."RetencionBaseImponible = ".$this->getRetencionBaseImponible()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionPorcentaje() ) )
            {
                $s_SQLQuery .= $s_Separator."RetencionPorcentaje = ".$this->getRetencionPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRetencionTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."RetencionTotal = ".$this->getRetencionTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipodeCambio() ) )
            {
                $s_SQLQuery .= $s_Separator."TipodeCambio = ".$this->getTipodeCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMonedaDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."MonedaDocumento = '".$this->getMonedaDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoSubTotal = ".$this->getMontoSubTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotalMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoSubTotalMN = ".$this->getMontoSubTotalMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAfecto() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoAfecto = ".$this->getMontoAfecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAfectoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoAfectoMN = ".$this->getMontoAfectoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoNoAfecto() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoNoAfecto = ".$this->getMontoNoAfecto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoNoAfectoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoNoAfectoMN = ".$this->getMontoNoAfectoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoExonerado() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoExonerado = ".$this->getMontoExonerado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoExoneradoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoExoneradoMN = ".$this->getMontoExoneradoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoGratuito() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoGratuito = ".$this->getMontoGratuito()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoGratuitoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoGratuitoMN = ".$this->getMontoGratuitoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoImpuestos() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoImpuestos = ".$this->getMontoImpuestos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoImpuestoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoImpuestoMN = ".$this->getMontoImpuestoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoDescuentos() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoDescuentos = ".$this->getMontoDescuentos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoDescuentosMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoDescuentosMN = ".$this->getMontoDescuentosMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAnticipo() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoAnticipo = ".$this->getMontoAnticipo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoAnticipoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoAnticipoMN = ".$this->getMontoAnticipoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoRedondeo() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoRedondeo = ".$this->getMontoRedondeo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoRedondeoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoRedondeoMN = ".$this->getMontoRedondeoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoTotal = ".$this->getMontoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotalMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoTotalMN = ".$this->getMontoTotalMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoPagado() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoPagado = ".$this->getMontoPagado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoPagadoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoPagadoMN = ".$this->getMontoPagadoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSaldo() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoSaldo = ".$this->getMontoSaldo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSaldoMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoSaldoMN = ".$this->getMontoSaldoMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaFacturacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaFacturacion = '".$this->getFechaFacturacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaAprobacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaAprobacion = '".$this->getFechaAprobacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotaCreditoDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."NotaCreditoDocumento = '".$this->getNotaCreditoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImpresionPendienteFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ImpresionPendienteFlag = '".$this->getImpresionPendienteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaImpresion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaImpresion = '".$this->getFechaImpresion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getImpresionGuiaRemFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ImpresionGuiaRemFlag = '".$this->getImpresionGuiaRemFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaImpresionGuiRem() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaImpresionGuiRem = '".$this->getFechaImpresionGuiRem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroRefAdicional1() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroRefAdicional1 = '".$this->getNumeroRefAdicional1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRefAdicional1() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRefAdicional1 = '".$this->getFechaRefAdicional1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAnulacionComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."AnulacionComentario = '".$this->getAnulacionComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCanalVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."CanalVenta = '".$this->getCanalVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCobranza() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCobranza = '".$this->getFechaCobranza()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCobranzaEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."CobranzaEstado = '".$this->getCobranzaEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND  IdCompania = ".$this->getIdCompania()." AND  NumeroDocumento = '".$this->getNumeroDocumento()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM VTA_Documento WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND  IdCompania = ".$this->getIdCompania()." AND  NumeroDocumento = '".$this->getNumeroDocumento()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>