<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Turno.xml */
/* Generado: 2021-09-09 16:57:53 */

/* Mantenimiento de los registros de la tabla TR_Turno */
abstract class BaseTR_TurnoDP extends TR_TurnoBV
{
    /* Constructor ( Establece los valores desde un objeto TR_TurnoBN ) */
    public function __construct( TR_TurnoBN $o_TR_TurnoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_TR_TurnoBN ) )
        {
            $this->setByBN( $o_TR_TurnoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto TR_TurnoBN */
    public function setByBN( TR_TurnoBN $o_TR_TurnoBN )
    {
        if ( !is_null( $o_TR_TurnoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_TR_TurnoBN->getIdTurno() );
        }
        if ( !is_null( $o_TR_TurnoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_TurnoBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_TurnoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_TurnoBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescripcion() ) )
        {
            $this->setTurnoDescripcion( $o_TR_TurnoBN->getTurnoDescripcion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescHora() ) )
        {
            $this->setTurnoDescHora( $o_TR_TurnoBN->getTurnoDescHora() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescMin() ) )
        {
            $this->setTurnoDescMin( $o_TR_TurnoBN->getTurnoDescMin() );
        }
        if ( !is_null( $o_TR_TurnoBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_TurnoBN->getEstado() );
        }
        if ( !is_null( $o_TR_TurnoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_TurnoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_TurnoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_TurnoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_TurnoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_TR_TurnoFN = new TR_TurnoFN();
        $o_TR_TurnoBN = $o_TR_TurnoFN->selectByPk( $this->getIdTurno() );
        if ( is_null( $o_TR_TurnoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO TR_Turno ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TurnoDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTurnoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescHora() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TurnoDescHora";
                $s_SQLQuery2 .= $s_Separator."".$this->getTurnoDescHora()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescMin() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TurnoDescMin";
                $s_SQLQuery2 .= $s_Separator."".$this->getTurnoDescMin()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE TR_Turno SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."TurnoDescripcion = '".$this->getTurnoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescHora() ) )
            {
                $s_SQLQuery .= $s_Separator."TurnoDescHora = ".$this->getTurnoDescHora()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTurnoDescMin() ) )
            {
                $s_SQLQuery .= $s_Separator."TurnoDescMin = ".$this->getTurnoDescMin()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTurno = ".$this->getIdTurno().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM TR_Turno WHERE  IdTurno = ".$this->getIdTurno().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>