<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_SerieEscaneo.xml */
/* Generado: 2022-02-03 21:35:40 */

/* Mantenimiento de los registros de la tabla SR_SerieEscaneo */
abstract class BaseSR_SerieEscaneoDP extends SR_SerieEscaneoBV
{
    /* Constructor ( Establece los valores desde un objeto SR_SerieEscaneoBN ) */
    public function __construct( SR_SerieEscaneoBN $o_SR_SerieEscaneoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_SerieEscaneoBN ) )
        {
            $this->setByBN( $o_SR_SerieEscaneoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_SerieEscaneoBN */
    public function setByBN( SR_SerieEscaneoBN $o_SR_SerieEscaneoBN )
    {
        if ( !is_null( $o_SR_SerieEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_SerieEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_SerieEscaneoBN->getSerieId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_SerieEscaneoBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_SerieEscaneoBN->getProductoId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_SerieEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_SerieEscaneoBN->getOperacion() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_SerieEscaneoBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_SerieEscaneoBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_SerieEscaneoBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_SerieEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_SerieEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_SerieEscaneoBN->getFechaRegistro() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
        $o_SR_SerieEscaneoBN = $o_SR_SerieEscaneoFN->selectByPk( $this->getMovimientoDetalleId(), $this->getSerieId() );
        if ( is_null( $o_SR_SerieEscaneoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_SerieEscaneo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoDetalleId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoDetalleId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoDetalleId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieId";
                $s_SQLQuery2 .= $s_Separator."".$this->getSerieId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProductoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Operacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Almacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_SerieEscaneo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery .= $s_Separator."MovimientoId = ".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery .= $s_Separator."ProductoId = '".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."Fecha = '".$this->getFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery .= $s_Separator."Operacion = '".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."Almacen = '".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaTipo = '".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumero = '".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  SerieId = ".$this->getSerieId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_SerieEscaneo WHERE  MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND  SerieId = ".$this->getSerieId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>