<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreSerie.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Mantenimiento de los registros de la tabla SR_PreSerie */
abstract class BaseSR_PreSerieDP extends SR_PreSerieBV
{
    /* Constructor ( Establece los valores desde un objeto SR_PreSerieBN ) */
    public function __construct( SR_PreSerieBN $o_SR_PreSerieBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_SR_PreSerieBN ) )
        {
            $this->setByBN( $o_SR_PreSerieBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto SR_PreSerieBN */
    public function setByBN( SR_PreSerieBN $o_SR_PreSerieBN )
    {
        if ( !is_null( $o_SR_PreSerieBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_PreSerieBN->getSerieId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_PreSerieBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_PreSerieBN->getProductoId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getSerieNumero() ) )
        {
            $this->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_PreSerieBN->getOperacion() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_PreSerieBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_PreSerieBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreSerieBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreSerieBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreSerieBN->getFechaRegistro() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_SR_PreSerieFN = new SR_PreSerieFN();
        $o_SR_PreSerieBN = $o_SR_PreSerieFN->selectByPk( $this->getSerieId() );
        if ( is_null( $o_SR_PreSerieBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO SR_PreSerie ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getSerieId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieId";
                $s_SQLQuery2 .= $s_Separator."".$this->getSerieId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MovimientoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ProductoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SerieNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSerieNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Operacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Almacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ReferenciaNumero";
                $s_SQLQuery2 .= $s_Separator."'".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE SR_PreSerie SET ";
            $s_Separator = "";
            if ( !is_null( $this->getMovimientoId() ) )
            {
                $s_SQLQuery .= $s_Separator."MovimientoId = ".$this->getMovimientoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProductoId() ) )
            {
                $s_SQLQuery .= $s_Separator."ProductoId = '".$this->getProductoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSerieNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."SerieNumero = '".$this->getSerieNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOperacion() ) )
            {
                $s_SQLQuery .= $s_Separator."Operacion = '".$this->getOperacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."Almacen = '".$this->getAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaTipo = '".$this->getReferenciaTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getReferenciaNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."ReferenciaNumero = '".$this->getReferenciaNumero()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioRegistro = '".$this->getUsuarioRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaRegistro = '".$this->getFechaRegistro()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  SerieId = ".$this->getSerieId().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM SR_PreSerie WHERE  SerieId = ".$this->getSerieId().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>