<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: RegistroHistorial.xml */
/* Generado: 2021-11-29 22:16:59 */

/* Mantenimiento de los registros de la tabla RegistroHistorial */
abstract class BaseRegistroHistorialDP extends RegistroHistorialBV
{
    /* Constructor ( Establece los valores desde un objeto RegistroHistorialBN ) */
    public function __construct( RegistroHistorialBN $o_RegistroHistorialBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_RegistroHistorialBN ) )
        {
            $this->setByBN( $o_RegistroHistorialBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto RegistroHistorialBN */
    public function setByBN( RegistroHistorialBN $o_RegistroHistorialBN )
    {
        if ( !is_null( $o_RegistroHistorialBN->getIdLog() ) )
        {
            $this->setIdLog( $o_RegistroHistorialBN->getIdLog() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_RegistroHistorialBN->getIdCompania() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_RegistroHistorialBN->getIdSucursal() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getBaseDatos() ) )
        {
            $this->setBaseDatos( $o_RegistroHistorialBN->getBaseDatos() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getTabla() ) )
        {
            $this->setTabla( $o_RegistroHistorialBN->getTabla() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdFecha() ) )
        {
            $this->setIdFecha( $o_RegistroHistorialBN->getIdFecha() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdDocumento() ) )
        {
            $this->setIdDocumento( $o_RegistroHistorialBN->getIdDocumento() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdCampo() ) )
        {
            $this->setIdCampo( $o_RegistroHistorialBN->getIdCampo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getCampoValor() ) )
        {
            $this->setCampoValor( $o_RegistroHistorialBN->getCampoValor() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getCampoDescripcion() ) )
        {
            $this->setCampoDescripcion( $o_RegistroHistorialBN->getCampoDescripcion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getModulo() ) )
        {
            $this->setModulo( $o_RegistroHistorialBN->getModulo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIP() ) )
        {
            $this->setIP( $o_RegistroHistorialBN->getIP() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getValorAnterior() ) )
        {
            $this->setValorAnterior( $o_RegistroHistorialBN->getValorAnterior() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getValorNuevo() ) )
        {
            $this->setValorNuevo( $o_RegistroHistorialBN->getValorNuevo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_RegistroHistorialBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_RegistroHistorialBN->getFechaCreacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_RegistroHistorialBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_RegistroHistorialBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_RegistroHistorialFN = new RegistroHistorialFN();
        $o_RegistroHistorialBN = $o_RegistroHistorialFN->selectByPk( $this->getIdLog() );
        if ( is_null( $o_RegistroHistorialBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO RegistroHistorial ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdLog() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLog";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLog()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBaseDatos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."BaseDatos";
                $s_SQLQuery2 .= $s_Separator."'".$this->getBaseDatos()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTabla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Tabla";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTabla()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCampo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCampo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdCampo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCampoValor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CampoValor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCampoValor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCampoDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CampoDescripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCampoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModulo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Modulo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getModulo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIP() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IP";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIP()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorAnterior() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ValorAnterior";
                $s_SQLQuery2 .= $s_Separator."'".$this->getValorAnterior()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorNuevo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ValorNuevo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getValorNuevo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE RegistroHistorial SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBaseDatos() ) )
            {
                $s_SQLQuery .= $s_Separator."BaseDatos = '".$this->getBaseDatos()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTabla() ) )
            {
                $s_SQLQuery .= $s_Separator."Tabla = '".$this->getTabla()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFecha() ) )
            {
                $s_SQLQuery .= $s_Separator."IdFecha = '".$this->getIdFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDocumento() ) )
            {
                $s_SQLQuery .= $s_Separator."IdDocumento = '".$this->getIdDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCampo() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCampo = '".$this->getIdCampo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCampoValor() ) )
            {
                $s_SQLQuery .= $s_Separator."CampoValor = '".$this->getCampoValor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCampoDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."CampoDescripcion = '".$this->getCampoDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModulo() ) )
            {
                $s_SQLQuery .= $s_Separator."Modulo = '".$this->getModulo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIP() ) )
            {
                $s_SQLQuery .= $s_Separator."IP = '".$this->getIP()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorAnterior() ) )
            {
                $s_SQLQuery .= $s_Separator."ValorAnterior = '".$this->getValorAnterior()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorNuevo() ) )
            {
                $s_SQLQuery .= $s_Separator."ValorNuevo = '".$this->getValorNuevo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdLog = ".$this->getIdLog().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM RegistroHistorial WHERE  IdLog = ".$this->getIdLog().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>