<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_TipoGrupo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla PR_TipoGrupo */
abstract class BasePR_TipoGrupoDP extends PR_TipoGrupoBV
{
    /* Constructor ( Establece los valores desde un objeto PR_TipoGrupoBN ) */
    public function __construct( PR_TipoGrupoBN $o_PR_TipoGrupoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PR_TipoGrupoBN ) )
        {
            $this->setByBN( $o_PR_TipoGrupoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PR_TipoGrupoBN */
    public function setByBN( PR_TipoGrupoBN $o_PR_TipoGrupoBN )
    {
        if ( !is_null( $o_PR_TipoGrupoBN->getIdPrTipoId() ) )
        {
            $this->setIdPrTipoId( $o_PR_TipoGrupoBN->getIdPrTipoId() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getNombre() ) )
        {
            $this->setNombre( $o_PR_TipoGrupoBN->getNombre() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getPrefijoTipo() ) )
        {
            $this->setPrefijoTipo( $o_PR_TipoGrupoBN->getPrefijoTipo() );
        }
        if ( !is_null( $o_PR_TipoGrupoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PR_TipoGrupoBN->getSecuencia() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PR_TipoGrupoFN = new PR_TipoGrupoFN();
        $o_PR_TipoGrupoBN = $o_PR_TipoGrupoFN->selectByPk( $this->getIdPrTipoId() );
        if ( is_null( $o_PR_TipoGrupoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PR_TipoGrupo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdPrTipoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPrTipoId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdPrTipoId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrefijoTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrefijoTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPrefijoTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PR_TipoGrupo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrefijoTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."PrefijoTipo = '".$this->getPrefijoTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Secuencia = '".$this->getSecuencia()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdPrTipoId = '".$this->getIdPrTipoId()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PR_TipoGrupo WHERE  IdPrTipoId = '".$this->getIdPrTipoId()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>