<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionRegistro.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Mantenimiento de los registros de la tabla PLA_MarcacionRegistro */
abstract class BasePLA_MarcacionRegistroDP extends PLA_MarcacionRegistroBV
{
    /* Constructor ( Establece los valores desde un objeto PLA_MarcacionRegistroBN ) */
    public function __construct( PLA_MarcacionRegistroBN $o_PLA_MarcacionRegistroBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_PLA_MarcacionRegistroBN ) )
        {
            $this->setByBN( $o_PLA_MarcacionRegistroBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto PLA_MarcacionRegistroBN */
    public function setByBN( PLA_MarcacionRegistroBN $o_PLA_MarcacionRegistroBN )
    {
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_MarcacionRegistroBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_MarcacionRegistroBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PLA_MarcacionRegistroBN->getSecuencia() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_MarcacionRegistroBN->getEstado() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getObligatorioFlag() ) )
        {
            $this->setObligatorioFlag( $o_PLA_MarcacionRegistroBN->getObligatorioFlag() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getIdEquivalente() ) )
        {
            $this->setIdEquivalente( $o_PLA_MarcacionRegistroBN->getIdEquivalente() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_PLA_MarcacionRegistroFN = new PLA_MarcacionRegistroFN();
        $o_PLA_MarcacionRegistroBN = $o_PLA_MarcacionRegistroFN->selectByPk( $this->getIdRegistro() );
        if ( is_null( $o_PLA_MarcacionRegistroBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO PLA_MarcacionRegistro ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Secuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObligatorioFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ObligatorioFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getObligatorioFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdEquivalente() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdEquivalente";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdEquivalente()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE PLA_MarcacionRegistro SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSecuencia() ) )
            {
                $s_SQLQuery .= $s_Separator."Secuencia = ".$this->getSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObligatorioFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ObligatorioFlag = ".$this->getObligatorioFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdEquivalente() ) )
            {
                $s_SQLQuery .= $s_Separator."IdEquivalente = ".$this->getIdEquivalente()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRegistro = '".$this->getIdRegistro()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM PLA_MarcacionRegistro WHERE  IdRegistro = '".$this->getIdRegistro()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>